/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.schedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.etl.EASKettle;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlExecuteLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlExecuteLogInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlStrategyFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.KettleCommandInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.KettleXmlHelper;
import com.kingdee.eas.framework.bireport.bimanager.etl.LostStrategy_ETL;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.ETLXMLHandle;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.EtlLogUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.AbstractDispatchCallBack;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import com.kingdee.eas.framework.bireport.bimanager.util.LostStrategy;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientAgent;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class ETLDispatchCallBackImpl
extends AbstractDispatchCallBack {
    private EtlDispatchManagerEntryInfo info = null;
    private EtlExecuteLogInfo executeInfo = null;
    String dispatchLogID = "";
    private StringBuffer logInfo = new StringBuffer();

    public ETLDispatchCallBackImpl(Context ctx, EtlDispatchManagerEntryInfo info, int index, String dispatchLogID) {
        super(ctx, index);
        this.info = info;
        try {
            LostStrategy lostStrategy = LostStrategy_ETL.str2LostStrategy(info.getLostStra());
            if (lostStrategy == null) {
                lostStrategy = new LostStrategy_ETL();
            }
            this.setLostStrategy(lostStrategy);
            this.dispatchLogID = dispatchLogID;
            String strategy = lostStrategy.toString();
            this.logInfo.append("\u65b9\u6848\u5931\u8d25\u7b56\u7565:" + strategy);
            this.logInfo.append("\n");
        }
        catch (Exception e) {
            this.addException(e);
        }
    }

    public void executeEntry(EtlSchemeManagerInfo schememInfo, int index, boolean isTryCatch) throws Exception {
        byte[] fileByte = null;
        fileByte = isTryCatch ? schememInfo.getCatchScheme() : schememInfo.getFileWay();
        String fileName = schememInfo.getNumber();
        Date date2 = new Date();
        Timestamp startTime = new Timestamp(date2.getTime());
        String status = null;
        String logContent = null;
        String url = null;
        String configFileName = null;
        if (fileByte != null) {
            try {
                String transFile = new String(fileByte, "UTF-8");
                ClientAgent client = new ClientAgent(0L);
                KettleCommandInfo commandInfo = new KettleCommandInfo();
                commandInfo.companyID = schememInfo.getCompanyID(index);
                commandInfo.fileName = fileName;
                commandInfo.tempDataCenterID = schememInfo.getDataCenter(index);
                commandInfo.datacenters = KettleXmlHelper.getHasUseDBCenters(DBConnectionMap.getInstance(this.ctx).getDBCenters(), schememInfo.getDataCenter(index), transFile);
                EASKettle kettle = (EASKettle)client.createRemoteInstance(EASKettle.class);
                commandInfo.fileContext = transFile = ETLXMLHandle.putParamInXml(this.ctx, transFile, index, schememInfo);
                url = client.getURL();
                configFileName = client.getConfigFileName();
                Map resultTrans = kettle.executeTrans(commandInfo);
                if (resultTrans.containsKey("Exception")) {
                    throw (Exception)resultTrans.get("Exception");
                }
                client.client().terminal();
                date2 = new Date();
                Timestamp endTime = new Timestamp(date2.getTime());
                if (resultTrans != null) {
                    status = resultTrans.get("status").toString();
                    logContent = resultTrans.get("logContent").toString();
                    if (logContent.indexOf("Exception") > 0) {
                        status = "LOST";
                    }
                    this.executeInfo = EtlLogUtil.addExecuteLog(this.info.getSchemeID(), status, startTime, endTime, this.getCompanyName(index), this.getDBName(index), this.dispatchLogID, logContent);
                    if (this.executeInfo != null) {
                        EtlExecuteLogFactory.getLocalInstance(this.ctx).addLogInfo(this.executeInfo);
                    }
                    if (status.equals("LOST")) {
                        throw new Exception("etl dispatch lost");
                    }
                    if (logContent.indexOf("Exception") > 0) {
                        throw new Exception("etl dispatch lost");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logContent = e.getMessage();
                if (status == null) {
                    status = "LOST";
                    if (e.getMessage().indexOf("Connection refused: connect") > 0) {
                        logContent = "kettle \u670d\u52a1\u5668\u672a \u542f\u52a8,\u8bf7\u542f\u52a8kettle\u670d\u52a1\u5668\u3002\n1.\u67e5\u770bkettle\u670d\u52a1\u5668 URL=" + url + " \u662f\u5426\u53ef\u4ee5\u8bbf\u95ee\u3002\n2.\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6b63\u786e\u914d\u7f6e\u3002\u914d\u7f6e\u6587\u4ef6\u8def\u5f84(eas \u670d\u52a1\u5668)\uff1a" + configFileName + "\n3.\u8bf7\u914d\u7f6e\u6b63\u786e\u7684kettle\u670d\u52a1\u5668\u5730\u5740\uff0c\u5e76\u542f\u52a8";
                        this.addException(new Exception(logContent));
                    }
                    date2 = new Date();
                    Timestamp endTime = new Timestamp(date2.getTime());
                    this.executeInfo = EtlLogUtil.addExecuteLog(this.info.getSchemeID(), status, startTime, endTime, this.getCompanyName(index), this.getDBName(index), this.dispatchLogID, logContent);
                    if (this.executeInfo != null) {
                        EtlExecuteLogFactory.getLocalInstance(this.ctx).addLogInfo(this.executeInfo);
                    }
                }
                throw e;
            }
        }
    }

    public String getStrategy() {
        return this.info.getLostStra();
    }

    @Override
    public void completeEntry() {
        String schemeID = this.info.getScheme().getId().toString();
        try {
            EtlStrategyFacadeFactory.getLocalInstance(this.ctx).addStrategy(schemeID, this.dispatchLogID, this.logInfo.toString());
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    @Override
    public String getSchemeName() {
        return this.info.getScheme().getName();
    }

    @Override
    public void logException(Exception e) {
        this.addException(e);
    }

    public String getLogInfo() {
        return this.logInfo.toString();
    }

    @Override
    public void logInfo(String obj) {
        this.logInfo.append(obj);
        this.logInfo.append("\n");
    }

    public boolean hasTryCatchScheme() {
        return this.info.huaTryCatchScheme();
    }

    @Override
    public void executScheme(int i) throws Exception {
        this.info.refreshSchemeXMLAtApp(this.ctx);
        this.executeEntry(this.info.getScheme(), i, false);
    }

    @Override
    public void executTryCatchScheme(int i) throws Exception {
        byte[] catchScheme = this.info.getScheme().getCatchScheme();
        if (catchScheme == null || catchScheme.length == 0) {
            this.logInfo("\u4e0d\u5b58\u5728ETL\u5f02\u5e38\u5904\u7406\u65b9\u6848");
        } else {
            this.executeEntry(this.info.getScheme(), i, true);
        }
    }

    @Override
    public String getCompanyName(int index) {
        if (this.info.getScheme().getComDBMapping() == null) {
            return "";
        }
        if (index > this.info.getScheme().getComDBMapping().getEntry().size() - 1) {
            return "";
        }
        EtlCompanyDBMappingEntryInfo entryInfo = this.info.getScheme().getComDBMapping().getEntry().get(index);
        if (entryInfo.getCompany() == null) {
            return "";
        }
        return entryInfo.getCompany().getName();
    }

    @Override
    public int getBatchSize() {
        return this.info.getEntrySize();
    }

    @Override
    public String getDBName(int index) {
        if (this.info.getScheme().getComDBMapping() == null) {
            return "";
        }
        if (index > this.info.getScheme().getComDBMapping().getEntry().size() - 1) {
            return "";
        }
        EtlSchemeManagerInfo managerInfo = this.info.getScheme();
        if (managerInfo.getDataCenter(index) == null) {
            return "";
        }
        try {
            DBCenterModel centerModel = DBConnectionMap.getInstance(null).get(managerInfo.getDataCenter(index));
            if (centerModel == null) {
                return "\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5931\u8d25\uff1a\u6570\u636e\u4e2d\u5fc3ID=" + managerInfo.getDataCenter(index);
            }
            return centerModel.getDbCenterName();
        }
        catch (Exception e) {
            return "\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5931\u8d25\uff1a\u6570\u636e\u4e2d\u5fc3ID=" + managerInfo.getDataCenter(index);
        }
    }
}

