/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.sc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletCollection;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataAcquisitionTempletInfo;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingRelationCollection;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingRelationFactory;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingRelationInfo;
import com.kingdee.eas.framework.bireport.bimanager.sc.UploadToEnum;
import com.kingdee.eas.framework.bireport.bimanager.sc.UrgeUpLoadCollection;
import com.kingdee.eas.framework.bireport.bimanager.sc.UrgeUpLoadFactory;
import com.kingdee.eas.framework.bireport.bimanager.sc.UrgeUpLoadInfo;
import com.kingdee.eas.framework.bireport.bimanager.web.FlowCfgCollection;
import com.kingdee.eas.framework.bireport.bimanager.web.FlowCfgFactory;
import com.kingdee.eas.framework.bireport.bimanager.web.FlowCfgInfo;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;

public class UrgeUpLoadCallBack {
    void exceute(Context ctx) throws BOSException {
        if (!this.hasUrgeUpLoad(ctx)) {
            return;
        }
        UrgeUpLoadCollection cols = this.getUrgeUpLoadCollection(ctx);
        UrgeUpLoadCollection jtcb = new UrgeUpLoadCollection();
        UrgeUpLoadCollection zgscb = new UrgeUpLoadCollection();
        for (int i = 0; i < cols.size(); ++i) {
            UrgeUpLoadInfo urgeUpLoadInfo = cols.get(i);
            if (urgeUpLoadInfo.getUrgeByGroup().equals((Object)UploadToEnum.GroupUrge)) {
                jtcb.add(urgeUpLoadInfo);
                continue;
            }
            zgscb.add(urgeUpLoadInfo);
        }
        this.urgeGroup(jtcb, ctx);
        this.urgeSonCompany(zgscb, ctx);
    }

    public UrgeUpLoadCollection getUrgeUpLoadCollection(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getGroupUrgeSelector());
        UrgeUpLoadCollection urgeUpLoads = UrgeUpLoadFactory.getLocalInstance(ctx).getUrgeUpLoadCollection(view);
        return urgeUpLoads;
    }

    private void urgeGroup(UrgeUpLoadCollection urgeUpLoads, Context ctx) throws BOSException {
        if (urgeUpLoads == null || urgeUpLoads.size() < 1) {
            return;
        }
        this.urgeBaseDataUpload(urgeUpLoads, ctx);
        this.urgeFactDataUpload(urgeUpLoads, ctx);
        this.urgeMappingUpload(urgeUpLoads, ctx);
    }

    private void urgeMappingUpload(UrgeUpLoadCollection urgeUpLoads, Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("isUser", (Object)new Integer(1)));
        view.setFilter(f);
        view.getSelector().add("mappingScheme.*");
        view.getSelector().add("mappingScheme.company.id");
        view.getSelector().add("endDate");
        MappingRelationCollection collection = MappingRelationFactory.getLocalInstance(ctx).getMappingRelationCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            MappingRelationInfo relationInfo = collection.get(i);
            for (int j = 0; j < urgeUpLoads.size(); ++j) {
                this.SentMsgMappingGroup(ctx, urgeUpLoads.get(i), relationInfo);
            }
        }
    }

    private void SentMsgMappingGroup(Context ctx, UrgeUpLoadInfo urgeUpLoadInfo, MappingRelationInfo relationInfo) {
        Date endDate = relationInfo.getEndDate();
        int days = (int)(endDate.getTime() - new Date().getTime()) / 86400000;
        FilterInfo filter = new FilterInfo();
        if (days < 0) {
            filter.getFilterItems().add(new FilterItemInfo("beforeNoticeDays", (Object)new Integer(0 - days)));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("afterUrgeDays", (Object)new Integer(days)));
        }
        filter.getFilterItems().add(new FilterItemInfo("urgeByGroup", (Object)"01"));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)relationInfo.getMappingScheme().getCompany().getId().toString()));
    }

    private void urgeFactDataUpload(UrgeUpLoadCollection urgeUpLoads, Context ctx) {
    }

    private void urgeBaseDataUpload(UrgeUpLoadCollection urgeUpLoads, Context ctx) throws BOSException {
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("isUser", (Object)new Integer(1)));
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < urgeUpLoads.size(); ++i) {
            UrgeUpLoadInfo info = urgeUpLoads.get(i);
            companySet.add(info.getCompany().getId().toString());
        }
        f.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("id", (Object)"select FBaseDataTempletID from T_BI_MNG_BaseData"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(f);
        view.getSelector().add("*");
        BaseDataAcquisitionTempletCollection tempCos = BaseDataAcquisitionTempletFactory.getLocalInstance(ctx).getBaseDataAcquisitionTempletCollection(view);
        if (tempCos.size() < 1) {
            return;
        }
        int i = 0;
        if (i < tempCos.size()) {
            BaseDataAcquisitionTempletInfo templetInfo = tempCos.get(i);
            this.urgeBaseDataTemple(ctx, urgeUpLoads, templetInfo);
            return;
        }
    }

    private boolean isBeforeIn(Date endDate, int before) {
        return false;
    }

    private void urgeBaseDataTemple(Context ctx, UrgeUpLoadCollection urgeUpLoads, BaseDataAcquisitionTempletInfo templetInfo) {
        int n = urgeUpLoads.size();
        for (int i = 0; i < n; ++i) {
            UrgeUpLoadInfo upLoadInfo = urgeUpLoads.get(i);
            if (!upLoadInfo.getUrgeByGroup().equals((Object)UploadToEnum.GroupUrge)) continue;
            if (this.checkTimeIsRighteBefore(upLoadInfo.getBeforeNoticeDays(), templetInfo.getEndDate())) {
                this.SentMes(ctx, upLoadInfo.getUserCollection(ctx, 0), templetInfo, urgeUpLoads, true);
            }
            if (!this.checkTiemeIsRighteAfter(upLoadInfo.getAfterUrgeDays(), templetInfo.getEndDate())) continue;
            this.SentMes(ctx, upLoadInfo.getUserCollection(ctx, 0), templetInfo, urgeUpLoads, false);
        }
    }

    private boolean checkTiemeIsRighteAfter(int afterUrgeDays, Date endDate) {
        return false;
    }

    private boolean checkTimeIsRighteBefore(int beforeNoticeDays, Date endDate) {
        return (new Date().getTime() - endDate.getTime()) / 86400000L - (long)beforeNoticeDays == 0L;
    }

    private void SentMes(Context ctx, UserCollection userCollection, BaseDataAcquisitionTempletInfo templetInfo, UrgeUpLoadCollection urgeUpLoads, boolean b) {
    }

    private boolean timeisRighte(BaseDataAcquisitionTempletInfo templetInfo, Context ctx) {
        return false;
    }

    private void urgeSonCompany(UrgeUpLoadCollection urgeUpLoads, Context ctx) throws BOSException {
        if (urgeUpLoads == null || urgeUpLoads.size() < 1) {
            return;
        }
        this.auditFlowUrge(urgeUpLoads, ctx);
        this.dataMapingUrge(urgeUpLoads, ctx);
    }

    private void dataMapingUrge(UrgeUpLoadCollection urgeUpLoads, Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(2)));
        f.getFilterItems().add(new FilterItemInfo("isUser", (Object)new Integer(1)));
        view.setFilter(f);
        view.getSelector().add("mappingScheme.*");
        view.getSelector().add("mappingScheme.company.id");
        view.getSelector().add("endDate");
        MappingRelationCollection collection = MappingRelationFactory.getLocalInstance(ctx).getMappingRelationCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            MappingRelationInfo relationInfo = collection.get(i);
            for (int j = 0; j < urgeUpLoads.size(); ++j) {
                this.SentMsgMappingGroup(ctx, urgeUpLoads.get(i), relationInfo);
            }
        }
    }

    private void auditFlowUrge(UrgeUpLoadCollection urgeUpLoads, Context ctx) throws BOSException {
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("currAuditSeq", (Object)new Integer(0), CompareType.NOTEQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(f);
        view.getSelector().add("seq");
        view.getSelector().add("company.id");
        view.getSelector().add("auditFlow.entry.user.id");
        view.getSelector().add("auditFlow.entry.seq");
        view.getSelector().add("auditFlow.entry.userGroup.users.id");
        FlowCfgCollection collection = FlowCfgFactory.getLocalInstance(ctx).getFlowCfgCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            FlowCfgInfo flowCfgInfo = collection.get(i);
            this.sendMsg(ctx, flowCfgInfo, urgeUpLoads);
        }
    }

    private void sendMsg(Context ctx, FlowCfgInfo flowCfgInfo, UrgeUpLoadCollection urgeUpLoads) throws BOSException {
        for (int i = 0; i < urgeUpLoads.size(); ++i) {
            UrgeUpLoadInfo upLoadInfo = urgeUpLoads.get(i);
            if (!upLoadInfo.getUrgeByGroup().equals((Object)UploadToEnum.SonCompanyUrge) || !flowCfgInfo.getCompany().getId().toString().equalsIgnoreCase(flowCfgInfo.getCompany().getId().toString()) || !upLoadInfo.getUrgeTypeEnum().equals("01")) continue;
            this.SendMsgSonCompanyData(ctx, flowCfgInfo, upLoadInfo);
        }
    }

    private void SendMsgSonCompanyData(Context ctx, FlowCfgInfo flowCfgInfo, UrgeUpLoadInfo upLoadInfo) throws BOSException {
    }

    public SelectorItemCollection getGroupUrgeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("isNoticeBySysMsg"));
        sic.add(new SelectorItemInfo("isNoticeByMail"));
        sic.add(new SelectorItemInfo("isNoticeByPhoneMsg"));
        sic.add(new SelectorItemInfo("beforeNoticeDays"));
        sic.add(new SelectorItemInfo("afterUrgeDays"));
        sic.add(new SelectorItemInfo("users.*"));
        sic.add(new SelectorItemInfo("users.user.*"));
        sic.add(new SelectorItemInfo("groups.*"));
        sic.add(new SelectorItemInfo("groups.group.users*"));
        return sic;
    }

    public SelectorItemCollection getProcessUrgeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("isNoticeBySysMsg"));
        sic.add(new SelectorItemInfo("isNoticeByMail"));
        sic.add(new SelectorItemInfo("isNoticeByPhoneMsg"));
        sic.add(new SelectorItemInfo("beforeNoticeDays"));
        sic.add(new SelectorItemInfo("afterUrgeDays"));
        return sic;
    }

    public boolean hasUrgeUpLoad(Context ctx) throws BOSException {
        String sql = "select top 1 fid from T_BI_MNG_UrgeUpLoad";
        try {
            RptRowSet executeQuery = DBUtilx.executeQuery((String)sql, null, (Context)ctx);
            if (executeQuery.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

