/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.wrapper.MethodWrapper;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.InputSource;

public class ScheduleMngUtil {
    private static Logger log = Logger.getLogger(ScheduleMngUtil.class);
    public static final String SCHEDULE_RETRYTIME = "RetryTime";
    public static final String SCHEDULE_TYPE = "Type";
    public static final String SCHEDULE_BEGIN_TIME = "BeginTime";
    public static final String SCHEDULE_END_TIME = "EndTime";
    public static final String SCHEDULE_USE_CALENDAR = "UseCalendar";
    public static final String SCHEDULE_ORG_UnitId = "OrgUnitId";
    public static final String SCHEDULE_INSTRUCTION_TYPE = "InstructionType";
    public static final String SCHEDULE_SCHEDULE_PLAN = "SchedulePlan";

    public static void createJobDef(Context ctx, String viewId, String viewName, String scheduleXML, Class claName, String methodName, Object[] params) throws Exception {
        JobDef jobDef = ScheduleMngUtil.toJobDef(ctx, viewId, viewName, scheduleXML, claName, methodName, params);
        Trigger trigger = ScheduleMngUtil.toTrigger(jobDef, scheduleXML);
        IJobService svc = JobServiceFactory.getLocalInstance((Context)ctx);
        try {
            svc.createJobDef(jobDef, trigger, true);
        }
        catch (Throwable e) {
            log.error((Object)("createJobDef error , id:" + viewId + " , scheduleXML:" + scheduleXML), e);
        }
    }

    private static JobDef toJobDef(Context ctx, String viewId, String viewName, String scheduleXML, Class claName, String methodName, Object[] params) throws Exception {
        String jobdefid = viewId + "BGJOBDEF";
        String packageName = "com.kingdee.eas.framework.bireport.bimanager.etl.client";
        String title = "BI\u7ba1\u63a7\u4e2d\u5fc3-" + viewName;
        String description = "BI\u7ba1\u63a7\u4e2d\u5fc3\uff1aid=" + viewId + ",name" + viewName;
        String proxyUserID = ctx.getCaller().toString();
        String proxyOrgID = (String)ScheduleMngUtil.xmlToMap(scheduleXML).get(SCHEDULE_ORG_UnitId);
        boolean isPersistent = true;
        MethodWrapper handler = null;
        boolean isSmallJob = false;
        String mutex = null;
        int priority = 0;
        int missedTimeout = -1;
        JobIsolationLevel isolationLevel = null;
        String viewerUI = null;
        String dc = ctx.getAIS();
        String user = ctx.getCaller().toString();
        handler = new MethodWrapper(claName, methodName, params);
        JobDef jobDef = new JobDef(jobdefid, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, (Wrapper)handler, isSmallJob, mutex, priority, missedTimeout, isolationLevel, viewerUI, dc, user);
        return jobDef;
    }

    private static Trigger toTrigger(JobDef jobDef, String scheduleXML) throws Exception {
        Date validateTime = new Date();
        Date expiredTime = new Date(2842790400000L);
        String pulseSourceCode = "timer";
        boolean isAutoLoad = true;
        String schedulePlan = (String)ScheduleMngUtil.xmlToMap(scheduleXML).get(SCHEDULE_TYPE) + ":" + (String)ScheduleMngUtil.xmlToMap(scheduleXML).get(SCHEDULE_SCHEDULE_PLAN);
        boolean useCalendar = "true".equals(ScheduleMngUtil.xmlToMap(scheduleXML).get(SCHEDULE_USE_CALENDAR));
        Trigger trigger = new Trigger(validateTime, expiredTime, jobDef, pulseSourceCode, isAutoLoad, schedulePlan, useCalendar);
        return trigger;
    }

    public static Map xmlToMap(String xml) {
        if (xml == null) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        SAXBuilder sb = new SAXBuilder();
        Document doc = null;
        try {
            doc = sb.build(new InputSource(new StringReader(xml)));
            Element root = doc.getRootElement();
            paramMap.put(SCHEDULE_SCHEDULE_PLAN, root.getText());
            paramMap.put(SCHEDULE_RETRYTIME, root.getAttributeValue(SCHEDULE_RETRYTIME));
            paramMap.put(SCHEDULE_TYPE, root.getAttributeValue(SCHEDULE_TYPE));
            paramMap.put(SCHEDULE_BEGIN_TIME, root.getAttributeValue(SCHEDULE_BEGIN_TIME));
            paramMap.put(SCHEDULE_END_TIME, root.getAttributeValue(SCHEDULE_END_TIME));
            paramMap.put(SCHEDULE_USE_CALENDAR, root.getAttributeValue(SCHEDULE_USE_CALENDAR));
            paramMap.put(SCHEDULE_ORG_UnitId, root.getAttributeValue(SCHEDULE_ORG_UnitId));
            paramMap.put(SCHEDULE_INSTRUCTION_TYPE, root.getAttributeValue(SCHEDULE_INSTRUCTION_TYPE));
        }
        catch (JDOMException je) {
            log.error((Object)("bulid xml, xml:" + xml + " error"), (Throwable)je);
        }
        catch (IOException ie) {
            log.error((Object)("bulid xml, xml:" + xml + " error"), (Throwable)ie);
        }
        return paramMap;
    }
}

