/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.web.app.spi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.ServletHelper;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONString;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.web.IWebUtilFacade;
import com.kingdee.eas.framework.bireport.bimanager.web.WebUtilFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.web.app.IBIManagerServer;
import com.kingdee.eas.framework.bireport.bimanager.web.app.WebUtilFacadeControllerBean;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetTemplateHasUploadHandler
implements IBIManagerServer {
    @Override
    public String getMappingActionName() {
        return "getTemplateHasUpload";
    }

    @Override
    public JSON service(Context ctx, HttpServletRequest request, HttpServletResponse response, IWebUtilFacade facade, OrgUnitInfo orgInfo, String currUserIDAndOrg) throws BIReportException, BOSException, EASBizException {
        try {
            facade = WebUtilFacadeFactory.getRemoteInstance();
            return new JSONMap(this._getTemplate(ctx, currUserIDAndOrg, request.getParameter("treenode")));
        }
        catch (BOSException e) {
            try {
                ServletHelper.writeOut((HttpServletResponse)response, (String)ServletHelper.wrapError((JSON)new JSONString(e.getMessage())));
            }
            catch (IOException e1) {
                e.printStackTrace();
            }
            return null;
        }
        catch (EASBizException e) {
            try {
                ServletHelper.writeOut((HttpServletResponse)response, (String)ServletHelper.wrapError((JSON)new JSONString(e.getMessage())));
            }
            catch (IOException e1) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected Map _getTemplate(Context ctx, String userIDAndOrg, String baseOrFact) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        ArrayList templateList = new ArrayList();
        HashMap<String, Object> tempMap = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            RptRowSet rs = null;
            String[] userIDAndOrgArray = userIDAndOrg.split("@");
            String userID = userIDAndOrgArray[0];
            String companyID = userIDAndOrgArray[1];
            String biProSchemeID = WebUtilFacadeControllerBean.getBIProSchemeID(conn, userID);
            Object[] params = null;
            StringBuffer getTemplateListStr = new StringBuffer();
            if (baseOrFact.equals("basedata")) {
                getTemplateListStr.append("  select bd.fid, bd.FName_L2 fname,bd.fnumber from T_BI_MNG_BaseDataAT bd  \r\n");
                getTemplateListStr.append(" inner join T_BI_MNG_BaseData up on up.FBaseDataTempletID=bd.fid  \r\n");
                getTemplateListStr.append(" where     up.FBillStatus<>3 and                                       \r\n");
                getTemplateListStr.append("  bd.FCompanyID=? and bd.FBIProSchemeID=? and bd.FReportSource=? and bd.FIsUsed=1 \r\n");
                params = new Object[]{companyID, biProSchemeID, new Integer(1)};
            } else if (baseOrFact.equals("factdata")) {
                getTemplateListStr.append(" select fd.fid, fd.FName_L2 fname,fd.fnumber, fd.FGatherFrequency from T_BI_MNG_FactDataTemplet fd \r\n");
                getTemplateListStr.append(" where                                            \r\n");
                getTemplateListStr.append("  fd.FCompanyID=? and fd.FBIProSchemeID=? and fd.FReportSource=? and fd.FIsUsed=1 \r\n");
                params = new Object[]{companyID, biProSchemeID, new Integer(1)};
            } else {
                getTemplateListStr.append("  (select bd.fid, bd.FName_L2 fname,bd.fnumber from T_BI_MNG_BaseDataAT bd \r\n");
                getTemplateListStr.append(" left join T_BI_MNG_FlowCfg fc on fc.FTemplateID=bd.FID                  \r\n");
                getTemplateListStr.append(" where fc.FTemplateID is null                                            \r\n");
                getTemplateListStr.append(" and bd.FCompanyID=? and bd.FBIProSchemeID=? and bd.FReportSource=? and bd.FIsUsed=1) \r\n");
                getTemplateListStr.append(" union all \r\n");
                getTemplateListStr.append(" (select fd.fid, fd.FName_L2 fname,fd.fnumber from T_BI_MNG_FactDataTemplet fd \r\n");
                getTemplateListStr.append(" left join T_BI_MNG_FlowCfg fc on fc.FTemplateID=fd.FID                  \r\n");
                getTemplateListStr.append(" where fc.FTemplateID is null                                            \r\n");
                getTemplateListStr.append(" and fd.FCompanyID=? and fd.FBIProSchemeID=? and fd.FReportSource=? and fd.FIsUsed=1) \r\n");
                params = new Object[]{companyID, biProSchemeID, new Integer(1), companyID, biProSchemeID, new Integer(1)};
            }
            SqlParams sqlParams = new SqlParams(params);
            rs = DBUtil.executeQuery((String)getTemplateListStr.toString(), (SqlParams)sqlParams, (Connection)conn);
            while (rs.next()) {
                tempMap = new HashMap<String, Object>();
                tempMap.put("fid", rs.getString("fid"));
                tempMap.put("fname", rs.getString("fname"));
                tempMap.put("fnumber", rs.getString("fnumber"));
                if (baseOrFact.equals("factdata")) {
                    tempMap.put("FGatherFrequency", rs.getObject("FGatherFrequency"));
                }
                templateList.add(tempMap);
            }
            map.put("templateList", templateList);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

