/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionTypeInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.app.ConnectionHelper;
import com.kingdee.eas.framework.bireport.bimanager.ws.TimeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSInvokeException;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDBInstanceInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsInterfaceTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.ws.app.AbstractWSEngineInvokeFacadeControllerBean;
import com.kingdee.eas.framework.bireport.bimanager.ws.app.WsCheckTableColumnHandler;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientAgent;
import com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.translate.ExpressionInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.sysParam.DefaultParamValueInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.BizMethod;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.ClientAgentCreator;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.ClientAgentUtil;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.DBTableStructHelper;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.WSDLUtil;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WSEngineInvokeFacadeControllerBean
extends AbstractWSEngineInvokeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.ws.app.WSEngineInvokeFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getDBList(Context ctx, String url, String userName, String psw) throws BOSException, EASBizException, WSInvokeException {
        ClientAgent clientAgent = null;
        try {
            clientAgent = ClientAgentCreator.getClientAgent(url, userName, psw);
            List list = clientAgent.getDataBases();
            return list;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (clientAgent != null) {
                clientAgent.client().terminal();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getTableColumn(Context ctx, String url, String userName, String psw, String DBID, String tableName) throws BOSException, EASBizException, WSInvokeException {
        ClientAgent clientAgent = null;
        try {
            clientAgent = ClientAgentCreator.getClientAgent(url, userName, psw);
            List list = clientAgent.getTableColumns(DBID, tableName);
            return list;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (clientAgent != null) {
                clientAgent.client().terminal();
            }
        }
        return null;
    }

    private void handleException(Exception e) throws BOSException, EASBizException, WSInvokeException {
        if (e.getMessage() != null && e.getMessage().indexOf("Connection refused: connect") > -1) {
            throw new WSInvokeException(WSInvokeException.TOMCATISNOTSTART);
        }
        if (e.getMessage() != null && e.getMessage().indexOf("Login failed") > -1) {
            throw new WSInvokeException(WSInvokeException.LOADFAIL);
        }
        if (e.getMessage() != null && e.getMessage().indexOf("HTTP Version Not Supported") > -1) {
            throw new WSInvokeException(WSInvokeException.URLISNOTRIGHT);
        }
        if (e.getMessage() != null && e.getMessage().indexOf("The service cannot be found for the endpoint reference") > -1) {
            throw new WSInvokeException(WSInvokeException.URLISNOTRIGHT);
        }
        if (e.getMessage() != null && e.getMessage().indexOf("no protocol") > -1) {
            throw new WSInvokeException(WSInvokeException.URLISNOTRIGHT);
        }
        throw new BOSException((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getTables(Context ctx, String url, String userName, String psw, String DBID) throws BOSException, EASBizException, WSInvokeException {
        ClientAgent clientAgent = null;
        try {
            clientAgent = ClientAgentCreator.getClientAgent(url, userName, psw);
            List list = clientAgent.getTables(DBID);
            return list;
        }
        catch (Exception e) {
            this.handleException(e);
            List list = null;
            return list;
        }
        finally {
            if (clientAgent != null) {
                clientAgent.client().terminal();
            }
        }
    }

    @Override
    protected List _getBizMethodParams(Context ctx, String url, String methodName) throws BOSException, EASBizException, WSInvokeException {
        LinkedList list = new LinkedList();
        try {
            List list2 = WSDLUtil.getBizMethoeds(url);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getBizMethods(Context ctx, String url) throws BOSException, EASBizException, WSInvokeException {
        ClientAgent clientAgent = null;
        try {
            clientAgent = ClientAgentCreator.getClientAgent(url);
            Object wsdl = clientAgent.getWSDL();
            if (wsdl == null) {
                throw new BOSException();
            }
            if (wsdl instanceof List) {
                List list = (List)wsdl;
                return list;
            }
            String wsdlURL = wsdl.toString().indexOf("?wsdl") > 0 ? wsdl.toString() : wsdl.toString() + "?wsdl";
            List list = WSDLUtil.getBizMethoeds(wsdlURL);
            return list;
        }
        catch (Exception e) {
            this.handleException(e);
            List list = null;
            return list;
        }
        finally {
            if (clientAgent != null) {
                clientAgent.client().terminal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RptRowSet _queryBySql(Context ctx, String url, String user, String psw, String dbID, String sql) throws BOSException, EASBizException {
        if (sql.startsWith("easKSQL")) {
            String SQL = sql.substring(7, sql.length());
            try {
                if (SQL.indexOf("create ") > 0 || SQL.indexOf("alter ") > 0 || SQL.indexOf("update ") > 0 || SQL.indexOf("drop ") > 0 || SQL.indexOf("delete ") > 0) {
                    DBUtilx.execute((String)SQL, null, (Context)ctx);
                    return null;
                }
                return DBUtilx.executeQuery((String)SQL, null, (Context)ctx);
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
        }
        ClientAgent clientAgent = null;
        Map queryBySql = null;
        try {
            clientAgent = ClientAgentCreator.getClientAgent(url, user, psw);
            queryBySql = clientAgent.queryBySql(dbID, sql, 100);
            RptRowSet rptRowSet = new RptRowSet((String[])queryBySql.get("columnNames"), (List)queryBySql.get("rowSet"));
            return rptRowSet;
        }
        catch (Exception e) {
            try {
                if (null != queryBySql && queryBySql.containsKey("exception")) {
                    this.handleException((Exception)queryBySql.get("exception"));
                } else {
                    this.handleException(e);
                }
            }
            catch (WSInvokeException e1) {
                throw new BOSException((Throwable)((Object)e1));
            }
        }
        finally {
            if (clientAgent != null) {
                clientAgent.client().terminal();
            }
        }
        return null;
    }

    @Override
    protected void _checkSchemeTableColumn(Context ctx, String schemeID) throws BOSException, EASBizException, WSInvokeException {
        WsExtractSchemeInfo schemeInfo = this.getWsSchemeInfo(ctx, schemeID);
        if (schemeInfo == null) {
            return;
        }
        this.execut(schemeInfo, ctx);
    }

    private WsExtractSchemeInfo getWsSchemeInfo(Context ctx, String schemeID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        view.getSelector().add("service.*");
        view.getSelector().add("dbInstance.*");
        view.getSelector().add("entry.*");
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)schemeID));
        view.setFilter(f);
        WsExtractSchemeCollection collection = WsExtractSchemeFactory.getLocalInstance(ctx).getWsExtractSchemeCollection(view);
        if (collection.size() == 1) {
            return collection.get(0);
        }
        return null;
    }

    public void execut(WsExtractSchemeInfo info, Context ctx) {
        if (info != null) {
            if (WsInterfaceTypeEnum.BUSINESS.equals((Object)info.getInterfaceType())) {
                this.excuteQueryByBiz(ctx, info);
            } else if (WsInterfaceTypeEnum.COMMON_SQL.equals((Object)info.getInterfaceType())) {
                this.excuteQueryBySQL(ctx, info);
            } else {
                this.excuteQueryByTable(ctx, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteQueryByBiz(Context ctx, WsExtractSchemeInfo wsScheme) {
        BizMethod method = new BizMethod();
        method.setAsText(wsScheme.getExtractMethod());
        String methodName = method.methodName;
        WsExtractSchemeEntryCollection entry = wsScheme.getEntry();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entry.size(); ++i) {
            WsExtractSchemeEntryInfo entryInfo = entry.get(i);
            DefaultParamValueInfo paramValue = new DefaultParamValueInfo();
            paramValue.value = paramValue.parse(entryInfo.getSysValue());
            map.put(entryInfo.getMethodName(), paramValue.value.toValueOnparam(ctx));
        }
        ClientAgent agent = ClientAgentUtil.getAgent(wsScheme.getService());
        try {
            Object lock = new Object();
            WsCheckTableColumnHandler callHandler = new WsCheckTableColumnHandler(ctx, wsScheme, lock);
            agent.queryByBizMethod(null, methodName, map, callHandler, this);
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (Exception exception) {
        }
        finally {
            agent.client().terminal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteQueryByTable(Context ctx, WsExtractSchemeInfo wsScheme) {
        String dbID = wsScheme.getDbInstance().getDBInstanceID();
        String extractTbl = wsScheme.getExtractTbl();
        String timeField = wsScheme.getTimeField();
        String startDate = wsScheme.getStartDate();
        String endDate = wsScheme.getEndDate();
        ClientAgent agent = ClientAgentUtil.getAgent(wsScheme.getService());
        Object lock = new Object();
        try {
            WsCheckTableColumnHandler callHandler = new WsCheckTableColumnHandler(ctx, wsScheme, lock);
            agent.queryByTable(dbID, extractTbl, timeField, TimeInfo.stringToTimeInfo(startDate).timeInfo2Date(), TimeInfo.stringToTimeInfo(startDate).timeInfo2Date(), callHandler, this);
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (Exception exception) {
        }
        finally {
            agent.client().terminal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteQueryBySQL(Context ctx, WsExtractSchemeInfo wsScheme) {
        WsDBInstanceInfo dbInstance = wsScheme.getDbInstance();
        dbInstance.setWsManager(wsScheme.getService());
        String customSql = wsScheme.getCustomSql();
        ExpressionInfo expre = new ExpressionInfo(customSql, ctx);
        ClientAgent agent = ClientAgentUtil.getAgent(dbInstance.getWsManager());
        try {
            Object lock = new Object();
            String sql = expre.toStringAtApp();
            sql = "select * from (" + sql + ") A where 1!=1";
            WsCheckTableColumnHandler callHandler = new WsCheckTableColumnHandler(ctx, wsScheme, lock);
            agent.queryBySql(dbInstance.getDBInstanceID(), sql, callHandler, this);
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (Exception exception) {
        }
        finally {
            agent.client().terminal();
        }
    }

    @Override
    protected Map _getTableStruct(Context ctx, String tableName, String schemeID, String type) throws BOSException, EASBizException {
        DBConnectionTypeInfo connection = null;
        connection = "eas".equals(type) ? ConnectionHelper.getEASConnection(ctx) : ("ods".equals(type) ? ConnectionHelper.getODSConnection(ctx, schemeID) : ConnectionHelper.getDWConnection(ctx, schemeID));
        try {
            Map map = DBTableStructHelper.getTableColumnKey_Type(connection, tableName);
            return map;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (connection != null && connection.conn != null) {
                try {
                    connection.conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

