/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.encryptalgorithm;

import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.IEncryptoAlgorithm;
import java.security.MessageDigest;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CryptoTeanImpl
implements IEncryptoAlgorithm {
    private static final int ROUNDS = 32;
    private static final int DELTA = -1640531527;

    @Override
    public String encrypt(String strKey, String strSrc) throws CryptException {
        String strEncode;
        byte[] btKey = new byte[strKey.getBytes().length + 1];
        System.arraycopy(strKey.getBytes(), 0, btKey, 0, strKey.getBytes().length);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(btKey);
            byte[] btDigest = md.digest();
            byte[] btSrc = strSrc.getBytes("UTF-16LE");
            byte[] btEncrypt = CryptoTeanImpl.encrypt(btDigest, btSrc);
            BASE64Encoder encoder = new BASE64Encoder();
            strEncode = encoder.encode(btEncrypt);
        }
        catch (Exception e) {
            throw new CryptException(e.getMessage(), e);
        }
        return strEncode;
    }

    @Override
    public String decrypt(String strKey, String strEncrypt) throws CryptException {
        String strDecode;
        byte[] btKey = new byte[strKey.getBytes().length + 1];
        System.arraycopy(strKey.getBytes(), 0, btKey, 0, strKey.getBytes().length);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(btKey);
            byte[] btDigest = md.digest();
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] btDecode = decoder.decodeBuffer(strEncrypt);
            byte[] btDeCrypt = CryptoTeanImpl.decrypt(btDigest, btDecode);
            strDecode = new String(btDeCrypt, "UTF-16LE");
        }
        catch (Exception e) {
            throw new CryptException(e.getMessage(), e);
        }
        return strDecode;
    }

    public static byte[] encrypt(byte[] k, byte[] v) {
        CryptoTeanImpl.tean(k, v, 32);
        return v;
    }

    public static byte[] decrypt(byte[] k, byte[] v) {
        CryptoTeanImpl.tean(k, v, -32);
        return v;
    }

    static int bytesToInt(byte[] b, int offset) {
        int i = ((b[0 + offset] & 0xFF) << 0) + ((b[1 + offset] & 0xFF) << 8) + ((b[2 + offset] & 0xFF) << 16) + ((b[3 + offset] & 0xFF) << 24);
        return i;
    }

    static int[] bytesToInts(byte[] b) {
        if (b.length < 0) {
            return null;
        }
        int[] p = new int[b.length / 4];
        for (int i = 0; i < b.length / 4; ++i) {
            p[i] = CryptoTeanImpl.bytesToInt(b, i * 4);
        }
        return p;
    }

    static byte[] intToBytes(int i) {
        byte[] b = new byte[]{(byte)(i >> 0), (byte)(i >> 8), (byte)(i >> 16), (byte)(i >> 24)};
        return b;
    }

    private static void tean(byte[] k, byte[] v, int N) {
        if (v.length % 8 != 0 || k.length % 16 != 0) {
            return;
        }
        for (int i = 0; i < v.length / 8; ++i) {
            byte[] temp = new byte[8];
            System.arraycopy(v, i * 8, temp, 0, 8);
            CryptoTeanImpl.inner_tean(k, temp, N);
            System.arraycopy(temp, 0, v, i * 8, 8);
        }
    }

    private static void inner_tean(byte[] k1, byte[] v1, int N) {
        int[] k = CryptoTeanImpl.bytesToInts(k1);
        int[] v = CryptoTeanImpl.bytesToInts(v1);
        int y = v[0];
        int z = v[1];
        int sum = 0;
        if (N > 0) {
            int limit = -1640531527 * N;
            while (sum != limit) {
                z += ((y += (z << 4 ^ z >>> 5) + (z ^ sum) + k[sum & 3]) << 4 ^ y >>> 5) + (y ^ (sum -= 1640531527)) + k[sum >> 11 & 3];
            }
        } else {
            sum = -1640531527 * -N;
            while (sum != 0) {
                y -= ((z -= (y << 4 ^ y >>> 5) + (y ^ sum) + k[sum >> 11 & 3]) << 4 ^ z >>> 5) + (z ^ (sum += 1640531527)) + k[sum & 3];
            }
        }
        System.arraycopy(CryptoTeanImpl.intToBytes(y), 0, v1, 0, 4);
        System.arraycopy(CryptoTeanImpl.intToBytes(z), 0, v1, 4, 4);
    }
}

