/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.base.util;

import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.log4j.Logger;

public class ClassUtil {
    private static final Logger logger = Logger.getLogger(ClassUtil.class);
    public static final String JAR_URL_SEPARATOR = "!/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List<Class> findPackageClasses(String configPackage) throws IOException {
        ArrayList<Class> classList;
        block8: {
            String filePath;
            URL url;
            ClassLoader loader;
            String configPackagePath;
            block7: {
                configPackagePath = configPackage.replace('.', '/');
                loader = ClassUtil.class.getClassLoader();
                Enumeration<URL> urls = loader.getResources(configPackagePath);
                URL uRL = url = urls.hasMoreElements() ? urls.nextElement() : null;
                if (url == null) {
                    throw new NullPointerException("classes not found in package '" + configPackage + "', current ClassLoader is " + loader.getClass().getName());
                }
                filePath = ClassUtil.getFilePath(url);
                classList = new ArrayList<Class>();
                if (!"jar".equals(url.getProtocol())) break block7;
                FileInputStream fis = null;
                JarInputStream jiStream = null;
                try {
                    fis = new FileInputStream(new File(filePath));
                    jiStream = new JarInputStream(fis);
                    JarEntry jarEntry = null;
                    while ((jarEntry = jiStream.getNextJarEntry()) != null) {
                        Class clazz;
                        String fileName;
                        String entryName = jarEntry.getName();
                        if (!entryName.startsWith(configPackagePath) || !(fileName = entryName.toLowerCase(Locale.ENGLISH)).endsWith(".class") || (clazz = ClassUtil.loadClass(loader, entryName)) == null) continue;
                        classList.add(clazz);
                    }
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{jiStream, fis});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{jiStream, fis});
                break block8;
            }
            if ("file".equals(url.getProtocol())) {
                File[] files;
                File dir = new File(filePath);
                for (File file : files = dir.listFiles()) {
                    Class clazz;
                    String fileName = file.getName().toLowerCase(Locale.ENGLISH);
                    if (!fileName.endsWith(".class") || (clazz = ClassUtil.loadClass(loader, configPackagePath + "/" + file.getName())) == null) continue;
                    classList.add(clazz);
                }
            } else {
                throw new RuntimeException("\u67e5\u627e\u5305'" + configPackage + "'\u4e0b\u6240\u6709\u7c7b\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u67e5\u627e\u8def\u5f84\uff1a" + url.getPath());
            }
        }
        return classList;
    }

    private static String getFilePath(URL jarUrl) {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            urlFile = urlFile.substring(0, separatorIndex);
        }
        try {
            return new URI(urlFile).getPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static Class loadClass(ClassLoader loader, String classFile) {
        try {
            classFile = classFile.substring(0, classFile.length() - 6).replace('/', '.');
            return loader.loadClass(classFile);
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        List<Class> list = ClassUtil.findPackageClasses("com.kingdee.eas.eip.agent.service.config.impl");
        System.out.println(list.size());
        for (Class cl : list) {
            System.out.println(cl.getName());
        }
    }
}

