/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.json.format;

import com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils;
import com.kingdee.eas.csinterface.agent.service.json.JSONException;
import com.kingdee.eas.csinterface.agent.service.json.format.TypeFormatter;
import java.text.ParseException;
import java.util.Date;

public class DataTimeFormatter
implements TypeFormatter<Date> {
    private static final String PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";

    @Override
    public String getClassName() {
        return Date.class.getName();
    }

    @Override
    public String format(Date o) {
        return DateTimeUtils.format(o, PATTERN);
    }

    @Override
    public Date parse(String s) throws JSONException {
        try {
            return DateTimeUtils.parseDate(s, PATTERN);
        }
        catch (ParseException e) {
            throw new JSONException("\u89e3\u6790\u65e5\u671f\u51fa\u9519\uff0c\u89e3\u6790\u5668\u683c\u5f0f'yyyy-MM-dd HH:mm:ss,SSS'\uff0c\u8f93\u5165\u65e5\u671f\u503c'" + s + "'");
        }
    }
}

