/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db;

import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.SQLType;
import com.kingdee.util.TypeConversionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DBTransformUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(ResultSet rs, Integer index, SQLType sqlType) throws SQLException {
        Object result;
        block27: {
            result = null;
            InputStream in = null;
            try {
                if (SQLType.INT.equals(sqlType) || SQLType.PG_INTEGER.equals(sqlType)) {
                    result = rs.getInt(index);
                    break block27;
                }
                if (SQLType.NUMBER.equals(sqlType) || SQLType.DECIMAL.equals(sqlType) || SQLType.NUMERIC.equals(sqlType)) {
                    result = rs.getBigDecimal(index);
                    break block27;
                }
                if (SQLType.BIGINT.equals(sqlType)) {
                    result = rs.getLong(index);
                    break block27;
                }
                if (SQLType.DOUBLE.equals(sqlType)) {
                    result = rs.getDouble(index);
                    break block27;
                }
                if (SQLType.CHAR.equals(sqlType) || SQLType.VARCHAR.equals(sqlType) || SQLType.VARCHAR2.equals(sqlType) || SQLType.NCHAR.equals(sqlType) || SQLType.NVARCHAR.equals(sqlType) || SQLType.NVARCHAR2.equals(sqlType) || SQLType.PG_CHARACTER.equals(sqlType)) {
                    result = rs.getString(index);
                    break block27;
                }
                if (SQLType.DATETIME.equals(sqlType) || SQLType.TIMESTAMP.equals(sqlType) || SQLType.PG_TIMESTAMP.equals(sqlType)) {
                    result = rs.getTimestamp(index);
                    break block27;
                }
                if (SQLType.BINARY.equals(sqlType) || SQLType.VARBINARY.equals(sqlType)) {
                    result = rs.getBytes(index);
                    break block27;
                }
                if (SQLType.BLOB.equals(sqlType) || SQLType.IMAGE.equals(sqlType)) {
                    in = rs.getBinaryStream(index);
                    if (in == null) {
                        Object var5_5 = null;
                        return var5_5;
                    }
                    int blockSize = 1024;
                    byte[] block = new byte[1024];
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    int len = -1;
                    do {
                        try {
                            len = in.read(block);
                        }
                        catch (IOException e1) {
                            throw new SQLException(e1.getMessage());
                        }
                        if (len <= 0) continue;
                        byteOut.write(block, 0, len);
                    } while (len == 1024);
                    result = byteOut.toByteArray();
                    break block27;
                }
                result = SQLType.CLOB.equals(sqlType) || SQLType.NCLOB.equals(sqlType) || SQLType.PG_TEXT.equals(sqlType) ? rs.getString(index) : rs.getObject(index);
            }
            catch (NullPointerException e) {
                Object var6_11 = null;
                return var6_11;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static void transform(PreparedStatement preparedStratement, int index, Object obj, String typeStr) throws Exception {
        boolean isNull;
        SQLType sqlType = SQLType.getEnum(typeStr);
        boolean bl = isNull = obj == null || obj.toString().length() == 0;
        if (SQLType.INT.equals(sqlType) || SQLType.PG_INTEGER.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setNull(index, 4);
            } else {
                preparedStratement.setInt(index, Integer.parseInt(obj.toString()));
            }
        } else if (SQLType.NUMBER.equals(sqlType) || SQLType.NUMERIC.equals(sqlType) || SQLType.DECIMAL.equals(sqlType) || SQLType.DOUBLE.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setNull(index, 8);
            } else {
                preparedStratement.setBigDecimal(index, new BigDecimal(obj.toString()));
            }
        } else if (SQLType.CHAR.equals(sqlType) || SQLType.VARCHAR.equals(sqlType) || SQLType.VARCHAR2.equals(sqlType) || SQLType.NCHAR.equals(sqlType) || SQLType.NVARCHAR.equals(sqlType) || SQLType.NVARCHAR2.equals(sqlType) || SQLType.PG_CHARACTER.equals(sqlType)) {
            preparedStratement.setObject(index, obj);
        } else if (SQLType.DATETIME.equals(sqlType) || SQLType.TIMESTAMP.equals(sqlType) || SQLType.PG_TIMESTAMP.equals(sqlType)) {
            Timestamp time = null;
            if (obj != null && obj.toString().length() != 0) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                Date obj2 = fmt.parse(obj.toString());
                time = new Timestamp(obj2.getTime());
            }
            preparedStratement.setTimestamp(index, isNull ? null : time);
        } else if (SQLType.BINARY.equals(sqlType) || SQLType.VARBINARY.equals(sqlType)) {
            preparedStratement.setBytes(index, isNull ? null : obj.toString().getBytes());
        } else if (SQLType.BLOB.equals(sqlType) || SQLType.IMAGE.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setBytes(index, null);
            } else {
                byte[] bytesTemp = TypeConversionUtils.objToBytes((Object)obj);
                preparedStratement.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytesTemp), bytesTemp.length);
            }
        } else if (SQLType.CLOB.equals(sqlType) || SQLType.NCLOB.equals(sqlType) || SQLType.PG_TEXT.equals(sqlType)) {
            preparedStratement.setString(index, TypeConversionUtils.objToString((Object)obj));
        } else {
            preparedStratement.setObject(index, isNull ? null : obj);
        }
    }
}

