/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogCollection;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecordBaseDataLogInfo {
    private static Logger logger = Logger.getLogger(RecordBaseDataLogInfo.class);
    private FileOutputStream writer = null;
    private Context ctx;
    private Connection connection;
    private Statement readingStatement;
    private String loggerError = "EIP- \u8bb0\u5f55\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65e5\u5fd7\u5f02\u5e38";
    private boolean needRecordLog = false;
    static final ThreadLocal<RecordBaseDataLogInfo> threadMonitorIds = new ThreadLocal();
    public static final Map<String, String> typeMap = new HashMap<String, String>();
    private StringBuffer recordLoggerInfo = new StringBuffer();

    public static RecordBaseDataLogInfo getCurrent() {
        return threadMonitorIds.get();
    }

    public RecordBaseDataLogInfo(Context ctx, boolean needRecordLog) {
        this.ctx = ctx;
        this.needRecordLog = needRecordLog;
    }

    public void open() throws Exception {
        try {
            this.connection = SQLUtil.getKSQLConnection(this.ctx);
            this.readingStatement = this.connection.createStatement(1003, 1007);
        }
        catch (SQLException e) {
            logger.error((Object)("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage()), (Throwable)e);
        }
        catch (SQLDataException e1) {
            logger.error((Object)("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e1.getMessage()), (Throwable)e1);
        }
    }

    public void close() {
        SQLUtil.cleanup(this.readingStatement, this.connection);
    }

    public void recordBaseDataSynHeadInfo(BaseDataSynHeadInfo headInfo) {
        if (!this.needRecordLog) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        StringBuffer planInfo = new StringBuffer();
        try {
            this.writer = new FileOutputStream(RecordBaseDataLogInfo.getFile(), true);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            planInfo.append("\r\n\r\n*******************************************************************************\r\n");
            planInfo.append("#####################  " + headInfo.getNumber() + "(" + headInfo.getName() + ")  #####################\r");
            planInfo.append("*******************************************************************************\r");
            planInfo.append("\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5\uff1a" + headInfo.getExtendedProperty("connNumber") + "\r");
            planInfo.append("\u6267\u884c\u65f6\u95f4\uff1a" + format.format(new Date()) + "\r");
            planInfo.append("\u65b9\u6848\u6700\u540e\u66f4\u65b0\u65f6\u95f4:" + format.format(new Date(headInfo.getLastUpdateTime().getTime())) + "\r");
            long endTime = System.currentTimeMillis();
            long recordLogTimes = endTime - beginTime;
            planInfo.append("*************\u6b64\u6b65\u9aa4\u8bb0\u5f55\u589e\u52a0\u7684\u8017\u65f6\uff1a" + recordLogTimes + "ms *************\r");
            this.recordLoggerInfo.append(planInfo);
            this.writer.write(planInfo.toString().getBytes());
        }
        catch (Exception e) {
            logger.error((Object)this.loggerError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recordTableInfo(BaseDataSynTableInfo tableInfo, String oprtType) {
        if (!this.needRecordLog) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        StringBuffer logBuffer = new StringBuffer();
        ResultSet rs = null;
        try {
            this.open();
            long tableCount = 0L;
            String tableName = tableInfo.getTableName();
            String getTableCountSQL = null;
            getTableCountSQL = DBUtil.isOracle((Connection)this.connection) ? "select num_rows count from user_tables where table_name = '" + tableName.toUpperCase() + "'" : "select count(*) count from " + tableName;
            rs = this.readingStatement.executeQuery(getTableCountSQL);
            while (rs.next()) {
                tableCount = rs.getLong("count");
            }
            long pkTableCount = 0L;
            String pkTable = tableInfo.getPkTableName();
            String getPKTableCountSQL = "select count(*) count from " + pkTable;
            rs = this.readingStatement.executeQuery(getPKTableCountSQL);
            while (rs.next()) {
                pkTableCount = rs.getLong("count");
            }
            logBuffer.append("\r\n");
            logBuffer.append("\u6267\u884c\u8868\u540d\uff1a" + tableName + ",\u8bb0\u5f55\u6570\uff1a" + tableCount + "\r");
            logBuffer.append("\u589e\u91cf\u8868\u540d\uff1a" + pkTable + ",\u8bb0\u5f55\u6570\uff1a" + pkTableCount + "\r");
            logBuffer.append("\u6267\u884c\u7684\u7c7b\u578b\uff1a" + typeMap.get(oprtType) + "\r");
            this.close();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        SQLUtil.cleanup(rs);
        long endTime = System.currentTimeMillis();
        long recordLogTimes = endTime - beginTime;
        logBuffer.append("*************\u6b64\u6b65\u9aa4\u8bb0\u5f55\u589e\u52a0\u7684\u8017\u65f6\uff1a" + recordLogTimes + "ms *************\r");
        try {
            this.recordLoggerInfo.append(logBuffer);
            this.writer.write(logBuffer.toString().getBytes());
            return;
        }
        catch (IOException e) {
            logger.error((Object)this.loggerError);
            e.printStackTrace();
            return;
        }
        finally {
            this.close();
            SQLUtil.cleanup(rs);
            endTime = System.currentTimeMillis();
            recordLogTimes = endTime - beginTime;
            logBuffer.append("*************\u6b64\u6b65\u9aa4\u8bb0\u5f55\u589e\u52a0\u7684\u8017\u65f6\uff1a" + recordLogTimes + "ms *************\r");
            try {
                this.recordLoggerInfo.append(logBuffer);
                this.writer.write(logBuffer.toString().getBytes());
            }
            catch (IOException e) {
                logger.error((Object)this.loggerError);
                e.printStackTrace();
            }
        }
    }

    public void recordTableExecInfo(String recordString) {
        if (!this.needRecordLog) {
            return;
        }
        try {
            this.recordLoggerInfo.append(recordString);
            this.writer.write(recordString.getBytes());
        }
        catch (IOException e) {
            logger.error((Object)this.loggerError);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void finishRecordInfo(BaseDataDownMonitorLogInfo monitorLogInfo) {
        if (!this.needRecordLog) {
            return;
        }
        beginTime = System.currentTimeMillis();
        logBuffer = new StringBuffer();
        try {
            contextBuffer = new StringBuffer();
            contextBuffer.append("\u6267\u884c\u603b\u8017\u65f6\uff1a" + monitorLogInfo.getDuration() + "\r");
            contextBuffer.append("*****************************\r");
            contextBuffer.append("\u65b9\u6848\u6267\u884c\u603b\u4f53\u4fe1\u606f\uff1a" + monitorLogInfo.getContent() + "\r");
            subLogMap = (HashMap)SubMonitorLogFactory.getLocalInstance(this.ctx).getDetailByMonitor(monitorLogInfo.getId().toString());
            content = new StringBuffer();
            count = 0;
            for (String planNumber : subLogMap.keySet()) {
                if (count > 0) {
                    content.append("\r");
                }
                ++count;
                coll = (SubMonitorLogCollection)subLogMap.get(planNumber);
                it = coll.iterator();
                isFirst = true;
                while (it.hasNext()) {
                    logInfo = (SubMonitorLogInfo)it.next();
                    isMainTable = logInfo.isMainTable();
                    displayName = "\u7f16\u7801(ID)";
                    type = RecordBaseDataLogInfo.typeMap.get(logInfo.getCmd());
                    success = logInfo.getSuccess() == null ? "" : logInfo.getSuccess();
                    v0 = failure = logInfo.getFailure() == null ? "" : logInfo.getFailure();
                    if (!isFirst) {
                        content.append("\n-------------------------------\r");
                    }
                    if (isFirst) {
                        isFirst = false;
                        content.append("\n\u65b9\u6848\u7f16\u7801\uff1a").append(planNumber).append("\r");
                    }
                    content.append("\n\u8868\u540d\uff1a").append(logInfo.getTableName());
                    content.append("\n").append(type + "\u5931\u8d25" + displayName + "\uff0c\u603b\u6761\u6570\uff1a" + logInfo.getFailureCount() + "\uff1a\r").append(failure);
                    content.append("\n").append(type + "\u6210\u529f" + displayName + "\uff0c\u603b\u6761\u6570\uff1a" + logInfo.getSuccessCount() + "\uff1a\r").append(success);
                }
            }
            contextBuffer.append("\u65b9\u6848\u6267\u884c\u8be6\u7ec6\u4fe1\u606f\uff1a" + content + "\r");
            try {
                this.recordLoggerInfo.append(contextBuffer);
                this.writer.write(contextBuffer.toString().getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            RecordBaseDataLogInfo.logger.error((Object)e);
        }
        finally {
            endTime = System.currentTimeMillis();
            recordLogTimes = endTime - beginTime;
            logBuffer.append("*************\r\u5173\u95ed\u65e5\u5fd7\u8bb0\u5f55\u589e\u52a0\u7684\u8017\u65f6\uff1a" + recordLogTimes + "ms *************");
            try {
                this.recordLoggerInfo.append(logBuffer);
                this.writer.write(logBuffer.toString().getBytes());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e1) {}
            }
            try {
                this.writer = new FileOutputStream(RecordBaseDataLogInfo.getBakFile(), true);
                this.writer.write(this.recordLoggerInfo.toString().getBytes());
                bakTime = System.currentTimeMillis();
                logBuffer.append("\r*************\u5907\u4efd\u8bb0\u5f55\u589e\u52a0\u7684\u8017\u65f6\uff1a" + (bakTime - endTime) + "ms *************\r");
                this.writer.write(logBuffer.toString().getBytes());
                ** if (this.writer == null) goto lbl-1000
            }
            catch (Exception e) {
                try {
                    RecordBaseDataLogInfo.logger.error((Object)"EIP- \u7eaa\u5f55\u57fa\u7840\u8d44\u6599\u540c\u6b65\u5907\u4efd\u65e5\u5fd7\u5f02\u5e38");
                    ** if (this.writer == null) goto lbl-1000
                }
                catch (Throwable var22_40) {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException var23_41) {}
                    }
                    throw var22_40;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        this.writer.close();
                    }
                    catch (IOException var9_27) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.writer.close();
                }
                catch (IOException bakTime) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
    }

    public static File getFile() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String fileName = format.format(new Date()) + ".txt";
        File folder = RecordBaseDataLogInfo.getBaseDataLogDir();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static File getBakFile() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String fileName = format.format(new Date()) + "_bak.txt";
        File folder = RecordBaseDataLogInfo.getBaseDataLogDir();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File file = new File(folder, fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static File getBaseDataLogDir() {
        String logPath = System.getProperty("EAS_HOME") + File.separator + "admin" + File.separator + "logs" + File.separator + "BaseDataLog";
        return new File(logPath);
    }

    public static void main(String[] args) {
    }

    static {
        typeMap.put("add", "\u65b0\u589e");
        typeMap.put("update", "\u66f4\u65b0");
        typeMap.put("del", "\u5220\u9664");
    }
}

