/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.DBTransformUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.SQLType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class BaseDataBatchInsertHelper {
    private static ThreadLocal<BaseDataBatchInsertHelper> threadInsertHelpers = new ThreadLocal();
    private String insertSql;
    private List<String> columns;
    private String userInfoId;
    private Timestamp currentTime;
    private static final String headReservedFields = "FID, FControlUnitID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime";
    private static final int headReservedFieldsLen = 6;
    private static final String entryReservedFields = "FID, FSeq";
    private static final int entryReservedFieldsLen = 2;
    private String transmitSerialNumber;
    private int transmitChunkedNumber;
    private static final String insertChunkedTransmit = "insert into T_EIP_ChunkedTransmit(FTransmitSerialNumber, FTransmitChunkedNumber, FUserID, FCreateTime, FLastUpdateTime) values(?,?,?,?,?)";
    private static final String undateChunkedTransmit = "update T_EIP_ChunkedTransmit set FTransmitChunkedNumber=?, FLastUpdateTime=? where FTransmitSerialNumber=?";

    private BaseDataBatchInsertHelper() {
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public void setParameters(List<ColumnModel> columns, PreparedStatement preparedStratement, Map<String, Object> dataMap, Map<String, String> colTypeMap) throws SQLException, BOSException {
        String columnName = "";
        for (int i = 0; i < columns.size(); ++i) {
            columnName = columns.get((int)i).destName;
            if (StringUtils.isEmpty((String)columnName)) {
                columnName = columns.get((int)i).name;
            }
            Object obj = dataMap.get(columnName);
            String colType = null;
            try {
                colType = colTypeMap.get(columnName.toUpperCase()).toUpperCase();
                DBTransformUtil.transform(preparedStratement, i + 1, obj, colType);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("\u8fdb\u884c\u6570\u636e\u8f6c\u6362\u65f6\u51fa\u9519,\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + colType + "." + e.getMessage());
            }
        }
    }

    public void setParameters(String[] columns, PreparedStatement stmt, JSONArray data, JSONObject colType) {
        String columnName = "";
        for (int i = 0; i < columns.length; ++i) {
            columnName = columns[i];
            Object obj = data.get(i);
            try {
                String sscolType = colType.get((Object)columnName.toUpperCase()).toString().toUpperCase();
                DBTransformUtil.transform(stmt, i + 1, obj, sscolType);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringBuffer errorInfo = new StringBuffer();
                String columnStr = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.arrayToString(columns, ",");
                String objStr = data.toString();
                objStr = objStr.substring(objStr.indexOf(",") + 1, objStr.length());
                String coTypeStr = colType.toString();
                errorInfo.append(" \u5217\u540d\uff1a").append(columnStr).append(" \u6570\u636e\u503c\uff1a").append(objStr).append(" \u6570\u636e\u7c7b\u578b\u5bf9\u7167\u5173\u7cfb\uff1a").append(coTypeStr).append(" \u8f6c\u6362\u51fa\u9519\u7684\u5217\uff1a").append(columns[i]);
                Logger.error((Throwable)e, (String)errorInfo.toString());
                throw new RuntimeException("\u8fdb\u884c\u6570\u636e\u8f6c\u6362\u65f6\u51fa\u9519\uff1a" + e.getMessage() + " " + errorInfo.toString());
            }
        }
    }

    public static void transform(PreparedStatement preparedStratement, int index, Object obj, String typeStr) throws Exception {
        boolean isNull;
        SQLType sqlType = SQLType.getEnum(typeStr);
        boolean bl = isNull = obj == null || obj.toString().length() == 0;
        if (SQLType.INT.equals(sqlType) || SQLType.PG_INTEGER.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setNull(index, 4);
            } else {
                preparedStratement.setInt(index, Integer.parseInt(obj.toString()));
            }
        } else if (SQLType.NUMBER.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setNull(index, 8);
            } else {
                preparedStratement.setDouble(index, Double.parseDouble(obj.toString()));
            }
        } else if (SQLType.NUMERIC.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setNull(index, 2);
            } else {
                preparedStratement.setBigDecimal(index, new BigDecimal(obj.toString()));
            }
        } else if (SQLType.DECIMAL.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setNull(index, 3);
            } else {
                preparedStratement.setBigDecimal(index, new BigDecimal(obj.toString()));
            }
        } else if (SQLType.DOUBLE.equals(sqlType)) {
            if (isNull) {
                preparedStratement.setNull(index, 8);
            } else {
                preparedStratement.setBigDecimal(index, new BigDecimal(obj.toString()));
            }
        } else if (SQLType.CHAR.equals(sqlType) || SQLType.VARCHAR.equals(sqlType) || SQLType.VARCHAR2.equals(sqlType) || SQLType.NCHAR.equals(sqlType) || SQLType.NVARCHAR.equals(sqlType) || SQLType.NVARCHAR2.equals(sqlType) || SQLType.PG_CHARACTER.equals(sqlType)) {
            preparedStratement.setObject(index, obj);
        } else if (SQLType.DATETIME.equals(sqlType) || SQLType.TIMESTAMP.equals(sqlType) || SQLType.PG_TIMESTAMP.equals(sqlType)) {
            Timestamp time = null;
            if (obj != null && obj.toString().length() != 0) {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                java.util.Date obj2 = fmt.parse(obj.toString());
                time = new Timestamp(obj2.getTime());
            }
            preparedStratement.setTimestamp(index, isNull ? null : time);
        } else if (SQLType.BINARY.equals(sqlType) || SQLType.VARBINARY.equals(sqlType)) {
            preparedStratement.setBytes(index, isNull ? null : obj.toString().getBytes());
        } else if (SQLType.BLOB.equals(sqlType)) {
            preparedStratement.setBlob(index, isNull ? null : (Blob)obj);
        } else if (SQLType.CLOB.equals(sqlType) || SQLType.NCLOB.equals(sqlType) || SQLType.PG_TEXT.equals(sqlType)) {
            preparedStratement.setObject(index, isNull ? null : obj);
        } else {
            preparedStratement.setObject(index, isNull ? null : obj);
            throw new Exception("not support the type of conversion : " + sqlType);
        }
    }

    public static final BaseDataBatchInsertHelper getInstance() {
        return threadInsertHelpers.get();
    }

    private static Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static void setCurrentTransmitChunkedNumber(int transmitChunkedNumber) {
        BaseDataBatchInsertHelper.threadInsertHelpers.get().transmitChunkedNumber = transmitChunkedNumber;
    }

    public void updateTransmitChunked(Connection con) throws SQLException {
        if (!StringUtils.isEmpty((String)this.transmitSerialNumber)) {
            PreparedStatement undateChunkedTransmitStatement = con.prepareStatement(undateChunkedTransmit);
            try {
                undateChunkedTransmitStatement.setInt(1, this.transmitChunkedNumber);
                undateChunkedTransmitStatement.setDate(2, new Date(System.currentTimeMillis()));
                undateChunkedTransmitStatement.setString(3, this.transmitSerialNumber);
                undateChunkedTransmitStatement.executeUpdate();
            }
            finally {
                SQLUtils.cleanup((Statement)undateChunkedTransmitStatement);
            }
        }
    }

    public static final void prepare(String tableName, List<ColumnModel> colNameList) throws BOSException, SQLException {
        BaseDataBatchInsertHelper insertHelper = new BaseDataBatchInsertHelper();
        insertHelper.currentTime = BaseDataBatchInsertHelper.getTime();
        insertHelper.columns = new ArrayList<String>();
        insertHelper.insertSql = BaseDataBatchInsertHelper.generateInsertSql(insertHelper.columns, tableName, colNameList);
        threadInsertHelpers.set(insertHelper);
    }

    public static final void prepare() {
        BaseDataBatchInsertHelper insertHelper = new BaseDataBatchInsertHelper();
        threadInsertHelpers.set(insertHelper);
    }

    public static String generateInsertSql(List<String> columns, String tableName, List<ColumnModel> colNameList) {
        StringBuilder sqlBuffer = new StringBuilder();
        StringBuilder paramBuffer = new StringBuilder();
        sqlBuffer.append("insert into ").append(tableName).append("(");
        for (int i = 0; i < colNameList.size(); ++i) {
            String destColName = colNameList.get((int)i).destName;
            if (StringUtils.isEmpty((String)destColName)) {
                destColName = colNameList.get((int)i).name;
            }
            columns.add(destColName);
            if (i > 0) {
                sqlBuffer.append(",");
                paramBuffer.append(",");
            }
            sqlBuffer.append(destColName);
            paramBuffer.append("?");
        }
        sqlBuffer.append(")");
        sqlBuffer.append(" values(").append((CharSequence)paramBuffer).append(")");
        return sqlBuffer.toString();
    }
}

