/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.SQLType;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeEnum;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class DataModelUtil {
    public static final StructuredDataModel convert(BaseDataSynTableInfo tableInfo, Context ctx) throws Exception {
        return DataModelUtil.convert(tableInfo, false, ctx);
    }

    public static final StructuredDataModel convert(BaseDataSynTableInfo tableInfo, Context ctx, boolean filterChangeful) throws Exception {
        return DataModelUtil.convert(tableInfo, filterChangeful, ctx);
    }

    public static final StructuredDataModel convert(BaseDataSynTableInfo tableInfo, boolean filterChangeful, Context ctx) throws Exception {
        ColumnModel column;
        BaseDataSynColumnInfo info;
        int i;
        if (tableInfo == null) {
            throw new NullPointerException("\u6620\u5c04\u4fe1\u606f\u4e3a\u7a7a!");
        }
        String tableName = tableInfo.getTableName();
        ArrayList<ColumnModel> headerColumns = new ArrayList<ColumnModel>();
        ArrayList<ColumnModel> entryColumns = new ArrayList<ColumnModel>();
        ArrayList<ColumnModel> newColumns = new ArrayList<ColumnModel>();
        BaseDataSynHeadInfo headInfo = tableInfo.getParent();
        headInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(tableInfo.getParent().getId().toString()));
        BaseDataSynColumnCollection columnColl = headInfo.getColumnEntrys();
        if (BaseDataSynTypeEnum.newLaunch.equals((Object)headInfo.getBaseDataSynType())) {
            for (i = 0; i < columnColl.size(); ++i) {
                info = columnColl.get(i);
                if (!StringUtils.endsWithIgnoreCase((String)tableName, (String)info.getTableName())) continue;
                column = null;
                if (StringUtils.isEmpty((String)info.getColName())) {
                    throw new IllegalArgumentException("DataColumn's name can't be empty!");
                }
                if (StringUtils.isEmpty((String)info.getColAlias())) {
                    info.setColAlias(info.getColName());
                }
                column = tableInfo.isMainTable() && info.isPkTime() ? new ColumnModel(info.getColName(), info.getColAlias(), SQLType.getEnum(info.getColDataType().toUpperCase()), null, info.isPkField(), true, info.isNeedSyn(), info.isNeedUpdateSyn(), info.isPkTime(), info.getTransRule()) : new ColumnModel(info.getColName(), info.getColAlias(), SQLType.getEnum(info.getColDataType().toUpperCase()), null, info.isPkField(), info.isChangeful(), info.isNeedSyn(), info.isNeedUpdateSyn(), info.isPkTime(), info.getTransRule());
                if ((info.isPkTime() || info.isNeedUpdateSyn()) && !StringUtils.isEmpty((String)info.getColName())) {
                    headerColumns.add(column);
                }
                if (!info.isNeedSyn() && !info.isPkTime() || StringUtils.isEmpty((String)info.getColName())) continue;
                entryColumns.add(column);
            }
        } else if (BaseDataSynTypeEnum.alreadyLaunch.equals((Object)headInfo.getBaseDataSynType())) {
            for (i = 0; i < columnColl.size(); ++i) {
                info = columnColl.get(i);
                if (info.isPkTime() && StringUtils.isEmpty((String)info.getDestColName())) {
                    BaseDataResourceholder.putPKColumn(info.getColName());
                    ColumnModel pkTimeColumn = new ColumnModel(info.getColName(), info.getColAlias(), info.getDestColName(), info.getDestColAlias(), info.getDefaultValue(), info.getBaseDataSynTypeMap(), SQLType.getEnum(info.getColDataType()), SQLType.getEnum(info.getDestColDataType()), info.isPkField(), info.isChangeful(), info.isNeedSyn(), info.isNeedUpdateSyn(), info.isPkTime(), info.getTransRule());
                    headerColumns.add(pkTimeColumn);
                }
                if (!StringUtils.endsWithIgnoreCase((String)tableName, (String)info.getTableName()) || StringUtils.isEmpty((String)info.getDestColName())) continue;
                column = null;
                column = tableInfo.isMainTable() && info.isPkTime() ? new ColumnModel(info.getColName(), info.getColAlias(), info.getDestColName(), info.getDestColAlias(), info.getDefaultValue(), info.getBaseDataSynTypeMap(), SQLType.getEnum(info.getColDataType()), SQLType.getEnum(info.getDestColDataType()), info.isPkField(), true, info.isNeedSyn(), info.isNeedUpdateSyn(), info.isPkTime(), info.getTransRule()) : new ColumnModel(info.getColName(), info.getColAlias(), info.getDestColName(), info.getDestColAlias(), info.getDefaultValue(), info.getBaseDataSynTypeMap(), SQLType.getEnum(info.getColDataType()), SQLType.getEnum(info.getDestColDataType()), info.isPkField(), info.isChangeful(), info.isNeedSyn(), info.isNeedUpdateSyn(), info.isPkTime(), info.getTransRule());
                if ((info.isPkTime() || info.isNeedUpdateSyn()) && !StringUtils.isEmpty((String)info.getColName())) {
                    headerColumns.add(column);
                }
                if ((info.isNeedSyn() || info.isPkTime()) && !StringUtils.isEmpty((String)info.getColName())) {
                    entryColumns.add(column);
                }
                if (filterChangeful) {
                    if (!info.isNeedUpdateSyn() && !info.isPkTime() || !StringUtils.isEmpty((String)info.getColName())) continue;
                    newColumns.add(column);
                    continue;
                }
                if (!info.isNeedSyn() && !info.isPkTime() || !StringUtils.isEmpty((String)info.getColName())) continue;
                newColumns.add(column);
            }
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u57fa\u7840\u8d44\u6599\u540c\u6b65\u7c7b\u578b" + (Object)((Object)headInfo.getBaseDataSynType()));
        }
        HashMap<String, BaseDataSynTableInfo> properties = new HashMap<String, BaseDataSynTableInfo>();
        properties.put("baseDataSynInfo", tableInfo);
        StructuredDataModel.TableModel header = new StructuredDataModel.TableModel("header", headerColumns.toArray(new ColumnModel[0]));
        StructuredDataModel.TableModel entry = new StructuredDataModel.TableModel("entry", entryColumns.toArray(new ColumnModel[0]));
        StructuredDataModel.TableModel news = new StructuredDataModel.TableModel("news", newColumns.toArray(new ColumnModel[0]));
        StructuredDataModel.TableModel[] tms = new StructuredDataModel.TableModel[]{header, entry, news};
        StructuredDataModel structuredDataModel = new StructuredDataModel(tableInfo.getTableName(), tableInfo.getTableAlias(), properties, tms);
        structuredDataModel.addTableRelation(header, entry, 1);
        structuredDataModel.addTableRelation(entry, news, 1);
        try {
            structuredDataModel.setCompleted();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return structuredDataModel;
    }
}

