/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.agent.servlet.openapi.ApiResult;
import com.kingdee.eas.csinterface.agent.util.WebUtil;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.webservice.CustomerOpenAPIFactory;
import com.kingdee.eas.csinterface.webservice.CustomerOpenAPIInfo;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import com.kingdee.eas.csinterface.webservice.framework.Return;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebCustomerOpenAPIServlet
extends RequestProcessor {
    private static final Logger logger = Logger.getLogger(WebCustomerOpenAPIServlet.class);

    @Override
    public String getTargetURI() {
        return "/customer/";
    }

    @Override
    public String process(Map<String, String> params, String reqContent) throws Exception {
        CustomerOpenAPIInfo openAPIInfo;
        String result = null;
        this.response.setHeader("Content-type", "text/html;charset=UTF-8");
        Object oldSession = this.getContext(params);
        Context context = null;
        if (!(oldSession instanceof Context)) {
            return oldSession.toString();
        }
        context = (Context)oldSession;
        String uri = this.request.getRequestURI();
        logger.info((Object)("[EIP]request URI : " + uri));
        uri = WebUtil.relative("/easportal/eip", uri);
        uri = uri.startsWith("/") ? uri : "/" + uri;
        String customerAPINumber = uri.substring(uri.lastIndexOf("/") + 1);
        if (StringUtils.isEmpty((String)customerAPINumber)) {
            result = ReturnDataService.format(Return.valueOf(-1, "please define apinumber", Integer.valueOf(0)));
        }
        if ((openAPIInfo = CustomerOpenAPIFactory.getLocalInstance(context).getCustomerOpenAPIInfo("where number = '" + customerAPINumber + "'")) == null) {
            result = ReturnDataService.format(Return.valueOf(-1, "apinumber:" + customerAPINumber + " is not exist", Integer.valueOf(0)));
        }
        JSONArray bodyData = null;
        try {
            bodyData = JSONObject.parseArray((String)reqContent);
        }
        catch (Exception e) {
            return ReturnDataService.format(Return.valueOf(-1, "data is invalid", Integer.valueOf(0)));
        }
        String className = openAPIInfo.getClassName();
        String methodName = openAPIInfo.getMethod();
        Class<?> implClass = null;
        Method method = null;
        try {
            implClass = Class.forName(className);
            method = implClass.getMethod(methodName, Context.class, Map.class);
        }
        catch (Exception e) {
            String errorMsg = "not class or method in system," + className + "." + methodName + "(Map(String, Object))";
            return ReturnDataService.format(Return.valueOf(-1, errorMsg, Integer.valueOf(-1)));
        }
        ApiResult apiResult = (ApiResult)method.invoke(implClass.newInstance(), context, bodyData);
        if (apiResult.isSuccess().booleanValue()) {
            String resultData = "";
            Object resultObj = apiResult.getData();
            resultData = resultObj == null ? "" : (resultObj instanceof String ? resultObj.toString() : JSONObject.toJSONString((Object)resultObj));
            result = ReturnDataService.format(Return.valueOf("\u6267\u884c\u6210\u529f", resultData, 0));
        } else {
            result = ReturnDataService.format(Return.valueOf(-1, apiResult.getMessage(), Integer.valueOf(-1)));
        }
        return result;
    }

    private Object getContext(Map<String, String> params) throws Exception {
        String token = this.request.getParameter("token");
        if (token == null) {
            token = params.get("token");
        }
        Context context = SessionUtil.getContextByToken(token);
        context.setClientHostIP("127.0.0.1");
        return context;
    }
}

