/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillStatus;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.TransactionWrapperFacadeFactory;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.app.AbstractDynamicBillTemplateControllerBean;
import com.kingdee.eas.csinterface.app.DynamicBillBatchInsertHelper;
import com.kingdee.eas.csinterface.app.TransactionBlock;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.provider.db.MiddleBillDataProvider;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.monitor.FeedBackStatus;
import com.kingdee.eas.csinterface.monitor.app.FeedBackManager;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DynamicBillTemplateControllerBean
extends AbstractDynamicBillTemplateControllerBean
implements ICommonBOSType {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.app.DynamicBillTemplateControllerBean");
    public static boolean isNewTran = false;
    private BOSObjectType type;
    private IMetaDataPK pk;
    boolean isAgent;
    PreparedStatement deleteStatement;
    ThreadLocal<BillMappingInfo> billMapping = new ThreadLocal();

    @Override
    public BOSObjectType getBOSType() {
        return this.type;
    }

    public void setBOSType(BOSObjectType type) {
        this.type = type;
    }

    public IMetaDataPK getPK() {
        return this.pk;
    }

    public void setPK(IMetaDataPK pk) {
        this.pk = pk;
    }

    private void deleteFromDataProcessProvider(Context ctx, CoreBillBaseInfo coreBillBaseInfo) throws EASBizException, BOSException {
        DynamicBillTemplateInfo info = (DynamicBillTemplateInfo)coreBillBaseInfo;
        try {
            Object pkVal = info.get("headpk");
            this.deleteStatement.setObject(1, pkVal);
            this.deleteStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public CoreBillBaseInfo getCoreBillBaseInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        if (selector != null && selector.contains(new SelectorItemInfo("fiVouchered"))) {
            selector.add(new SelectorItemInfo("headpk"));
        }
        return super.getCoreBillBaseInfo(ctx, pk, selector);
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        if (!FeedBackManager.getDeletefromVoucher()) {
            super.isCanDelete(ctx, pk, coreBillInfo);
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        if (!FeedBackManager.getDeletefromVoucher()) {
            FeedBackManager.updateFeedBackLogByMidID(ctx, new HashSet<String>(ids), "", FeedBackStatus.DELETE_MID_SUCCESSED);
        }
        if (!this.isAgent) {
            this.deleteFromDataProcessProvider(ctx, coreBillInfo);
        }
    }

    @Override
    protected void _addBatchMidBill(Context ctx, CoreBaseCollection middleColl) throws BOSException, EASBizException {
        DynamicBillBatchInsertHelper insertHelper = DynamicBillBatchInsertHelper.getInstance();
        if (insertHelper == null) {
            this.insertBatchByORAMapping(ctx, middleColl);
            MonitorManager.getCurrentSrcToMidBill().addSuccessfulBillCount(middleColl.size());
        } else {
            try {
                this.insertByNativeJDBCBatch(ctx, middleColl, insertHelper);
                MonitorManager.getCurrentSrcToMidBill().addSuccessfulBillCount(middleColl.size());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertByNativeJDBCBatch(Context ctx, CoreBaseCollection middleColl, DynamicBillBatchInsertHelper insertHelper) throws SQLException, BOSException {
        Connection con = EJBFactory.getConnection((Context)ctx);
        PreparedStatement insertHeadStatement = null;
        PreparedStatement insertEntryStatement = null;
        try {
            insertHeadStatement = con.prepareStatement(insertHelper.getInsertHeaderSql());
            insertEntryStatement = con.prepareStatement(insertHelper.getInsertEntrySql());
            for (int i = 0; i < middleColl.size(); ++i) {
                DynamicBillTemplateInfo headInfo = (DynamicBillTemplateInfo)middleColl.get(i);
                DynamicBillTemplateEntryCollection entryColl = headInfo.getEntrys();
                insertHelper.setHeaderParameters(insertHeadStatement, headInfo);
                insertHeadStatement.addBatch();
                for (int j = 0; j < entryColl.size(); ++j) {
                    DynamicBillTemplateEntryInfo entryInfo = entryColl.get(j);
                    insertHelper.setEntryParameters(insertEntryStatement, entryInfo, j + 1);
                    insertEntryStatement.addBatch();
                }
            }
            insertHelper.updateTransmitChunked(con);
            insertHeadStatement.executeBatch();
            insertEntryStatement.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(insertEntryStatement);
            SQLUtils.cleanup((Statement)insertHeadStatement);
            SQLUtils.cleanup((Connection)con);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)insertEntryStatement);
        SQLUtils.cleanup((Statement)insertHeadStatement);
        SQLUtils.cleanup((Connection)con);
    }

    @Deprecated
    private void insertBatchByORAMapping(Context ctx, CoreBaseCollection middleColl) throws EASBizException, BOSException {
        for (DynamicBillTemplateInfo info : middleColl) {
            super.addnew(ctx, (CoreBaseInfo)info);
        }
    }

    private CoreBillBaseInfo canRemove(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (this.isVoucherFlag(ctx, pk)) {
            throw new BillBaseException(BillBaseException.FIVOUCHERED2);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("headpk"));
        CoreBillBaseInfo coreBillInfo = this.getCoreBillBaseInfo(ctx, pk, selector);
        this.isCanDelete(ctx, pk, coreBillInfo);
        return coreBillInfo;
    }

    @Override
    public String[] _deleteBatchMidBill(Context ctx, String billNumber, String[] ids, boolean directDel) throws BOSException, EASBizException {
        IBillMapping instance = BillMappingFactory.getLocalInstance(ctx);
        BillMappingInfo billMappingInfo = instance.getBillMappingInfo("where number = '" + billNumber + "'");
        this.billMapping.set(billMappingInfo);
        this.isAgent = DataSourceType.agent.equals((Object)billMappingInfo.getDsType());
        String[] srcIds = new String[ids.length];
        if (!directDel && this.isAgent) {
            for (int i = 0; i < ids.length; ++i) {
                CoreBillBaseInfo billInfo = this.canRemove(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
                Object pkVal = billInfo.get("headpk");
                srcIds[i] = pkVal.toString();
            }
            EipTaskManager.orderDeleteBillData(ctx, billMappingInfo, ids, srcIds);
            return null;
        }
        if (!this.isAgent) {
            ConnectionInfo cnInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo((IObjectPK)new ObjectUuidPK(billMappingInfo.getSrcDBConn().getId().toString()));
            billMappingInfo.setSrcDBConn(cnInfo);
        }
        MiddleBillDataProvider dataProvider = null;
        try {
            if (!this.isAgent) {
                StructuredDataModel dataModel = DataModelUtil.convert(billMappingInfo);
                dataProvider = new MiddleBillDataProvider(dataModel);
                dataProvider.open();
                Connection con = dataProvider.getConnection();
                String pkTableName = billMappingInfo.getPkTableName();
                if (con.getMetaData().getDatabaseProductName().equalsIgnoreCase("PostgreSQL")) {
                    pkTableName = pkTableName.replace("\"", "").toLowerCase();
                }
                this.deleteStatement = con.prepareStatement("delete from " + pkTableName + " where " + "headpk" + " = ?");
            }
            LinkedList<String> result = new LinkedList<String>();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    super._delete(ctx, (IObjectPK)new ObjectUuidPK(ids[i]));
                    result.add(ids[i]);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("\u5ffd\u7565\u5355\u636e\u5220\u9664\u5931\u8d25\uff0cbotp\u6821\u9a8c\u5931\u8d25. \u52a8\u6001\u5355\u636enumber:" + billNumber + ", \u5355\u636eid:" + ids[i]));
                    this.updateFeedBackLogByMidID(ctx, ids, i, e);
                }
            }
            if (!FeedBackManager.getDeletefromVoucher()) {
                FeedBackManager.asynFeedBackByMidIds(ctx, new HashSet<String>(Arrays.asList(ids)));
            }
            String[] stringArray = result.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)this.deleteStatement);
            if (dataProvider != null) {
                try {
                    dataProvider.close();
                }
                catch (DIPException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private void updateFeedBackLogByMidID(Context ctx, String[] ids, int i, Exception e) throws BOSException {
        if (isNewTran) {
            final Context ctxTmp = ctx;
            final HashSet<String> idsSet = new HashSet<String>(Arrays.asList(ids[i]));
            final String errorInfo = ThrowableHelper.toString(e);
            TransactionWrapperFacadeFactory.getLocalInstance(ctx).doInvokerNewTransaction(new TransactionBlock(){

                @Override
                public Object doTransaction() throws Exception {
                    FeedBackManager.updateFeedBackLogByMidID(ctxTmp, idsSet, errorInfo, FeedBackStatus.DELETE_MID_FAILED);
                    return "back";
                }
            });
        } else {
            FeedBackManager.updateFeedBackLogByMidID(ctx, new HashSet<String>(Arrays.asList(ids[i])), ThrowableHelper.toString(e), FeedBackStatus.DELETE_MID_FAILED);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnun, IObjectValue relationInfo, IObjectValue destBillVO) throws BOSException, EASBizException {
        try {
            if (BOTBillOperStateEnum.DELETE.equals((Object)billOperStateEnun)) {
                BOSUuid id = BOSUuid.read((String)srcBillPK.toString());
                DynamicBillTemplateInfo info = (DynamicBillTemplateInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(id.getType(), CommonUtil.convert2PK(id.toString()));
                if (info != null) {
                    info.setMidBillStatus(DynamicBillStatus.normal);
                    info.setFivouchered(false);
                    DynamicObjectFactory.getLocalInstance((Context)ctx).update(id.getType(), srcBillPK, (IObjectValue)info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5220\u9664\u51ed\u8bc1\u65f6\uff0c\u53cd\u5199\u4e2d\u95f4\u8868\u72b6\u6001\u51fa\u9519\uff0c\u4e2d\u95f4\u8868ID\uff08" + srcBillPK + "\uff09\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String pkTableName = (String)ctx.get((Object)"PK_TABLE_NAME");
        ConnectionInfo connectionInfo = (ConnectionInfo)ctx.get((Object)"SRC_CONNECTION");
        if (StringUtil.isEmpty((String)pkTableName)) {
            throw new BOSException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u589e\u91cf\u8868");
        }
        if (connectionInfo == null) {
            throw new BOSException("\u6e90\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38");
        }
        Connection conn = null;
        try {
            conn = KSQLUtil.getConnection(connectionInfo);
            this.deleteStatement = conn.prepareStatement("delete from " + pkTableName + " where " + "headpk" + " = ?");
            super._delete(ctx, pk);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtil.cleanup(conn);
        }
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] objectPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum billOperStateEnun, BOTRelationCollection relationColl, IObjectCollection objColl) throws BOSException {
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] objectPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum billOperStateEnun, BOTRelationCollection relationColl) throws BOSException {
    }
}

