/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.executor.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.agent.servlet.openapi.impl.OpenAPIPackImpl;
import com.kingdee.eas.csinterface.async.app.executor.impl.AbstractInterfaceExecutor;
import com.kingdee.eas.csinterface.async.app.executor.util.JSONConvertUtil;
import com.kingdee.eas.csinterface.async.app.task.util.DateUtil;
import com.kingdee.eas.csinterface.async.app.task.util.SaveDataRelationUtil;
import com.kingdee.eas.csinterface.async.app.task.util.UserCacheFactory;
import com.kingdee.eas.csinterface.async.standardImpl.impl.StandUserHandelImp;
import com.kingdee.eas.csinterface.async.util.BOSEntityUtil;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationCollection;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationFactory;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class StandardExecotor
extends AbstractInterfaceExecutor {
    private static final Logger logger = Logger.getLogger(StandardExecotor.class);
    protected EntityObjectInfo eoi;
    protected Class<?> facade;
    protected Class<?> infoClass;
    protected Method actionMethod;
    protected ICoreBase instance;

    public StandardExecotor(Context ctx, String taskId, Boolean isSuccess, String data, String message, String action, String solution, String access) {
        super(ctx, taskId, isSuccess, data, message, action, solution, access);
    }

    @Override
    public Object executor() throws Exception {
        Object result = null;
        super.executor();
        this.prepare();
        JSONArray dataArray = JSONObject.parseArray((String)this.data);
        if (packAction.contains(this.action.toString())) {
            String billNum = this.dataService.getBillNumber().getNumber();
            result = this.extractedNotSave(this.action, billNum, dataArray, this.bosType);
        } else if ("init".equals(this.action.toString())) {
            ICoreBase entityMethodObj = (ICoreBase)BOSEntityUtil.getLocalInstance(this.ctx, this.bosType.toString());
            int j = dataArray.size();
            for (int i = 0; i < j; ++i) {
                String dataStr = dataArray.getString(i);
                JSONObject dataObj = JSONObject.parseObject((String)dataStr);
                if (!"initialization".equalsIgnoreCase(dataObj.getString("action"))) continue;
                dataObj.put("taskId", (Object)this.taskId);
                result = StandUserHandelImp.standartInit(this.ctx, dataObj, entityMethodObj, this.adaptorService);
            }
        } else {
            result = this.saveObj(dataArray);
        }
        return result;
    }

    protected void prepare() throws Exception {
        this.eoi = EJBAccessFactory.createLocalInstance((Context)this.ctx).getEntityInfo(this.bosType);
        int splitIndex = this.eoi.getBusinessImplName().lastIndexOf(".") + 1;
        ICoreBase entityMethodObj = (ICoreBase)BOSEntityUtil.getLocalInstance(this.ctx, this.bosType.toString());
        String infoName = this.eoi.getBusinessImplName() + "Info";
        this.infoClass = Class.forName(infoName);
        this.facade = entityMethodObj.getClass();
        this.actionMethod = this.facade.getMethod(this.action.toString(), CoreBaseInfo.class);
        this.instance = (ICoreBase)BOSEntityUtil.getLocalInstance(this.ctx, this.bosType.toString());
    }

    protected Object extractedNotSave(String action, String billNum, JSONArray dataArray, BOSObjectType bosType) throws Exception {
        Object result = null;
        String dataType = "id";
        StringBuffer filterBuf = new StringBuffer();
        HashSet<String> otherIds = new HashSet<String>();
        int j = dataArray.size();
        for (int i = 0; i < j; ++i) {
            if (filterBuf.length() > 0) {
                filterBuf.append(",");
            }
            String dataStr = dataArray.getString(i);
            JSONObject dataObj = JSONObject.parseObject((String)dataStr);
            String id = dataObj.getString("id");
            String number = dataObj.getString("number");
            String otherId = dataObj.getString("eipsrcid");
            if (id != null) {
                filterBuf.append(id);
                continue;
            }
            if (otherId != null) {
                otherIds.add(otherId);
                List<String> easIds = SaveDataRelationUtil.getEASIDByOtherId(this.ctx, otherIds);
                if (easIds.size() <= 0) continue;
                filterBuf.append(StringUtils.converList2String(easIds, ",", ""));
                continue;
            }
            if (number == null) continue;
            filterBuf.append(number);
            dataType = "number";
        }
        OpenAPIPackImpl.invokeStateChange(this.ctx, bosType, action, filterBuf.toString(), dataType);
        if ("delete".equalsIgnoreCase(action.toString())) {
            OpenDataRelationCollection relationCollection = SaveDataRelationUtil.getDataRelations(this.ctx, otherIds);
            HashSet<String> dynaBillIdSets = new HashSet<String>();
            HashSet<String> idSet = new HashSet<String>();
            if (relationCollection != null && relationCollection.size() > 0) {
                for (int j2 = 0; j2 < relationCollection.size(); ++j2) {
                    dynaBillIdSets.add(relationCollection.get(j2).getDynaBillId());
                    idSet.add(relationCollection.get(j2).getId().toString());
                }
                MidBillFactory.getInstance(this.ctx, billNum).deleteBatchMidBill(billNum, dynaBillIdSets.toArray(new String[0]), true);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                OpenDataRelationFactory.getLocalInstance(this.ctx).delete(filter);
            }
        }
        return null;
    }

    protected Object saveObj(JSONArray dataArray) throws Exception {
        Object result = null;
        int j = dataArray.size();
        for (int i = 0; i < j; ++i) {
            String dataStr = dataArray.getString(i);
            JSONObject dataObj = JSONObject.parseObject((String)dataStr);
            CoreBaseInfo info = JSONConvertUtil.convert(this.ctx, dataObj, this.infoClass);
            String eipsrcid = dataObj.getString("eipsrcid");
            OpenDataRelationInfo relationInfo = null;
            OpenDataRelationCollection relationcolls = null;
            try {
                String relationSQL = "select destBillId where sourcebillid = '" + eipsrcid + "' and openService = '" + this.adaptorService.getId().toString() + "'";
                relationcolls = OpenDataRelationFactory.getLocalInstance(this.ctx).getOpenDataRelationCollection(relationSQL);
                if (relationcolls != null && relationcolls.size() > 0) {
                    relationInfo = relationcolls.get(0);
                    String destBillid = relationInfo.getDestBillId().toString();
                    String querySingle = "getValue";
                    Method singleMethod = this.facade.getMethod(querySingle, IObjectPK.class);
                    Object dbObj = singleMethod.invoke((Object)this.instance, CommonUtil.convert2PK(destBillid));
                    if (dbObj != null) {
                        BOSUuid bs = BOSUuid.read((String)destBillid);
                        info.setId(bs);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("EAS\u540c\u6b65\u5916\u90e8\u7cfb\u7edf\u6570\u636e\uff0c\u67e5\u8be2\u6570\u636e\u5173\u8054\u5173\u7cfb\u65f6\u5f02\u5e38\uff1a" + e.getMessage()));
            }
            result = this.actionMethod.invoke((Object)this.instance, info);
            if (relationInfo != null) continue;
            relationInfo = new OpenDataRelationInfo();
            relationInfo.setDestBillId(info.getId().toString());
            relationInfo.setSourceBillId(dataObj.getString("eipsrcid"));
            Object srcEntity = dataObj.get((Object)"srcEntity");
            relationInfo.setSourceEntityId(srcEntity == null ? "" : srcEntity.toString());
            relationInfo.setDestBillEntryId(this.bosType.toString() == null ? "" : this.bosType.toString().toString());
            relationInfo.setOpenService(this.adaptorService);
            relationInfo.setCreator(UserCacheFactory.getUserInfo(this.ctx, this.ctx.getCaller()));
            relationInfo.setCreateTime(DateUtil.dateToTime(new Date()));
            this.relationColl.add((CoreBaseInfo)relationInfo);
        }
        return result;
    }

    protected Object saveEachData(JSONObject dataObj, Class clazz) throws Exception {
        Object result = null;
        CoreBaseInfo info = JSONConvertUtil.convert(this.ctx, dataObj, clazz);
        String eipsrcid = dataObj.getString("eipsrcid");
        OpenDataRelationInfo relationInfo = null;
        OpenDataRelationCollection relationcolls = null;
        try {
            String relationSQL = "select destBillId where sourcebillid = '" + eipsrcid + "' and openService = '" + this.adaptorService.getId().toString() + "'";
            relationcolls = OpenDataRelationFactory.getLocalInstance(this.ctx).getOpenDataRelationCollection(relationSQL);
            if (relationcolls != null && relationcolls.size() > 0) {
                relationInfo = relationcolls.get(0);
                String destBillid = relationInfo.getDestBillId().toString();
                String querySingle = "getValue";
                Method singleMethod = this.facade.getMethod(querySingle, IObjectPK.class);
                Object dbObj = singleMethod.invoke((Object)this.instance, CommonUtil.convert2PK(destBillid));
                if (dbObj != null) {
                    BOSUuid bs = BOSUuid.read((String)destBillid);
                    info.setId(bs);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("EAS\u540c\u6b65\u5916\u90e8\u7cfb\u7edf\u6570\u636e\uff0c\u67e5\u8be2\u6570\u636e\u5173\u8054\u5173\u7cfb\u65f6\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        result = this.actionMethod.invoke((Object)this.instance, info);
        if (relationInfo == null) {
            relationInfo = new OpenDataRelationInfo();
            relationInfo.setDestBillId(info.getId().toString());
            relationInfo.setSourceBillId(dataObj.getString("eipsrcid"));
            Object srcEntity = dataObj.get((Object)"srcEntity");
            relationInfo.setSourceEntityId(srcEntity == null ? "" : srcEntity.toString());
            relationInfo.setDestBillEntryId(this.bosType.toString() == null ? "" : this.bosType.toString().toString());
            relationInfo.setOpenService(this.adaptorService);
            relationInfo.setCreator(UserCacheFactory.getUserInfo(this.ctx, this.ctx.getCaller()));
            relationInfo.setCreateTime(DateUtil.dateToTime(new Date()));
            this.relationColl.add((CoreBaseInfo)relationInfo);
        }
        return result;
    }
}

