/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.mq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.rabbitmq.productor.mqfactory.MQFactory;
import com.kingdee.bos.rabbitmq.productor.publish.MessagePublisher;

public class MQConnectionFactory {
    private String mqName;
    private String region;
    private String queneName;
    public static final String MQ_CALLBACK_CONSUMER = "com.kingdee.eas.csinterface.async.app.task.mq.MQCallBackConsumer";

    private MQConnectionFactory() {
    }

    public static MQConnectionFactory getConnection(String mqName, String region, String queneName) {
        MQConnectionFactory conn = new MQConnectionFactory();
        conn.setMqName(mqName);
        conn.setRegion(region);
        conn.setQueneName(queneName);
        return conn;
    }

    public static void publish(String mqName, String region, String queneName, String message) throws BOSException {
        MQConnectionFactory conn = new MQConnectionFactory();
        conn.setMqName(mqName);
        conn.setRegion(region);
        conn.setQueneName(queneName);
        conn.publish(message);
    }

    public void publish(String message) throws BOSException {
        MQFactory factory = null;
        try (MessagePublisher publish = null;){
            factory = MQFactory.get((String)this.mqName);
            publish = factory.createSimplePublisher(this.region, this.queneName, MQ_CALLBACK_CONSUMER);
            publish.publish(message);
        }
    }

    public String getMqName() {
        return this.mqName;
    }

    public void setMqName(String mqName) {
        this.mqName = mqName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getQueneName() {
        return this.queneName;
    }

    public void setQueneName(String queneName) {
        this.queneName = queneName;
    }
}

