/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.app.task.execute;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.rabbitmq.initialize.ConfigManager;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.csinterface.async.app.task.AsyncOrderTaskUtil;
import com.kingdee.eas.csinterface.async.app.task.IAsyncTaskExecutor;
import com.kingdee.eas.csinterface.async.app.task.model.ResultInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynExecuteAPIFacadeFactory;
import com.kingdee.eas.hr.rec.util.DateUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class AysncBaseDataSynImpl
implements IAsyncTaskExecutor {
    private static Logger logger = Logger.getLogger(AysncBaseDataSynImpl.class);
    private static final String PLANNUMBER = "planNumber";
    private static final String SPECIALSQL = "specialSQL";
    private static final String ACTIONTYPE = "actionType";
    private static final String CONNECTIONNUMBER = "connectionNumber ";
    private static final String AGENTNUMBER = "agentNumber";
    private static final String USERLIST = "userList";

    public static void main(String[] args) throws Exception {
        System.out.println(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public static void orderTask(Context ctx, String planNumber, String specialSQL, String actionType, String connectionNumber, String agentNumber, String userList) throws BOSException {
        ConfigManager.initConsumer();
        JSONObject dataObj = new JSONObject();
        dataObj.put(PLANNUMBER, (Object)planNumber);
        dataObj.put(SPECIALSQL, (Object)specialSQL);
        dataObj.put(ACTIONTYPE, (Object)actionType);
        dataObj.put(CONNECTIONNUMBER, (Object)connectionNumber);
        dataObj.put(AGENTNUMBER, (Object)agentNumber);
        dataObj.put(USERLIST, (Object)userList);
        String description = "EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65(" + planNumber + ")_" + System.currentTimeMillis();
        DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.SSS");
        AsyncOrderTaskUtil.orderTask(ctx, "EIPBaseDataSynService", dataObj.toJSONString(), null, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInfo execute(Context ctx, Job job, String taskData, ResultInfo result) throws BOSException {
        JSONObject dataObj = JSONObject.parseObject((String)taskData);
        String planNumber = dataObj.getString(PLANNUMBER);
        String specialSQL = dataObj.getString(SPECIALSQL);
        String actionType = dataObj.getString(ACTIONTYPE);
        String connectionNumber = dataObj.getString(CONNECTIONNUMBER);
        String agentNumber = dataObj.getString(AGENTNUMBER);
        String userList = dataObj.getString(USERLIST);
        StringBuilder message = new StringBuilder();
        try {
            ctx.put((Object)"sync", (Object)"true");
            BaseDataSynExecuteAPIFacadeFactory.getLocalInstance(ctx).execPlanPatchWithUser(planNumber, specialSQL, actionType, connectionNumber, agentNumber, userList);
            result.setSuccess(true);
            message.append("\u65b9\u6848\u540c\u6b65\u6267\u884c\u6210\u529f");
        }
        catch (Exception e) {
            message.append("\u65b9\u6848\u540c\u6b65\u6267\u884c\u6210\u529f");
            result.setMessage(e.getMessage());
            result.setException(e);
            result.setSuccess(false);
        }
        finally {
            result.setMessage("\u65b9\u6848\u6267\u884c\u6210\u529f\uff0c\u65b9\u6848\u7f16\u7801\uff1a" + planNumber);
        }
        return result;
    }
}

