/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.async.standardImpl.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.rabbitmq.support.EASMQPublish;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.csinterface.agent.servlet.openapi.util.BaseUtil;
import com.kingdee.eas.csinterface.async.app.task.handler.impl.AbstractApiUserHandle;
import com.kingdee.eas.csinterface.openapi.OpenAPIDispatcherInfo;
import com.kingdee.eas.csinterface.openapi.app.feedback.util.IERPUtil;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.ISCAPIUtil;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.ValidationUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.rabbitmq.rabbit.RabbitPublishInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PersonOuPartImpl
extends AbstractApiUserHandle {
    private static final Logger logger = Logger.getLogger(PersonOuPartImpl.class);

    @Override
    public String getBosType() {
        return "80EF7DED";
    }

    @Override
    public String getObjectValue(Context ctx, IObjectPK pk, SelectorItemCollection selectors) throws Exception {
        SelectorItemCollection personSel = new SelectorItemCollection();
        personSel.addObjectCollection((IObjectCollection)selectors);
        personSel.add(new SelectorItemInfo("number"));
        personSel.add(new SelectorItemInfo("name"));
        personSel.add(new SelectorItemInfo("email"));
        personSel.add(new SelectorItemInfo("cell"));
        personSel.add(new SelectorItemInfo("idCardNO"));
        personSel.add(new SelectorItemInfo("birthday"));
        personSel.add(new SelectorItemInfo("gender"));
        personSel.add(new SelectorItemInfo("deletedStatus"));
        PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo(pk, personSel);
        if (person.getGender() == null) {
            throw new BOSException("\u804c\u5458(" + person.getName() + ")\u5fc5\u987b\u7ef4\u62a4\u6027\u522b");
        }
        if (person.getCell() == null || "".equals(person.getCell())) {
            throw new BOSException("\u804c\u5458(" + person.getName() + ")\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ValidationUtils.isPhone(person.getCell())) {
            throw new BOSException("\u804c\u5458(" + person.getName() + ")\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        String personJSON = ISCAPIUtil.convertObjectToJson(ctx, person.getBOSType(), person, "save");
        JSONObject sendObj = JSONObject.parseObject((String)JSONArray.parseArray((String)personJSON).get(0).toString());
        String languageKey = BaseUtil.getLocalLanguage();
        String personSQL = "select t1.FNUMBER username, t2.FID  personid from T_PM_USER t1 inner join T_BD_PERSON t2 on t1.FPERSONID = t2.FID where t1.FISDELETE = 0 and t1.FFORBIDDEN = 0 and t1.FPERSONID ='" + pk.toString() + "' group by t2.FID ,t1.FNUMBER ";
        IRowSet userRS = DbUtil.executeQuery((Context)ctx, (String)personSQL);
        String username = null;
        while (userRS.next()) {
            username = userRS.getString("username");
        }
        String openSQL = " select t3.fxtid from T_BD_Person t1 inner JOIN T_PM_EASXTUSERMAP t3 on t1.fid =t3.fpersonid and t1.fid = '" + pk.toString() + "'";
        IRowSet openidSet = DbUtil.executeQuery((Context)ctx, (String)openSQL);
        while (openidSet.next()) {
            sendObj.put("openid", (Object)openidSet.getString("fxtid"));
        }
        sendObj.put("username", (Object)(username == null ? " " : username));
        String positionSQL = "select t2.fname_" + languageKey + " position, t2.fisrespposition isrespposition, t3.fnumber orgNumber, t1.fisprimary fisprimary,t3.FID id  from T_ORG_PositionMember t1  inner join t_org_position t2 on t1.fpositionid = t2.fid  inner join t_org_baseunit t3 on t2.fadminorgunitid = t3.fid where t1.fpersonid = '" + pk.toString() + "'";
        JSONArray positionArr = new JSONArray();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)positionSQL);
        int beginIndex = 0;
        while (rs.next()) {
            JSONObject position = new JSONObject();
            position.put("eipsrcid", (Object)rs.getString("id"));
            position.put("department", (Object)rs.getString("orgNumber"));
            position.put("position", (Object)rs.getString("position"));
            position.put("seq", (Object)beginIndex++);
            position.put("isincharge", (Object)rs.getInt("isrespposition"));
            position.put("ispartjob", (Object)(1 - rs.getInt("fisprimary")));
            positionArr.add((Object)position);
        }
        sendObj.put("gender", (Object)person.getGender().getValue());
        sendObj.put("usertype", (Object)1);
        sendObj.put("entry", (Object)positionArr);
        return sendObj.toJSONString();
    }

    @Override
    public String initData(Context ctx, JSONObject originalData, ICoreBase instance, OpenAPIDispatcherInfo adaptorService) throws Exception {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        JSONObject extData = IERPUtil.getIERPExtend(ctx, adaptorService);
        String taskId = originalData.getString("taskId");
        int partNum = originalData.getIntValue("maxnumber");
        int total = 0;
        JSONObject all = new JSONObject();
        JSONArray arr = new JSONArray();
        JSONArray allArr = new JSONArray();
        int count = 0;
        StringBuffer idBuffer = new StringBuffer();
        String filterStr = originalData.getString("filter");
        if (!StringUtils.isEmpty((String)filterStr)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo(filterStr);
            view.setFilter(filter);
            SelectorItemCollection personSel = new SelectorItemCollection();
            personSel.add(new SelectorItemInfo("id"));
            view.setSelector(personSel);
            PersonCollection personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
            if (personColl.size() > 0) {
                for (int i = 0; i < personColl.size(); ++i) {
                    if (i + 1 == personColl.size()) {
                        idBuffer.append("'" + personColl.get(i).get("id") + "'");
                        continue;
                    }
                    idBuffer.append("'" + personColl.get(i).get("id") + "',");
                }
            }
        }
        HashMap<String, JSONArray> positionMap = new HashMap<String, JSONArray>();
        String positionSQL = "select t2.fname_l2 position, t2.fisrespposition isrespposition,t3.fid orgId, t3.fnumber orgNumber,  t1.fisprimary fisprimary, t1.fpersonid personid  from T_ORG_PositionMember t1  inner join t_org_position t2 on t1.fpositionid = t2.fid  inner join t_org_baseunit t3 on t2.fadminorgunitid = t3.fid ";
        if (!StringUtils.isEmpty((String)idBuffer.toString())) {
            positionSQL = positionSQL + "where t1.fpersonid in (" + idBuffer.toString() + ")";
        }
        int beginIndex = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(positionSQL);
            while (rs.next()) {
                JSONArray positionArr;
                JSONObject position = new JSONObject();
                JSONObject department = new JSONObject();
                department.put("number", (Object)rs.getString("orgNumber"));
                position.put("department", (Object)department);
                position.put("eipsrcid", (Object)rs.getString("orgId"));
                position.put("position", (Object)rs.getString("position"));
                position.put("seq", (Object)beginIndex++);
                position.put("isincharge", (Object)rs.getInt("isrespposition"));
                position.put("ispartjob", (Object)(1 - rs.getInt("fisprimary")));
                String personid = rs.getString("personid");
                if (positionMap.containsKey(personid)) {
                    positionArr = (JSONArray)positionMap.get(personid);
                    positionArr.add((Object)position);
                    continue;
                }
                positionArr = new JSONArray();
                positionArr.add((Object)position);
                positionMap.put(personid, positionArr);
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("sql is:" + positionSQL), (Throwable)exc);
                throw new BOSException("Sql execute exception : " + positionSQL, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        String personSQL = null;
        personSQL = !StringUtils.isEmpty((String)idBuffer.toString()) ? "select t1.FNUMBER username, t2.FID  personid from T_PM_USER t1 inner join T_BD_PERSON t2 on t1.FPERSONID = t2.FID and t1.fpersonid in (" + idBuffer.toString() + ") where t1.FISDELETE = 0 and t1.FFORBIDDEN = 0  group by t2.FID ,t1.FNUMBER " : "select t1.FNUMBER username, t2.FID  personid from T_PM_USER t1 inner join T_BD_PERSON t2 on t1.FPERSONID = t2.FID  where t1.FISDELETE = 0 and t1.FFORBIDDEN = 0  group by t2.FID ,t1.FNUMBER ";
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(personSQL);
            String username = null;
            while (rs.next()) {
                username = rs.getString("username");
                map.put(rs.getString("personId"), username == null ? " " : username);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + positionSQL), (Throwable)exc);
            throw new BOSException("Sql execute exception : " + positionSQL, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        String querySQL = " select t1.fid, t1.fnumber, t1.fname_l2, t1.fsimplenamepingyin, t1.fidcardno, t1.fgender, t1.femail,  t1.fcell, t1.fbirthday ,t1.fdeletedstatus,t3.fxtid  from T_BD_Person t1  INNER JOIN (select fcell from T_BD_Person  group by fcell HAVING COUNT(fcell)<2  ) t2 on t2.fcell=t1.fcell  LEFT JOIN T_PM_EASXTUSERMAP t3 on t1.fid =t3.fpersonid  where t1.fcell is not null ";
        if (!StringUtils.isEmpty((String)idBuffer.toString())) {
            querySQL = querySQL + " and t1.fid in (" + idBuffer.toString() + ")";
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(querySQL);
            String phone = "";
            while (rs.next()) {
                phone = rs.getString("fcell");
                if (!ValidationUtils.isPhone(phone)) {
                    logger.error((Object)("phone number verification failed,phone number is:" + phone));
                    continue;
                }
                JSONObject personObj = new JSONObject();
                personObj.put("eipsrcid", (Object)rs.getString("fid"));
                personObj.put("number", (Object)rs.getString("fnumber"));
                personObj.put("name", (Object)rs.getString("fname_l2"));
                personObj.put("simpleNamePingYin", (Object)rs.getString("fsimplenamepingyin"));
                personObj.put("idCardNo", (Object)rs.getString("fidcardno"));
                personObj.put("gender", (Object)rs.getString("fgender"));
                personObj.put("email", (Object)rs.getString("femail"));
                personObj.put("cell", (Object)phone);
                personObj.put("birthday", (Object)rs.getString("fbirthday"));
                personObj.put("usertype", (Object)1);
                personObj.put("deletedStatus", (Object)rs.getString("fdeletedstatus"));
                personObj.put("username", (Object)(map.get(rs.getString("fid")) == null ? " " : map.get(rs.getString("fid"))));
                personObj.put("openid", (Object)rs.getString("fxtid"));
                JSONArray positionArr = (JSONArray)positionMap.get(rs.getString("fid"));
                JSONArray positionArrays = null;
                if (positionArr == null || positionArr.size() <= 0) continue;
                positionArrays = new JSONArray();
                JSONObject jsonObject = null;
                for (int i = 0; i < positionArr.size(); ++i) {
                    jsonObject = JSON.parseObject((String)positionArr.getString(i));
                    jsonObject.put("seq", (Object)(i + 1));
                    positionArrays.add((Object)jsonObject);
                }
                personObj.put("entry", (Object)positionArrays);
                allArr.add((Object)personObj);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + positionSQL), (Throwable)exc);
            throw new BOSException("Sql execute exception : " + positionSQL, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        if (allArr != null && allArr.size() > 0) {
            total = allArr.size();
            for (Object jb : allArr) {
                arr.add(jb);
                if (++count % partNum != 0) continue;
                this.pushPersonData(ctx, adaptorService.getFeedbackService().getQueue(), extData, taskId, total, all, arr, count);
                all = new JSONObject();
                arr = new JSONArray();
                count = 0;
            }
            if (arr != null) {
                this.pushPersonData(ctx, adaptorService.getFeedbackService().getQueue(), extData, taskId, total, all, arr, count);
            }
        }
        return null;
    }

    private void pushPersonData(Context ctx, RabbitPublishInfo publisher, JSONObject extData, String taskId, int total, JSONObject all, JSONArray arr, int count) throws Exception {
        all.put("taskId", (Object)taskId);
        all.put("total", (Object)total);
        all.put("data", (Object)arr);
        all.put("action", (Object)"init");
        all.put("count", (Object)count);
        all.putAll((Map)extData);
        EASMQPublish.publish((Context)ctx, (String)publisher.getId().toString(), (String)all.toJSONString());
    }
}

