/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice.BaseDataSynCheckUtilByWSService;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BaseDataSynUtilByWSService {
    public static List<String> getMainPKListForAdd(Context ctx, String planNumber, String extendSQL) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtilByWSService.getMainTableIDListForAdd(ctx, planNumber, extendSQL, null);
    }

    public static List<String> getMainPKListForAdd(Context ctx, String planNumber, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtilByWSService.getMainTableIDListForAdd(ctx, planNumber, extendSQL, isFirst);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getMainTableIDListForAdd(Context ctx, String planNumber, String extendSQL, Boolean isFirst) throws BOSException, EASBizException, Exception {
        ArrayList<String> pkList = new ArrayList<String>();
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
        String agentId4http = MonitorManager.getCurrent().getExtendedProperty("agentId4http");
        BaseDataSynTableInfo tableInfo = BaseDataSynUtil.getMainTableInfo(ctx, headInfo);
        BaseDataRunner.deleteInvalidRecord(ctx, tableInfo.getPkTableName(), agentId4http);
        String specialSQL = tableInfo.getSrcWhere();
        specialSQL = BaseDataSynUtil.expendExtendSQL(specialSQL, extendSQL);
        BaseDataRunner baseDataRunner = null;
        baseDataRunner = new BaseDataRunner(tableInfo, ctx, 1, BaseDataSynUtil.MAXCOUNT, false, "", specialSQL, tableInfo.getRelateSQL(), true, agentId4http);
        String ksql = baseDataRunner.initQuerySqlAdd(tableInfo.getTableName(), agentId4http);
        StructuredDataModel dataModel = baseDataRunner.dataModel;
        String mainPK = BaseDataSynUtilByWSService.getMainPK(dataModel);
        if (StringUtils.isEmpty((String)mainPK)) {
            throw new BOSException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a(mainPK can't be empty)" + tableInfo.getPkTableName());
        }
        String s = "";
        String beforeSQLDefine = tableInfo.getBeforeSQL();
        if (!StringUtils.isEmpty((String)beforeSQLDefine)) {
            BaseDataSynCheckUtilByWSService.addBeforeSQLCheckIfNeed(ctx, tableInfo, ksql, pkList, beforeSQLDefine, mainPK);
        } else {
            Connection conn = null;
            Statement stmt = null;
            ResultSet resultSet = null;
            try {
                conn = DBUtils.getConnection(ctx);
                s = DBUtils.isPostgresSQL(conn) ? ksql : (!(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)DBUtils.getDBType(conn)) : ksql);
                stmt = conn.createStatement();
                resultSet = DBUtil.isOracle((Connection)conn) ? stmt.executeQuery(ksql) : stmt.executeQuery(s);
                while (resultSet.next()) {
                    String fid = resultSet.getString("FID");
                    pkList.add(fid);
                }
            }
            catch (Exception sqle) {
                try {
                    throw sqle;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        }
        HashSet<String> h = new HashSet<String>();
        h.addAll(pkList);
        pkList.clear();
        pkList.addAll(h);
        if (pkList.size() != 0) return pkList;
        if (isFirst == false) return pkList;
        MonitorLogInfo current = MonitorManager.getCurrent();
        String warnMsg = current.getExtendedProperty("warnMsg");
        if (warnMsg == null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(headInfo.getNumber(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u65b0\u589e\u540c\u6b65\u7684\u6570\u636e" + ("".equals(s) ? s : " , \u67e5\u8be2\u6761\u4ef6\u4e3a : \n" + s)));
            current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)jsonObject));
            return pkList;
        }
        JSONObject parseObject = JSON.parseObject((String)warnMsg);
        parseObject.put(headInfo.getNumber(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u65b0\u589e\u540c\u6b65\u7684\u6570\u636e" + ("".equals(s) ? s : " , \u67e5\u8be2\u6761\u4ef6\u4e3a : \n" + s)));
        current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)parseObject));
        return pkList;
    }

    public static String getMainPK(StructuredDataModel dataModel) {
        StructuredDataModel.TableModel[] tables = dataModel.getPriorityTables();
        StructuredDataModel.TableModel model = tables[1];
        String mainPk = "";
        for (int i = 0; i < model.columns.length; ++i) {
            if (StringUtils.isEmpty((String)model.columns[i].name) || !model.columns[i].isPk) continue;
            mainPk = model.columns[i].destName;
            mainPk = StringUtils.isEmpty((String)mainPk) ? model.columns[i].name : mainPk;
        }
        return mainPk;
    }
}

