/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EIPConfiguration {
    private static final Logger logger = Logger.getLogger(EIPConfiguration.class);
    private static EIPConfiguration INSTANCE = new EIPConfiguration();
    private List<String> bigDataEntryTables;
    private List<String> notNeedUpdateTables;
    private int mainTableMaxCount = 40000;
    private int subTableMaxCount = 40000;
    private int mainTablePageSize = 300;
    private int subTablePageSize = 5000;
    private String instanceTag = null;

    public static EIPConfiguration Instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EIPConfiguration() {
        String path = System.getProperty("eas.properties.dir");
        String file = path + File.separator + "eipconfig.properties";
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        try {
            String instanceTagStr;
            String subTablePageSize;
            String mainTablePageSize;
            String subTableMaxCount;
            String mainTableMaxCount;
            String ignoredtables;
            inputStream = new FileInputStream(file);
            prop.load(inputStream);
            String updatetables = prop.getProperty("bigDataEntryTables");
            if (!StringUtils.isEmpty((String)updatetables)) {
                String[] updatetableName = updatetables.toLowerCase().split(",");
                this.bigDataEntryTables = Arrays.asList(updatetableName);
            }
            if (!StringUtils.isEmpty((String)(ignoredtables = prop.getProperty("notNeedUpdateTables")))) {
                String[] ignoredtableName = ignoredtables.toLowerCase().split(",");
                this.notNeedUpdateTables = Arrays.asList(ignoredtableName);
            }
            if (!StringUtils.isEmpty((String)(mainTableMaxCount = prop.getProperty("mainTableMaxCount")))) {
                this.mainTableMaxCount = Integer.valueOf(mainTableMaxCount);
            }
            if (!StringUtils.isEmpty((String)(subTableMaxCount = prop.getProperty("subTableMaxCount")))) {
                this.subTableMaxCount = Integer.valueOf(subTableMaxCount);
            }
            if (!StringUtils.isEmpty((String)(mainTablePageSize = prop.getProperty("mainTablePageSize")))) {
                this.mainTablePageSize = Integer.valueOf(mainTablePageSize);
            }
            if (!StringUtils.isEmpty((String)(subTablePageSize = prop.getProperty("subTablePageSize")))) {
                this.subTablePageSize = Integer.valueOf(subTablePageSize);
            }
            if (!StringUtils.isEmpty((String)(instanceTagStr = prop.getProperty("instanceTag")))) {
                this.instanceTag = instanceTagStr;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isBigDataEntryTable(String tableName) {
        return this.bigDataEntryTables != null && this.bigDataEntryTables.contains(tableName.toLowerCase());
    }

    public boolean needUpdateTable(String tableName) {
        return this.notNeedUpdateTables == null || !this.notNeedUpdateTables.contains(tableName.toLowerCase());
    }

    public int getMainTableMaxCount() {
        return this.mainTableMaxCount;
    }

    public int getSubTableMaxCount() {
        return this.subTableMaxCount;
    }

    public int getMainTablePageSize() {
        return this.mainTablePageSize;
    }

    public int getSubTablePageSize() {
        return this.subTablePageSize;
    }

    public String getInstanceName() {
        String instanceId = Configuration.instanceId();
        if (this.instanceTag == null) {
            return instanceId;
        }
        return "(" + this.instanceTag + ")" + instanceId + "_";
    }

    public String getServerTag() {
        return this.instanceTag;
    }
}

