/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.sql.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadBaseDataSynParam {
    public static boolean openMultiPlan = true;
    public static int planProtocol = 1;
    public static boolean openMultiPage = true;
    public static int pageProtocol = 2;
    public static boolean openMutliTable = true;
    public static int tableProtocol = 12;
    public static boolean openMulti = false;
    public static ThreadPoolExecutor planExec = null;
    public static ThreadPoolExecutor pageExec = null;
    public static ThreadPoolExecutor tableExec = null;
    public static int planThreshold = 20;
    public static int pageThreshold = 80;
    public static int tableThreshold = 100;
    public static boolean isOpened = false;
    static Map<String, Map<String, Number>> allPoolInfo = new HashMap<String, Map<String, Number>>();
    public static int parentTotalPage = 8;

    public static void resetThreadPool(String type, int size) {
        if (type.equalsIgnoreCase("plan")) {
            planExec.shutdown();
            planExec = new ThreadPoolExecutor(1, 3, 45L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(planThreshold + 10));
        }
        if (type.equalsIgnoreCase("page")) {
            pageExec.shutdown();
            pageExec = new ThreadPoolExecutor(1, 3, 45L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(pageThreshold + 20));
        }
        if (type.equalsIgnoreCase("table")) {
            tableExec.shutdown();
            tableExec = new ThreadPoolExecutor(2, 10, 45L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(tableThreshold * 5));
        }
    }

    public static void closeThreadPool(String type) {
        if (type.equalsIgnoreCase("ALL")) {
            isOpened = false;
            planExec.shutdown();
            pageExec.shutdown();
            tableExec.shutdown();
        }
        if (type.equalsIgnoreCase("plan")) {
            planExec.shutdown();
        }
        if (type.equalsIgnoreCase("page")) {
            pageExec.shutdown();
        }
        if (type.equalsIgnoreCase("table")) {
            tableExec.shutdown();
        }
    }

    public static void closeThreadPoolNow(String type) {
        if (type.equalsIgnoreCase("ALL")) {
            isOpened = false;
            planExec.shutdownNow();
            pageExec.shutdownNow();
            tableExec.shutdownNow();
        }
        if (type.equalsIgnoreCase("plan")) {
            planExec.shutdownNow();
        }
        if (type.equalsIgnoreCase("page")) {
            pageExec.shutdownNow();
        }
        if (type.equalsIgnoreCase("table")) {
            tableExec.shutdownNow();
        }
    }

    public static void openDefaultThreadPool() {
        isOpened = true;
        planExec = new ThreadPoolExecutor(1, 3, 45L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(planThreshold + 10));
        pageExec = new ThreadPoolExecutor(1, 3, 45L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(pageThreshold + 20));
        tableExec = new ThreadPoolExecutor(2, 8, 45L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(tableThreshold * 5));
    }

    public static Map<String, Map<String, Number>> monitorThreadPool() {
        if (!planExec.isShutdown()) {
            ThreadBaseDataSynParam.recordPoolInfo("plan", planExec);
        }
        if (!pageExec.isShutdown()) {
            ThreadBaseDataSynParam.recordPoolInfo("page", pageExec);
        }
        if (!tableExec.isShutdown()) {
            ThreadBaseDataSynParam.recordPoolInfo("table", tableExec);
        }
        return allPoolInfo;
    }

    private static void recordPoolInfo(String type, ExecutorService exec) {
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)exec;
        HashMap<String, Number> poolInfo = new HashMap<String, Number>();
        poolInfo.put("totalWork", tpe.getTaskCount());
        poolInfo.put("queueWork", tpe.getQueue().size());
        poolInfo.put("activeWork", tpe.getActiveCount());
        poolInfo.put("completedWork", tpe.getCompletedTaskCount());
        allPoolInfo.put(type, poolInfo);
    }

    public static void setProtocol(String type, int protocol) {
        if (type.equalsIgnoreCase("plan")) {
            planProtocol = protocol;
        }
        if (type.equalsIgnoreCase("page")) {
            pageProtocol = protocol;
        }
        if (type.equalsIgnoreCase("table")) {
            tableProtocol = protocol;
        }
    }

    public static void setProtocol(int planCount, int pageCount, int tableCount) {
        planProtocol = planCount;
        pageProtocol = pageCount;
        tableProtocol = tableCount;
    }

    public static boolean isOpenMultiThread(String isOpenMultiThread) {
        if (ThreadBaseDataSynParam.isExecByMultiThrad()) {
            if ("notMultiThead".equalsIgnoreCase(isOpenMultiThread)) {
                return false;
            }
            if ("openMultiThead".equalsIgnoreCase(isOpenMultiThread) || (StringUtil.isEmpty((String)isOpenMultiThread) || isOpenMultiThread.indexOf("notMultiThead") == -1) && openMulti) {
                if (!isOpened) {
                    ThreadBaseDataSynParam.openDefaultThreadPool();
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isExecByMultiThrad() {
        return !ThreadBaseDataSynParam.checkCondition(tableExec, tableThreshold) && !ThreadBaseDataSynParam.checkCondition(pageExec, pageThreshold) && !ThreadBaseDataSynParam.checkCondition(planExec, planThreshold);
    }

    private static boolean checkCondition(ThreadPoolExecutor exec, int threshold) {
        return null != exec && exec.getQueue().size() > threshold;
    }

    public static boolean isOpenMutliTable() {
        return openMutliTable && !ThreadBaseDataSynParam.checkCondition(tableExec, tableThreshold * 3);
    }
}

