/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util.config;

import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.FlatDataModel;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class GetChangedDataUtil {
    private static final Logger logger = Logger.getLogger(GetChangedDataUtil.class);

    public FlatDataModel execChangeSQL(Context ctx, BaseDataSynTableInfo tableInfo, StructuredDataModel dataModel, String agentId, String mainChangeIds, boolean isTree, String mainIDs) throws Exception {
        boolean isMainTable = tableInfo.isMainTable();
        FlatDataModel flatDataModel = new FlatDataModel();
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel entry = tableModels[1];
        String pkField = "";
        for (int i = 0; i < entry.columns.length; ++i) {
            String columnName = entry.columns[i].name;
            if (!entry.columns[i].isPk) continue;
            pkField = columnName;
        }
        StringBuffer execMsg = new StringBuffer();
        JSONObject hashCodeObj = new JSONObject();
        try {
            long endExecTime = System.currentTimeMillis();
            ArrayList<String> addIds = new ArrayList<String>(100);
            ArrayList<String> updateIds = new ArrayList<String>(100);
            ArrayList<String> deleteIds = new ArrayList<String>(100);
            ArrayList<String> insertColumns = new ArrayList<String>(100);
            ArrayList<String> updateColumns = new ArrayList<String>(100);
            ArrayList<String> allColumns = new ArrayList<String>(100);
            for (int i = 0; i < entry.columns.length; ++i) {
                String columnName = entry.columns[i].name;
                if (entry.columns[i].isPk) {
                    pkField = columnName;
                }
                allColumns.add(columnName);
                if (entry.columns[i].isNeedSyn) {
                    insertColumns.add(columnName);
                }
                if (!entry.columns[i].isChangeSyn) continue;
                updateColumns.add(columnName);
            }
            if (!isMainTable) {
                long beginDeleteTime = System.currentTimeMillis();
                String pkTableName = tableInfo.getPkTableName().replace("\"", "");
                StringBuffer deleteBuf = new StringBuffer();
                deleteBuf.append("select p.headpk from ").append(pkTableName).append(" p ").append(" where not exists (").append(" select 1 from ").append(tableInfo.getTableName()).append(" where p.headpk = ").append(pkField).append(" ) and p.").append("mainPK").append(" in (").append(mainIDs).append(") ");
                String deleteSQL = deleteBuf.toString();
                IRowSet deleteRS = DbUtil.executeQuery((Context)ctx, (String)deleteSQL);
                while (deleteRS.next()) {
                    String headpk = deleteRS.getString("headpk");
                    deleteIds.add(headpk);
                }
                long endDeleteTime = System.currentTimeMillis();
                execMsg.append("\u5220\u9664\u6267\u884c\u7684KSQL\uff1a" + deleteSQL + "\r");
                execMsg.append("\u975e\u4e3b\u8868\u83b7\u53d6\u5220\u9664\u6570\u636e\uff1a\u603b\u884c\u6570\uff1a" + deleteIds.size() + "\uff0c\u8017\u65f6\uff1a" + (endDeleteTime - beginDeleteTime) + "ms \r");
            }
            String updateSQL = this.initSpecialTableUpdateQueryString(tableInfo, pkField, agentId, mainIDs);
            IRowSet updateRS = DbUtil.executeQuery((Context)ctx, (String)updateSQL);
            String updateId = null;
            while (updateRS.next()) {
                updateId = updateRS.getString("fid");
                if (updateIds.contains(updateId)) continue;
                updateIds.add(updateId);
            }
            String addSQL = this.initSpecialTableAddQueryString(tableInfo, pkField, agentId, mainIDs);
            IRowSet addRS = DbUtil.executeQuery((Context)ctx, (String)addSQL);
            String addId = null;
            while (addRS.next()) {
                addId = addRS.getString("fid");
                if (addIds.contains(addId)) continue;
                addIds.add(addId);
            }
            flatDataModel.setTableInfo(tableInfo);
            flatDataModel.setAddIds(addIds);
            flatDataModel.setUpdateIds(updateIds);
            flatDataModel.setDeleteIds(deleteIds);
            flatDataModel.setAllColumn(insertColumns);
            flatDataModel.setUpdateColumn(updateColumns);
            flatDataModel.setAddColumn(allColumns);
        }
        catch (Exception e) {
            logger.error((Object)"\u6267\u884csql\u5931\u8d25\uff01", (Throwable)e);
            throw e;
        }
        return flatDataModel;
    }

    private String initSpecialTableAddQueryString(BaseDataSynTableInfo tableInfo, String pkField, String agentId, String mainIds) {
        StringBuilder sqlBuf = new StringBuilder();
        String headPkName = null;
        String AS_NAME = "t1.";
        String ALIAS_NAME = "t1";
        String tableName = tableInfo.getTableName();
        String pkTableName = tableInfo.getPkTableName();
        sqlBuf.append("select ");
        sqlBuf.append(pkField).append(" fid");
        sqlBuf.append(" from ").append(tableName).append(" " + ALIAS_NAME);
        sqlBuf.append(" where not exists ( select 1 from ").append(pkTableName.replaceAll("\"", "")).append(" p");
        sqlBuf.append(" where t1.").append(headPkName).append(" = p.").append("headpk");
        sqlBuf.append(" and p.agentid = '").append(agentId).append("' ");
        sqlBuf.append(" and ");
        String relateSQL = tableInfo.getRelateSQL();
        if (!StringUtils.isEmpty((String)relateSQL)) {
            relateSQL = relateSQL.replace(tableName + ".", AS_NAME);
            relateSQL = relateSQL.replace("${fid}", mainIds);
            sqlBuf.append(relateSQL);
        } else {
            sqlBuf.append(" where 1=1 ");
        }
        String filterString = tableInfo.getSrcWhere();
        if (!StringUtils.isEmpty((String)filterString)) {
            if (StringUtils.startsWithIgnoreCase((String)(filterString = filterString.trim()), (String)"where")) {
                filterString = StringUtils.replaceIgnoreCase((String)filterString, (String)"where", (String)"");
            }
            if (!filterString.matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        return sqlBuf.toString();
    }

    private String initSpecialTableUpdateQueryString(BaseDataSynTableInfo tableInfo, String pkField, String agentId, String mainIds) {
        StringBuilder sqlBuf = new StringBuilder();
        String timeField = "flastupdatetime";
        String AS_NAME = "t1.";
        String ALIAS_NAME = "t1";
        String tableName = tableInfo.getTableName();
        String pkTable = tableInfo.getPkTableName();
        sqlBuf.append("select ");
        sqlBuf.append(pkField);
        sqlBuf.append(" from ").append(tableName).append(" " + ALIAS_NAME);
        sqlBuf.append(" inner join ").append(pkTable).append(" p ");
        sqlBuf.append(" where t1.").append(timeField).append(" <> p.changeime ");
        sqlBuf.append(" and p.agentid = '").append(agentId).append("' ");
        sqlBuf.append(" and ");
        String relateSQL = tableInfo.getRelateSQL();
        if (!StringUtils.isEmpty((String)relateSQL)) {
            relateSQL = relateSQL.replace(tableName + ".", AS_NAME);
            relateSQL = relateSQL.replace("${fid}", mainIds);
            sqlBuf.append(relateSQL);
        } else {
            sqlBuf.append(" where 1=1 ");
        }
        String filterString = tableInfo.getSrcWhere();
        if (!StringUtils.isEmpty((String)filterString)) {
            if (StringUtils.startsWithIgnoreCase((String)(filterString = filterString.trim()), (String)"where")) {
                filterString = StringUtils.replaceIgnoreCase((String)filterString, (String)"where", (String)"");
            }
            if (!filterString.matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        return sqlBuf.toString();
    }
}

