/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.billmapping.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.agent.task.TaskAction;
import com.kingdee.eas.csinterface.agent.task.TaskType;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingHelper;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.app.util.KeyTable;
import com.kingdee.eas.csinterface.billmapping.app.util.TempTableUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.json.JSONException;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.rabbitmq.rabbit.app.util.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class KeyTableUtil {
    public static final String NO_PKTABLE = "\u672a\u751f\u6210\u589e\u91cf\u8868";
    private static Logger logger = Logger.getLogger(KeyTableUtil.class);

    public static void createKeyTable(Context ctx, BillMappingInfo info) throws BOSException, EASBizException, SQLException, DIPException {
        ConnectionInfo srcDBConn = info.getSrcDBConn();
        String id = srcDBConn.getId().toString();
        IObjectPK pk = CommonUtil.convert2PK(id);
        ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(pk);
        KeyTable keyTable = KeyTableUtil.getKeyTable(info);
        info.setPkTableName(keyTable.getTableName());
        String srcViewName = info.getSrcViewName();
        KeyTableUtil.createKeyTable(conn, conn.getDBType(), keyTable, srcViewName);
    }

    public static boolean existKeyTable(Context ctx, BillMappingInfo info) throws EASBizException, BOSException, SQLException, DIPException {
        String keyTablenName = KeyTableUtil.getPKTableName(info);
        if (DataSourceType.jdbc.equals((Object)info.getDsType())) {
            if (info.getSrcDBConn() == null) {
                logger.error((Object)("\u7531\u4e8e\u6e90\u7cfb\u7edf\u8fde\u63a5\u4fe1\u606f\u4e3a\u7a7a,\u589e\u91cf\u8868" + keyTablenName + "\u65e0\u6cd5\u5220\u9664"));
                return false;
            }
        } else if (DataSourceType.agent.equals((Object)info.getDsType())) {
            return true;
        }
        ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(info.getSrcDBConn().getId().toString()));
        DataBaseType dbType = DataBaseType.getInstance(conn.getDBType().getName());
        keyTablenName = keyTablenName.replace("\"", "");
        String ksql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='" + keyTablenName + "'";
        IRowSet rowSet = null;
        if (DBType.MySql.equals((Object)conn.getDBType())) {
            ksql = "SELECT table_name FROM `INFORMATION_SCHEMA`.`TABLES` WHERE table_name ='" + keyTablenName + "' AND TABLE_SCHEMA='" + conn.getInstance().toString() + "'";
            rowSet = KSQLUtil.executeQuery(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), ksql);
            while (rowSet.next()) {
                if (!keyTablenName.equalsIgnoreCase(rowSet.getString(1))) continue;
                return true;
            }
            return false;
        }
        rowSet = KSQLUtil.executeQuery(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), ksql);
        if (!rowSet.next()) {
            ksql = "select KSQL_TABNAME from KSQL_USERTABLES where KSQL_TABNAME like 'T_EIP_%'";
            rowSet = KSQLUtil.executeQuery(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), ksql);
            while (rowSet.next()) {
                if (!keyTablenName.equalsIgnoreCase(rowSet.getString(1))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String getPKTableName(BillMappingInfo info) {
        return BillMappingHelper.calc2PkTableName(info.getId().toString());
    }

    private static KeyTable getKeyTable(BillMappingInfo info) {
        BillMappingEntryInfo headpk = null;
        BillMappingEntryInfo entrypk = null;
        BillMappingEntryCollection coll = info.getEntrys();
        Iterator itr = coll.iterator();
        while (itr.hasNext()) {
            BillMappingEntryInfo entry = (BillMappingEntryInfo)itr.next();
            String srcFieldName = entry.getSrcFieldName();
            if ("headpk".equalsIgnoreCase(srcFieldName)) {
                headpk = entry;
            }
            if (!"entrypk".equalsIgnoreCase(srcFieldName)) continue;
            entrypk = entry;
        }
        if (null == headpk) {
            throw new RuntimeException("\u7f3a\u5c11headpk");
        }
        if (null == entrypk) {
            throw new RuntimeException("\u7f3a\u5c11entrypk");
        }
        String keyTablenName = KeyTableUtil.getPKTableName(info);
        return new KeyTable(keyTablenName, headpk, entrypk);
    }

    private static void createKeyTable(ConnectionInfo conn, DBType dbType, KeyTable table, String srcViewName) throws BOSException {
        String ksql = KeyTableUtil.getSQL2CreateKeyTable(table, dbType, conn, srcViewName);
        String[] ksqlColl = new String[2];
        ksqlColl[0] = ksql;
        try {
            String ksqlStatuIndex;
            ksqlColl[1] = ksqlStatuIndex = KeyTableUtil.getSQL2CreateHeadPkIndex(table, dbType);
        }
        catch (SqlTranslateException e) {
            logger.error((Object)("ksql  \u8f6c\u5316\u5f02\u5e38\uff1a" + (Object)((Object)e)));
            ksqlColl[1] = "";
        }
        try {
            DataBaseType dataBaseType = DataBaseType.getInstance(conn.getDBType().getName());
            KSQLUtil.executeUpdate(dataBaseType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), ksqlColl);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getSQL2CreateHeadPkIndex(KeyTable table, DBType dbType) throws SqlTranslateException {
        String tableName = table.getTableName();
        if (DBType.PostgreSQL.equals((Object)dbType)) {
            tableName = tableName.replace("\"", "");
        }
        String statusIndex = com.kingdee.eas.csinterface.basedatasyn.app.util.KeyTableUtil.MD5(tableName + "status");
        StringBuilder ksqlBuff = new StringBuilder();
        if (DBType.MySql.equals((Object)dbType)) {
            tableName = tableName.replaceAll("\"", "`");
        } else {
            ksqlBuff.append("IF Not Exists(Select * From KSQL_INDEXES Where KSQL_INDNAME= '").append(statusIndex).append("')\n");
        }
        ksqlBuff.append("create index ").append(statusIndex).append(" on ").append(tableName).append(" (headpk) ; ");
        return ksqlBuff.toString();
    }

    private static String getSQL2CreateKeyTable(KeyTable table, DBType dbType, ConnectionInfo connInfo, String srcViewName) throws BOSException {
        DataTypeConverter typeConverter = DataTypeConverter.getConverter(dbType);
        String tableName = table.getTableName();
        if (DBType.MySql.equals((Object)dbType)) {
            tableName = tableName.replaceAll("\"", "`");
        }
        BillMappingEntryInfo headpk = table.getHeadpk();
        SQLType headType = typeConverter.convert(headpk.getSrcFieldDataType());
        ColumnInfo headColInfo = new ColumnInfo();
        headColInfo.setTypeName(headType);
        headColInfo.setLength(headpk.getSrcFieldDataLength());
        headColInfo.setPrecision(headpk.getSrcFieldDataPrecision());
        headColInfo.setScale(headpk.getSrcFieldDataScale());
        StringBuffer sb = new StringBuffer("create table  " + tableName);
        sb.append("(");
        sb.append("headpk ");
        sb.append(DBUtils.getDataType(headColInfo));
        if (DBType.SQLServer.equals((Object)dbType)) {
            Connection c = null;
            try {
                c = KSQLUtil.getConnection(connInfo);
                String rule = TempTableUtil.checkSortRule(c, srcViewName);
                sb.append(" collate " + rule);
            }
            catch (Exception e1) {
                throw new BOSException((Throwable)e1);
            }
            finally {
                SQLUtils.cleanup((Connection)c);
            }
        }
        sb.append(" , ");
        ColumnInfo createTime = new ColumnInfo();
        createTime.setTypeName(SQLType.DATETIME);
        sb.append(" createTime ");
        sb.append(DBUtils.getDataType(createTime));
        sb.append(");");
        return sb.toString();
    }

    public static void dropKeyTable(Context ctx, BillMappingInfo info) throws BOSException, EASBizException {
        String keyTablenName = KeyTableUtil.getPKTableName(info);
        String ksql = "drop table " + keyTablenName;
        if (DataSourceType.jdbc.equals((Object)info.getDsType())) {
            ConnectionInfo conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(info.getSrcDBConn().getId().toString()));
            DataBaseType dbType = DataBaseType.getInstance(conn.getDBType().getName());
            if (dbType.getName().equalsIgnoreCase("PostgreSql")) {
                ksql = "drop table " + keyTablenName.replace("\"", "");
            }
            try {
                KSQLUtil.executeUpdate(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), new String[]{ksql});
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (DataSourceType.agent.equals((Object)info.getDsType())) {
            String taskDes = "\u3010" + TaskType.VIEW.toString() + " - " + TaskAction.VIEW_DROP_PK_TABLE.toString() + "\u3011\u8981\u89c6\u56fe\u589e\u91cf\u8868\u7684\u5355\u636e\u4e3a: \u5355\u636e\u7f16\u7801[" + info.getNumber() + "]\uff0c\u5355\u636e\u540d\u79f0\u4e3a[" + info.getBillMappingName() + "]";
            String taskID = EipTaskManager.generateTaskID(TaskType.VIEW.type, TaskAction.VIEW_DROP_PK_TABLE.action, info.getId().toString());
            JSONObject paramJSON = new JSONObject();
            try {
                paramJSON.put("billName", info.getNumber());
                paramJSON.put("billNumber", info.getNumber());
                paramJSON.put("sql", ksql);
            }
            catch (JSONException e) {
                throw new BOSException((Throwable)e);
            }
            EipTaskManager.orderTask(ctx, taskID, TaskType.VIEW, TaskAction.VIEW_DROP_PK_TABLE, paramJSON.toString(), taskDes, info.getAgentUser(), null);
        }
    }
}

