/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.ProjectFactory;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.action.IDataAction;
import com.kingdee.eas.csinterface.biz.app.ActionType;
import com.kingdee.eas.csinterface.biz.app.DataSourceType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.extract.DataExtractFactory;
import com.kingdee.eas.csinterface.biz.extract.IDataExtract;
import com.kingdee.eas.csinterface.biz.extract.OperateStatus;
import com.kingdee.eas.csinterface.biz.load.DataLoaderFacatory;
import com.kingdee.eas.csinterface.biz.load.IDataLoader;
import com.kingdee.eas.csinterface.biz.log.MonitorLogManager;
import com.kingdee.eas.csinterface.biz.model.Params;
import com.kingdee.eas.csinterface.biz.transform.DataTransform;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataProjectAction
implements IDataAction {
    private static final Logger logger = Logger.getLogger(DataProjectAction.class);
    private String projectId;

    public DataProjectAction(String projectId) {
        this.projectId = projectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTask() {
        block12: {
            Context ctx = EIPContext.getInstance().getContext();
            MonitorLogManager.enter(ActionType.DATAPROJECT);
            try {
                if (StringUtils.isEmpty((String)this.projectId)) break block12;
                ProjectInfo projectInfo = ProjectFactory.getLocalInstance(ctx).getProjectInfo("SELECT *,entrys.srcField,entrys.srcDesc,entrys.required,entrys.expression,entrys.mappingTrans,entrys.targetField,srcObj.entrys.id,entrys.parentField,srcObj.entrys.type,srcObj.entrys.alias,srcObj.entrys.name,srcObj.connection.id,srcObj.connection.number WHERE id='" + this.projectId + "'");
                MonitorLogManager.enterProject(projectInfo);
                EIPContext eipContext = EIPContext.getInstance();
                eipContext.put("projectInfo", projectInfo);
                IDataExtract dataExtract = DataExtractFactory.getInstance().getExtract();
                DataSourceInfo dataSourceInfo = (DataSourceInfo)eipContext.get("dataSourceInfo");
                if (DataSourceType.INTERFACE.equals((Object)dataSourceInfo.getDsType())) {
                    TableData tableData = dataExtract.getSrcData(null, OperateStatus.ADDNEW);
                    if (!tableData.hasNext()) {
                        MonitorLogManager.warn("\u6ca1\u6709\u67e5\u627e\u5230\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\n");
                        return;
                    }
                    DataTransform dataTransform = DataTransform.getInstance(tableData, OperateStatus.ADDNEW);
                    dataTransform.trans();
                    String data = dataTransform.getData();
                    if (!StringUtils.isEmpty((String)data)) {
                        IDataLoader dataLoader = DataLoaderFacatory.getInstance(OperateStatus.ADDNEW);
                        List<String> successId = dataLoader.loadData(data);
                        try {
                            dataLoader.callback(successId, tableData);
                        }
                        catch (Exception e) {
                            MonitorLogManager.warn("\u56de\u5199\u589e\u91cf\u8868\u6216\u751f\u6210\u5173\u7cfb\u8868\u5f02\u5e38");
                        }
                    }
                    MonitorLogManager.enterContent("\u4e3b\u8868\u5f85\u4f20\u8f93\u8bb0\u5f55\uff1a\u5f85\u65b0\u589e\u8bb0\u5f55\u3010" + tableData.size() + "\u3011\u6761\uff1b");
                    return;
                }
                Map<String, List<String>> mainPkList = dataExtract.getMainPkList();
                List<String> addList = mainPkList.get("addList");
                List<String> updateList = mainPkList.get("updateList");
                List<String> deleteList = mainPkList.get("deleteList");
                MonitorLogManager.enterContent("\u4e3b\u8868\u5f85\u4f20\u8f93\u8bb0\u5f55\uff1a\u5f85\u65b0\u589e\u8bb0\u5f55\u3010" + addList.size() + "\u3011\u6761\uff1b" + "\u5f85\u66f4\u65b0\u8bb0\u5f55\u3010" + updateList.size() + "\u3011\u6761\uff1b" + "\u5f85\u5220\u9664\u8bb0\u5f55\u3010" + deleteList.size() + "\u3011\u6761");
                this.runSync(dataExtract, addList, OperateStatus.ADDNEW);
                this.runSync(dataExtract, updateList, OperateStatus.UPDATE);
                this.runSync(dataExtract, deleteList, OperateStatus.DELETE);
            }
            catch (Exception e1) {
                String message = e1.getCause() == null ? e1.getMessage() : e1.getCause().getMessage();
                MonitorLogManager.error("\u96c6\u6210\u5931\u8d25\uff1a" + message + "\n", ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
                logger.error((Object)"\u96c6\u6210\u51fa\u9519", (Throwable)e1);
            }
            finally {
                MonitorLogManager.exit();
            }
        }
    }

    private void runSync(IDataExtract dataExtract, List<String> mainPKList, OperateStatus status) throws BOSException {
        if (mainPKList.isEmpty()) {
            return;
        }
        int page = mainPKList.size() / Params.EXTRACT_COUNT;
        int rest = mainPKList.size() % Params.EXTRACT_COUNT;
        List<String> dealList = null;
        for (int i = 0; i <= page; ++i) {
            if (i == page && rest != 0) {
                dealList = mainPKList.subList(i * page, i * page + rest);
            } else if (i < page) {
                dealList = mainPKList.subList(i * page, i * (page + 1));
            }
            TableData tableData = dataExtract.getSrcData(dealList, status);
            if (!tableData.hasNext()) {
                MonitorLogManager.warn("\u6ca1\u6709\u67e5\u627e\u5230\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\n");
                return;
            }
            DataTransform dataTransform = DataTransform.getInstance(tableData, status);
            dataTransform.trans();
            String data = dataTransform.getData();
            if (StringUtils.isEmpty((String)data)) continue;
            IDataLoader dataLoader = DataLoaderFacatory.getInstance(status);
            List<String> successId = dataLoader.loadData(data);
            try {
                dataLoader.callback(successId, tableData);
                continue;
            }
            catch (Exception e) {
                MonitorLogManager.warn("\u56de\u5199\u589e\u91cf\u8868\u6216\u751f\u6210\u5173\u7cfb\u8868\u5f02\u5e38");
            }
        }
    }
}

