/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.extract;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.csinterface.biz.InterfaceInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.app.ActionType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.exception.EIPException;
import com.kingdee.eas.csinterface.biz.extract.IDataExtract;
import com.kingdee.eas.csinterface.biz.extract.OperateStatus;
import com.kingdee.eas.csinterface.biz.handler.IAPIProcessHandler;
import com.kingdee.eas.csinterface.biz.model.Params;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class APIExtract
implements IDataExtract {
    private static final Logger logger = Logger.getLogger(APIExtract.class);

    @Override
    public TableData getSrcData(List<String> pkList, OperateStatus actionType) throws BOSException {
        String[] fields;
        EIPContext eipContext = EIPContext.getInstance();
        InterfaceInfo interfaceInfo = (InterfaceInfo)eipContext.get("apiInfo");
        ProjectInfo projectInfo = (ProjectInfo)eipContext.get("projectInfo");
        Map dataSourceResult = (Map)eipContext.get("dataSourceResult");
        if (interfaceInfo == null) {
            throw new EIPException("\u672a\u914d\u7f6e\u63a5\u53e3\u5b9e\u73b0");
        }
        String customClass = interfaceInfo.getCustomClass();
        if (StringUtils.isEmpty((String)customClass)) {
            throw new EIPException("\u672a\u914d\u7f6e\u63a5\u53e3\u5b9e\u73b0");
        }
        TableData tableData = new TableData();
        String headFields = (String)dataSourceResult.get("headFields");
        String entryFields = (String)dataSourceResult.get("entryFields");
        for (String field : fields = (headFields + "," + entryFields).split(",")) {
            if (StringUtils.isEmpty((String)field)) continue;
            tableData.addColumn(field);
        }
        try {
            IAPIProcessHandler apiProcess = (IAPIProcessHandler)Class.forName(customClass).newInstance();
            Params.APIParams apiParams = new Params.APIParams(ActionType.DATAPROJECT, projectInfo.getNumber());
            apiParams.setColumns(tableData.getCloumnModels());
            List<Map<String, Object>> srcDatas = apiProcess.getSrcData(apiParams);
            int size = tableData.getCloumnModels().size();
            for (Map<String, Object> srcData : srcDatas) {
                for (int j = 0; j < size; ++j) {
                    String columnName = tableData.getColumnModel(j).getName();
                    tableData.addData(srcData.get(columnName));
                }
            }
            return tableData;
        }
        catch (Exception e) {
            logger.error((Object)"\u3010EIP\u3011\u62bd\u53d6\u6570\u636e\u9519\u8bef", (Throwable)e);
            throw new EIPException("\u3010EIP\u3011\u62bd\u53d6\u6570\u636e\u9519\u8bef");
        }
    }

    @Override
    public Map<String, List<String>> getMainPkList() throws BOSException, SQLException {
        return null;
    }
}

