/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.load;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.openapi.util.OpenApiBOUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.app.DataSourceType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.PKTableData;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.load.AbstractDataLoader;
import com.kingdee.eas.csinterface.biz.log.MonitorLogManager;
import com.kingdee.eas.csinterface.biz.model.PKTable;
import com.kingdee.eas.csinterface.biz.util.DateUtils;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataLoaderForUpdate
extends AbstractDataLoader {
    private static final Logger logger = Logger.getLogger(DataLoaderForUpdate.class);

    protected DataLoaderForUpdate() {
    }

    @Override
    public List<String> loadData(String data) {
        ProjectInfo projectInfo = (ProjectInfo)EIPContext.getInstance().get("projectInfo");
        data = this.preHandle(data, projectInfo);
        String clzObjectValueName = null;
        try {
            Context ctx = EIPContext.getInstance().getContext();
            BOSObjectType bosObjectType = BOSObjectType.create((String)projectInfo.getTargetObj());
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosObjectType);
            clzObjectValueName = entityObjectInfo.getObjectCollectionClass();
            Class<IObjectCollection> objectCollectionClass = Class.forName(clzObjectValueName);
            MethodInfo method = this.getMethodInfoFromEntryInfo(projectInfo.getTargetFunc(), entityObjectInfo, "updateMethod");
            Object[] result = new Object[]{};
            if (!StringUtils.isEmpty((String)data)) {
                List<Object> paramsValue = this.getParamsValue(method, objectCollectionClass, data);
                result = new Object[paramsValue.size()];
                for (int i = 0; i < paramsValue.size(); ++i) {
                    result[i] = OpenApiBOUtils.callMethod((Context)ctx, (BOSObjectType)bosObjectType, (MethodInfo)method, (Object[])new Object[]{paramsValue.get(i)});
                }
            }
            List<String> successIds = this.parseResult(result);
            this.postHandle(successIds, projectInfo);
            return successIds;
        }
        catch (ClassNotFoundException e) {
            MonitorLogManager.error("\u96c6\u6210\u5931\u8d25\uff1a" + e.getCause().getMessage() + ("can't find " + clzObjectValueName) + "\n", ExceptionUtil.getExcLinkStackTrace((Throwable)e));
            logger.error((Object)("\u96c6\u6210\u51fa\u9519\uff0ccan't find " + clzObjectValueName), (Throwable)e);
        }
        catch (Exception e1) {
            MonitorLogManager.error("\u96c6\u6210\u5931\u8d25\uff1a" + e1.getCause().getMessage() + "\n", ExceptionUtil.getExcLinkStackTrace((Throwable)e1));
            logger.error((Object)"\u96c6\u6210\u51fa\u9519", (Throwable)e1);
        }
        return Collections.emptyList();
    }

    @Override
    public void callback(List<String> successIds, TableData srcData) {
        Map srcToDest = (Map)EIPContext.getInstance().get("srcToDest");
        ConnectionInfo conn = (ConnectionInfo)EIPContext.getInstance().get("connectionInfo");
        DataSourceInfo dataSourceInfo = (DataSourceInfo)EIPContext.getInstance().get("dataSourceInfo");
        Map dataSourceResult = (Map)EIPContext.getInstance().get("dataSourceResult");
        String changeTimeField = (String)dataSourceResult.get("changeTimeField");
        String headPKField = (String)dataSourceResult.get("headpk");
        boolean fromJBDC = DataSourceType.JDBC.equals((Object)dataSourceInfo.getDsType());
        if (fromJBDC && conn != null) {
            PKTable pkTable = new PKTable(dataSourceInfo.getMainView(), conn);
            String connid = conn.getId().toString();
            while (srcData.next()) {
                String headPK = srcData.getString(headPKField);
                String destId = (String)srcToDest.get(headPK);
                if (!successIds.contains(destId)) continue;
                String changeTime = srcData.getString(changeTimeField);
                pkTable.addTableData(new PKTableData(headPK, new Timestamp(DateUtils.parse(changeTime).getTime()), null, connid, 1, 1, null, null));
            }
            if (pkTable.size() > 0) {
                pkTable.executeInsert();
            }
        }
    }
}

