/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.transform;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.biz.AbstractMappingResultEntryInfo;
import com.kingdee.eas.csinterface.biz.MappingInfo;
import com.kingdee.eas.csinterface.biz.MappingResultEntryFactory;
import com.kingdee.eas.csinterface.biz.ProjectEntryCollection;
import com.kingdee.eas.csinterface.biz.ProjectEntryInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.transform.IDataTransformHandler;
import com.kingdee.eas.csinterface.biz.util.Script;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ColumnTransformHandler
implements IDataTransformHandler {
    @Override
    public void handle(Map<String, Object> ctx) {
        Map mapping = (Map)ctx.get("mapping");
        TableData tableData = (TableData)ctx.get("srcData");
        ProjectInfo projectInfo = (ProjectInfo)ctx.get("project");
        ProjectEntryCollection coll = projectInfo.getEntrys();
        JSONObject rowData = new JSONObject();
        this.handleMapping(mapping, tableData, rowData);
        this.handleTypeMapping(rowData, coll);
        this.handleExpression(rowData, coll);
        rowData.put("bosType", (Object)projectInfo.getTargetObj());
        ctx.put("rowData", rowData);
    }

    private void handleMapping(Map<String, String> mapping, TableData originData, JSONObject targetData) {
        Set<Map.Entry<String, String>> entrys = mapping.entrySet();
        for (Map.Entry<String, String> entry : entrys) {
            String target = originData.getString(entry.getValue());
            targetData.put(entry.getKey(), (Object)target);
        }
    }

    private void handleTypeMapping(JSONObject rowData, ProjectEntryCollection entrys) {
        Context ctx = EIPContext.getInstance().getContext();
        for (int i = 0; i < entrys.size(); ++i) {
            ProjectEntryInfo entry = entrys.get(i);
            if (entry.getMappingTrans() == null) continue;
            MappingInfo mappingInfo = entry.getMappingTrans();
            AbstractMappingResultEntryInfo mappingResultEntryInfo = null;
            try {
                mappingResultEntryInfo = MappingResultEntryFactory.getLocalInstance(ctx).getMappingResultEntryInfo("SELECT srcID,destID where srcID = '" + rowData.getString(entry.getTargetField()) + "' and parent.mapping.id = '" + mappingInfo.getId().toString() + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mappingResultEntryInfo == null) continue;
            rowData.put(entry.getTargetField(), (Object)mappingResultEntryInfo.getDestID());
        }
    }

    private void handleExpression(JSONObject rowData, ProjectEntryCollection entrys) {
        Context ctx = EIPContext.getInstance().getContext();
        for (int i = 0; i < entrys.size(); ++i) {
            ProjectEntryInfo entry = entrys.get(i);
            if (StringUtils.isEmpty((String)entry.getExpression())) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("it", rowData);
            rowData.put(entry.getTargetField(), Script.getScript(ctx, entry.getExpression(), params).execute());
        }
    }
}

