/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.transform;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.extract.OperateStatus;
import com.kingdee.eas.csinterface.biz.transform.GroupTransformHandler;
import com.kingdee.eas.csinterface.biz.transform.IDataTransformHandler;
import com.kingdee.eas.csinterface.biz.transform.IdentifyTransformHandler;
import com.kingdee.eas.csinterface.biz.transform.RowTransformHandler;
import java.util.HashMap;
import java.util.Map;

public class DataTransform {
    private IDataTransformHandler[] handlers = new IDataTransformHandler[]{new RowTransformHandler(), new IdentifyTransformHandler(), new GroupTransformHandler()};
    private ProjectInfo projectInfo;
    private TableData tableData;
    private OperateStatus status;
    private Map<String, Object> ctx = new HashMap<String, Object>();

    private DataTransform() {
    }

    public static DataTransform getInstance(TableData tableData, OperateStatus status) {
        ProjectInfo projectInfo = (ProjectInfo)EIPContext.getInstance().get("projectInfo");
        DataTransform instance = new DataTransform();
        instance.projectInfo = projectInfo;
        instance.tableData = tableData;
        instance.status = status;
        return instance;
    }

    public void trans() {
        this.ctx.put("project", this.projectInfo);
        this.ctx.put("srcData", this.tableData);
        this.ctx.put("status", (Object)this.status);
        for (IDataTransformHandler handler : this.handlers) {
            handler.handle(this.ctx);
        }
    }

    public String getData() {
        return ((JSONArray)this.ctx.get("destData")).toJSONString();
    }
}

