/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.editor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataOptions;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.DataSourceType;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.IEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.info.FieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.TranslateLocalUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class EntityTableEditor
implements IEditor {
    public static final String DATA_SOURCE_TYPE = "DataSourceType";
    public static final String DYNEXTENDPROPERTYLIST = "dynExtendPropertyList";
    private EntityObjectInfo entityInfo;
    private DataTableInfo tableInfo;
    private List<RelationshipInfo> relationInfos;
    private List<String> toDelRelationList = null;

    public EntityTableEditor(EntityObjectInfo entityObjectInfo, DataTableInfo tableInfo) {
        this.entityInfo = entityObjectInfo;
        this.tableInfo = tableInfo;
    }

    private PropertyInfo addEntityField(FieldInfo fieldInfo, EntityObjectInfo baseDataEntityInfo) {
        Object prop = null;
        prop = baseDataEntityInfo == null ? this.createOwnProperty(fieldInfo) : this.createLinkProperty(baseDataEntityInfo, fieldInfo);
        prop.setName(fieldInfo.getRealName());
        if (ContextUtils.getLocaleFromEnv().equals(new Locale("l1"))) {
            prop.setAlias(fieldInfo.getAlias());
        } else {
            prop.setAlias(TranslateLocalUtil.getSimplified(fieldInfo.getAlias()), new Locale("l2"));
            prop.setAlias(TranslateLocalUtil.getTraditional(fieldInfo.getAlias()), new Locale("l3"));
        }
        prop.setAlias(fieldInfo.getAlias());
        prop.setDescription(fieldInfo.getAlias());
        return prop;
    }

    private LinkPropertyInfo createLinkProperty(EntityObjectInfo relationEntityInfo, FieldInfo fieldInfo) {
        LinkPropertyInfo linkprop = new LinkPropertyInfo();
        linkprop.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        RelationshipInfo relation = new RelationshipInfo();
        relation.setPackage("com.kingdee.eas.csinterface.custom");
        String relationName = "R_" + this.entityInfo.getName() + "_" + relationEntityInfo.getName() + "_" + fieldInfo.getRealName();
        relation.setName(relationName);
        relation.setType(RelationshipType.ASSOCIATION);
        relation.setClientCardinality(CardinalityType.ONE);
        relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
        relation.setClientObject(this.entityInfo);
        relation.setSupplierObject(relationEntityInfo);
        relation.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        linkprop.setRelationship(relation);
        if (this.relationInfos == null) {
            this.relationInfos = new ArrayList<RelationshipInfo>();
        }
        this.relationInfos.add(relation);
        EntityViewInfo defaultView = relationEntityInfo.getDefaultView();
        if (defaultView == null) {
            defaultView = new EntityViewInfo();
            relationEntityInfo.setDefaultView(defaultView);
        }
        linkprop.setExtendedProperty("isForMapping", "false");
        linkprop.setExtendedProperty("isForGrouping", "false");
        linkprop.setExtendedProperty("isForMatching", "false");
        linkprop.setExtendedProperty("isForWrittenBack", "false");
        String dynExtendPropertyList = linkprop.getExtendedProperty(DYNEXTENDPROPERTYLIST) + "|isForMapping|isForGrouping|isForMatching|isForWrittenBack";
        linkprop.setExtendedProperty(DYNEXTENDPROPERTYLIST, dynExtendPropertyList);
        return linkprop;
    }

    private OwnPropertyInfo createOwnProperty(FieldInfo fieldInfo) {
        OwnPropertyInfo prop = new OwnPropertyInfo();
        prop.setDataType(fieldInfo.getDataType());
        if (DataType.ENUM.equals((Object)fieldInfo.getDataType())) {
            String fullName = fieldInfo.getEnumName();
            prop.setMetadataRef(fullName);
        }
        prop.setLength(fieldInfo.getLength());
        prop.setPrecision(fieldInfo.getPrecision());
        prop.setDecimalDigits(fieldInfo.getScale());
        prop.getExtendedProperties().put(DATA_SOURCE_TYPE, DataSourceType.MANAUL.getName());
        prop.setExtendedProperty("isInCode", "true");
        String dynExtendPropertyList = "isInCode";
        prop.setExtendedProperty(DYNEXTENDPROPERTYLIST, dynExtendPropertyList);
        prop.setExtendedProperty("isCommonQueryFilter", "true");
        dynExtendPropertyList = prop.getExtendedProperty(DYNEXTENDPROPERTYLIST) + "|" + "isCommonQueryFilter";
        prop.setExtendedProperty(DYNEXTENDPROPERTYLIST, dynExtendPropertyList);
        prop.setExtendedProperty("isForMapping", "true");
        prop.setExtendedProperty("isForGrouping", "true");
        prop.setExtendedProperty("isForMatching", "true");
        prop.setExtendedProperty("isForWrittenBack", "true");
        dynExtendPropertyList = prop.getExtendedProperty(DYNEXTENDPROPERTYLIST) + "|isForMapping|isForGrouping|isForMatching|isForWrittenBack";
        prop.setExtendedProperty(DYNEXTENDPROPERTYLIST, dynExtendPropertyList);
        prop.setExtendedProperty("enableFieldPermission", String.valueOf(true));
        dynExtendPropertyList = prop.getExtendedProperty(DYNEXTENDPROPERTYLIST) + "|enableFieldPermission";
        prop.setExtendedProperty(DYNEXTENDPROPERTYLIST, dynExtendPropertyList);
        return prop;
    }

    private ColumnInfo createColumnByBizField(FieldInfo fieldInfo, DataTableInfo tableInfo, EntityObjectInfo baseDataEntityInfo) throws Exception {
        if (tableInfo == null) {
            throw new IllegalArgumentException("DataTableInfo cannot be null!");
        }
        ColumnInfo column = new ColumnInfo();
        String fieldName = fieldInfo.getRealName();
        if (!"id".equalsIgnoreCase(fieldName)) {
            column.setNullable(true);
        }
        column.setDefaultValue(null);
        if (!StringUtils.isEmpty((String)fieldInfo.getBaseDataType())) {
            String name = this.generateColumnName(tableInfo, fieldName);
            column.setName(name);
            column.setTypeName(SQLType.VARCHAR);
            column.setLength(44);
            DataTableInfo refTable = baseDataEntityInfo.getTable();
            if (refTable != null && refTable.getPrimaryKey() != null && refTable.getPrimaryKey().getPKColumns().size() == 1) {
                ForeignKeyInfo fk = new ForeignKeyInfo();
                fk.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
                fk.setName(BIMNameFactory.createTableFKName((String)tableInfo.getPackage(), (String)tableInfo.getName(), (String)refTable.getName(), (String)fieldInfo.getRealName(), (boolean)true));
                fk.setRefTable((AbstractTableInfo)refTable);
                FKColumnPairInfo fkColumnPair = new FKColumnPairInfo();
                fkColumnPair.setPrimaryKeyColumn(refTable.getPrimaryKey().getPKColumns().get(0).getColumn());
                fkColumnPair.setForeignKeyColumn(column);
                fk.getFKColumnPairs().add(fkColumnPair);
                tableInfo.getForeignKeys().add(fk);
            }
        } else {
            column.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            String name = this.generateColumnName(tableInfo, fieldName);
            column.setName(name);
            if (StringUtils.isEmpty((String)fieldInfo.getBaseDataType())) {
                column.setTypeName(fieldInfo.getSqlType());
                column.setLength(fieldInfo.getLength());
            } else {
                column.setTypeName(SQLType.VARCHAR);
                column.setLength(44);
            }
            column.setPrecision(fieldInfo.getPrecision());
            column.setScale(fieldInfo.getScale());
            column.setMultilingual(false);
            column.setAlias(fieldInfo.getAlias());
            column.setDescription(column.getAlias());
        }
        return column;
    }

    public List<RelationshipInfo> getRelationInfos() {
        return this.relationInfos;
    }

    public String generateColumnName(DataTableInfo tableInfo, String name) throws BOSException {
        String prefix;
        Context ctx = ConfigMDUtil.getContext();
        String string = prefix = MetaDataOptions.isDevelopVersion() ? "F" : "CF";
        if ("entryStatus".equalsIgnoreCase(name) || "assignmentNumber".equalsIgnoreCase(name)) {
            prefix = "F";
        }
        name = StringUtils.headCharUpperCase((String)name);
        String resultColName = DBUtils.getColumnName(ctx, tableInfo.getName(), prefix + name);
        return resultColName;
    }

    @Override
    public void add(FieldInfo fieldInfo) throws Exception {
        EntityObjectInfo baseDataEntityInfo = null;
        if (!StringUtils.isEmpty((String)fieldInfo.getBaseDataType())) {
            baseDataEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(fieldInfo.getBaseDataType()));
        }
        PropertyInfo prop = this.addEntityField(fieldInfo, baseDataEntityInfo);
        ColumnInfo column = this.createColumnByBizField(fieldInfo, this.tableInfo, baseDataEntityInfo);
        prop.setMappingField(column);
        prop.setConfigured(true);
        this.entityInfo.getProperties().add(prop);
        this.tableInfo.getColumns().add(column);
    }

    @Override
    public void delete(FieldInfo fieldInfo) {
        PropertyCollection pcs = this.entityInfo.getProperties();
        ColumnInfo columnInfo = null;
        for (int i = 0; i < pcs.size(); ++i) {
            PropertyInfo pInfo = pcs.get(i);
            if (!pInfo.getName().equals(fieldInfo.getRealName())) continue;
            if (pInfo instanceof LinkPropertyInfo) {
                if (this.toDelRelationList == null) {
                    this.toDelRelationList = new ArrayList<String>();
                }
                this.toDelRelationList.add(((LinkPropertyInfo)pInfo).getRelationship().getRealFullName());
            }
            pcs.removeObject((IObjectValue)pInfo);
            columnInfo = pInfo.getMappingField();
            break;
        }
        String columnName = null;
        if (columnInfo != null) {
            columnName = columnInfo.getName();
        }
        ColumnCollection ccs = this.tableInfo.getColumns();
        for (int i = 0; i < ccs.size(); ++i) {
            ColumnInfo cInfo = ccs.get(i);
            if (!cInfo.getName().equals(columnName)) continue;
            ccs.removeObject((IObjectValue)cInfo);
            break;
        }
    }

    public List<String> getToDelRelationList() {
        return this.toDelRelationList;
    }
}

