/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.business.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataTemplateCopyUtil;
import com.kingdee.eas.csinterface.business.BizWizardEntryCollection;
import com.kingdee.eas.csinterface.business.BizWizardEntryFactory;
import com.kingdee.eas.csinterface.business.BizWizardEntryInfo;
import com.kingdee.eas.csinterface.business.BizWizardFactory;
import com.kingdee.eas.csinterface.business.BizWizardInfo;
import com.kingdee.eas.csinterface.business.IBizWizard;
import com.kingdee.eas.csinterface.business.app.AbstractDeletePlanControllerBean;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.IKSQLFacade;
import com.kingdee.eas.csinterface.utils.KSQLFacadeFactory;
import com.kingdee.eas.csinterface.utils.ViewSQLSimpleParser;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeletePlanControllerBean
extends AbstractDeletePlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.business.app.DeletePlanControllerBean");
    private Map<String, Set<IObjectPK>> explainMap = new HashMap<String, Set<IObjectPK>>();
    private static String[] COLUMN = new String[]{"srcViewId", "billMpingId", "botpRuleId", "dataTypeMapId", "dataMapId", "multiDataMapId", "scheduleId", "pks"};

    public DeletePlanControllerBean() {
        this.initIdsMap();
    }

    protected String _delte(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BizWizardInfo info = BizWizardFactory.getLocalInstance(ctx).getBizWizardInfo(pk);
        try {
            this.explanInfo(info);
            if (!StringUtil.isEmpty((String)info.getSrcViewId())) {
                try {
                    SrcDBViewInfo viewInfo = SrcDBViewFactory.getLocalInstance(ctx).getSrcDBViewInfo(CommonUtil.convert2PK(info.getSrcViewId()));
                    this.deleteSrcViews(true, viewInfo, ctx);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("\u5220\u9664\u6570\u636e\u5e93\u4e2d\u7684\u89c6\u56fe\u5931\u8d25\u3002" + e.getMessage()));
                }
            }
            try {
                this.batchDelete(ctx);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            BizWizardFactory.getLocalInstance(ctx).delete(pk);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    public void initIdsMap() {
        int i = 0;
        this.explainMap.put(COLUMN[i++], new HashSet());
        this.explainMap.put(COLUMN[i++], new HashSet());
        this.explainMap.put(COLUMN[i++], new HashSet());
        this.explainMap.put(COLUMN[i++], new HashSet());
        this.explainMap.put(COLUMN[i++], new HashSet());
        this.explainMap.put(COLUMN[i++], new HashSet());
        this.explainMap.put(COLUMN[i++], new HashSet());
        this.explainMap.put(COLUMN[i++], new HashSet());
    }

    public synchronized Map<String, Set<IObjectPK>> explanInfo(BizWizardInfo info) {
        BizWizardEntryCollection entrys = info.getEntrys();
        BizWizardEntryInfo entry = null;
        this.initIdsMap();
        this.explainMap.get(COLUMN[0]).add(this.convert2PK(info.getSrcViewId()));
        this.explainMap.get(COLUMN[1]).add(this.convert2PK(info.getBillMapId()));
        this.explainMap.get(COLUMN[2]).add(this.convert2PK(info.getBotpRuleId()));
        int length = entrys.size();
        for (int i = 0; i < length; ++i) {
            entry = entrys.get(i);
            if (entry == null) continue;
            if (entry.getDataTypeMapId() != null) {
                this.explainMap.get(COLUMN[3]).add(this.convert2PK(entry.getDataTypeMapId()));
            }
            if (entry.getDataMapId() != null) {
                this.explainMap.get(COLUMN[4]).add(this.convert2PK(entry.getDataMapId()));
            }
            if (entry.getMultiDataMapId() != null) {
                this.explainMap.get(COLUMN[5]).add(this.convert2PK(entry.getMultiDataMapId()));
            }
            if (entry.getScheduleId() != null) {
                this.explainMap.get(COLUMN[6]).add(this.convert2PK(entry.getScheduleId()));
            }
            this.explainMap.get(COLUMN[7]).add(this.convert2PK(entry.getId().toString()));
        }
        return this.explainMap;
    }

    public void batchDelete(Context ctx) throws EASBizException, BOSException {
        IObjectPK[] pks = new IObjectPK[]{};
        try {
            SrcDBViewFactory.getLocalInstance(ctx).delete(this.explainMap.get(COLUMN[0]).toArray(pks));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        try {
            BaseDataMapingFactory.getLocalInstance(ctx).deleteBatchData(this.explainMap.get(COLUMN[4]).toArray(pks));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        try {
            BaseDataTypeFactory.getLocalInstance(ctx).deleteBatchData(this.explainMap.get(COLUMN[3]).toArray(pks));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        try {
            BOTMappingFactory.getLocalInstance((Context)ctx).deleteBatchData(this.explainMap.get(COLUMN[2]).toArray(pks));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        try {
            MultiToMultiMapFactory.getLocalInstance(ctx).deleteBatchData(this.explainMap.get(COLUMN[5]).toArray(pks));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        try {
            ScheduleFactory.getLocalInstance(ctx).deleteBatchData(this.explainMap.get(COLUMN[6]).toArray(pks));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        Set<IObjectPK> billPK = this.explainMap.get(COLUMN[1]);
        if (billPK.size() > 0 && billPK.toArray()[0] != null) {
            try {
                BillMappingInfo bill = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo((IObjectPK)billPK.toArray()[0]);
                if (bill != null) {
                    MetadataTemplateCopyUtil.delete(ctx, bill.getNumber());
                    BillMappingFactory.getLocalInstance(ctx).deleteBatchData(this.explainMap.get(COLUMN[1]).toArray(pks));
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u5220\u9664\u5355\u636e\u3010" + billPK.toArray()[0] + "\u3011\u7684\u5931\u8d25\u3002" + e.getMessage()));
            }
        }
        BizWizardEntryFactory.getLocalInstance(ctx).deleteBatchData(this.explainMap.get(COLUMN[7]).toArray(pks));
    }

    public IObjectPK convert2PK(String pk) {
        return CommonUtil.convert2PK(pk);
    }

    public void deleteSrcViews(boolean dialect, SrcDBViewInfo info, Context ctx) throws BOSException, EASBizException {
        String ksql = info.getCreateViewSql();
        if (StringUtils.isEmpty((String)ksql)) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u89c6\u56fe\u8bed\u53e5\u4e3a\u7a7a\uff0c\u4e0d\u5fc5\u5220\u9664\u89c6\u56fe\u3002"));
            return;
        }
        ViewSQLSimpleParser simpleParser = new ViewSQLSimpleParser(ksql);
        ArrayList<ViewSQLSimpleParser.ViewParseResult> parseResults = simpleParser.getParseResult();
        ArrayList<String> ksqls = new ArrayList<String>();
        ArrayList<String> viewNames = new ArrayList<String>();
        Object mainViewName = null;
        int index = 0;
        for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
            ++index;
            viewNames.add(parseResult.viewName);
            ksqls.add(dialect ? "/*dialect*/" + parseResult.viewSql : parseResult.viewSql);
        }
        DataSourceType dsType = info.getDsType();
        if (dsType == null) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u7f51\u7edc\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\u89c6\u56fe"));
            return;
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            ConnectionInfo conn = info.getConnection();
            if (null == conn) {
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(conn.getId());
            conn = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo((IObjectPK)pk);
            DataBaseType dbType = DataBaseType.getInstance(info.getDbType().getName());
            IKSQLFacade facade = KSQLFacadeFactory.getLocalInstance(ctx);
            Object[] existViews = facade.existViews(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), viewNames.toArray(new String[0]));
            if (existViews != null && existViews.length > 0) {
                String viewNamesStr = StringUtils.arrayToString((Object[])existViews, (String)",");
                logger.info((Object)("\u9009\u62e9\u4e86\u5f3a\u5236\u5220\u9664\u89c6\u56fe:" + viewNamesStr));
                for (int i = 0; i < existViews.length; ++i) {
                    if (((String)existViews[i]).charAt(0) == '\"') continue;
                    existViews[i] = ((String)existViews[i]).toUpperCase();
                }
                try {
                    facade.createView(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), new String[0], (String[])existViews);
                    logger.info((Object)"\u5220\u9664\u89c6\u56fe\u6210\u529f\u3002");
                }
                catch (Exception e) {
                    logger.error((Object)("\u5220\u9664\u89c6\u56fe\u5931\u8d25\u3002\n" + e));
                }
            }
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            // empty if block
        }
    }

    @Override
    protected String _delete(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        IBillMapping billInstance = BillMappingFactory.getLocalInstance(ctx);
        IBizWizard bizInstance = BizWizardFactory.getLocalInstance(ctx);
        BizWizardInfo bizInfo = bizInstance.getBizWizardInfo(pk);
        String billId = bizInfo.getBillMapId();
        BillMappingInfo bill = null;
        boolean onlyDeletePlan = true;
        if (!StringUtils.isEmpty((String)billId)) {
            try {
                bill = billInstance.getBillMappingInfo(CommonUtil.convert2PK(billId));
                onlyDeletePlan = false;
            }
            catch (ObjectNotFoundException ne) {
                logger.error((Object)ne.getMessage());
            }
        }
        if (onlyDeletePlan) {
            BizWizardFactory.getLocalInstance(ctx).delete(pk);
        } else {
            boolean deleteBill;
            IObjectPK[] typeArrayPK = null;
            boolean deleteType = (Boolean)param.get("deleteType");
            if (deleteType) {
                Set typeIdSet = billInstance.getBaseDataType(billId, false);
                typeArrayPK = new IObjectPK[typeIdSet.size()];
                int i = 0;
                for (String typeId : typeIdSet) {
                    typeArrayPK[i++] = CommonUtil.convert2PK(typeId);
                }
            }
            if (deleteBill = ((Boolean)param.get("deleteBill")).booleanValue()) {
                billInstance.delete(CommonUtil.convert2PK(billId));
            } else {
                BizWizardFactory.getLocalInstance(ctx).delete(pk);
            }
            if (deleteType) {
                BaseDataTypeFactory.getLocalInstance(ctx).delete(typeArrayPK);
            }
        }
        boolean deleteSrcView = (Boolean)param.get("deleteSrcView");
        if (deleteSrcView) {
            try {
                String srcDBViewId = bizInfo.getSrcViewId();
                if (!StringUtils.isEmpty((String)srcDBViewId)) {
                    SrcDBViewFactory.getLocalInstance(ctx).delete(CommonUtil.convert2PK(srcDBViewId));
                }
            }
            catch (ObjectNotFoundException ne) {
                logger.error((Object)ne.getMessage());
            }
        }
        return null;
    }
}

