/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.model;

import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import java.io.Serializable;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialException;
import org.apache.log4j.Logger;

public class DataRow
implements Serializable,
Comparable {
    static final Logger logger = Logger.getLogger(DataRow.class);
    private static final long serialVersionUID = 7923850397766708694L;
    public final String pkColumn;
    private Map values;
    private Map manyToOne;
    private Map oneToMany;
    private boolean isIgnore;

    public boolean isIgnore() {
        return this.isIgnore;
    }

    public void setIgnore(boolean isIgnore) {
        this.isIgnore = isIgnore;
    }

    public DataRow(StructuredDataModel.TableModel tableModel) {
        this.pkColumn = tableModel.pkColumn.name;
        this.values = new HashMap(tableModel.columns.length);
    }

    public void setValue(String name, Object value) {
        this.values.put(name, value);
    }

    public Map getValues() {
        return this.values;
    }

    public DataRow getParentDataRow(String tableName) {
        if (this.manyToOne != null) {
            return (DataRow)this.manyToOne.get(tableName);
        }
        return null;
    }

    public List getChildrenDataRows(String tableName) {
        if (this.oneToMany != null) {
            return (List)this.oneToMany.get(tableName);
        }
        return null;
    }

    public List<DataRow> getFirstChildrenDataRows() {
        if (this.oneToMany != null && this.oneToMany.values().size() > 0) {
            return (List)this.oneToMany.values().iterator().next();
        }
        return null;
    }

    public void addChildrenDataRow(String tableName, DataRow dataRow) {
        ArrayList<DataRow> refDataRows;
        if (this.oneToMany == null) {
            this.oneToMany = new HashMap();
        }
        if ((refDataRows = (ArrayList<DataRow>)this.oneToMany.get(tableName)) == null) {
            refDataRows = new ArrayList<DataRow>();
            this.oneToMany.put(tableName, refDataRows);
        }
        refDataRows.add(dataRow);
    }

    public void setParentDataRow(String tableName, DataRow dataRow) {
        if (this.manyToOne == null) {
            this.manyToOne = new HashMap();
        }
        this.manyToOne.put(tableName, dataRow);
    }

    public int hashCode() {
        return this.values.get(this.pkColumn).hashCode();
    }

    public boolean equals(Object obj) {
        return ((DataRow)obj).values.get(this.pkColumn).equals(this.values.get(this.pkColumn));
    }

    public int compareTo(Object obj) {
        Comparable<String> c1 = null;
        if (obj instanceof DataRow) {
            Object value = ((DataRow)obj).values.get(this.pkColumn);
            c1 = this.getComparator(value);
        } else {
            c1 = this.getComparator(obj);
        }
        Comparable<String> c2 = this.getComparator(this.values.get(this.pkColumn));
        if (c1.getClass() != c2.getClass()) {
            logger.info((Object)("unsupported compare between '" + c1.toString() + ":" + c1.getClass().getName() + "' and '" + c2.toString() + ":" + c2.getClass().getName() + "'"));
        }
        return c2.compareTo(c1.toString());
    }

    public String getStr(Clob clob) {
        try {
            return clob.getSubString(0L, (int)clob.length());
        }
        catch (SerialException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Comparable<String> getComparator(Object obj) {
        String c = null;
        if (obj instanceof Comparable) {
            c = obj.toString();
        } else if (obj instanceof Clob) {
            c = this.getStr((Clob)obj);
        }
        return c;
    }

    public String toString() {
        return this.values.toString();
    }
}

