/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.process.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingType;
import com.kingdee.eas.csinterface.billmapping.MutiToMutiPriorityType;
import com.kingdee.eas.csinterface.billmapping.ReportFieldInfo;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.process.IBatchProcessor;
import com.kingdee.eas.csinterface.data.process.impl.BaseDataMappingHelper;
import com.kingdee.eas.csinterface.data.util.AssistAccountUtil;
import com.kingdee.eas.csinterface.monitor.app.FeedBackManager;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistTypeMultiMapEntrysCollection;
import com.kingdee.eas.csinterface.syncdatabase.AssistTypeMultiMapEntrysFactory;
import com.kingdee.eas.csinterface.syncdatabase.AssistTypeMultiMapEntrysInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapMergeEntryListFactory;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapMergeEntryListInfo;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapType;
import com.kingdee.eas.csinterface.syncdatabase.MutiToMutiBillMappingCollection;
import com.kingdee.eas.csinterface.syncdatabase.MutiToMutiBillMappingFactory;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataMultiToMultiMapHelper;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataTypeRuleFilter;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ImportUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.utils.AssistAccountMappingUtil;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.framework.AbstractObjectBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BaseDataConvertBatchProcessor
implements IBatchProcessor {
    private static final Logger logger = CoreUIObject.getLogger(BaseDataConvertBatchProcessor.class);
    static final String PREFIX_MMMM = "mmmm$";
    static final String ASSISTHG_ERROR = "assistHG_error";
    static final int MAX_ERROR_COUNT = 50;
    private static ThreadLocal<String> billmappingId = new ThreadLocal();
    private static ThreadLocal<BillMappingInfo> billMapping = new ThreadLocal();
    private static ThreadLocal<Map> accountMap = new ThreadLocal();
    private static ThreadLocal<Map> easCashFlowItemMap = new ThreadLocal();
    static final String MUTIMAP_NUll_FLAG = "mutimap_null";
    static final String ACCOUNT_NO_ASST = "account_no_asst";
    static final String REPORT_ASST = "FAsst[0-9]?_?Number";
    private static ThreadLocal<Map> accountAsstMap = new ThreadLocal();
    private static ThreadLocal<Map> asstActMap = new ThreadLocal();
    private static ThreadLocal<Map> multiMapCache = new ThreadLocal();
    private static ThreadLocal<Map> assistTypeMultiMapCache = new ThreadLocal();
    private static ThreadLocal<Map> ouCuMap = new ThreadLocal();
    private static ThreadLocal<Map> srcIDBaseDataTypeMapCache = new ThreadLocal();
    private static ThreadLocal<Map> ahFidMap = new ThreadLocal();

    @Override
    public String getProcessorID() {
        return null;
    }

    @Override
    public StructuredTableData process(Context ctx, StructuredTableData data, StructuredDataModel model) throws DIPException {
        String key;
        String colNameAlias;
        String colName;
        String billMappingInfoId = (String)model.getProperty("billMappingID");
        try {
            billMapping.set(BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo(CommonUtil.convert2PK(billMappingInfoId)));
            FeedBackManager.initFeedBackLog(ctx, data, model);
        }
        catch (EASBizException e) {
            throw new DIPException(e.getMessage());
        }
        catch (BOSException e) {
            throw new DIPException(e.getMessage());
        }
        BaseDataMappingHelper baseDataMappingUtil = new BaseDataMappingHelper(ctx);
        Map<String, Map<String, CoreBaseInfo>> headBaseDataMap = baseDataMappingUtil.initBaseDataMappingOnHead(data, model);
        Map<String, Map<String, Map<String, CoreBaseInfo>>> entryBaseDataMap = baseDataMappingUtil.initBaseDataMappingOnEntry(data, model, headBaseDataMap);
        StructuredDataModel.ColumnModel[] headBaseDataTypes = model.getPriorityTables()[0].baseDataTypes;
        StructuredDataModel.ColumnModel[] entryBaseDataTypes = model.getPriorityTables()[1].baseDataTypes;
        List headRows = data.getFirstTableRows();
        this.cacheAccountMap(model, headRows);
        this.cacheEASCashFlowItemMap(model, headRows);
        boolean foundMatch = this.processMultiToMultiMap(ctx, model, headRows);
        Map<String, Set<Object>> unknowBaseDataValues = MonitorManager.getCurrentSrcToMidBill().getUnkownBaseDataValues();
        Map<String, Set<Object>> errorBillIdsMap = MonitorManager.getCurrentSrcToMidBill().getErrorBillIdsMap();
        HashMap<String, String> assistRecordIDMap = new HashMap<String, String>();
        String selfField = null;
        try {
            selfField = this.getSelfField(model, ctx);
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2\u7ec4\u5408\u65b9\u6848\u5b57\u6bb5" + selfField + "\u5f02\u5e38"), (Throwable)e);
            throw new DIPException("\u67e5\u8be2\u7ec4\u5408\u65b9\u6848\u5b57\u6bb5" + selfField + "\u5f02\u5e38", e);
        }
        if (headBaseDataTypes != null && headBaseDataTypes.length > 0) {
            for (StructuredDataModel.ColumnModel baseDataTypeCol : headBaseDataTypes) {
                colName = baseDataTypeCol.name;
                colNameAlias = baseDataTypeCol.alias;
                key = colName + "(" + colNameAlias + ")";
                Map<String, CoreBaseInfo> map = headBaseDataMap.get(colName);
                HashSet unknowBaseDataList = new HashSet();
                BaseDataTypeInfo info = (BaseDataTypeInfo)baseDataTypeCol.baseDataType;
                boolean replaceFlag = BaseDataTypeRuleFilter.matchReplace(info.getRule());
                String[] rule = null;
                if (replaceFlag) {
                    rule = info.getRule().split("\\?");
                }
                for (DataRow headRow : headRows) {
                    Map fileds = headRow.getValues();
                    String headPk = headRow.getValues().get(headRow.pkColumn).toString();
                    Object value = fileds.get(colName);
                    if (null == value || StringUtils.isEmpty((String)value.toString())) {
                        fileds.put(colName, null);
                        continue;
                    }
                    if (replaceFlag) {
                        value = value.toString().replace(rule[1], rule[0]);
                    }
                    CoreBaseInfo newValue = map.get(value.toString());
                    if (foundMatch && fileds.get(PREFIX_MMMM + colName) == Boolean.TRUE) continue;
                    if (null == newValue) {
                        Set<Object> set;
                        if (unknowBaseDataList.size() <= 50) {
                            unknowBaseDataList.add(value);
                        }
                        if ((set = errorBillIdsMap.get(key + "[" + value + "]")) == null) {
                            set = new HashSet<Object>();
                            errorBillIdsMap.put(key + "[" + value + "]", set);
                        }
                        set.add(headPk);
                        fileds.put(colName, null);
                        if (colName.equalsIgnoreCase(selfField)) continue;
                        headRow.setIgnore(true);
                        continue;
                    }
                    fileds.put(colName, newValue);
                }
                if (unknowBaseDataList.size() <= 0) continue;
                if (null != unknowBaseDataValues.get(key)) {
                    unknowBaseDataList.addAll((Collection)unknowBaseDataValues.get(key));
                }
                unknowBaseDataValues.put(key, unknowBaseDataList);
                logger.info((Object)("\u5b57\u6bb5\u540d\uff1a" + key + ",\u672a\u5339\u914d\u6570\u91cf\uff1a" + unknowBaseDataList.size()));
            }
        }
        if (entryBaseDataTypes != null && entryBaseDataTypes.length > 0) {
            for (StructuredDataModel.ColumnModel baseDataTypeCol : entryBaseDataTypes) {
                ICoreBase instance;
                colName = baseDataTypeCol.name;
                colNameAlias = baseDataTypeCol.alias;
                key = colName + "(" + colNameAlias + ")";
                BaseDataTypeInfo baseDataType = (BaseDataTypeInfo)baseDataTypeCol.baseDataType;
                try {
                    instance = BaseDataMappingHelper.getCoreBaseInstance(ctx, baseDataType);
                }
                catch (BOSException e) {
                    logger.error((Object)"\u67e5\u8be2\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04\u5bf9\u5e94ICoreBase\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
                    throw new DIPException("\u67e5\u8be2\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04\u5bf9\u5e94ICoreBase\u5bf9\u8c61\u5f02\u5e38\uff01", e);
                }
                String bosType = instance.getType().toString();
                Map<String, Map<String, CoreBaseInfo>> map = entryBaseDataMap.get(colName);
                for (DataRow headRow : headRows) {
                    List<DataRow> entryRows = headRow.getFirstChildrenDataRows();
                    HashSet<Object> unknowBaseDataList = new HashSet<Object>();
                    BaseDataTypeInfo info = (BaseDataTypeInfo)baseDataTypeCol.baseDataType;
                    boolean replaceFlag = BaseDataTypeRuleFilter.matchReplace(info.getRule());
                    String[] rule = null;
                    if (replaceFlag) {
                        rule = info.getRule().split("\\?");
                    }
                    String headPk = headRow.getValues().get(headRow.pkColumn).toString();
                    for (DataRow entryRow : entryRows) {
                        Map fileds = entryRow.getValues();
                        Object value = fileds.get(colName);
                        if (null == value || StringUtils.isEmpty((String)value.toString())) {
                            fileds.put(colName, null);
                            continue;
                        }
                        if (replaceFlag) {
                            value = value.toString().replace(rule[1], rule[0]);
                        }
                        CoreBaseInfo newValue = null;
                        for (Map.Entry<String, Map<String, CoreBaseInfo>> temp : map.entrySet()) {
                            String tempKey = temp.getKey();
                            Map<String, CoreBaseInfo> tMap = temp.getValue();
                            if ("9DA99826".equals(bosType)) {
                                Object companyField = model.getProperty("extCompanyField");
                                Object destCompany = null;
                                if (null != companyField) {
                                    destCompany = headRow.getValues().get(companyField);
                                }
                                if (!StringUtils.isEmpty((String)tempKey) && null != destCompany && tempKey.equals(destCompany.toString())) {
                                    newValue = tMap.get(value.toString());
                                    continue;
                                }
                                newValue = tMap.get(value.toString());
                                continue;
                            }
                            newValue = tMap.get(value.toString());
                        }
                        if (foundMatch && fileds.get(PREFIX_MMMM + colName) == Boolean.TRUE) continue;
                        if (null == newValue) {
                            Set<Object> set;
                            if (unknowBaseDataList.size() <= 50) {
                                unknowBaseDataList.add(value);
                            }
                            if ((set = errorBillIdsMap.get(key + "[" + value + "]")) == null) {
                                set = new HashSet<Object>();
                                errorBillIdsMap.put(key + "[" + value + "]", set);
                            }
                            set.add(headPk);
                            fileds.put(colName, null);
                            if (colName.equalsIgnoreCase(selfField)) continue;
                            entryRow.setIgnore(true);
                            continue;
                        }
                        fileds.put(colName, newValue);
                    }
                    if (unknowBaseDataList.size() <= 0) continue;
                    if (null != unknowBaseDataValues.get(key)) {
                        unknowBaseDataList.addAll((Collection)unknowBaseDataValues.get(key));
                    }
                    unknowBaseDataValues.put(key, unknowBaseDataList);
                    logger.info((Object)("\u5b57\u6bb5\u540d\uff1a" + key + ",\u672a\u5339\u914d\u6570\u91cf\uff1a" + unknowBaseDataList.size()));
                }
            }
        }
        if (BillMappingType.billMapping.equals((Object)billMapping.get().getMappingType()) || BillMappingType.easBillMapping.equals((Object)billMapping.get().getMappingType()) || BillMappingType.k3wiseBillMapping.equals((Object)billMapping.get().getMappingType()) || BillMappingType.K3WISE_V121PZ_PZTOPZ.equals((Object)billMapping.get().getMappingType()) || BillMappingType.voucher.equals((Object)billMapping.get().getMappingType()) || BillMappingType.easVoucher.equals((Object)billMapping.get().getMappingType())) {
            this.dealAssistAccount(ctx, data, model, assistRecordIDMap);
            this.dealEASCashFlowAssistAccount(ctx, data, model, assistRecordIDMap);
        } else if (BillMappingType.reportMapping.equals((Object)billMapping.get().getMappingType()) || BillMappingType.easReport.equals((Object)billMapping.get().getMappingType()) || BillMappingType.k3WiseReport.equals((Object)billMapping.get().getMappingType())) {
            this.dealReportAssistAccount(ctx, data, model);
        }
        BaseDataConvertBatchProcessor.clear(multiMapCache);
        BaseDataConvertBatchProcessor.clear(accountAsstMap);
        BaseDataConvertBatchProcessor.clear(asstActMap);
        BaseDataConvertBatchProcessor.clear(accountMap);
        BaseDataConvertBatchProcessor.clear(easCashFlowItemMap);
        BaseDataConvertBatchProcessor.clear(srcIDBaseDataTypeMapCache);
        BaseDataConvertBatchProcessor.clear(assistTypeMultiMapCache);
        Object dataProcessType = model.getProperty("dataProcessType");
        if (null == dataProcessType || "allNotProcess".equalsIgnoreCase(dataProcessType.toString())) {
            if (unknowBaseDataValues != null && unknowBaseDataValues.size() > 0) {
                int valueCount = 0;
                valueCount = unknowBaseDataValues.values().size();
                StringBuilder bdInfoBuf = new StringBuilder();
                bdInfoBuf.append("\u57fa\u7840\u8d44\u6599\u8f6c\u6362\u51fa\u9519\uff1a\u6709 ").append(unknowBaseDataValues.size()).append(" \u4e2a\u5b57\u6bb5").append("\uff0c\u4e00\u5171 ").append(valueCount).append(" \u4e2a\u6e90\u7cfb\u7edf\u8d44\u6599\u503c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u76ee\u6807\u7cfb\u7edf\u503c\u3002");
                throw new DIPException(bdInfoBuf.toString());
            }
            return data;
        }
        if ("allProcess".equalsIgnoreCase(dataProcessType.toString())) {
            return data;
        }
        if ("partProcess".equalsIgnoreCase(dataProcessType.toString())) {
            this.filterData(data);
        }
        return data;
    }

    public String getSelfField(StructuredDataModel model, Context ctx) throws Exception {
        BillMappingInfo billMappingInfo = (BillMappingInfo)model.getProperty("mapping");
        BillMappingEntryCollection entryColl = billMappingInfo.getEntrys();
        String selfField = null;
        boolean flag = false;
        for (int j = 0; j < entryColl.size(); ++j) {
            String temp = entryColl.get(j).getMidFieldName();
            if (temp.length() > 3) {
                flag = temp.substring(temp.length() - 4).equalsIgnoreCase("_SRC");
            }
            if (!flag) continue;
            selfField = temp.substring(0, temp.length() - 4);
            break;
        }
        return selfField;
    }

    private void dealReportAssistAccount(Context ctx, StructuredTableData data, StructuredDataModel model) throws DIPException {
        String asstNumber = billMapping.get().getAsstNumber();
        if (StringUtils.isEmpty((String)asstNumber)) {
            return;
        }
        AssistAccountTypeInfo assistAccountType = (AssistAccountTypeInfo)model.getProperty("assistAccountType");
        AssistAccountTypeEntryCollection entrys = assistAccountType.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            AssistAccountTypeEntryInfo info = entrys.get(i);
            BaseDataTypeInfo baseDataType = info.getBaseDataType();
            this.threadLocalMapPut(srcIDBaseDataTypeMapCache, info.getSrcID(), baseDataType);
        }
        BaseDataMappingHelper baseDataMappingUtil = new BaseDataMappingHelper(ctx);
        String reportGroup = (String)model.getProperty("reportGroup");
        Map<String, Map<String, CoreBaseInfo>> assistAccountDataMap = baseDataMappingUtil.initBaseDataMappingOnAssAcc(reportGroup, data, model);
        Map<String, Map<String, CoreBaseInfo>> assistAccountBaseDataMap = baseDataMappingUtil.initBaseDataTypeMappingOnReport(reportGroup, data, model);
        String reportSupportclass = (String)model.getProperty("reportSupportClass");
        ArrayList<String> reaportSrcFiledSort = new ArrayList<String>();
        String id = billMapping.get().getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("Entrys.*"));
        sic.add(new SelectorItemInfo("Entrys.reportField.*"));
        BillMappingInfo info = null;
        try {
            info = BillMappingFactory.getLocalInstance(ctx).getBillMappingInfo(CommonUtil.convert2PK(id), sic);
        }
        catch (Exception e) {
            throw new DIPException("\u67e5\u8be2\u5355\u636e\u4fe1\u606f\u51fa\u9519", e);
        }
        Pattern patten = Pattern.compile(REPORT_ASST, 2);
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            String fieldName;
            BillMappingEntryInfo entryInfo = info.getEntrys().get(i);
            ReportFieldInfo reportFiled = entryInfo.getReportField();
            if (reportFiled == null || entryInfo.isDropped() || !patten.matcher(fieldName = reportFiled.getName()).matches()) continue;
            reaportSrcFiledSort.add(entryInfo.getSrcFieldName());
        }
        Collections.sort(reaportSrcFiledSort, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() < o2.length()) {
                    return -1;
                }
                if (o1.length() > o2.length()) {
                    return 1;
                }
                return o1.compareToIgnoreCase(o2);
            }
        });
        Map<String, CoreBaseInfo> asstActTypeMap = assistAccountDataMap.get(reportGroup);
        List headRows = data.getFirstTableRows();
        Map<String, Set<Object>> unknowBaseDataValues = MonitorManager.getCurrentSrcToMidBill().getUnkownBaseDataValues();
        for (DataRow headRow : headRows) {
            Map fileds = headRow.getValues();
            String value = (String)fileds.get(reportGroup);
            if (StringUtil.isEmpty((String)value)) continue;
            Map<String, String> numberMap = AssistAccountMappingUtil.getNumberMapForReport(value, ctx, reportSupportclass);
            if (reaportSrcFiledSort.size() < numberMap.keySet().size()) {
                throw new DIPException("\u62a5\u8868\u89e3\u6790\u51fa\u7684\u8f85\u52a9\u8d26\u5b57\u6bb5\u591a\u4e8e\u4e2d\u95f4\u8868\u5bf9\u5e94\u7684\u5b57\u6bb5.(" + numberMap.keySet().size() + ">" + reaportSrcFiledSort.size());
            }
            boolean isSuccess = true;
            int i = 0;
            StringBuilder newAstActNumber = new StringBuilder();
            Iterator<String> ite = numberMap.keySet().iterator();
            while (ite.hasNext()) {
                CoreBaseInfo newBaseData;
                ++i;
                String asstActTypeNumber = ite.next();
                CoreBaseInfo destID = asstActTypeMap.get(asstActTypeNumber);
                if (destID == null) {
                    this.generateLog("\u6838\u7b97\u9879", asstActTypeNumber, unknowBaseDataValues);
                    isSuccess = false;
                    continue;
                }
                if (i > 1) {
                    newAstActNumber.append("|");
                }
                newAstActNumber.append(destID.get("number"));
                Map<String, CoreBaseInfo> baseDataMapping = assistAccountBaseDataMap.get(asstActTypeNumber);
                String oldBaseData = numberMap.get(asstActTypeNumber);
                BaseDataTypeInfo baseDataTypeInfo = (BaseDataTypeInfo)this.threadLocalMapGet(srcIDBaseDataTypeMapCache, asstActTypeNumber);
                if (BaseDataTypeRuleFilter.matchReplace(baseDataTypeInfo.getRule())) {
                    String[] rule = baseDataTypeInfo.getRule().split("\\?");
                    oldBaseData = oldBaseData.replace(rule[1], rule[0]);
                }
                if ((newBaseData = baseDataMapping.get(oldBaseData)) == null) {
                    this.generateLog(asstActTypeNumber, oldBaseData, unknowBaseDataValues);
                    isSuccess = false;
                    continue;
                }
                fileds.put(reaportSrcFiledSort.get(i), String.valueOf(newBaseData.get(baseDataTypeInfo.getDestID())));
            }
            if (!isSuccess) continue;
            fileds.put(reaportSrcFiledSort.get(0), newAstActNumber.toString());
        }
    }

    private void cacheAccountMap(StructuredDataModel model, List<DataRow> headRows) {
        Boolean isIntegrateEasAssAcc = (Boolean)model.getProperty("isIntegrateEasAssAcc");
        if (!isIntegrateEasAssAcc.booleanValue()) {
            return;
        }
        Map<String, String> relationMap = AssistAccountMappingUtil.findRelationMap((String)model.getProperty("assistAccountRelation"));
        String account = relationMap.get("FAccount");
        for (DataRow headRow : headRows) {
            List<DataRow> entryRows = headRow.getFirstChildrenDataRows();
            String headPk = headRow.getValues().get(headRow.pkColumn).toString();
            for (DataRow entryRow : entryRows) {
                Map fileds = entryRow.getValues();
                String srcAccount = (String)fileds.get(account);
                String entryPk = (String)fileds.get(entryRow.pkColumn);
                this.threadLocalMapPut(accountMap, headPk + entryPk, srcAccount);
            }
        }
    }

    private void cacheEASCashFlowItemMap(StructuredDataModel model, List<DataRow> headRows) {
        Boolean isIntegrateEasCashFlow = (Boolean)model.getProperty("isIntegrateEasCashFlow");
        if (!isIntegrateEasCashFlow.booleanValue()) {
            return;
        }
        Map<String, String> assistRelationMap = AssistAccountMappingUtil.findRelationMap((String)model.getProperty("assistAccountRelation"));
        Map<String, String> easCashFlowRelationMap = AssistAccountMappingUtil.findRelationMap(String.valueOf(model.getProperty("easCashFlowRelation")));
        String priItem = easCashFlowRelationMap.get("CFPrimaryNumber");
        String cfFid = easCashFlowRelationMap.get("CFFid");
        for (DataRow headRow : headRows) {
            List<DataRow> entryRows = headRow.getFirstChildrenDataRows();
            String headPk = headRow.getValues().get(headRow.pkColumn).toString();
            for (DataRow entryRow : entryRows) {
                Map fileds = entryRow.getValues();
                String cfFidFlag = (String)fileds.get(cfFid);
                if (StringUtils.isEmpty((String)cfFidFlag)) continue;
                String srcPriItem = (String)fileds.get(priItem);
                String entryPk = (String)fileds.get(entryRow.pkColumn);
                this.threadLocalMapPut(easCashFlowItemMap, headPk + entryPk + cfFidFlag, srcPriItem);
            }
        }
    }

    private void dealAssistAccount(Context ctx, StructuredTableData data, StructuredDataModel model, Map<String, String> assistRecordIDMap) throws DIPException {
        Boolean isIntegrateEasAssAcc = (Boolean)model.getProperty("isIntegrateEasAssAcc");
        if (!isIntegrateEasAssAcc.booleanValue()) {
            return;
        }
        AssistAccountTypeInfo assistAccountType = (AssistAccountTypeInfo)model.getProperty("assistAccountType");
        if (assistAccountType == null) {
            return;
        }
        AssistAccountTypeEntryCollection entrys = assistAccountType.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            AssistAccountTypeEntryInfo info = entrys.get(i);
            BaseDataTypeInfo baseDataType = info.getBaseDataType();
            this.threadLocalMapPut(srcIDBaseDataTypeMapCache, info.getSrcID(), baseDataType);
        }
        billmappingId.set((String)model.getProperty("billMappingID"));
        BaseDataMappingHelper baseDataMappingUtil = new BaseDataMappingHelper(ctx);
        Map<String, String> relationMap = AssistAccountMappingUtil.findRelationMap((String)model.getProperty("assistAccountRelation"));
        String assistAccount = relationMap.get("FNumberGroup");
        Map<String, Map<String, CoreBaseInfo>> assistAccountDataMap = baseDataMappingUtil.initBaseDataMappingOnAssAcc(assistAccount, data, model);
        Map<String, Map<String, CoreBaseInfo>> assistAccountBaseDataMap = baseDataMappingUtil.initBaseDataTypeMappingOnAssAcc(assistAccount, data, model);
        List headRows = data.getFirstTableRows();
        String account = relationMap.get("FAccount");
        String assistId = relationMap.get("FAssigID");
        String cu = relationMap.get("FOuID");
        String assistRecordID = relationMap.get("AFid");
        String assistRecordDes = relationMap.get("AFDescription");
        String assistOriAmount = relationMap.get("AFOriAmount");
        String entryOriCurrency = relationMap.get("FEntryORICurrency");
        Map<String, CoreBaseInfo> dataMap = assistAccountDataMap.get(assistAccount);
        Map<String, Set<Object>> unknowBaseDataValues = MonitorManager.getCurrentSrcToMidBill().getUnkownBaseDataValues();
        for (DataRow headRow : headRows) {
            List<DataRow> entryRows = headRow.getFirstChildrenDataRows();
            String headPk = (String)headRow.getValues().get(headRow.pkColumn);
            for (DataRow entryRow : entryRows) {
                Object controlUnit = entryRow.getValues().get(cu);
                Map fileds = entryRow.getValues();
                Object value = fileds.get(assistAccount);
                Object ahFid = fileds.get(assistId);
                Object destAccount = fileds.get(account);
                String destAccountId = null;
                destAccountId = destAccount instanceof AbstractCoreBaseInfo ? ((AbstractCoreBaseInfo)destAccount).getId().toString() : (String)destAccount;
                String astecordID = (String)fileds.get(assistRecordID);
                if (null != astecordID) {
                    String astDesc = (String)fileds.get(assistRecordDes);
                    String astGID = (String)fileds.get(assistId);
                    String astOriAmount = fileds.get(assistOriAmount).toString();
                    assistRecordIDMap.put(astecordID, astGID + "_" + (astDesc == null ? "" : astDesc) + "_" + astOriAmount);
                }
                String entryPk = (String)fileds.get(entryRow.pkColumn);
                String srcAccount = (String)this.threadLocalMapGet(accountMap, headPk + entryPk);
                DataRow result = (DataRow)this.threadLocalMapGet(ahFidMap, srcAccount + ahFid + destAccountId);
                if (result != null && ahFid != null) {
                    fileds.put(assistId, result.getValues().get(assistId));
                    fileds.put(assistAccount, result.getValues().get(assistAccount));
                    entryRow.setIgnore(result.isIgnore());
                    continue;
                }
                Object acc = fileds.get(account);
                Object newValue = this.transfer(ctx, headPk, headPk + entryPk, value, dataMap, assistAccountBaseDataMap, acc, assistId, fileds, unknowBaseDataValues, controlUnit);
                if (null == newValue) {
                    fileds.put(assistAccount, null);
                    fileds.put(assistId, null);
                } else if (ASSISTHG_ERROR.equals(newValue)) {
                    fileds.put(assistAccount, newValue + ":" + value);
                    fileds.put(assistId, null);
                    entryRow.setIgnore(true);
                } else {
                    fileds.put(assistAccount, newValue);
                }
                if (ahFid != null) {
                    this.threadLocalMapPut(ahFidMap, srcAccount + ahFid + destAccountId, entryRow);
                }
                String tempAHFID = "";
                if (null != ahFid) {
                    tempAHFID = ahFid.toString();
                }
                this.setAsstAccountOriginalAmount(ctx, acc, assistOriAmount, tempAHFID, fileds, entryOriCurrency);
            }
        }
        AssistAccountMappingUtil.clear();
    }

    private void setAsstAccountOriginalAmount(Context ctx, Object acc, String originalAmount, String aHfid, Map fileds, String entryOriCurrency) throws DIPException {
        String[] accountAndAcc = null;
        if (null == acc) {
            return;
        }
        try {
            accountAndAcc = this.getMidAccountAcc(ctx, acc);
            if (StringUtils.isEmpty((String)aHfid) && !StringUtils.isEmpty((String)accountAndAcc[0])) {
                String tempCurrency = "";
                String oriCurrency = (String)fileds.get(entryOriCurrency);
                if (!StringUtils.isEmpty((String)oriCurrency)) {
                    tempCurrency = oriCurrency;
                }
                fileds.put(originalAmount, tempCurrency);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u6e90\u7cfb\u7edf\u79d1\u76ee\u6ca1\u6709\u8f85\u52a9\u8d26\uff0c\u4e2d\u95f4\u5355\u79d1\u76ee\uff1a[" + accountAndAcc[1] + "]\u6709\u8f85\u52a9\u8d26\u7684\u573a\u666f\u4e0b\u8bbe\u7f6e\u8f85\u52a9\u8d26\u672c\u4f4d\u5e01\u91d1\u989d\u5f02\u5e38\uff01"), (Throwable)e);
            throw new DIPException("\u6e90\u7cfb\u7edf\u79d1\u76ee\u6ca1\u6709\u8f85\u52a9\u8d26\uff0c\u4e2d\u95f4\u5355\u79d1\u76ee\uff1a[" + accountAndAcc[1] + "]\uff0c\u6709\u8f85\u52a9\u8d26\u7684\u573a\u666f\u4e0b\u8bbe\u7f6e\u8f85\u52a9\u8d26\u539f\u5e01\u91d1\u989d\u5f02\u5e38\uff01", e);
        }
    }

    private String[] getMidAccountAcc(Context ctx, Object acc) {
        String groupId = "";
        String account = "";
        String[] arry = new String[2];
        if (acc instanceof CoreBaseInfo) {
            Object caa = ((CoreBaseInfo)acc).get("CAA");
            if (caa != null) {
                groupId = ((CoreBaseInfo)caa).getId().toString();
            }
            account = ((CoreBaseInfo)acc).get("number").toString();
        } else {
            String key = null;
            key = acc instanceof EiPArtificialCoreBaseInfo ? ((EiPArtificialCoreBaseInfo)((Object)acc)).getId().toString() : (String)acc;
            groupId = (String)this.threadLocalMapGet(accountAsstMap, key);
            if (groupId == null) {
                try {
                    groupId = this.getCAAByAccounID(ctx, acc);
                }
                catch (BOSException e) {
                    logger.error((Object)("\u83b7\u53d6\u4e2d\u95f4\u5355\u79d1\u76ee\uff1a[" + account + "]\u672c\u7ea7\u8f85\u52a9\u8d26\u5f02\u5e38\u3002"), (Throwable)e);
                }
            }
            account = String.valueOf(acc);
        }
        if (ACCOUNT_NO_ASST.equals(groupId)) {
            groupId = null;
        }
        arry[0] = groupId;
        arry[1] = account;
        return arry;
    }

    private void dealEASCashFlowAssistAccount(Context ctx, StructuredTableData data, StructuredDataModel model, Map<String, String> assistRecordIDMap) throws DIPException {
        Boolean isIntegrateEasCashFlow = (Boolean)model.getProperty("isIntegrateEasCashFlow");
        if (!isIntegrateEasCashFlow.booleanValue()) {
            return;
        }
        AssistAccountTypeInfo assistAccountType = (AssistAccountTypeInfo)model.getProperty("assistAccountType");
        if (assistAccountType == null) {
            return;
        }
        billmappingId.set((String)model.getProperty("billMappingID"));
        BaseDataMappingHelper baseDataMappingUtil = new BaseDataMappingHelper(ctx);
        Map<String, String> relationMap = AssistAccountMappingUtil.findRelationMap(String.valueOf(model.getProperty("easCashFlowRelation")));
        Map<String, String> asstRelationMap = AssistAccountMappingUtil.findRelationMap((String)model.getProperty("assistAccountRelation"));
        Map<String, String> assistRelationMap = AssistAccountMappingUtil.findRelationMap((String)model.getProperty("assistAccountRelation"));
        String assistFID = assistRelationMap.get("AFid");
        String cashflowGrp = relationMap.get("CFAssGrp");
        Map<String, Map<String, CoreBaseInfo>> cashFlowGrpDataMap = baseDataMappingUtil.initBaseDataMappingOnAssAcc(cashflowGrp, data, model);
        Map<String, Map<String, CoreBaseInfo>> cashFlowGrpBaseDataMap = baseDataMappingUtil.initBaseDataTypeMappingOnAssAcc(cashflowGrp, data, model);
        List headRows = data.getFirstTableRows();
        String cashflowPrimaryItem = relationMap.get("CFPrimaryNumber");
        String cashflowGrpID = relationMap.get("CFAssGrpId");
        String cashflowAsstRecordID = relationMap.get("CFOppVoucherAssistRecordId");
        String cashflowFID = relationMap.get("CFFid");
        String cu = asstRelationMap.get("FOuID");
        Map<String, CoreBaseInfo> grpDataMap = cashFlowGrpDataMap.get(cashflowGrp);
        Map<String, Set<Object>> unknowBaseDataValues = MonitorManager.getCurrentSrcToMidBill().getUnkownBaseDataValues();
        for (DataRow headRow : headRows) {
            List<DataRow> entryRows = headRow.getFirstChildrenDataRows();
            String headPk = headRow.getValues().get(headRow.pkColumn).toString();
            for (DataRow entryRow : entryRows) {
                Object controlUnit = entryRow.getValues().get(cu);
                Map fields = entryRow.getValues();
                Object value = fields.get(cashflowGrp);
                Object ahFid = fields.get(cashflowGrpID);
                Object destPrimaryItem = fields.get(cashflowPrimaryItem);
                String destPrimaryItemId = null;
                destPrimaryItemId = destPrimaryItem instanceof AbstractCoreBaseInfo ? ((AbstractCoreBaseInfo)destPrimaryItem).getId().toString() : (String)destPrimaryItem;
                String recordID = (String)fields.get(cashflowAsstRecordID);
                if (!StringUtils.isEmpty((String)recordID)) {
                    String asstSeq = assistRecordIDMap.get(recordID);
                    fields.put(cashflowAsstRecordID, asstSeq);
                }
                Object primaryItem = fields.get(cashflowPrimaryItem);
                String entryPk = fields.get(entryRow.pkColumn).toString();
                String cfFidFlag = (String)fields.get(cashflowFID);
                String srcPriItem = (String)this.threadLocalMapGet(easCashFlowItemMap, headPk + entryPk + cfFidFlag);
                DataRow result = (DataRow)this.threadLocalMapGet(ahFidMap, srcPriItem + ahFid + destPrimaryItemId);
                if (result != null && ahFid != null) {
                    fields.put(cashflowGrpID, result.getValues().get(cashflowGrpID));
                    continue;
                }
                Object newValue = this.transferGrp(ctx, headPk, headPk + entryPk + cfFidFlag, value, grpDataMap, cashFlowGrpBaseDataMap, primaryItem, cashflowGrpID, fields, unknowBaseDataValues, controlUnit);
                if (null == newValue) {
                    fields.put(cashflowGrp, newValue);
                    fields.put(cashflowGrpID, null);
                } else if (ASSISTHG_ERROR.equals(newValue)) {
                    fields.put(cashflowGrp, newValue + ":" + value);
                    fields.put(cashflowGrpID, null);
                    entryRow.setIgnore(true);
                } else {
                    fields.put(cashflowGrp, newValue);
                }
                if (ahFid == null) continue;
                this.threadLocalMapPut(ahFidMap, srcPriItem + ahFid + destPrimaryItemId, entryRow);
            }
        }
        AssistAccountMappingUtil.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object transfer(Context ctx, String headpk, String entryKey, Object value, Map<String, CoreBaseInfo> dataMap, Map<String, Map<String, CoreBaseInfo>> assistAccountBaseDataMap, Object acc, String assistId, Map fileds, Map<String, Set<Object>> unknowBaseDataValues, Object controlUnit) throws DIPException {
        String groupId;
        String srcAccount;
        HashMap<String, String> datas;
        Map<String, Set<Object>> errorBillIdsMap;
        StringBuilder result;
        String account;
        block24: {
            String key;
            block23: {
                Map<String, String> assActNumberNameMap;
                Map<String, String> numberMap;
                block22: {
                    fileds.put(assistId, null);
                    if (acc == null) {
                        return null;
                    }
                    account = "";
                    result = new StringBuilder();
                    errorBillIdsMap = MonitorManager.getCurrentSrcToMidBill().getErrorBillIdsMap();
                    datas = new HashMap<String, String>();
                    numberMap = AssistAccountMappingUtil.getNumberMap((String)value);
                    assActNumberNameMap = AssistAccountMappingUtil.getAssActNumberNameMap((String)value);
                    if (numberMap != null) break block22;
                    Object var18_19 = null;
                    return var18_19;
                }
                srcAccount = (String)this.threadLocalMapGet(accountMap, entryKey);
                String resultByMuti = this.transferByMutiToMutiMap(ctx, srcAccount, datas, numberMap, assActNumberNameMap);
                if (!StringUtils.isEmpty((String)resultByMuti) && !MUTIMAP_NUll_FLAG.equals(resultByMuti)) {
                    result.append(resultByMuti);
                }
                if (datas.isEmpty() && StringUtils.isEmpty((String)result.toString())) {
                    String resultByNormal = this.transferByNormal(ctx, headpk, srcAccount, MultiToMultiMapType.easAssistAccount, datas, numberMap, dataMap, assistAccountBaseDataMap, assActNumberNameMap, unknowBaseDataValues);
                    result.append(resultByNormal);
                }
                groupId = null;
                if (acc instanceof CoreBaseInfo) {
                    Object caa = ((CoreBaseInfo)acc).get("CAA");
                    if (caa != null) {
                        groupId = ((CoreBaseInfo)caa).getId().toString();
                    }
                    account = ((CoreBaseInfo)acc).get("number").toString();
                } else {
                    key = null;
                    key = acc instanceof EiPArtificialCoreBaseInfo ? ((EiPArtificialCoreBaseInfo)((Object)acc)).getId().toString() : (String)acc;
                    groupId = (String)this.threadLocalMapGet(accountAsstMap, key);
                    if (groupId == null) {
                        groupId = this.getCAAByAccounID(ctx, acc);
                        this.threadLocalMapPut(accountAsstMap, key, groupId == null ? ACCOUNT_NO_ASST : groupId);
                    }
                    account = String.valueOf(acc);
                }
                if (ACCOUNT_NO_ASST.equals(groupId)) {
                    groupId = null;
                }
                if (!StringUtils.isEmpty((String)result.toString())) break block23;
                key = null;
                return key;
            }
            if (StringUtil.isEmpty((String)result.toString()) || !StringUtils.isEmpty((String)groupId)) break block24;
            logger.error((Object)("\u751f\u6210\u4e2d\u95f4\u5355\u8fc7\u7a0b\u4e2d\uff0c\u4e2d\u95f4\u5355headpk\uff1a[" + headpk + "]\uff0c\u4e2d\u95f4\u5355\u5206\u5f55entrypk:[" + entryKey + "]\uff0c\u4e2d\u95f4\u5355\u7684\u79d1\u76ee:[" + account + "]\uff0c\u6ca1\u6709\u672c\u7ea7\u8f85\u52a9\u8d26\u3002"));
            key = null;
            return key;
        }
        try {
            CtrlUnitInfo cu = null;
            if (controlUnit != null && controlUnit instanceof AbstractObjectBaseInfo) {
                cu = ((AbstractObjectBaseInfo)controlUnit).getCU();
            } else if (controlUnit != null) {
                String key = null;
                key = controlUnit instanceof EiPArtificialCoreBaseInfo ? ((EiPArtificialCoreBaseInfo)((Object)controlUnit)).getId().toString() : (String)controlUnit;
                cu = (CtrlUnitInfo)this.threadLocalMapGet(ouCuMap, key);
                if (cu == null) {
                    cu = this.getCUByOuId(ctx, controlUnit);
                    this.threadLocalMapPut(ouCuMap, key, cu);
                }
            }
            try {
                String assistantHGInfoId = this.tryAgain(ctx, datas, groupId, cu, srcAccount, account, value);
                fileds.put(assistId, assistantHGInfoId);
            }
            catch (Exception e) {
                this.generateLog("\u8f85\u52a9\u8d26\u6a2a\u8868", e.getMessage(), unknowBaseDataValues);
                Set<Object> set = errorBillIdsMap.get("\u8f85\u52a9\u8d26\u6a2a\u8868:" + e.getMessage());
                if (set == null) {
                    set = new HashSet<Object>();
                    errorBillIdsMap.put("\u8f85\u52a9\u8d26\u6a2a\u8868:" + e.getMessage(), set);
                }
                set.add(headpk);
                String string = ASSISTHG_ERROR;
                return string;
            }
        }
        catch (Exception e) {
            logger.error((Object)("EIP:transfer object AssistantHGInfo error![" + headpk + "][" + entryKey + "]"));
            logger.error((Object)e);
            String string = ASSISTHG_ERROR;
            return string;
        }
        return result;
    }

    private CtrlUnitInfo getCUByOuId(Context ctx, Object ou) throws EASBizException, BOSException {
        if (ou == null) {
            return null;
        }
        String id = null;
        id = ou instanceof EiPArtificialCoreBaseInfo ? ((EiPArtificialCoreBaseInfo)((Object)ou)).getId().toString() : (String)ou;
        IObjectPK pk = CommonUtil.convert2PK(id);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("CU.name"));
        selector.add(new SelectorItemInfo("CU.number"));
        FullOrgUnitInfo ouInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(pk, selector);
        if (ouInfo != null) {
            return ouInfo.getCU();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object transferGrp(Context ctx, String headpk, String entryKey, Object value, Map<String, CoreBaseInfo> dataMap, Map<String, Map<String, CoreBaseInfo>> assistAccountBaseDataMap, Object primaryItem, String assistId, Map fileds, Map<String, Set<Object>> unknowBaseDataValues, Object controlUnit) throws DIPException {
        String groupId;
        String srcPriItem;
        HashMap<String, String> datas;
        Map<String, Set<Object>> errorBillIdsMap;
        StringBuilder result;
        String pItem;
        block21: {
            Object caa;
            block20: {
                Map<String, String> assActNumberNameMap;
                Map<String, String> numberMap;
                block19: {
                    if (primaryItem == null) {
                        fileds.put(assistId, null);
                        return null;
                    }
                    pItem = "";
                    result = new StringBuilder();
                    errorBillIdsMap = MonitorManager.getCurrentSrcToMidBill().getErrorBillIdsMap();
                    datas = new HashMap<String, String>();
                    numberMap = AssistAccountMappingUtil.getNumberMap((String)value);
                    assActNumberNameMap = AssistAccountMappingUtil.getAssActNumberNameMap((String)value);
                    if (numberMap != null) break block19;
                    Object var18_19 = null;
                    return var18_19;
                }
                srcPriItem = (String)this.threadLocalMapGet(easCashFlowItemMap, entryKey);
                String resultByMuti = this.transferEASCashFlowMutiToMutiMap(ctx, srcPriItem, datas, numberMap, assActNumberNameMap);
                if (!StringUtils.isEmpty((String)resultByMuti) && !MUTIMAP_NUll_FLAG.equals(resultByMuti)) {
                    result.append(resultByMuti);
                }
                if (datas.isEmpty() && StringUtils.isEmpty((String)result.toString())) {
                    String resultByNormal = this.transferByNormal(ctx, headpk, srcPriItem, MultiToMultiMapType.easCashFlower, datas, numberMap, dataMap, assistAccountBaseDataMap, assActNumberNameMap, unknowBaseDataValues);
                    result.append(resultByNormal);
                }
                groupId = null;
                if (primaryItem instanceof CoreBaseInfo) {
                    caa = ((CoreBaseInfo)primaryItem).get("asstAccount");
                    if (caa != null) {
                        groupId = ((CoreBaseInfo)caa).getId().toString();
                    }
                    pItem = ((CoreBaseInfo)primaryItem).get("number").toString();
                }
                if (!StringUtils.isEmpty(groupId)) break block20;
                caa = null;
                return caa;
            }
            if (!StringUtils.isEmpty((String)result.toString())) break block21;
            caa = null;
            return caa;
        }
        try {
            CtrlUnitInfo cu = null;
            if (controlUnit != null && controlUnit instanceof AbstractObjectBaseInfo) {
                cu = ((AbstractObjectBaseInfo)controlUnit).getCU();
            } else if (controlUnit != null) {
                String key = null;
                key = controlUnit instanceof EiPArtificialCoreBaseInfo ? ((EiPArtificialCoreBaseInfo)((Object)controlUnit)).getId().toString() : (String)controlUnit;
                cu = (CtrlUnitInfo)this.threadLocalMapGet(ouCuMap, key);
                if (cu == null) {
                    cu = this.getCUByOuId(ctx, controlUnit);
                    this.threadLocalMapPut(ouCuMap, key, cu);
                }
            }
            try {
                String assistantHGInfoId = this.tryAgain(ctx, datas, groupId, cu, srcPriItem, pItem, value);
                fileds.put(assistId, assistantHGInfoId);
            }
            catch (Exception e) {
                this.generateLog("\u8f85\u52a9\u8d26\u6a2a\u8868", e.getMessage(), unknowBaseDataValues);
                Set<Object> set = errorBillIdsMap.get("\u8f85\u52a9\u8d26\u6a2a\u8868:" + e.getMessage());
                if (set == null) {
                    set = new HashSet<Object>();
                    errorBillIdsMap.put("\u8f85\u52a9\u8d26\u6a2a\u8868:" + e.getMessage(), set);
                }
                set.add(headpk);
                String string = ASSISTHG_ERROR;
                return string;
            }
        }
        catch (Exception e) {
            logger.error((Object)("EIP:transfer assistHG fail![headpk:" + headpk + "][entryKey" + entryKey + "]"));
            logger.error((Object)e);
            String string = ASSISTHG_ERROR;
            return string;
        }
        return result;
    }

    private String tryAgain(Context ctx, Map<String, String> datas, String groupId, CtrlUnitInfo cu, String srcAccount, String account, Object value) throws BOSException, EASBizException {
        HashMap<String, String> datas1 = new HashMap<String, String>();
        IObjectCollection coll = (IObjectCollection)this.threadLocalMapGet(asstActMap, groupId);
        if (coll == null) {
            EntityViewInfo aview = new EntityViewInfo();
            SelectorItemCollection aselectors = aview.getSelector();
            aselectors.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
            aselectors.add(new SelectorItemInfo("asstActType.name"));
            FilterInfo afi = new FilterInfo();
            aview.setFilter(afi);
            FilterItemCollection afilters = afi.getFilterItems();
            afilters.add(new FilterItemInfo("asstAccount.id", (Object)groupId));
            Object resultv = null;
            try {
                Class<?> asstAccFactory = Class.forName("com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory");
                Method method = asstAccFactory.getMethod("getLocalInstance", Context.class);
                Object accountViewFacadeObj = method.invoke(asstAccFactory, ctx);
                Class<?> facade = accountViewFacadeObj.getClass();
                Method method2 = facade.getMethod("getAsstActGroupDetailCollection", EntityViewInfo.class);
                resultv = method2.invoke(accountViewFacadeObj, aview);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (resultv != null) {
                coll = (IObjectCollection)resultv;
            }
            this.threadLocalMapPut(asstActMap, groupId, coll);
        }
        for (int i = 0; i < coll.size(); ++i) {
            AsstActGroupDetailInfo info = (AsstActGroupDetailInfo)coll.getObject(i);
            String name = info.getAsstActType().getName();
            datas1.put(name, datas.get(name));
        }
        AssistantHGInfo assistantHGInfo = AssistAccountUtil.getAssistantHGInfo(ctx, datas1, groupId, cu, srcAccount, account, value);
        if (assistantHGInfo != null) {
            return assistantHGInfo.getId().toString();
        }
        return null;
    }

    private String transferByMutiToMutiMap(Context ctx, String srcAccount, Map<String, String> datas, Map<String, String> numberMap, Map<String, String> assActNumberNameMap) throws BOSException {
        String result = "";
        Map<String, Set<Object>> unknowBaseDataValues = MonitorManager.getCurrentSrcToMidBill().getUnkownBaseDataValues();
        try {
            Iterator<String> itr = numberMap.keySet().iterator();
            String billMappingId = billmappingId.get();
            CoreBaseCollection coll = this.getMutiToMutiCollection(ctx, billMappingId, MultiToMultiMapType.easAssistAccount);
            HashMap<String, String> srcMap = new HashMap<String, String>();
            while (itr.hasNext()) {
                String srcID = itr.next();
                String srcName = assActNumberNameMap.get(srcID);
                String srcBaseData = numberMap.get(srcID);
                srcMap.put(srcName, srcBaseData);
            }
            for (int i = 0; i < coll.size(); ++i) {
                MultiToMultiMapMergeEntryListInfo info = (MultiToMultiMapMergeEntryListInfo)coll.get(i);
                if (!info.getSrcAccount().equals(srcAccount)) continue;
                String[] srcFields = BaseDataMultiToMultiMapHelper.split(info.getSrcField());
                String[] srcFieldValues = BaseDataMultiToMultiMapHelper.split(info.getSrcFieldValue());
                if (srcFields == null || srcFieldValues == null || srcFields.length != srcFieldValues.length) continue;
                HashMap<String, String> srcMutiToMutiMap = new HashMap<String, String>();
                for (int j = 0; j < srcFields.length; ++j) {
                    srcMutiToMutiMap.put(srcFields[j], srcFieldValues[j]);
                }
                Boolean flag = this.compare(srcMap, srcMutiToMutiMap);
                if (!flag.booleanValue()) continue;
                StringBuilder resultBuilder = new StringBuilder();
                String[] destFields = BaseDataMultiToMultiMapHelper.split(info.getDestField());
                String[] destFieldTypes = BaseDataMultiToMultiMapHelper.split(info.getDestFieldType());
                String[] destFieldValues = BaseDataMultiToMultiMapHelper.split(info.getDestFieldValue());
                for (int index = 0; index < destFieldTypes.length; ++index) {
                    EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("name", destFieldTypes[index]);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("destBaseData.*"));
                    view.setSelector(sic);
                    BaseDataTypeCollection collection = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeCollection(view);
                    if (collection == null || collection.size() <= 0) {
                        throw new Exception("\u67e5\u8be2\u4e0d\u5230\u540d\u79f0\u4e3a" + destFieldTypes[index] + "\u7684\u7c7b\u578b\u6620\u5c04");
                    }
                    ICoreBase instance = BaseDataMappingHelper.getCoreBaseInstance(ctx, collection.get(0));
                    IObjectPK pk = CommonUtil.convert2PK(destFieldValues[index]);
                    CoreBaseInfo coreBaseInfo = instance.getValue(pk);
                    datas.put(destFields[index], String.valueOf(coreBaseInfo.get(collection.get(0).getDestID())));
                    resultBuilder.append(destFields[index] + ":");
                    resultBuilder.append(String.valueOf(coreBaseInfo.get(collection.get(0).getDestID())) + "(" + String.valueOf(coreBaseInfo.get(collection.get(0).getDestDisplay())) + ");");
                }
                result = resultBuilder.toString();
                if (result.length() <= 0) {
                    result = MUTIMAP_NUll_FLAG;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.generateLog("\u8f85\u52a9\u8d26\u7ec4\u5408\u6620\u5c04", ThrowableHelper.toString(e), unknowBaseDataValues);
            logger.error((Object)"\u8f85\u52a9\u8d26\u7ec4\u5408\u6620\u5c04\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BOSException("\u8f85\u52a9\u8d26\u7ec4\u5408\u6620\u5c04\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    private String transferEASCashFlowMutiToMutiMap(Context ctx, String srcAccount, Map<String, String> datas, Map<String, String> numberMap, Map<String, String> assActNumberNameMap) throws BOSException {
        String result = "";
        Map<String, Set<Object>> unknowBaseDataValues = MonitorManager.getCurrentSrcToMidBill().getUnkownBaseDataValues();
        try {
            Iterator<String> itr = numberMap.keySet().iterator();
            String billMappingId = billmappingId.get();
            CoreBaseCollection coll = this.getMutiToMutiCollection(ctx, billMappingId, MultiToMultiMapType.easCashFlower);
            HashMap<String, String> srcMap = new HashMap<String, String>();
            while (itr.hasNext()) {
                String srcID = itr.next();
                String srcName = assActNumberNameMap.get(srcID);
                String srcBaseData = numberMap.get(srcID);
                srcMap.put(srcName, srcBaseData);
            }
            for (int i = 0; i < coll.size(); ++i) {
                MultiToMultiMapMergeEntryListInfo info = (MultiToMultiMapMergeEntryListInfo)coll.get(i);
                if (!info.getSrcAccount().equals(srcAccount)) continue;
                String[] srcFields = BaseDataMultiToMultiMapHelper.split(info.getSrcField());
                String[] srcFieldValues = BaseDataMultiToMultiMapHelper.split(info.getSrcFieldValue());
                if (srcFields == null || srcFieldValues == null || srcFields.length != srcFieldValues.length) continue;
                HashMap<String, String> srcMutiToMutiMap = new HashMap<String, String>();
                for (int j = 0; j < srcFields.length; ++j) {
                    srcMutiToMutiMap.put(srcFields[j], srcFieldValues[j]);
                }
                Boolean flag = this.compare(srcMap, srcMutiToMutiMap);
                if (!flag.booleanValue()) continue;
                StringBuilder resultBuilder = new StringBuilder();
                String[] destFields = BaseDataMultiToMultiMapHelper.split(info.getDestField());
                String[] destFieldTypes = BaseDataMultiToMultiMapHelper.split(info.getDestFieldType());
                String[] destFieldValues = BaseDataMultiToMultiMapHelper.split(info.getDestFieldValue());
                for (int index = 0; index < destFieldTypes.length; ++index) {
                    EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("name", destFieldTypes[index]);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("destBaseData.*"));
                    view.setSelector(sic);
                    BaseDataTypeCollection collection = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeCollection(view);
                    if (collection == null || collection.size() <= 0) {
                        throw new Exception("\u67e5\u8be2\u4e0d\u5230\u540d\u79f0\u4e3a" + destFieldTypes[index] + "\u7684\u7c7b\u578b\u6620\u5c04");
                    }
                    ICoreBase instance = BaseDataMappingHelper.getCoreBaseInstance(ctx, collection.get(0));
                    IObjectPK pk = CommonUtil.convert2PK(destFieldValues[index]);
                    CoreBaseInfo coreBaseInfo = instance.getValue(pk);
                    datas.put(destFields[index], (String)coreBaseInfo.get(collection.get(0).getDestID()));
                    resultBuilder.append(destFields[index] + ":");
                    resultBuilder.append(String.valueOf(coreBaseInfo.get(collection.get(0).getDestID())) + "(" + String.valueOf(coreBaseInfo.get(collection.get(0).getDestDisplay())) + ");");
                }
                result = resultBuilder.toString();
                if (result.length() <= 0) {
                    result = MUTIMAP_NUll_FLAG;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.generateLog("\u73b0\u91d1\u6d41\u7ec4\u5408\u6620\u5c04", ThrowableHelper.toString(e), unknowBaseDataValues);
            logger.error((Object)"\u73b0\u91d1\u6d41\u7ec4\u5408\u6620\u5c04\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BOSException("\u73b0\u91d1\u6d41\u7ec4\u5408\u6620\u5c04\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    private String transferByNormal(Context ctx, String headpk, String srcAccount, MultiToMultiMapType type, Map<String, String> datas, Map<String, String> numberMap, Map<String, CoreBaseInfo> dataMap, Map<String, Map<String, CoreBaseInfo>> assistAccountBaseDataMap, Map<String, String> assActNumberNameMap, Map<String, Set<Object>> unknowBaseDataValues) throws Exception {
        Map<String, AssistTypeMultiMapEntrysInfo> map = this.getAssistTypeMutiToMutiCollection(ctx, billmappingId.get(), type);
        AssistTypeMultiMapEntrysInfo atm = map.get(srcAccount);
        if (atm != null) {
            String[] deleteType;
            for (String key : deleteType = BaseDataMultiToMultiMapHelper.split(atm.getDeleteFieldType())) {
                numberMap.remove(key);
            }
        }
        StringBuilder result = new StringBuilder();
        Map<String, Set<Object>> errorBillIdsMap = MonitorManager.getCurrentSrcToMidBill().getErrorBillIdsMap();
        for (String srcID : numberMap.keySet()) {
            CoreBaseInfo newBaseData;
            CoreBaseInfo destID = dataMap.get(srcID);
            if (destID == null) {
                this.generateLog("\u6838\u7b97\u9879", srcID, unknowBaseDataValues);
                Set<Object> set = errorBillIdsMap.get("\u6838\u7b97\u9879[" + srcID + "]");
                if (set == null) {
                    set = new HashSet<Object>();
                    errorBillIdsMap.put("\u6838\u7b97\u9879[" + srcID + "]", set);
                }
                set.add(headpk);
                continue;
            }
            Map<String, CoreBaseInfo> baseDataMapping = assistAccountBaseDataMap.get(srcID);
            String oldBaseData = numberMap.get(srcID);
            BaseDataTypeInfo info = (BaseDataTypeInfo)this.threadLocalMapGet(srcIDBaseDataTypeMapCache, srcID);
            if (BaseDataTypeRuleFilter.matchReplace(info.getRule())) {
                String[] rule = info.getRule().split("\\?");
                oldBaseData = oldBaseData.replace(rule[1], rule[0]);
            }
            if ((newBaseData = baseDataMapping.get(oldBaseData)) == null) {
                this.generateLog(assActNumberNameMap.get(srcID), oldBaseData, unknowBaseDataValues);
                Set<Object> set = errorBillIdsMap.get(assActNumberNameMap.get(srcID) + "[" + oldBaseData + "]");
                if (set == null) {
                    set = new HashSet<Object>();
                    errorBillIdsMap.put(assActNumberNameMap.get(srcID) + "[" + oldBaseData + "]", set);
                }
                set.add(headpk);
                result.append(String.valueOf(destID.get(info.getDestDisplay())) + ":");
                result.append(oldBaseData + "(\u672a\u8f6c\u6362);");
                datas.put(String.valueOf(destID.get(info.getDestDisplay())), null);
                continue;
            }
            result.append(String.valueOf(destID.get("name") + ":"));
            result.append(String.valueOf(newBaseData.get(info.getDestID())) + "(" + String.valueOf(newBaseData.get(info.getDestDisplay())) + ");");
            datas.put(String.valueOf(destID.get("name")), String.valueOf(newBaseData.get(info.getDestID())));
        }
        if (atm != null) {
            String[] destFields = BaseDataMultiToMultiMapHelper.split(atm.getAddField());
            String[] destFieldTypes = BaseDataMultiToMultiMapHelper.split(atm.getAddFieldType());
            String[] destFieldValues = BaseDataMultiToMultiMapHelper.split(atm.getAddFieldValues());
            for (int index = 0; index < destFieldTypes.length; ++index) {
                IObjectPK pk;
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("name", destFieldTypes[index]);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("destBaseData.*"));
                view.setSelector(sic);
                BaseDataTypeCollection collection = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeCollection(view);
                if (collection == null || collection.size() <= 0) continue;
                ICoreBase instance = BaseDataMappingHelper.getCoreBaseInstance(ctx, collection.get(0));
                CoreBaseInfo coreBaseInfo = instance.getValue(pk = CommonUtil.convert2PK(destFieldValues[index]));
                if (coreBaseInfo == null) {
                    throw new Exception("\u67e5\u8be2\u65b0\u589e\u6838\u7b97\u9879ID\u4e3a[" + destFieldValues[index] + "]\u5bf9\u8c61\u4e3a\u7a7a");
                }
                datas.put(destFields[index], (String)coreBaseInfo.get(collection.get(0).getDestID()));
                result.append(destFields[index] + ":");
                result.append(String.valueOf(coreBaseInfo.get(collection.get(0).getDestID())) + "(" + String.valueOf(coreBaseInfo.get(collection.get(0).getDestDisplay())) + ");");
            }
        }
        return result.toString();
    }

    private Boolean compare(Map<String, String> srcMap, Map<String, String> srcMutiToMutiMap) {
        srcMap.remove("");
        srcMutiToMutiMap.remove("");
        if (srcMap.keySet().size() != srcMutiToMutiMap.keySet().size()) {
            return false;
        }
        for (String key : srcMap.keySet()) {
            if (!srcMutiToMutiMap.containsKey(key)) {
                return false;
            }
            if (srcMap.get(key).equals(srcMutiToMutiMap.get(key))) continue;
            return false;
        }
        return true;
    }

    public CoreBaseCollection getMutiToMutiCollection(Context ctx, String billMappingID, MultiToMultiMapType type) throws DIPException {
        try {
            FilterInfo filter;
            String key = billMappingID + type.getName();
            if (this.threadLocalMapGet(multiMapCache, key) != null) {
                return (CoreBaseCollection)this.threadLocalMapGet(multiMapCache, key);
            }
            CoreBaseCollection mmmmColl = new CoreBaseCollection();
            CoreBaseCollection mmmmColsPublic = null;
            HashSet<String> ids = new HashSet<String>();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterId = new FilterInfo();
            filterId.getFilterItems().add(new FilterItemInfo("billMapping.id", (Object)billMappingID, CompareType.EQUALS));
            ev.setFilter(filterId);
            MutiToMutiBillMappingCollection coll = MutiToMutiBillMappingFactory.getLocalInstance(ctx).getMutiToMutiBillMappingCollection(ev);
            if (!coll.isEmpty()) {
                for (int i = 0; i < coll.size(); ++i) {
                    ids.add(coll.get(i).getParent().getId().toString());
                }
            }
            if (!ids.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent.id", ids, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("parent.strategy.id", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("parent.isAssistAccountOnly", (Object)type.getValue(), CompareType.EQUALS));
                view.setFilter(filter);
                mmmmColsPublic = MultiToMultiMapMergeEntryListFactory.getLocalInstance(ctx).getCollection(view);
            }
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.strategy.id", (Object)billMappingID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.isAssistAccountOnly", (Object)type.getValue(), CompareType.EQUALS));
            view.setFilter(filter);
            CoreBaseCollection mmmmColsPrivate = MultiToMultiMapMergeEntryListFactory.getLocalInstance(ctx).getCollection(view);
            if (MutiToMutiPriorityType.privatePriority.equals((Object)billMapping.get().getMutiMapPriority())) {
                mmmmColl.addCollection(mmmmColsPrivate);
                mmmmColl.addCollection(mmmmColsPublic);
            } else {
                mmmmColl.addCollection(mmmmColsPublic);
                mmmmColl.addCollection(mmmmColsPrivate);
            }
            BaseDataMultiToMultiMapHelper.tranlate(ctx, mmmmColl);
            this.threadLocalMapPut(multiMapCache, key, mmmmColl);
            return mmmmColl;
        }
        catch (Exception e) {
            throw new DIPException("\u52a0\u8f7d\u591a\u5bf9\u591a\u6620\u5c04\u65f6\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    private String getCAAByAccounID(Context ctx, Object acc) throws BOSException {
        CoreBaseInfo asstAccountInfo;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (acc instanceof EiPArtificialCoreBaseInfo) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)((EiPArtificialCoreBaseInfo)((Object)acc)).getId().toString(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)String.valueOf(acc), CompareType.EQUALS));
        }
        ev.setFilter(filterInfo);
        IObjectCollection coll = null;
        Object resultv = null;
        try {
            Class<?> accountViewFactory = Class.forName("com.kingdee.eas.basedata.master.account.AccountViewFactory");
            Method method = accountViewFactory.getMethod("getLocalInstance", Context.class);
            Object accountViewFacadeObj = method.invoke(accountViewFactory, ctx);
            Class<?> facade = accountViewFacadeObj.getClass();
            Method method2 = facade.getMethod("getAccountViewCollection", EntityViewInfo.class);
            resultv = method2.invoke(accountViewFacadeObj, ev);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resultv != null) {
            coll = (IObjectCollection)resultv;
        }
        if (coll != null && coll.size() > 0 && (asstAccountInfo = (CoreBaseInfo)coll.getObject(0).get("CAA")) != null) {
            return asstAccountInfo.getId().toString();
        }
        return null;
    }

    private void generateLog(String key, Object object, Map<String, Set<Object>> unknowBaseDataValues) {
        Set<Object> objectList = unknowBaseDataValues.get(key);
        if (objectList == null) {
            objectList = new HashSet<Object>();
            if (objectList.size() < 50) {
                objectList.add(object);
            }
            unknowBaseDataValues.put(key, objectList);
        } else if (objectList.size() < 50) {
            objectList.add(object);
        }
    }

    private void filterData(StructuredTableData data) {
        List headRows = data.getFirstTableRows();
        if (null == headRows || headRows.size() <= 0) {
            return;
        }
        String headPkColName = ((DataRow)headRows.get((int)0)).pkColumn;
        DataRow headdataRow = null;
        block0: for (int i = headRows.size() - 1; i >= 0; --i) {
            headdataRow = (DataRow)headRows.get(i);
            if (null == headdataRow) continue;
            Object headPkboject = headdataRow.getValues().get(headPkColName);
            String headPkVaule = headPkboject.toString();
            if (headdataRow.isIgnore()) {
                data.addignoreDataHeadPks(headPkVaule);
                headRows.remove(i);
                MonitorManager.getCurrentSrcToMidBill().addIgnoreBillCount(1);
                continue;
            }
            List<DataRow> bodyRows = headdataRow.getFirstChildrenDataRows();
            DataRow bodyDataRow = null;
            if (null == bodyRows) continue;
            for (int j = bodyRows.size() - 1; j >= 0; --j) {
                bodyDataRow = bodyRows.get(j);
                if (null == bodyDataRow || !bodyDataRow.isIgnore()) continue;
                data.addignoreDataHeadPks(headPkVaule);
                headRows.remove(i);
                MonitorManager.getCurrentSrcToMidBill().addIgnoreBillCount(1);
                continue block0;
            }
        }
    }

    private boolean processMultiToMultiMap(Context ctx, StructuredDataModel model, List<DataRow> headRows) throws DIPException {
        CoreBaseCollection mmmmCols = null;
        String billMappingID = (String)model.getProperty("billMappingID");
        mmmmCols = this.getMutiToMutiCollection(ctx, billMappingID, MultiToMultiMapType.baseDataMap);
        boolean foundMatch = false;
        if (mmmmCols != null && mmmmCols.size() > 0) {
            for (DataRow headRow : headRows) {
                Map headValues = headRow.getValues();
                block1: for (MultiToMultiMapMergeEntryListInfo mmmmInfo : mmmmCols) {
                    Map entryValues;
                    List<DataRow> entryRows;
                    Object fVal;
                    SplitMMMMInfo splitMmmmInfo = this.splitFields(model, mmmmInfo);
                    if (splitMmmmInfo == null) continue;
                    if (splitMmmmInfo.srcHeadFieldValues != null) {
                        for (String field : splitMmmmInfo.srcHeadFieldValues.keySet()) {
                            fVal = headValues.get(field);
                            String string = fVal = fVal == null ? null : fVal.toString();
                            if (splitMmmmInfo.srcHeadFieldValues.get(field).equals(fVal)) continue;
                            continue block1;
                        }
                    }
                    boolean matchSrcEntryFieldValues = false;
                    if (splitMmmmInfo.srcEntryFieldValues != null) {
                        entryRows = headRow.getFirstChildrenDataRows();
                        block3: for (DataRow entryRow : entryRows) {
                            entryValues = entryRow.getValues();
                            for (String field : splitMmmmInfo.srcEntryFieldValues.keySet()) {
                                fVal = entryValues.get(field);
                                String string = fVal = fVal == null ? null : fVal.toString();
                                if (splitMmmmInfo.srcEntryFieldValues.get(field).equals(fVal)) continue;
                                continue block3;
                            }
                            if (!matchSrcEntryFieldValues) {
                                matchSrcEntryFieldValues = true;
                            }
                            if (splitMmmmInfo.destEntryFieldValues == null) continue;
                            for (String field : splitMmmmInfo.destEntryFieldValues.keySet()) {
                                entryValues.put(field, splitMmmmInfo.destEntryFieldValues.get(field));
                                entryValues.put(PREFIX_MMMM + field, Boolean.TRUE);
                                foundMatch = true;
                            }
                        }
                    } else if (splitMmmmInfo.destEntryFieldValues != null) {
                        entryRows = headRow.getFirstChildrenDataRows();
                        for (DataRow entryRow : entryRows) {
                            entryValues = entryRow.getValues();
                            for (String field : splitMmmmInfo.destEntryFieldValues.keySet()) {
                                entryValues.put(field, splitMmmmInfo.destEntryFieldValues.get(field));
                                entryValues.put(PREFIX_MMMM + field, Boolean.TRUE);
                                foundMatch = true;
                            }
                        }
                    }
                    if ((splitMmmmInfo.srcEntryFieldValues == null || !matchSrcEntryFieldValues) && splitMmmmInfo.srcEntryFieldValues != null || splitMmmmInfo.destHeadFieldValues == null) continue;
                    for (String field : splitMmmmInfo.destHeadFieldValues.keySet()) {
                        headValues.put(field, splitMmmmInfo.destHeadFieldValues.get(field));
                        headValues.put(PREFIX_MMMM + field, Boolean.TRUE);
                        foundMatch = true;
                    }
                }
            }
        }
        return foundMatch;
    }

    private SplitMMMMInfo splitFields(StructuredDataModel model, MultiToMultiMapMergeEntryListInfo mmmmInfo) throws DIPException {
        int j;
        int i;
        String[] srcFields = BaseDataMultiToMultiMapHelper.split(mmmmInfo.getSrcField());
        String[] srcFieldValues = BaseDataMultiToMultiMapHelper.split(mmmmInfo.getSrcFieldValue());
        String[] destFields = BaseDataMultiToMultiMapHelper.split(mmmmInfo.getDestField());
        String[] destFieldValues = BaseDataMultiToMultiMapHelper.split(mmmmInfo.getDestFieldValue());
        if (srcFields == null || srcFieldValues == null || destFields == null || destFieldValues == null || srcFields.length != srcFieldValues.length || destFields.length != destFieldValues.length) {
            return null;
        }
        SplitMMMMInfo splitMmmmInfo = new SplitMMMMInfo();
        StructuredDataModel.TableModel headTable = model.getPriorityTables()[0];
        StructuredDataModel.TableModel entryTable = model.getPriorityTables()[1];
        for (i = 0; i < headTable.columns.length; ++i) {
            for (j = 0; j < srcFields.length; ++j) {
                if (!headTable.columns[i].name.equals(srcFields[j])) continue;
                splitMmmmInfo.addSrcHeadFieldValue(srcFields[j], srcFieldValues[j]);
            }
            for (j = 0; j < destFields.length; ++j) {
                if (!headTable.columns[i].name.equals(destFields[j])) continue;
                splitMmmmInfo.addDestHeadFieldValue(destFields[j], new EiPArtificialCoreBaseInfo(destFieldValues[j]));
            }
        }
        for (i = 0; i < entryTable.columns.length; ++i) {
            for (j = 0; j < srcFields.length; ++j) {
                if (!entryTable.columns[i].name.equals(srcFields[j])) continue;
                splitMmmmInfo.addSrcEntryFieldValue(srcFields[j], srcFieldValues[j]);
            }
            for (j = 0; j < destFields.length; ++j) {
                if (!entryTable.columns[i].name.equals(destFields[j])) continue;
                splitMmmmInfo.addDestEntryFieldValue(destFields[j], new EiPArtificialCoreBaseInfo(destFieldValues[j]));
            }
        }
        return splitMmmmInfo;
    }

    public Map<String, AssistTypeMultiMapEntrysInfo> getAssistTypeMutiToMutiCollection(Context ctx, String billMappingID, MultiToMultiMapType type) throws DIPException {
        try {
            String key = billMappingID + type.getName();
            if (this.threadLocalMapGet(assistTypeMultiMapCache, key) != null) {
                return (Map)this.threadLocalMapGet(assistTypeMultiMapCache, key);
            }
            HashMap<String, AssistTypeMultiMapEntrysInfo> result = new HashMap<String, AssistTypeMultiMapEntrysInfo>();
            HashSet ids = new HashSet();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterId = new FilterInfo();
            filterId.getFilterItems().add(new FilterItemInfo("parent.billMapping.id", (Object)billMappingID, CompareType.EQUALS));
            filterId.getFilterItems().add(new FilterItemInfo("parent.type", (Object)type.getValue(), CompareType.EQUALS));
            ev.setFilter(filterId);
            AssistTypeMultiMapEntrysCollection coll = AssistTypeMultiMapEntrysFactory.getLocalInstance(ctx).getAssistTypeMultiMapEntrysCollection(ev);
            for (int i = 0; i < coll.size(); ++i) {
                result.put(coll.get(i).getSrcItem(), coll.get(i));
            }
            this.threadLocalMapPut(assistTypeMultiMapCache, key, result);
            return result;
        }
        catch (Exception e) {
            throw new DIPException("\u52a0\u8f7d\u6838\u7b97\u9879\u76ee\u7ec4\u5408\u6620\u5c04\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    private static void clear(ThreadLocal<Map> localMap) {
        Map map = localMap.get();
        if (map != null) {
            map.clear();
        }
    }

    private void threadLocalMapPut(ThreadLocal<Map> localMap, Object key, Object value) {
        HashMap<Object, Object> map = localMap.get();
        if (map == null) {
            map = new HashMap<Object, Object>();
        }
        localMap.set(map);
        map.put(key, value);
    }

    private Object threadLocalMapGet(ThreadLocal<Map> localMap, Object key) {
        Map map = localMap.get();
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static void clearCache() {
        billmappingId.set(null);
        billMapping.set(null);
        BaseDataConvertBatchProcessor.clear(accountMap);
        BaseDataConvertBatchProcessor.clear(easCashFlowItemMap);
        BaseDataConvertBatchProcessor.clear(accountAsstMap);
        BaseDataConvertBatchProcessor.clear(asstActMap);
        BaseDataConvertBatchProcessor.clear(multiMapCache);
        BaseDataConvertBatchProcessor.clear(ouCuMap);
        BaseDataConvertBatchProcessor.clear(srcIDBaseDataTypeMapCache);
        BaseDataConvertBatchProcessor.clear(ahFidMap);
    }

    public static final class EiPArtificialCoreBaseInfo
    extends AbstractCoreBaseInfo {
        public EiPArtificialCoreBaseInfo(String id) {
            this.setId(BOSUuid.read((String)id));
        }
    }

    private static class SplitMMMMInfo {
        public Map<String, String> srcHeadFieldValues;
        public Map<String, String> srcEntryFieldValues;
        public Map<String, AbstractCoreBaseInfo> destHeadFieldValues;
        public Map<String, AbstractCoreBaseInfo> destEntryFieldValues;

        private SplitMMMMInfo() {
        }

        public void addSrcHeadFieldValue(String field, String value) {
            if (this.srcHeadFieldValues == null) {
                this.srcHeadFieldValues = new HashMap<String, String>();
            }
            this.srcHeadFieldValues.put(field, value);
        }

        public void addSrcEntryFieldValue(String field, String value) {
            if (this.srcEntryFieldValues == null) {
                this.srcEntryFieldValues = new HashMap<String, String>();
            }
            this.srcEntryFieldValues.put(field, value);
        }

        public void addDestHeadFieldValue(String field, AbstractCoreBaseInfo value) {
            if (this.destHeadFieldValues == null) {
                this.destHeadFieldValues = new HashMap<String, AbstractCoreBaseInfo>();
            }
            this.destHeadFieldValues.put(field, value);
        }

        public void addDestEntryFieldValue(String field, AbstractCoreBaseInfo value) {
            if (this.destEntryFieldValues == null) {
                this.destEntryFieldValues = new HashMap<String, AbstractCoreBaseInfo>();
            }
            this.destEntryFieldValues.put(field, value);
        }
    }
}

