/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.eipserviceplugin.model.base;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.csinterface.eipserviceplugin.model.EIPPluginAdaptorModel;
import com.kingdee.eas.csinterface.eipserviceplugin.model.base.BaseModel;
import com.kingdee.eas.csinterface.eipserviceplugin.util.EIPPluginServiceAdaptorUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IERPModel
extends BaseModel
implements Serializable {
    public static final String IERP_ISC_URL = "/ierp/kapi/app/iscb/integrate/execute";
    public static final String ACTION_GETDEFINE = "getdefine";
    private String solution;
    private String loginservice;
    private String actions;
    private String userImpl;
    private String bosType;
    private String callback;
    private boolean sync;
    private String actionLists;
    private String userActions;
    private String publishId;

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public String getLoginservice() {
        return this.loginservice;
    }

    public void setLoginservice(String loginservice) {
        this.loginservice = loginservice;
    }

    public String getUserImpl() {
        return this.userImpl;
    }

    public void setUserImpl(String userImpl) {
        this.userImpl = userImpl;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getBosType() {
        return this.bosType;
    }

    public void setBosType(String bosType) {
        this.bosType = bosType;
    }

    public List<String> getActions() {
        ArrayList<String> methodList = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)this.actions)) {
            String[] actionType = this.actions.split(";");
            int j = actionType.length;
            for (int i = 0; i < j; ++i) {
                String[] singleAction = actionType[i].split(":");
                Boolean selected = Boolean.parseBoolean(singleAction[1]);
                if (!selected.booleanValue()) continue;
                methodList.add(singleAction[0]);
            }
        }
        return methodList;
    }

    public static void initialCache(Context ctx, EIPPluginAdaptorModel adaptorModel) throws BOSException {
        String ais = ctx.getAIS();
        String nameField = "t0.fname_" + BOSLocaleUtil.getShortCode((Locale)ContextUtils.getLocaleFromEnv());
        StringBuffer sqlBuffer = new StringBuffer(1000);
        sqlBuffer.append("select t0.fid, t0.fnumber, ").append(nameField).append(" name").append(",t0.fsolution, t0.faction, t0.fentityname, t0.fuserImpl, t0.factionList, t0.FUserAction").append(", t1.fid").append(", t0.fimpclassname").append(", t1.fwsservice").append(", t0.FCallback").append(", t0.FSync").append(", t0.FQueueId").append(" from T_EIP_EipServicePluginAdaptor t0").append(" inner join T_EIP_EIPSERVICEPLUGINTREE t1").append(" on t1.fid = t0.ftreeid and t0.fdeletedstatus = 1");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            IERPModel.generateCache((ResultSet)rs, ctx);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    public static IERPModel getAdaptorModel(Context ctx, String adaptorNumber) throws BOSException {
        IERPModel model = null;
        String nameField = "t0.fname_" + BOSLocaleUtil.getShortCode((Locale)ContextUtils.getLocaleFromEnv());
        StringBuffer sqlBuffer = new StringBuffer(1000);
        sqlBuffer.append("select t0.fid, t0.fnumber, ").append(nameField).append(" name").append(",t0.fsolution, t0.faction, t0.fentityname, t0.fuserImpl, t0.factionList").append(", t1.fid").append(", t0.fimpclassname").append(", t1.fwsservice").append(", t0.FCallback").append(", t0.FSync").append(", t0.FQueueId").append(" from T_EIP_EipServicePluginAdaptor t0").append(" inner join T_EIP_EIPSERVICEPLUGINTREE t1").append(" on t1.fid = t0.ftreeid and t0.fdeletedstatus = 1 and t0.fnumber = '" + adaptorNumber + "'");
        IRowSet rs = null;
        try {
            model = new IERPModel();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rs.next()) {
                model.setNumber(rs.getString("fnumber"));
                model.setName(rs.getString("name"));
                model.setActions(rs.getString("faction"));
                model.setActionLists(rs.getString("factionList"));
                model.setSolution(rs.getString("fsolution"));
                model.setEntityName(rs.getString("fentityname"));
                model.setExtendClass(rs.getString("fimpclassname"));
                model.setLoginservice(rs.getString("fwsservice"));
                model.setUserImpl(rs.getString("fuserImpl"));
                model.setPublishId(rs.getString("FQueueId"));
                String isCallback = rs.getString("FCallback");
                isCallback = isCallback == null ? "0" : isCallback;
                model.setCallback(isCallback);
                String syncStr = rs.getString("Fsync");
                boolean isSync = syncStr != null && !"0".equals(syncStr);
                model.setSync(isSync);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return model;
    }

    private static void generateCache(ResultSet rs, Context ctx) throws BOSException {
        EIPPluginAdaptorModel adaptorModel = EIPPluginServiceAdaptorUtil.getAdaptorCache().get(ctx.getAIS());
        ArrayList<IERPModel> list = new ArrayList<IERPModel>();
        try {
            while (rs.next()) {
                IERPModel model = new IERPModel();
                model.setNumber(rs.getString("fnumber"));
                model.setName(rs.getString("name"));
                model.setActions(rs.getString("faction"));
                model.setActionLists(rs.getString("factionList"));
                model.setSolution(rs.getString("fsolution"));
                model.setEntityName(rs.getString("fentityname"));
                model.setExtendClass(rs.getString("fimpclassname"));
                model.setLoginservice(rs.getString("fwsservice"));
                model.setUserImpl(rs.getString("fuserImpl"));
                model.setPublishId(rs.getString("FQueueId"));
                model.setUserActions(rs.getString("FUserAction"));
                String isCallback = rs.getString("FCallback");
                isCallback = isCallback == null ? "0" : isCallback;
                model.setCallback(isCallback);
                String syncStr = rs.getString("Fsync");
                boolean isSync = syncStr != null && !"0".equals(syncStr);
                model.setSync(isSync);
                list.add(model);
            }
            adaptorModel.setIerpList(list);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String serialize(IERPModel model) {
        return JSONObject.toJSONString((Object)model);
    }

    public static IERPModel deSerialize(Context ctx, String modelStr) {
        IERPModel model = new IERPModel();
        JSONObject obj = JSONObject.parseObject((String)modelStr);
        model.setActions(obj.getString("actions"));
        model.setActionLists(obj.getString("actionLists"));
        model.setEntityName(obj.getString("entityName"));
        model.setSolution(obj.getString("solution"));
        model.setLoginservice(obj.getString("loginservice"));
        model.setName(obj.getString("name"));
        model.setNumber(obj.getString("number"));
        model.setMethodBefore(obj.getBooleanValue("mehtodBefore"));
        model.setUserImpl(obj.getString("userImpl"));
        model.setBosType(obj.getString("bosType"));
        model.setCallback(obj.getString("callback"));
        model.setSync(obj.getBooleanValue("sync"));
        model.setPublishId(obj.getString("publishId"));
        model.setUserActions(obj.getString("userActions"));
        return model;
    }

    public String getCallback() {
        return this.callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public String getActionLists() {
        return this.actionLists;
    }

    public void setActionLists(String actionLists) {
        this.actionLists = actionLists;
    }

    public String getPublishId() {
        return this.publishId;
    }

    public void setPublishId(String publishId) {
        this.publishId = publishId;
    }

    public String getActualAction(String action) {
        if (this.actionLists == null) {
            return action;
        }
        String[] actionListArr = this.actionLists.split(";");
        int j = actionListArr.length;
        for (int i = 0; i < j; ++i) {
            String[] actionLists = actionListArr[i].split(":");
            if (!actionLists[0].equals(action)) continue;
            String[] actionArr = actionLists[1].split(",");
            return actionArr[0];
        }
        return "";
    }

    public String getAfterAction(String action) {
        if (this.actionLists == null) {
            return "";
        }
        String[] actionListArr = this.actionLists.split(";");
        int j = actionListArr.length;
        for (int i = 0; i < j; ++i) {
            String[] actionLists = actionListArr[i].split(":");
            if (!actionLists[0].equals(action)) continue;
            String actions = actionLists[1];
            if (actions.indexOf(",") > 0) {
                return actions.substring(actions.indexOf(",") + 1);
            }
            return "";
        }
        return "";
    }

    public void setUserActions(String userActions) {
        this.userActions = userActions;
    }

    public Map<String, String[]> getUserActions() {
        HashMap<String, String[]> actionMap = new HashMap<String, String[]>();
        if (this.userActions != null && this.userActions.length() > 0) {
            String[] eachAction = this.userActions.split("!");
            String method = null;
            for (int i = 0; i < eachAction.length; ++i) {
                String[] aa = eachAction[i].split(";");
                method = aa[2].split(":")[1];
                String action = aa[0].split(":")[0];
                String afterAction = null;
                if (aa.length > 2) {
                    afterAction = aa[2].split(":")[1];
                }
                actionMap.put(method, new String[]{action, afterAction});
            }
        }
        return actionMap;
    }
}

