/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.eipserviceplugin.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPExecute;
import com.kingdee.eas.csinterface.eipserviceplugin.model.EASBasicAction;
import com.kingdee.eas.csinterface.eipserviceplugin.model.EIPPluginAdaptorModel;
import com.kingdee.eas.csinterface.eipserviceplugin.model.base.IERPModel;
import com.kingdee.eas.csinterface.eipserviceplugin.util.cache.ClusterClearAdaotirCacheUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.webservice.app.handler.user.ierp.model.FieldDefineModel;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class EIPPluginServiceAdaptorUtil {
    private static final Logger logger = Logger.getLogger(EIPPluginServiceAdaptorUtil.class);
    private Map<String, Map<String, List<EIPPluginAdaptorModel>>> cache = new HashMap<String, Map<String, List<EIPPluginAdaptorModel>>>();
    private Map<String, Map<String, List<EIPPluginAdaptorModel>>> frontCache = new HashMap<String, Map<String, List<EIPPluginAdaptorModel>>>();
    private static Map<String, EIPPluginAdaptorModel> adaptorCache = new HashMap<String, EIPPluginAdaptorModel>();
    private static Map<String, FieldDefineModel> ierpDefineCache = new ConcurrentHashMap<String, FieldDefineModel>();
    private static final EIPPluginServiceAdaptorUtil instance = new EIPPluginServiceAdaptorUtil();

    public static FieldDefineModel getIerpDefine(String key) {
        return ierpDefineCache.get(key);
    }

    public static void putIerpDefine(String key, FieldDefineModel model) {
        ierpDefineCache.put(key, model);
    }

    public static void clearIerpDefine(String key) {
        Iterator<String> iter = ierpDefineCache.keySet().iterator();
        while (iter.hasNext()) {
            String fullkey = iter.next();
            if (!fullkey.endsWith(key)) continue;
            iter.remove();
        }
    }

    public static Map<String, EIPPluginAdaptorModel> getAdaptorCache() {
        return adaptorCache;
    }

    public Map<String, Map<String, List<EIPPluginAdaptorModel>>> getForntCache() {
        return this.frontCache;
    }

    public Map<String, Map<String, List<EIPPluginAdaptorModel>>> getCache() {
        return this.cache;
    }

    public static void clearCache(String ais) {
        adaptorCache.remove(ais);
    }

    public static void cleanCache(Context ctx) {
        adaptorCache.remove(ctx.getAIS());
        EIPPluginServiceAdaptorUtil.intCache(ctx);
    }

    private EIPPluginServiceAdaptorUtil() {
    }

    public static boolean isConfig(String datacenterName) {
        return adaptorCache.get(datacenterName) != null;
    }

    public static EIPPluginServiceAdaptorUtil getInstance() {
        return instance;
    }

    public BusinessObjectInfo getMetaData(Context ctx, BOSObjectType metaType, BOSObjectType boType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = null;
        if (MetaDataTypeList.ENTITY.equals((Object)metaType)) {
            bo = loader.getEntity(boType);
        } else if (MetaDataTypeList.FACADE.equals((Object)metaType)) {
            bo = loader.getFacade(boType);
        }
        return bo;
    }

    public MethodInfo getMethod(BusinessObjectInfo bo, IMetaDataPK operationPK) {
        if (bo == null || operationPK == null) {
            return null;
        }
        MethodCollection methods = bo.getAllMethodsRuntime();
        for (int i = 0; i < methods.size(); ++i) {
            if (!operationPK.toString().equalsIgnoreCase(methods.get(i).getInnerID())) continue;
            return methods.get(i);
        }
        return null;
    }

    public static void intCache(Context ctx) {
        if (!adaptorCache.containsKey(ctx.getAIS())) {
            EIPPluginServiceAdaptorUtil.initialAllCache(ctx, false);
        }
    }

    public void intFrontCache(Context ctx) throws BOSException {
    }

    private static synchronized void initialAllCache(Context ctx, Boolean isFrontAdaptor) {
        EIPPluginAdaptorModel adaptorModel = adaptorCache.get(ctx.getAIS());
        if (adaptorModel == null) {
            adaptorModel = new EIPPluginAdaptorModel();
            adaptorCache.put(ctx.getAIS(), adaptorModel);
        }
        if (adaptorModel.getIerpList() != null && adaptorModel.getIerpList().size() > 0) {
            return;
        }
        try {
            IERPModel.initialCache(ctx, adaptorModel);
        }
        catch (BOSException e) {
            logger.error((Object)("\u52a0\u8f7d\u6240\u6709\u62e6\u622a\u65b9\u6848\u5f02\u5e38" + ThrowableHelper.toString((Exception)((Object)e))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCommonCache(Context ctx, Boolean isFrontAdaptor) throws BOSException {
        String sql = "select t1.fisFrontAdaptor as fisFrontAdaptor,t1.FAdaptorClassName as FAdaptorClassName,t1.FAdaptorMethodName as FAdaptorMethodName,t2.FImpClassName as FImpClassName,t2.FImpMethodName as FImpMethodName,t2.FIsMethodBefore as FIsMethodBefore,t2.FBASEDATASYN as FBASEDATASYN,t2.FCONNECTION as FCONNECTION,t2.FSYNTYPE as FSYNTYPE,t2.FSRCWHERE as FSRCWHERE,t2.FPARAM  as fparam from T_EIP_EIPSERVICEPLUGINTREE as t1 left join T_EIP_EipServicePluginAdaptor as t2 on t1.fid = t2.FTreeID and t1.fid <> 'lVIAAACqcNdvDiIS' order by t1.fid ASC,t2.FSequence asc";
        Connection conn = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            this.generateCache(rs, ctx);
        }
        catch (SQLException exc) {
            try {
                this.cache.put(ctx.getAIS(), null);
                logger.error((Object)"\u62e6\u622a\u65b9\u6848\u52a0\u8f7d\u51fa\u9519\uff1asql", (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
    }

    public void generateCache(ResultSet rs, Context ctx) throws BOSException {
        String adaptorNamePrevious = null;
        HashMap mapCache = new HashMap();
        HashMap frontmapCache = new HashMap();
        ArrayList<EIPPluginAdaptorModel> list = null;
        try {
            while (rs.next()) {
                String FAdaptorClassName = rs.getString("FAdaptorClassName");
                String FAdaptorMethodName = rs.getString("FAdaptorMethodName");
                String adaptorName = FAdaptorClassName + "@" + FAdaptorMethodName;
                list = new ArrayList<EIPPluginAdaptorModel>();
                if (!adaptorName.equals(adaptorNamePrevious)) {
                    adaptorNamePrevious = adaptorName;
                    if (rs.getInt("fisFrontAdaptor") == 1) {
                        frontmapCache.put(adaptorName, list);
                    } else {
                        mapCache.put(adaptorName, list);
                    }
                }
                EIPPluginAdaptorModel adaptorModel = new EIPPluginAdaptorModel();
                list.add(adaptorModel);
            }
            this.cache.put(ctx.getAIS(), mapCache);
            this.frontCache.put(ctx.getAIS(), frontmapCache);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public Object getParamData(IServiceContext serviceContext, EIPPluginAdaptorModel adaptorModel) throws BOSException {
        return null;
    }

    public boolean isMethodBefore(int i) {
        return i == 0;
    }

    public static boolean isExist(String className, String methodName, String datacenterName, Boolean isMethodBefore) {
        if (adaptorCache.containsKey(datacenterName)) {
            EIPPluginAdaptorModel adaptorModel = adaptorCache.get(datacenterName);
            List<IERPModel> models = adaptorModel.getIerpList();
            if (models == null || models.size() == 0) {
                return false;
            }
            for (IERPModel model : models) {
                if (StringUtils.equals((String)className, (String)model.getEntityName())) {
                    for (String action : model.getActions()) {
                        String easActions = EASBasicAction.getInstance(action).getMethod();
                        String[] matchActions = easActions.split(";");
                        int len = matchActions.length;
                        for (int i = 0; i < len; ++i) {
                            if (!StringUtils.equals((String)matchActions[i], (String)methodName)) continue;
                            return true;
                        }
                    }
                }
                if (!StringUtils.equals((String)className, (String)model.getEntityName()) || model.getUserActions() == null || model.getUserActions().size() <= 0) continue;
                for (String method : model.getUserActions().keySet()) {
                    if (!StringUtils.equals((String)method, (String)methodName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isMethodBefore(IItemAction target, String actionName, ActionEvent e) {
        Boolean isMethodBefore = ((ItemAction)target).beforeActionPerformed((CoreUIObject)target.getUIObject(), actionName, e);
        return isMethodBefore;
    }

    public void doAdaptor(IServiceContext serviceContext, String dataCenterName, String className, String methodName, Boolean isMethodBefore) throws BOSException {
        Context ctx = serviceContext.getContext();
        Map<String, EIPPluginAdaptorModel> map = ClusterClearAdaotirCacheUtil.getClusterCache(ctx);
        if (map == null) {
            return;
        }
        EIPPluginAdaptorModel adaptorModel = map.get(ctx.getAIS());
        if (adaptorModel == null) {
            return;
        }
        IERPExecute.doAdaptor(serviceContext, ctx, adaptorModel, className, methodName);
    }
}

