/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.RecordBaseDataLogInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.EIPConfiguration;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataSynParam;
import com.kingdee.eas.csinterface.monitor.MonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogCollection;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.IAssembledMonitorInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.monitor.app.SubMonitorLogControllerBean;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class BaseDataDownMonitorLogInfo
extends MonitorLogInfo
implements IAssembledMonitorInfo {
    private static Logger logger = Logger.getLogger(BaseDataDownMonitorLogInfo.class);
    public static final String TYPE_BASE_DATA_DOWN = "BaseDataDown";
    public static final String TYPE_BASE_DATA_CHANGE = "BaseDataChange";
    public static final String TYPE_BASE_DATA_DELETE = "BaseDataDelete";
    private int readViewerDataCount;
    private int billCount;
    private int writeBackCount;
    private int filteredBillCount;
    private int successfulBillCount;
    private String chunkedTransmitNumber;
    private int chunkedCapacity;
    private int chunkedCount;
    private long chunkedTransmitTotalSize;
    private long chunkedBillDataTotalSize;
    private boolean recordRepeat;
    private String execType;
    private int execMode = 1;
    private boolean isExit = false;
    private Map<String, String> mainId_ChangeTime_map = new HashMap<String, String>();
    private ThreadLocal<Map<String, String>> threadLoacl_changeTime_map = new ThreadLocal();
    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private RecordBaseDataLogInfo recordBaseDataLog;
    private Map<String, List<Object>> unkownBaseDataValues = new HashMap<String, List<Object>>();
    private int ignoreBillCount;
    private int changeCount;
    public static final Map<String, String> typeMap = new HashMap<String, String>();

    public int getExecMode() {
        return this.execMode;
    }

    public void setExecMode(int execMode) {
        this.execMode = execMode;
    }

    public void setExit(boolean isExit) {
        this.isExit = isExit;
    }

    public boolean isExit() {
        return this.isExit;
    }

    public String getExecType() {
        return this.execType;
    }

    public void setExecType(String execType) {
        this.execType = execType;
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void setChangeCount(int changeCount) {
        this.changeCount = changeCount;
    }

    public void addChangeCount(int changeCount) {
        this.changeCount += changeCount;
    }

    public void setThreadLocalMapInfo(Map<String, String> mapInfo) {
        this.threadLoacl_changeTime_map.set(mapInfo);
    }

    public RecordBaseDataLogInfo getRecordBaseDataLog() {
        return this.recordBaseDataLog;
    }

    public void setRecordBaseDataLog(RecordBaseDataLogInfo recordBaseDataLog) {
        this.recordBaseDataLog = recordBaseDataLog;
    }

    public int getIgnoreBillCount() {
        return this.ignoreBillCount;
    }

    public void addIgnoreBillCount(int ignoreBillCount) {
        this.ignoreBillCount += ignoreBillCount;
    }

    public int getBillCount() {
        return this.billCount;
    }

    public void addReadViewerDataCount(int readViewerDataCount) {
        this.readViewerDataCount += readViewerDataCount;
    }

    public void addBillCount(int billCount) {
        this.billCount += billCount;
    }

    public void addSuccessfulBillCount(int successfulBillCount) {
        this.successfulBillCount += successfulBillCount;
    }

    public void addFilteredBillCount(int filteredBillCount) {
        this.filteredBillCount += filteredBillCount;
    }

    public void addWriteBackCount(int writeBackCount) {
        this.writeBackCount += writeBackCount;
    }

    public void setChunkedCapacity(int chunkedCapacity) {
        this.chunkedCapacity = chunkedCapacity;
    }

    public int getChunkedCapacity() {
        return this.chunkedCapacity;
    }

    public void setChunkedTransmitNumber(String chunkedTransmitNumber) {
        this.chunkedTransmitNumber = chunkedTransmitNumber;
    }

    public void addChunkedCount(int chunkedCount) {
        this.chunkedCount += chunkedCount;
    }

    public void addChunkedTransmitTotalSize(long chunkedSize) {
        this.chunkedTransmitTotalSize += chunkedSize;
    }

    public void addChunkedBillDataTotalSize(long chunkedSize) {
        this.chunkedBillDataTotalSize += chunkedSize;
    }

    public Map<String, List<Object>> getUnkownBaseDataValues() {
        return this.unkownBaseDataValues;
    }

    public static void enter(Context ctx, MonitorLogInfo monitorLogInfo, String operatorType, String operatorSource, String baseDataNumber, String summary, String oprtStatus, boolean hasData, boolean shouldRecord) {
        try {
            if (!hasData && !shouldRecord) {
                return;
            }
            BaseDataSynHeadInfo baseDataInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo("where number='" + baseDataNumber + "'");
            String billDesc = baseDataNumber + "(" + baseDataInfo.getName() + ")";
            BOSUuid id = BOSUuid.create((BOSObjectType)monitorLogInfo.getBOSType());
            monitorLogInfo.setId(id);
            monitorLogInfo.setOperator(((UserInfo)ctx.get((Object)"UserInfo")).getNumber());
            monitorLogInfo.setOperatorType(operatorType);
            monitorLogInfo.setOperatorSource(operatorSource);
            monitorLogInfo.setStatus(oprtStatus);
            monitorLogInfo.setServerIp(MonitorManager.getLocalIP());
            monitorLogInfo.setRpcPort(MonitorManager.getRpcPort());
            monitorLogInfo.setBillNumber(billDesc);
            monitorLogInfo.setSummary(summary != null && summary.length() > 255 ? summary.substring(0, 254) + "\u2026" : summary);
            monitorLogInfo.setStartTime(new Timestamp(System.currentTimeMillis()));
            String instance = Configuration.instanceId();
            String serverName = null;
            if (instance != null) {
                serverName = instance.split("@")[0];
            }
            monitorLogInfo.setServerName(serverName);
            monitorLogInfo.setHttpPort(null);
            monitorLogInfo.setServerTag(EIPConfiguration.Instance().getServerTag());
            if (hasData || shouldRecord) {
                // empty if block
            }
            MonitorLogFactory.getLocalInstance(ctx).log(monitorLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static void assemble(Context ctx, MonitorLogInfo monitorLogInfo) throws Exception {
        String monitorLogId = monitorLogInfo.getId().toString();
        HashMap subLogMap = (HashMap)SubMonitorLogControllerBean.getMainLogWithoutIDs(ctx, monitorLogId);
        StringBuffer content = new StringBuffer();
        if (subLogMap.size() > 0) {
            content.append("\n\u662f\u5426\u4f7f\u7528HTTP-Chunked\u7f16\u7801\u4f20\u8f93\uff1a").append("\u662f\n");
        }
        for (String planNumber : subLogMap.keySet()) {
            SubMonitorLogCollection logColl = (SubMonitorLogCollection)((Object)subLogMap.get(planNumber));
            Iterator it = logColl.iterator();
            boolean isFirst = true;
            while (it.hasNext()) {
                SubMonitorLogInfo logInfo = (SubMonitorLogInfo)it.next();
                int success = logInfo.getSuccessCount();
                int failure = logInfo.getFailureCount();
                int exist = logInfo.getExistCount();
                if (isFirst) {
                    isFirst = false;
                    content.append("\n\u4f20\u8f93\u65b9\u6848\u7f16\u7801\uff1a").append(planNumber).append("\n\u4f20\u8f93\u4e3b\u8868\uff1a").append(logInfo.getTableName());
                }
                content.append("\n\u603b\u5171\u4f20\u8f93\u7684\u8bb0\u5f55\u6570\uff1a").append(success + failure + exist);
                content.append("\n").append(typeMap.get(logInfo.getCmd()) + "\u6210\u529f\u6570\uff1a").append(success);
                if (StringUtils.equals((String)logInfo.getCmd(), (String)"add")) {
                    content.append("\n\u5df2\u5b58\u5728\u6570\uff1a").append(exist);
                }
                if (StringUtils.equals((String)monitorLogInfo.getStatus(), (String)"\u6210\u529f")) continue;
                content.append("\n").append(typeMap.get(logInfo.getCmd()) + "\u5931\u8d25\u6570\uff1a").append(failure);
            }
            content.append("\n---------------------------------------------------------------------\n");
        }
        String contentStr = content.toString();
        contentStr = contentStr.length() > 2000 ? contentStr.substring(0, 1999) + "\u2026" : contentStr;
        monitorLogInfo.setContent(contentStr);
    }

    public static void exit(Context ctx, MonitorLogInfo monitorLogInfo, String errorMsg, String trace) throws Exception {
        BaseDataDownMonitorLogInfo.assemble(ctx, monitorLogInfo);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            String content = monitorLogInfo.getContent() + "\n-----------------------\n\u5f02\u5e38\u4fe1\u606f\uff1a";
            content = content + errorMsg;
            monitorLogInfo.setContent(content);
        }
        monitorLogInfo.setStackTrace(trace);
        long startTime = monitorLogInfo.getStartTime().getTime();
        long duration = System.currentTimeMillis() - startTime;
        monitorLogInfo.setDuration(MonitorManager.getDurationDesc(duration));
        MonitorLogFactory.getLocalInstance(ctx).updateLog(monitorLogInfo);
    }

    public static void assemble(Context ctx, MonitorLogInfo monitorLogInfo, boolean isJDBC) throws EASBizException, BOSException {
        String contentStr;
        JSONObject parse;
        String warnMsg;
        String existData;
        String execMode;
        String monitorLogId = monitorLogInfo.getId().toString();
        HashMap subLogMap = (HashMap)SubMonitorLogControllerBean.getMainLogWithoutIDs(ctx, monitorLogId);
        StringBuffer content = new StringBuffer();
        if (subLogMap.size() > 0) {
            content.append("\n\u662f\u5426\u4f7f\u7528HTTP-Chunked\u7f16\u7801\u4f20\u8f93\uff1a").append("\u5426\n");
        }
        if (StringUtil.isEmpty((String)(execMode = monitorLogInfo.getExtendedProperty("execMode")))) {
            execMode = "\u5355\u7ebf\u7a0b";
        }
        content.append("\n\u96c6\u6210\u65b9\u5f0f\uff1a").append(execMode);
        for (String planNumber : subLogMap.keySet()) {
            SubMonitorLogCollection logColl = (SubMonitorLogCollection)((Object)subLogMap.get(planNumber));
            Iterator it = logColl.iterator();
            boolean isFirst = true;
            while (it.hasNext()) {
                SubMonitorLogInfo logInfo = (SubMonitorLogInfo)it.next();
                int success = logInfo.getSuccessCount();
                int failure = logInfo.getFailureCount();
                int exist = logInfo.getExistCount();
                if (isFirst) {
                    isFirst = false;
                    content.append("\n\u4f20\u8f93\u65b9\u6848\u7f16\u7801\uff1a").append(planNumber).append("\n\u4f20\u8f93\u4e3b\u8868\uff1a").append(logInfo.getTableName());
                }
                content.append("\n\u603b\u5171\u4f20\u8f93\u7684\u8bb0\u5f55\u6570\uff1a").append(success + failure + exist);
                content.append("\n").append(typeMap.get(logInfo.getCmd()) + "\u6210\u529f\u6570\uff1a").append(success);
                if (StringUtils.equals((String)logInfo.getCmd(), (String)"add")) {
                    content.append("\n\u5df2\u5b58\u5728\u6570\uff1a").append(exist);
                }
                if (StringUtils.equals((String)monitorLogInfo.getStatus(), (String)"\u6210\u529f")) continue;
                content.append("\n").append(typeMap.get(logInfo.getCmd()) + "\u5931\u8d25\u6570\uff1a").append(failure);
            }
            content.append("\n---------------------------------------------------------------------\n");
        }
        if ((monitorLogInfo.getStatus() == null || "\u6b63\u5728\u8fd0\u884c".equals(monitorLogInfo.getStatus())) && !StringUtils.isEmpty((String)(existData = monitorLogInfo.getExtendedProperty("extContext")))) {
            if (StringUtils.isEmpty((String)content.toString())) {
                content.append("\u6210\u529f\u540c\u6b65\u6570\uff1a0\u6761\n");
                content.append("\n---------------------------------------------------------------------\n");
            }
            content.append(existData);
        }
        if (!StringUtils.isEmpty((String)(warnMsg = monitorLogInfo.getExtendedProperty("warnMsg"))) && (parse = (JSONObject)JSON.parse((String)warnMsg)) != null) {
            for (Map.Entry entry : parse.entrySet()) {
                content.append((String)entry.getKey());
                content.append(entry.getValue());
                content.append("\n\n");
            }
        }
        contentStr = (contentStr = content.toString()).length() > 2000 ? contentStr.substring(0, 1999) + "\u2026" : contentStr;
        monitorLogInfo.setContent(contentStr);
    }

    @Override
    public void assemble(Context ctx) {
    }

    public boolean isRecordRepeat() {
        return this.recordRepeat;
    }

    public void setRecordRepeat(boolean recordRepeat) {
        this.recordRepeat = recordRepeat;
    }

    public Map<String, String> getMainId_ChangeTime_map() {
        if (ThreadBaseDataSynParam.openMulti) {
            Map<String, String> mapInfo = this.threadLoacl_changeTime_map.get();
            if (null == mapInfo) {
                mapInfo = new ConcurrentHashMap<String, String>();
                this.threadLoacl_changeTime_map.set(mapInfo);
            }
            return this.threadLoacl_changeTime_map.get();
        }
        return this.mainId_ChangeTime_map;
    }

    public void setMainId_ChangeTime_map(Map<String, String> mainId_ChangeTime_map) {
        this.mainId_ChangeTime_map = mainId_ChangeTime_map;
    }

    static {
        typeMap.put("add", "\u65b0\u589e");
        typeMap.put("update", "\u66f4\u65b0");
        typeMap.put("del", "\u5220\u9664");
    }
}

