/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.monitor.MergedLogVo;
import com.kingdee.eas.csinterface.monitor.MonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.app.AbstractMonitorLogControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MonitorLogControllerBean
extends AbstractMonitorLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.monitor.app.MonitorLogControllerBean");
    private static final int maxLen = 32700;

    @Override
    protected void _log(Context ctx, MonitorLogInfo monitorLogInfo) throws BOSException, EASBizException {
        this.formatLogInfo(monitorLogInfo);
        this._addnew(ctx, (IObjectPK)new ObjectUuidPK(monitorLogInfo.getId()), (IObjectValue)monitorLogInfo);
    }

    @Override
    protected void _updateLog(Context ctx, MonitorLogInfo monitorLogInfo) throws BOSException, EASBizException {
        this.formatLogInfo(monitorLogInfo);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(monitorLogInfo.getId()), (IObjectValue)monitorLogInfo);
    }

    private void formatLogInfo(MonitorLogInfo monitorLogInfo) {
        String content;
        if (null == monitorLogInfo) {
            return;
        }
        String stackTrace = monitorLogInfo.getStackTrace();
        if (StringUtils.isEmpty((String)stackTrace)) {
            return;
        }
        if (stackTrace.length() > 32700) {
            stackTrace = stackTrace.substring(0, 32700);
            monitorLogInfo.setStackTrace(stackTrace);
        }
        if (StringUtils.isEmpty((String)(content = monitorLogInfo.getContent()))) {
            return;
        }
        if (content.length() > 32700) {
            content = content.substring(0, 32700) + "\u2026";
            monitorLogInfo.setContent(content);
        }
    }

    @Override
    protected void _batchDelete(Context ctx, Timestamp beginTime, Timestamp endTime, int LogType) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        if (LogType == 0) {
            String baseDataMark = "BaseDataDown,BaseDataChange";
            filter.getFilterItems().add(new FilterItemInfo("simpleName", (Object)baseDataMark, CompareType.INCLUDE));
        } else if (LogType == 1) {
            filter.getFilterItems().add(new FilterItemInfo("simpleName", null, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("LastUpdateTime", (Object)beginTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LastUpdateTime", (Object)endTime, CompareType.LESS_EQUALS));
        IObjectPK[] deletePKs = MonitorLogFactory.getLocalInstance(ctx).delete(filter);
        if (LogType == 0) {
            StringBuffer bf = new StringBuffer();
            int size = deletePKs.length;
            for (int i = 0; i < size; ++i) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(deletePKs[i].toString());
            }
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("monitorLogId", (Object)bf.toString(), CompareType.INCLUDE));
            SubMonitorLogFactory.getLocalInstance(ctx).delete(filter1);
        }
    }

    @Override
    protected List _getMergedLog(Context ctx, String monitorLogId) throws BOSException, EASBizException {
        ArrayList<MergedLogVo> out = new ArrayList<MergedLogVo>();
        try {
            String sql = "select FStartTime,FDuration from  T_EIP_MonitorLogVersion where FMonitorLogID='" + monitorLogId + "' order by FStartTime desc";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (result.next()) {
                MergedLogVo vo = new MergedLogVo();
                vo.setStartTime(result.getTimestamp(1));
                vo.setDuration(result.getString(2));
                out.add(vo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return out;
    }
}

