/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.monitor.app.util.monitordel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.bos.util.backport.concurrent.ScheduledFuture;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.EIPConfigFileInfo;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.MonitorDelEventManager;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.MonitorDelEventObject;
import com.kingdee.eas.csinterface.monitor.app.util.monitordel.MonitorDelEventSource;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ScheduleScanEIPConfigFile {
    private static final Logger logger = Logger.getLogger(ScheduleScanEIPConfigFile.class);
    Context ctx;
    public static final int START_THREAD = 1;
    public static final int STARTED_THREAD = 2;
    AtomicInteger statue = new AtomicInteger(1);

    public ScheduleScanEIPConfigFile(Context ctx) {
        this.ctx = ctx;
    }

    public ScheduleScanEIPConfigFile() {
    }

    public void scan(TimeUnit unit, long delayTime, long initialDelay) {
        logger.info((Object)"eip config scan begin...");
        if (this.statue.get() == 1) {
            this.doScan(unit, delayTime, initialDelay);
            logger.info((Object)("schedule del monitor task started...statue:" + this.statue));
        }
    }

    private void doScan(TimeUnit unit, long delayTime, long initialDelay) {
        this.scheduleExecutor(new EIPTimerTask(), initialDelay, delayTime, unit);
    }

    public ScheduledFuture scheduleExecutor(TimerTask task, long initialDelay, long period, TimeUnit unit) {
        return Executors.newScheduledThreadPool((int)1).scheduleAtFixedRate((Runnable)task, initialDelay, period, unit);
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public static void main(String[] args) {
        ScheduleScanEIPConfigFile s = new ScheduleScanEIPConfigFile(null);
        ScheduledFuture sf = s.scheduleExecutor(new TimerTask(){
            int i = 0;

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    ++this.i;
                    System.out.println("run--" + this.i);
                }
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        sf.cancel(true);
        System.out.println("main end");
    }

    class EIPTimerTask
    extends TimerTask {
        @Override
        public void run() {
            ScheduleScanEIPConfigFile.this.statue.compareAndSet(1, 2);
            this.doRun();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() {
            EIPConfigFileInfo newEipFile = new EIPConfigFileInfo();
            MonitorDelEventSource eventSource = new MonitorDelEventSource(newEipFile);
            MonitorDelEventObject eventObj = new MonitorDelEventObject(null, eventSource);
            eventObj.setCtx(ScheduleScanEIPConfigFile.this.ctx);
            try {
                MonitorDelEventManager.getMrgInstance().fireEvent(eventObj);
            }
            catch (BOSException e) {
                logger.error((Object)ThrowableHelper.toString((Exception)((Object)e)));
            }
            finally {
                newEipFile = null;
            }
        }
    }
}

