/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.openapi.ierp.trace.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.openapi.OpenDataRelationInfo;
import com.kingdee.eas.csinterface.openapi.ierp.model.OpenIERPParamModel;
import com.kingdee.eas.csinterface.openapi.ierp.trace.IEIPTrace;
import com.kingdee.eas.csinterface.openapi.ierp.util.OpenIERPUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.util.StringUtils;

public class IerpTrace
implements IEIPTrace {
    @Override
    public void traceUp(OpenDataRelationInfo relationInfo, WSServiceInfo serviceInfo) throws BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("serviceUser"));
        selectors.add(new SelectorItemInfo("dataCenter"));
        selectors.add(new SelectorItemInfo("tenantId"));
        selectors.add(new SelectorItemInfo("password"));
        selectors.add(new SelectorItemInfo("tree.serviceURL"));
        selectors.add(new SelectorItemInfo("tree.port"));
        selectors.add(new SelectorItemInfo("tree.nameSpace"));
        selectors.add(new SelectorItemInfo("ssoLogin"));
        selectors.add(new SelectorItemInfo("appid"));
        selectors.add(new SelectorItemInfo("appSecuret"));
        try {
            serviceInfo = WSServiceFactory.getRemoteInstance().getWSServiceInfo(CommonUtil.convert2PK(serviceInfo.getId().toString()), selectors);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        String cell = null;
        if (serviceInfo.isSsoLogin()) {
            PersonInfo person;
            SysContext currCtx = SysContext.getSysContext();
            UserInfo user = currCtx.getCurrentUserInfo();
            cell = user.getCell();
            if (StringUtils.isEmpty((String)cell) && (person = user.getPerson()) != null) {
                try {
                    person = PersonFactory.getRemoteInstance().getPersonInfo(CommonUtil.convert2PK(person.getId()));
                }
                catch (EASBizException eASBizException) {
                    // empty catch block
                }
                cell = person.getCell();
            }
            if (StringUtils.isEmpty((String)cell)) {
                throw new BOSException("\u5f53\u524d\u7528\u6237\u6216\u5173\u8054\u804c\u5458\u672a\u8bbe\u5b9a\u624b\u673a\u53f7\uff0c\u65e0\u6cd5\u5b9e\u73b0\u8054\u67e5");
            }
        } else {
            cell = serviceInfo.getServiceUser();
        }
        String url = serviceInfo.getServiceURL();
        OpenIERPParamModel param = new OpenIERPParamModel();
        param.setUrl(url);
        param.setTenantId(serviceInfo.getTenantId());
        param.setDataCenter(serviceInfo.getDataCenter());
        param.setFormId(relationInfo.getSourceEntityId());
        param.setPkId(relationInfo.getSourceBillId());
        param.setUser(cell);
        try {
            OpenIERPUtil.openIerpForm(param);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void traceDown(OpenDataRelationInfo relationInfo, WSServiceInfo serviceInfo) throws BOSException {
    }
}

