/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.reportmapping.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.EntityTableEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.FieldEditorUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.ListUIEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.info.FieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataTemplateCopyUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.TranslateLocalUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.reportmapping.IReportMapping;
import com.kingdee.eas.csinterface.reportmapping.KeyTableUtil;
import com.kingdee.eas.csinterface.reportmapping.MidBillDataProcessFacadeFactory;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingEntryCollection;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingEntryInfo;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingFactory;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingHelper;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingInfo;
import com.kingdee.eas.csinterface.reportmapping.app.AbstractDynamicsMidBillPublisherFacadeControllerBean;
import com.kingdee.eas.csinterface.reportmapping.app.ComparatorFieldInfo;
import com.kingdee.eas.csinterface.reportmapping.app.util.ReportMappingUtil;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DynamicsMidBillPublisherFacadeControllerBean
extends AbstractDynamicsMidBillPublisherFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.reportmapping.app.DynamicsMidBillPublisherFacadeControllerBean");
    public static boolean isFix = false;

    @Override
    protected void _publish(Context ctx, String id) throws BOSException, EASBizException {
        String name = "";
        ReportMappingInfo info = null;
        try {
            try {
                EIPLicenseCheckUtil.checkLicenseEnough(ctx);
            }
            catch (Exception e) {
                logger.info((Object)"license not enough.");
                throw new DIPException(e.getMessage());
            }
            IObjectPK pk = CommonUtil.convert2PK(id);
            IReportMapping instance = ReportMappingFactory.getLocalInstance(ctx);
            SelectorItemCollection selector = ReportMappingUtil.getFullSelector();
            info = instance.getReportMappingInfo(pk, selector);
            name = info.getBillMappingName();
            this.createPKTalbe(ctx, instance, info);
            this.publish(ctx, info);
            this.updateInfo2Published(instance, info);
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            logger.info((Object)("EIP finished publishing the metadata{[" + id + "],[" + name + "]}"));
        }
    }

    @Override
    protected void _repair(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection selector;
        IObjectPK pk = CommonUtil.convert2PK(id);
        IReportMapping instance = ReportMappingFactory.getLocalInstance(ctx);
        ReportMappingInfo info = instance.getReportMappingInfo(pk, selector = ReportMappingUtil.getFullSelector());
        String number = info.getNumber();
        DIPMetadata dm = new DIPMetadata(number);
        QueryInfo queryInfo = UictUtils.loadQuery((IMetaDataPK)new MetaDataPK(dm.getQueryPK()));
        if (queryInfo instanceof QueryInfo) {
            SelectorInfo selectorInfo = queryInfo.getSelector();
            int size = selectorInfo.size();
            ReportMappingEntryCollection coll = info.getEntrys();
            Iterator its = coll.iterator();
            block2: while (its.hasNext()) {
                ReportMappingEntryInfo entryInfo = (ReportMappingEntryInfo)its.next();
                boolean isBaseDataType = entryInfo.getBaseDataType() != null;
                String displayName = entryInfo.getSrcFieldName();
                if (!entryInfo.isHead()) {
                    displayName = "entrys." + displayName;
                }
                if (isBaseDataType) {
                    displayName = displayName + ".name";
                }
                for (int i = 0; i < size; ++i) {
                    QueryFieldInfo qfInfo = selectorInfo.get(i);
                    String fieldName = qfInfo.getName();
                    if (!fieldName.equals(displayName)) continue;
                    displayName = entryInfo.getMidFieldAlias();
                    qfInfo.setDisplayName(displayName);
                    qfInfo.setDisplayName(TranslateLocalUtil.getSimplified(displayName), new Locale("l2"));
                    qfInfo.setDisplayName(TranslateLocalUtil.getTraditional(displayName), new Locale("l3"));
                    continue block2;
                }
            }
        }
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        entityInfo.setTrueClone(true);
        entrysEntityInfo.setTrueClone(true);
        DataTableInfo tableInfo = entityInfo.getTable();
        DataTableInfo entrysTableInfo = entrysEntityInfo.getTable();
        UIObjectInfo listUIInfo = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(dm.getListUIPK()));
        EntityTableEditor entityTableEditor = new EntityTableEditor(entityInfo, tableInfo);
        EntityTableEditor entrysEntityTableEditor = new EntityTableEditor(entrysEntityInfo, entrysTableInfo);
        ListUIEditor listUIEditor = new ListUIEditor(listUIInfo, queryInfo);
        listUIInfo = listUIEditor.getListUIObject();
        ArrayList<RelationshipInfo> relationInfos = new ArrayList<RelationshipInfo>();
        if (entityTableEditor.getRelationInfos() != null && entityTableEditor.getRelationInfos().size() > 0) {
            relationInfos.addAll(entityTableEditor.getRelationInfos());
        }
        if (entrysEntityTableEditor.getRelationInfos() != null && entrysEntityTableEditor.getRelationInfos().size() > 0) {
            relationInfos.addAll(entrysEntityTableEditor.getRelationInfos());
        }
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[6 + (relationInfos.size() > 0 ? relationInfos.size() : 0)];
        mds[0] = entrysTableInfo;
        mds[1] = entrysEntityInfo;
        mds[2] = tableInfo;
        mds[3] = entityInfo;
        mds[4] = queryInfo;
        mds[5] = listUIInfo;
        if (relationInfos.size() > 0) {
            int i = 6;
            for (int j = 0; j < relationInfos.size(); ++j) {
                if (relationInfos.get(j) != null) {
                    mds[i] = (AbstractMetaDataValue)relationInfos.get(j);
                }
                ++i;
            }
        }
        try {
            MetadataStoreFactory.getServerMetadataStore((Context)ctx).saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        }
        catch (Exception e) {
            logger.error((Object)("\u4fdd\u5b58\u4e1a\u52a1\u5355\u636e\u6620\u5c04\uff1a" + number + "\u7684\u5143\u6570\u636e\u5931\u8d25"));
            e.printStackTrace();
        }
    }

    private void createPKTalbe(Context ctx, IReportMapping instance, ReportMappingInfo info) throws EASBizException, BOSException, SQLException, DIPException {
        if (DataSourceType.jdbc.equals((Object)info.getDsType())) {
            ConnectionInfo srcDBConn = info.getSrcDBConn();
            if (srcDBConn == null) {
                logger.warn((Object)"\u8fde\u63a5\u4e3a\u7a7a,\u65e0\u6cd5\u521b\u5efa\u589e\u91cf\u8868");
                info.setPkTableName("\u672a\u751f\u6210\u589e\u91cf\u8868");
            } else {
                this.createKeyTableIfNotExist(ctx, info);
            }
        } else if (DataSourceType.agent.equals((Object)info.getDsType())) {
            if (StringUtils.isEmpty((String)info.getPkTableName()) || "\u672a\u751f\u6210\u589e\u91cf\u8868".equals(info.getPkTableName())) {
                String pkTableName = ReportMappingHelper.calc2PkTableName(info.getId().toString());
                info.setPkTableName(pkTableName);
            }
        } else {
            throw new BOSException("unsupported DataSource Type : " + (Object)((Object)info.getDsType()));
        }
        instance.save((CoreBaseInfo)info);
    }

    private void publish(Context ctx, ReportMappingInfo info) throws BOSException {
        boolean shouldUpdateBOTP = info.isPublished();
        String number = info.getNumber();
        String alias = info.getMidBillEntityMetaAlias();
        if (!info.isPublished()) {
            this.createResource(ctx, info, number, alias);
        }
        ArrayList<FieldInfo> fieldList2Publish = new ArrayList<FieldInfo>();
        ArrayList<FieldInfo> fieldList2Drop = new ArrayList<FieldInfo>();
        this.getFieldList2Process(info, fieldList2Publish, fieldList2Drop);
        ComparatorFieldInfo comparator = new ComparatorFieldInfo();
        Collections.sort(fieldList2Publish, comparator);
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            FieldEditorUtil.addFields(ctx, cn, number, fieldList2Publish);
            FieldEditorUtil.deleteFields(ctx, cn, number, fieldList2Drop);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtil.cleanup(cn);
            MetadataUtils.clearServerMetadataCache();
        }
        if (shouldUpdateBOTP) {
            return;
        }
        try {
            DIPMetadata dm = new DIPMetadata(info.getNumber());
            EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
            String bosType = entityInfo.getType().toString();
            String name = "com.kingdee.eas.csinterface.custom.app." + info.getNumber();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo btpFilter = new FilterInfo();
            btpFilter.getFilterItems().add(new FilterItemInfo("srcEntityFullName", (Object)name, CompareType.EQUALS));
            ev.setFilter(btpFilter);
            IBOTMapping botInstance = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingCollection botColl = botInstance.getBOTMappingCollection(ev);
            for (BOTMappingInfo botInfo : botColl) {
                String tmpType = botInfo.getSrcEntityName();
                if (StringUtils.equals((String)bosType, (String)tmpType)) continue;
                botInfo.setSrcEntityName(bosType);
                botInstance.update(CommonUtil.convert2PK(botInfo.getId().toString()), (CoreBaseInfo)botInfo);
            }
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private void createKeyTableIfNotExist(Context ctx, ReportMappingInfo info) throws BOSException {
        try {
            if (!KeyTableUtil.existKeyTable(ctx, info)) {
                KeyTableUtil.createKeyTable(ctx, info);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void createResource(Context ctx, ReportMappingInfo info, String number, String alias) throws BOSException {
        try {
            MetadataTemplateCopyUtil.copy(ctx, number, alias);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateInfo2Published(IReportMapping instance, ReportMappingInfo info) throws BOSException, EASBizException {
        info.setPublished(true);
        ReportMappingEntryCollection coll = info.getEntrys();
        ArrayList list = new ArrayList();
        Iterator its = coll.iterator();
        while (its.hasNext()) {
            ReportMappingEntryInfo entryInfo = (ReportMappingEntryInfo)its.next();
            entryInfo.setPublished(true);
        }
        instance.save((CoreBaseInfo)info);
    }

    private void getFieldList2Process(ReportMappingInfo info, List<FieldInfo> fieldList2Publish, List<FieldInfo> fieldList2Drop) {
        ReportMappingEntryCollection coll = info.getEntrys();
        Iterator its = coll.iterator();
        while (its.hasNext()) {
            ReportMappingEntryInfo entryInfo = (ReportMappingEntryInfo)its.next();
            this.add2FieldList2Publish(entryInfo, fieldList2Publish);
            this.add2FieldList22Drop(entryInfo, fieldList2Drop);
        }
        DIPMetadata dm = new DIPMetadata(info.getNumber());
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        if (entrysEntityInfo.getPropertyByName("entryStatus") == null) {
            FieldInfo entryStatus = new FieldInfo("entrys.entryStatus", "\u5206\u5f55\u8f6c\u6362\u72b6\u6001", SQLType.INT, 12, 12, 0);
            entryStatus.setDataType(DataType.ENUM);
            entryStatus.setEnumName("com.kingdee.eas.csinterface.DynamicBillEntryStatus");
            fieldList2Publish.add(entryStatus);
        }
        if (entrysEntityInfo.getPropertyByName("assignmentNumber") == null) {
            FieldInfo assignmentNumber = new FieldInfo("entrys.assignmentNumber", "\u4f5c\u4e1a\u53f7", SQLType.VARCHAR, 44, 44, 0);
            fieldList2Publish.add(assignmentNumber);
        }
    }

    private void add2FieldList22Drop(ReportMappingEntryInfo entryInfo, List<FieldInfo> fieldList2Drop) {
        if (entryInfo.isDropped()) {
            FieldInfo field = this.convertEntry2Field(entryInfo);
            fieldList2Drop.add(field);
        }
    }

    private void add2FieldList2Publish(ReportMappingEntryInfo entryInfo, List<FieldInfo> fieldList2Publish) {
        if (!entryInfo.isPublished()) {
            FieldInfo field = this.convertEntry2Field(entryInfo);
            fieldList2Publish.add(field);
            entryInfo.setPublished(true);
        }
    }

    private FieldInfo convertEntry2Field(ReportMappingEntryInfo entryInfo) {
        String alias = entryInfo.getMidFieldAlias();
        int precision = entryInfo.getMidFieldDataPrecision();
        int length = entryInfo.getMidFieldDataLength();
        int scale = entryInfo.getMidFieldDataScale();
        String sqlTypeName = entryInfo.getMidFieldDataType();
        SQLType sqlType = SQLType.getEnum((String)sqlTypeName);
        String name = entryInfo.getMidFieldName();
        if (!entryInfo.isHead()) {
            name = "entrys." + name;
        }
        FieldInfo field = new FieldInfo(name, alias, sqlType, length, precision, scale);
        BaseDataTypeInfo info = entryInfo.getBaseDataType();
        if (null != info) {
            BaseDataInfo baseDataInfo = info.getDestBaseData();
            String baseDataDisplayName = info.getDestDisplay();
            try {
                String queryName = baseDataInfo.getQueryName();
                String entityName = CommonUtil.getEntityName(queryName);
                field.setBaseDataType(entityName);
                field.setBaseDataDisplayName(baseDataDisplayName);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        field.setQueryDisplayName(alias);
        return field;
    }

    protected EntityObjectInfo _getEntityObjectInfo(Context ctx, String id) throws BOSException, EASBizException {
        DIPMetadata dm = new DIPMetadata(id);
        MidBillDataProcessFacadeFactory.getLocalInstance(ctx).addColumnIfNeed(DIPMetadata.getShortName(dm.getHeaderTablePK()), "fmidbillstatus");
        MetaDataPK pk = MetaDataPK.create((String)dm.getHeaderEntityPK());
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)pk);
        return entity;
    }
}

