/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.app.util.BillMappingUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.DataExtractor;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.provider.db.MiddleBillDataProvider;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.monitor.app.MidBillToDestMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.monitor.app.SrcToMidBillMonitorLogInfo;
import com.kingdee.eas.csinterface.schedule.app.AbstractBillServiceFacadeControllerBean;
import com.kingdee.eas.csinterface.schedule.app.service.DesBIllCreator;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.MidBillFactory;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BillServiceFacadeControllerBean
extends AbstractBillServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.schedule.app.BillServiceFacedeControllerBean");

    @Override
    protected String _processBillByType(Context ctx, String billMappingNumber, String botpRuleNumber, String filter, int type, int operator, boolean isSyn, String callBackClass) throws BOSException {
        String result = null;
        try {
            if (!isSyn) {
                result = this.process(ctx, billMappingNumber, botpRuleNumber, filter, type, operator, isSyn, callBackClass);
            } else {
                BillServiceHandle a = new BillServiceHandle(ctx, billMappingNumber, botpRuleNumber, filter, type, operator, isSyn, callBackClass);
                new Thread(a).start();
                JSONArray array = new JSONArray();
                JSONObject o = new JSONObject();
                o.put("isSuccess", (Object)true);
                o.put("processType", (Object)InterfaceProcessType.InitProcess);
                array.add((Object)o);
                result = array.toString();
            }
        }
        catch (Exception e) {
            JSONArray array = new JSONArray();
            JSONObject o = new JSONObject();
            try {
                o.put("isSuccess", (Object)false);
                o.put("error", (Object)e.getMessage());
                o.put("processType", (Object)InterfaceProcessType.InitProcess);
                array.add((Object)o);
            }
            catch (JSONException e1) {
                logger.error((Object)e);
            }
            result = array.toString();
            logger.error((Object)e);
        }
        return result;
    }

    private String processMidAndBotp(Context ctx, BillMappingInfo billMappingInfo, String botpRuleNumber, List<Object> headpks, int operator) throws Exception {
        BOTMappingInfo botMappingInfo = this.checkRelationofBotpAndBillMapping(ctx, billMappingInfo, botpRuleNumber);
        String message = null;
        switch (operator) {
            case 1: {
                message = this.processMidAndBotpAddNew(ctx, billMappingInfo, botMappingInfo, headpks);
                break;
            }
            case 0: {
                message = this.processMidAndBotpUpdate(ctx, billMappingInfo, botMappingInfo, headpks);
                break;
            }
            case -1: {
                message = this.processMidAndBotpdelete(ctx, billMappingInfo, botMappingInfo, headpks);
            }
        }
        return message;
    }

    private String processMidAndBotpdelete(Context ctx, BillMappingInfo billMappingInfo, BOTMappingInfo botMappingInfo, List<Object> headpks) throws Exception {
        return this.processMidBilldelete(ctx, billMappingInfo, headpks);
    }

    private String processMidAndBotpUpdate(Context ctx, BillMappingInfo billMappingInfo, BOTMappingInfo botMappingInfo, List<Object> headpks) throws Exception {
        String result = "";
        String midUpdate = this.processMidBillUpdate(ctx, billMappingInfo, headpks);
        if (headpks.isEmpty()) {
            result = midUpdate;
        } else {
            String destStatus = this.processBotp(ctx, billMappingInfo, botMappingInfo, headpks);
            result = this.mergeJSONString(midUpdate, destStatus);
        }
        return result;
    }

    private String processMidAndBotpAddNew(Context ctx, BillMappingInfo billMappingInfo, BOTMappingInfo botMappingInfo, List<Object> headpks) throws Exception {
        String result = "";
        String midStatu = this.processMidBillAddNew(ctx, billMappingInfo, headpks);
        if (headpks.isEmpty()) {
            result = midStatu;
        } else {
            String destStatus = this.processBotp(ctx, billMappingInfo, botMappingInfo, headpks);
            result = this.mergeJSONString(midStatu, destStatus);
        }
        return result;
    }

    private String processBotp(Context ctx, BillMappingInfo billMappingInfo, BOTMappingInfo botMappingInfo, List<Object> headpks) throws Exception {
        JSONArray array = new JSONArray();
        try {
            IDynamicBillTemplate template;
            HashSet<Object> headpkSet = new HashSet<Object>();
            for (Object headpk : headpks) {
                headpkSet.add(headpk);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)Boolean.FALSE, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("fiVouchered", null, CompareType.EQUALS));
            String noexistSQL = "( select 1 from T_EIP_AssigNumberBills where T_EIP_AssigNumberBills.FMidBillIds =  \"T0\".fid  and T_EIP_AssigNumberBills.FBillMappingId ='" + billMappingInfo.getId().toString() + "' )";
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)noexistSQL, CompareType.NOTEXISTS));
            filter.getFilterItems().add(new FilterItemInfo("headpk", headpkSet, CompareType.INCLUDE));
            EntityViewInfo ev = new EntityViewInfo();
            filter.setMaskString("(#0 or #1) and #2 and #3");
            ev.setFilter(filter);
            String entrySeq = billMappingInfo.getEntrySeq();
            if (!StringUtils.isEmpty((String)entrySeq)) {
                SorterItemInfo sorter = new SorterItemInfo("entrys." + entrySeq);
                sorter.setSortType(SortType.ASCEND);
                ev.getSorter().add(sorter);
            }
            if ((template = MidBillFactory.getInstance(ctx, billMappingInfo.getNumber())) == null) {
                logger.info((Object)("read MidBill data from '" + billMappingInfo.getNumber() + "' 's template is empty!!"));
                throw new BOSException("read MidBill data from '" + billMappingInfo.getNumber() + "' 's template is empty!");
            }
            CoreBillBaseCollection coreBaseColl = template.getCoreBillBaseCollection(ev);
            DesBIllCreator desBIllCreator = new DesBIllCreator(ctx, null, billMappingInfo.getNumber(), botMappingInfo, billMappingInfo.getCashFlowRelation(), billMappingInfo.isIntegrateCashFlow(), billMappingInfo.getEasCashFlowRelation(), billMappingInfo.isIntergrateEASCashFlow(), billMappingInfo.getAssistAccountRelation(), billMappingInfo.isIntegrateEasAssAcc());
            HashSet<String> midHeadpks = new HashSet<String>();
            for (int i = 0; i < coreBaseColl.size(); ++i) {
                DAPTransformResult voucher = null;
                CoreBillBaseCollection tempColl = new CoreBillBaseCollection();
                tempColl.add(coreBaseColl.get(i));
                JSONObject result = new JSONObject();
                result.put("sourceBillId", coreBaseColl.get(i).get("headpk"));
                midHeadpks.add((String)coreBaseColl.get(i).get("headpk"));
                try {
                    voucher = desBIllCreator.botp2DesBill(tempColl);
                    result.put("isSuccess", (Object)true);
                    VoucherInfo vouche = (VoucherInfo)voucher.getVoucherCollection().getObject(0);
                    result.put("targetId", (Object)vouche.getId().toString());
                    result.put("targetNumber", (Object)vouche.getNumber());
                    result.put("processType", (Object)InterfaceProcessType.Mid2Dest);
                }
                catch (Exception e) {
                    MonitorManager.enterMidBillToDest(ctx, "\u63a5\u53e3\u8c03\u7528", billMappingInfo.getNumber(), null);
                    MidBillToDestMonitorLogInfo monitorLogInfo = MonitorManager.getCurrentMidBillToDest();
                    if (monitorLogInfo != null) {
                        monitorLogInfo.addBillCount(1);
                        ArrayList<String> list = new ArrayList<String>();
                        list.add((String)coreBaseColl.get(i).get("headpk"));
                        monitorLogInfo.setDealingBillHeadpks(list);
                    }
                    MonitorManager.error(e);
                    MonitorManager.exit(ctx);
                    logger.error((Object)("\u3010\u51ed\u8bc1\u63a5\u53e3\u8c03\u7528\u3011\u6e90\u5355ID\uff1a" + coreBaseColl.get(i).get("headpk")), (Throwable)e);
                    result.put("isSuccess", (Object)false);
                    Object[] errorMsg = BillServiceFacadeControllerBean.generatekernelMessage(e, 3);
                    result.put("error", (Object)StringUtils.arrayToString((Object[])errorMsg, (String)";"));
                    result.put("isMergeError", (Object)false);
                    result.put("processType", (Object)InterfaceProcessType.Mid2Dest);
                }
                array.add((Object)result);
            }
            headpks.removeAll(midHeadpks);
            if (!headpks.isEmpty()) {
                for (Object str : headpks) {
                    JSONObject result = new JSONObject();
                    result.put("sourceBillId", str);
                    result.put("isSuccess", (Object)false);
                    result.put("error", (Object)"\u5df2\u751f\u6210\u6216\u8005\u662f\u5728\u5176\u5b83\u4efb\u52a1\u5904\u7406\u4e2d");
                    result.put("isMergeError", (Object)false);
                    result.put("processType", (Object)InterfaceProcessType.Mid2Dest);
                    array.add((Object)result);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u51ed\u8bc1\u63a5\u53e3\u8c03\u7528\u3011", (Throwable)e);
            JSONObject o = new JSONObject();
            try {
                o.put("sourceBillId", (Object)StringUtils.arrayToString((Object[])headpks.toArray(new String[0]), (String)","));
                o.put("isSuccess", (Object)false);
                o.put("error", (Object)e.getMessage());
                o.put("processType", (Object)InterfaceProcessType.Mid2Dest);
            }
            catch (JSONException e1) {
                logger.error((Object)e);
            }
            array.add((Object)o);
        }
        return array.toString();
    }

    private String processMidBill(Context ctx, BillMappingInfo billMappingInfo, List<Object> headpks, int operator) throws Exception {
        String message = null;
        switch (operator) {
            case 1: {
                message = this.processMidBillAddNew(ctx, billMappingInfo, headpks);
                break;
            }
            case 0: {
                message = this.processMidBillUpdate(ctx, billMappingInfo, headpks);
                break;
            }
            case -1: {
                message = this.processMidBilldelete(ctx, billMappingInfo, headpks);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processMidBilldelete(Context ctx, BillMappingInfo billMappingInfo, List<Object> headpks) throws Exception {
        JSONArray result = new JSONArray();
        Object conn = null;
        try {
            HashSet<String> headpkSet = new HashSet<String>();
            for (int i = 0; i < headpks.size(); ++i) {
                headpkSet.add((String)headpks.get(i));
            }
            CoreBillBaseCollection coll = this.findMidBillIdAndHeadpkOnly(ctx, billMappingInfo, headpkSet);
            ctx.put((Object)"PK_TABLE_NAME", (Object)billMappingInfo.getPkTableName());
            ConnectionInfo connectionInfo = billMappingInfo.getSrcDBConn();
            ctx.put((Object)"SRC_CONNECTION", (Object)connectionInfo);
            IDynamicBillTemplate template = MidBillFactory.getInstance(ctx, billMappingInfo.getNumber());
            HashSet<String> faildelVoucher = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                JSONObject o;
                DynamicBillTemplateInfo info = (DynamicBillTemplateInfo)coll.get(i);
                String headpk = info.getString("headpk");
                try {
                    ObjectUuidPK srcPk = new ObjectUuidPK(info.getId());
                    if (info.isFivouchered()) {
                        template.deleteVoucher((IObjectPK)srcPk);
                    }
                    template.delete((IObjectPK)srcPk);
                    o = new JSONObject();
                    o.put("sourceBillId", (Object)headpk);
                    o.put("isSuccess", (Object)true);
                    o.put("processType", (Object)InterfaceProcessType.Src2Middle);
                    result.add((Object)o);
                    continue;
                }
                catch (Exception e) {
                    faildelVoucher.add(headpk);
                    o = new JSONObject();
                    o.put("error", (Object)e.getMessage());
                    o.put("sourceBillId", (Object)headpk);
                    o.put("isSuccess", (Object)false);
                    o.put("processType", (Object)InterfaceProcessType.Src2Middle);
                    result.add((Object)o);
                }
            }
            headpks.removeAll(faildelVoucher);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u51ed\u8bc1\u63a5\u53e3\u8c03\u7528\u3011", (Throwable)e);
            JSONObject o = new JSONObject();
            Object[] errorMsg = BillServiceFacadeControllerBean.generatekernelMessage(e, 3);
            o.put("error", (Object)StringUtils.arrayToString((Object[])errorMsg, (String)";"));
            o.put("isSuccess", (Object)false);
            o.put("sourceBillId", (Object)StringUtils.arrayToString((Object[])headpks.toArray(new String[0]), (String)","));
            o.put("processType", (Object)InterfaceProcessType.Src2Middle);
            o.put("isMergeError", (Object)true);
            result.add((Object)o);
            headpks.clear();
            MonitorManager.error(e);
        }
        finally {
            MonitorManager.exit(ctx);
        }
        return result.toString();
    }

    private String processMidBillUpdate(Context ctx, BillMappingInfo billMappingInfo, List<Object> headpks) throws Exception {
        String result = "";
        String midDelete = this.processMidBilldelete(ctx, billMappingInfo, headpks);
        if (headpks.isEmpty()) {
            result = midDelete;
        } else {
            String midRenerate = this.processMidBillAddNew(ctx, billMappingInfo, headpks);
            result = this.mergeJSONString(midDelete, midRenerate);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processMidBillAddNew(Context ctx, BillMappingInfo billMappingInfo, List<Object> headpks) throws Exception {
        JSONArray result = new JSONArray();
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            ArrayList<String> headpkList = new ArrayList<String>();
            HashSet<String> headpkSet = new HashSet<String>();
            for (int i = 0; i < headpks.size(); ++i) {
                headpkList.add("'" + headpks.get(i) + "'");
                headpkSet.add((String)headpks.get(i));
            }
            String filter = StringUtils.arrayToString((Object[])headpkList.toArray(new String[0]), (String)",");
            param.put("filter", "headpk in (" + filter + ")");
            MonitorManager.enterSrcToMidBill(ctx, "\u63a5\u53e3\u8c03\u7528", billMappingInfo.getNumber(), null);
            StructuredDataModel dataModel = DataModelUtil.convert(billMappingInfo);
            MiddleBillDataProvider dataProvider = new MiddleBillDataProvider(dataModel);
            DataExtractor dataExtractor = new DataExtractor(dataProvider, dataModel);
            dataExtractor.extract(ctx, param, true);
            CoreBillBaseCollection coll = this.findMidBillIdAndHeadpkOnly(ctx, billMappingInfo, headpkSet);
            HashSet<String> sucHeadpks = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                String headpk = coll.get(i).getString("headpk");
                sucHeadpks.add(headpk);
                JSONObject o = new JSONObject();
                o.put("sourceBillId", (Object)headpk);
                o.put("isSuccess", (Object)true);
                o.put("processType", (Object)InterfaceProcessType.Src2Middle);
                result.add((Object)o);
            }
            headpkSet.removeAll(sucHeadpks);
            if (!headpkSet.isEmpty()) {
                JSONObject o = new JSONObject();
                o.put("isSuccess", (Object)false);
                o.put("isMergeError", (Object)true);
                SrcToMidBillMonitorLogInfo infoLog = MonitorManager.getCurrentSrcToMidBill();
                String error = infoLog.assembleDetailForBillService(ctx);
                o.put("error", (Object)error);
                o.put("sourceBillId", (Object)StringUtils.arrayToString((Object[])headpkSet.toArray(new String[0]), (String)","));
                o.put("processType", (Object)InterfaceProcessType.Src2Middle);
                result.add((Object)o);
            }
            headpks.removeAll(headpkSet);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u51ed\u8bc1\u63a5\u53e3\u8c03\u7528\u3011", (Throwable)e);
            JSONObject o = new JSONObject();
            o.put("isSuccess", (Object)false);
            Object[] errorMsg = BillServiceFacadeControllerBean.generatekernelMessage(e, 5);
            o.put("error", (Object)StringUtils.arrayToString((Object[])errorMsg, (String)";"));
            o.put("sourceBillId", (Object)StringUtils.arrayToString((Object[])headpks.toArray(new String[0]), (String)","));
            o.put("processType", (Object)InterfaceProcessType.Src2Middle);
            o.put("isMergeError", (Object)true);
            result.add((Object)o);
            headpks.clear();
            MonitorManager.error(e);
        }
        finally {
            MonitorManager.exit(ctx);
        }
        return result.toString();
    }

    public List<Object> findAllHeadpks(BillMappingInfo billMappingInfo, String filter) throws Exception {
        ArrayList<Object> headpks = new ArrayList<Object>();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String sql = " select distinct(headpk) from " + billMappingInfo.getSrcViewName() + " where " + filter;
            ConnectionInfo connectionInfo = billMappingInfo.getSrcDBConn();
            connection = KSQLUtil.getConnection(connectionInfo);
            statement = connection.prepareStatement(sql, 1003, 1007);
            rs = statement.executeQuery();
            while (rs.next()) {
                headpks.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"\u3010\u51ed\u8bc1\u63a5\u53e3\u8c03\u7528\u3011", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(rs, statement, connection);
                throw throwable;
            }
        }
        SQLUtil.cleanup(rs, statement, connection);
        return headpks;
    }

    private void checkParmVaild(int type, int operator, String billMappingNumber, String botpRuleNumber) throws DIPException {
        if (0 != type && 100 != type) {
            throw new DIPException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5408\u6cd5\uff0c\u64cd\u4f5c\u7c7b\u578b\u503c\u4ec5\u4e3a0(\u751f\u6210\u4e2d\u95f4\u5355\u636e)\u6216\u8005\u662f100(\u751f\u6210\u4e2d\u95f4\u5355\u548c\u76ee\u6807\u5355)");
        }
        if (operator != -1 && operator != 0 && operator != 1) {
            throw new DIPException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5408\u6cd5\uff0c\u64cd\u4f5c\u65b9\u5f0f\u503c\u4ec5\u4e3a1(\u65b0\u589e)\uff0c0(\u66f4\u65b0)\uff0c-1(\u5220\u9664)");
        }
        if (StringUtil.isEmpty((String)billMappingNumber)) {
            throw new DIPException("\u4e1a\u52a1\u5355\u636e\u7f16\u7801\u4e0d\u5408\u6cd5");
        }
        if (100 == type && StringUtil.isEmpty((String)botpRuleNumber)) {
            throw new DIPException("botp\u89c4\u5219\u7f16\u7801\u4e0d\u5408\u6cd5");
        }
    }

    private BillMappingInfo checkBillMappingExists(Context ctx, String billMappingNumber) throws EASBizException, BOSException, DIPException {
        SelectorItemCollection selector = BillMappingUtil.getFullSelector();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("number", (Object)billMappingNumber, CompareType.EQUALS));
        ev.setFilter(info);
        ev.setSelector(selector);
        BillMappingCollection coll = BillMappingFactory.getLocalInstance(ctx).getBillMappingCollection(ev);
        if (coll == null || coll.size() <= 0) {
            throw new DIPException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u636e\u6620\u5c04");
        }
        if (DataSourceType.agent.equals((Object)coll.get(0).getDsType())) {
            throw new DIPException("\u4e0d\u652f\u6301\u5ba2\u6237\u7aef\u4ee3\u7406\u7684\u5904\u7406\u65b9\u5f0f");
        }
        return coll.get(0);
    }

    private BOTMappingInfo checkRelationofBotpAndBillMapping(Context ctx, BillMappingInfo billMappingInfo, String botpRuleNumber) throws DIPException, BOSException {
        String name = "com.kingdee.eas.csinterface.custom.app." + billMappingInfo.getNumber();
        EntityViewInfo btpView = new EntityViewInfo();
        FilterInfo btpFilter = new FilterInfo();
        btpFilter.getFilterItems().add(new FilterItemInfo("srcEntityFullName", (Object)name, CompareType.EQUALS));
        btpFilter.getFilterItems().add(new FilterItemInfo("extRule.isEffected", (Object)"1", CompareType.EQUALS));
        btpFilter.getFilterItems().add(new FilterItemInfo("name", (Object)botpRuleNumber, CompareType.EQUALS));
        btpView.setFilter(btpFilter);
        IBOTMapping botInstance = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection btps = botInstance.getBOTMappingCollection(btpView);
        if (btps == null || btps.size() <= 0) {
            throw new DIPException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684BOTP\u89c4\u5219");
        }
        return btps.get(0);
    }

    private CoreBillBaseCollection findMidBillIdAndHeadpkOnly(Context ctx, BillMappingInfo billMappingInfo, Set<String> headpkSet) throws BOSException {
        IDynamicBillTemplate template = MidBillFactory.getInstance(ctx, billMappingInfo.getNumber());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("headpk", headpkSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("headpk"));
        sic.add(new SelectorItemInfo("Fivouchered"));
        ev.setSelector(sic);
        ev.setFilter(info);
        CoreBillBaseCollection coll = template.getCoreBillBaseCollection(ev);
        return coll;
    }

    private String mergeJSONString(String midStatu, String destStatus) {
        JSONArray tempArray = JSONArray.parseArray((String)midStatu);
        JSONArray resultArray = JSONArray.parseArray((String)destStatus);
        for (int i = 0; i < tempArray.size(); ++i) {
            JSONObject o = tempArray.getJSONObject(i);
            boolean flag = o.getBooleanValue("isSuccess");
            if (flag) continue;
            resultArray.add((Object)o);
        }
        return resultArray.toJSONString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(Context ctx, String billMappingNumber, String botpRuleNumber, String filter, int type, int operator, boolean isSyn, String callBackClass) {
        String result = null;
        List<Object> headpks = null;
        try {
            this.checkParmVaild(type, operator, billMappingNumber, botpRuleNumber);
            BillMappingInfo billMappingInfo = this.checkBillMappingExists(ctx, billMappingNumber);
            headpks = this.findAllHeadpks(billMappingInfo, filter);
            if (headpks == null || headpks.isEmpty()) {
                throw new DIPException("\u67e5\u8be2\u4e0d\u5230\u9700\u8981\u5904\u7406\u7684\u5355\u636e");
            }
            switch (type) {
                case 0: {
                    result = this.processMidBill(ctx, billMappingInfo, headpks, operator);
                    break;
                }
                case 100: {
                    result = this.processMidAndBotp(ctx, billMappingInfo, botpRuleNumber, headpks, operator);
                    break;
                }
            }
            this.callBackIfNecessary(ctx, isSyn, callBackClass, result);
        }
        catch (Exception e) {
            try {
                JSONArray array = new JSONArray();
                JSONObject o = new JSONObject();
                try {
                    o.put("isSuccess", (Object)false);
                    o.put("error", (Object)e.getMessage());
                    if (headpks != null) {
                        o.put("sourceBillId", (Object)StringUtils.arrayToString((Object[])headpks.toArray(new String[0]), (String)","));
                    }
                    o.put("processType", (Object)InterfaceProcessType.InitProcess);
                    array.add((Object)o);
                }
                catch (JSONException e1) {
                    logger.error((Object)e);
                }
                result = array.toString();
                logger.error((Object)e);
                this.callBackIfNecessary(ctx, isSyn, callBackClass, result);
            }
            catch (Throwable throwable) {
                this.callBackIfNecessary(ctx, isSyn, callBackClass, result);
                throw throwable;
            }
        }
        if (result == null) {
            throw new NullPointerException();
        }
        return result;
    }

    private void callBackIfNecessary(Context ctx, boolean isSyn, String callBackClass, String result) {
        try {
            Method method;
            if (!isSyn) {
                return;
            }
            String[] classAndMethod = callBackClass.split("#");
            if (classAndMethod.length != 2) {
                logger.error((Object)"\u3010\u5355\u636e\u63a5\u53e3\u56de\u8c03\u5931\u8d25\uff0c\u53c2\u6570callBackClass\u4e0d\u5408\u6cd5\u3011");
                return;
            }
            Class<?> o = Class.forName(classAndMethod[0]);
            if (o == null) {
                logger.error((Object)("\u3010\u5355\u636e\u63a5\u53e3\u56de\u8c03\u5931\u8d25\uff0c\u65e0\u6cd5\u52a0\u8f7d\u7c7b\u3011" + classAndMethod[0]));
            }
            if ((method = o.getMethod(classAndMethod[1], Context.class, String.class)) == null) {
                logger.error((Object)("\u3010\u5355\u636e\u63a5\u53e3\u56de\u8c03\u5931\u8d25\uff0c\u7c7b\u3011" + classAndMethod[0] + "\u4e0d\u5305\u542b\u53c2\u6570\u4e3aString\u7c7b\u578b\u7684\u65b9\u6cd5" + classAndMethod[1]));
            }
            method.invoke(o.newInstance(), ctx, result);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u5355\u636e\u63a5\u53e3\u56de\u8c03\u5931\u8d25\u3011", (Throwable)e);
        }
    }

    private static String[] generatekernelMessage(Throwable throwable, int level) {
        String[] result = new String[]{};
        if (throwable == null) {
            return result;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.flush();
            LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("Caused By") || line.contains("Exception")) {
                    lines.add(line);
                }
                if (lines.size() < level) {
                    line = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            lines.add(ex.toString());
        }
        return lines.toArray(result);
    }

    public class BillServiceHandle
    implements Runnable {
        Context ctx;
        String billMappingNumber;
        String botpRuleNumber;
        String filter;
        int type;
        int operator;
        boolean isSyn;
        String callBackClass;

        public BillServiceHandle(Context ctx, String billMappingNumber, String botpRuleNumber, String filter, int type, int operator, boolean isSyn, String callBackClass) {
            this.ctx = ctx;
            this.billMappingNumber = billMappingNumber;
            this.botpRuleNumber = botpRuleNumber;
            this.filter = filter;
            this.type = type;
            this.operator = operator;
            this.isSyn = isSyn;
            this.callBackClass = callBackClass;
        }

        @Override
        public void run() {
            BillServiceFacadeControllerBean.this.process(this.ctx, this.billMappingNumber, this.botpRuleNumber, this.filter, this.type, this.operator, this.isSyn, this.callBackClass);
        }
    }

    static enum InterfaceProcessType {
        Src2Middle("0"),
        Mid2Dest("1"),
        InitProcess("-1");

        private String name;

        private InterfaceProcessType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static InterfaceProcessType getInstance(String name) {
            for (InterfaceProcessType type : InterfaceProcessType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }
    }
}

