/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataMatchType;
import com.kingdee.eas.csinterface.syncdatabase.IConnection;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataInfoUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class AutoMatchBaseData {
    private static Logger logger = Logger.getLogger(AutoMatchBaseData.class);
    private Context ctx;
    private String baseDataTypeNumber;
    private String baseDataMappingNumber;
    private ScheduleInfo scheduleInfo;
    private BaseDataMapingInfo baseDataMapingInfo;
    private BaseDataTypeInfo baseDataTypeInfo;

    AutoMatchBaseData(Context ctx, BaseDataMapingInfo baseDataMappingInfo, ScheduleInfo scheduleInfo) {
        this.ctx = ctx;
        this.baseDataTypeNumber = baseDataMappingInfo.getNumber();
        this.baseDataMapingInfo = baseDataMappingInfo;
        try {
            this.baseDataTypeInfo = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(this.baseDataMapingInfo.getBaseDataType().getId().toString()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.scheduleInfo = scheduleInfo;
    }

    void process() throws Exception {
        BaseDataMapingEntryInfo entry;
        String name;
        String number;
        String id;
        IObjectValue obj;
        EIPLicenseCheckUtil.checkLicenseEnough(this.ctx);
        HashMap<String, String> unMatchkeyMap = new HashMap<String, String>();
        HashMap<String, String> unMatchValueMap = new HashMap<String, String>();
        this.getUnMatchValue(this.baseDataTypeInfo, this.baseDataMapingInfo, unMatchkeyMap, unMatchValueMap);
        MonitorManager.getCurrentAutoMatchBaseData().setTotalCount(unMatchValueMap.size());
        HashMap<String, String> unMatchkeyMap2 = new HashMap<String, String>();
        HashMap<String, String> unMatchValueMap2 = new HashMap<String, String>();
        unMatchkeyMap2.putAll(unMatchkeyMap);
        unMatchValueMap2.putAll(unMatchValueMap);
        HashMap<String, IObjectValue> resultNumMap = new HashMap<String, IObjectValue>();
        HashMap<String, IObjectValue> resultNameMap = new HashMap<String, IObjectValue>();
        DataMatchType matchType = this.baseDataTypeInfo.getMatchType();
        if (matchType == null || matchType.equals((Object)DataMatchType.NumName)) {
            this.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "number", resultNumMap);
            this.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "name", resultNameMap);
        } else if (matchType.equals((Object)DataMatchType.NumAndName)) {
            this.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "both", resultNumMap);
        } else {
            this.getDescValues(matchType, unMatchkeyMap, unMatchValueMap, "", resultNameMap);
        }
        BaseDataMapingEntryCollection entryColl = this.baseDataMapingInfo.getEntrys();
        Iterator it = entryColl.iterator();
        HashSet<String> existSet = new HashSet<String>();
        while (it.hasNext()) {
            BaseDataMapingEntryInfo entry2 = (BaseDataMapingEntryInfo)it.next();
            existSet.add(entry2.getSrcID());
        }
        HashSet<String> hasMatchSet = new HashSet<String>();
        BaseDataMapingEntryCollection newEntryColl = new BaseDataMapingEntryCollection();
        int successCount = 0;
        for (String key : resultNameMap.keySet()) {
            obj = (IObjectValue)resultNameMap.get(key);
            id = obj.get("id").toString();
            number = String.valueOf(obj.get(this.baseDataTypeInfo.getDestID()));
            name = String.valueOf(obj.get(this.baseDataTypeInfo.getDestDisplay()));
            if (existSet.contains(number)) continue;
            entry = new BaseDataMapingEntryInfo();
            if (matchType != null && matchType.equals((Object)DataMatchType.OnlyNum)) {
                entry.setSrcID(number);
                entry.setSrcDisplay((String)unMatchkeyMap2.get(number));
                entry.setDestID(id);
                entry.setDestNum(number);
                entry.setDestDisplay(name);
            } else if (matchType != null && matchType.equals((Object)DataMatchType.OnlyName)) {
                entry.setSrcID((String)unMatchValueMap2.get(name));
                entry.setSrcDisplay(name);
                entry.setDestID(id);
                entry.setDestNum(number);
                entry.setDestDisplay(name);
            } else {
                entry.setSrcID((String)unMatchValueMap2.get(name));
                entry.setSrcDisplay(name);
                entry.setDestID(id);
                entry.setDestNum(number);
                entry.setDestDisplay(name);
            }
            entry.setSystemAuto(true);
            newEntryColl.add(entry);
            ++successCount;
            hasMatchSet.add(entry.getSrcID());
        }
        for (String key : resultNumMap.keySet()) {
            obj = (IObjectValue)resultNumMap.get(key);
            id = obj.get("id").toString();
            number = (String)obj.get(this.baseDataTypeInfo.getDestID());
            name = (String)obj.get(this.baseDataTypeInfo.getDestDisplay());
            if (existSet.contains(key) || hasMatchSet.contains(key)) continue;
            entry = new BaseDataMapingEntryInfo();
            entry.setSrcID(key);
            entry.setSrcDisplay((String)unMatchkeyMap2.get(key));
            entry.setDestID(id);
            entry.setDestNum(number);
            entry.setDestDisplay(name);
            entry.setSystemAuto(true);
            newEntryColl.add(entry);
            hasMatchSet.add(entry.getSrcID());
            ++successCount;
        }
        this.baseDataMapingInfo.getEntrys().addCollection(newEntryColl);
        BaseDataMapingFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.baseDataMapingInfo);
        MonitorManager.getCurrentAutoMatchBaseData().setSuccessCount(successCount);
        for (String key : hasMatchSet) {
            unMatchkeyMap.remove(key);
        }
        StringBuffer unMatch = new StringBuffer();
        for (String key : unMatchkeyMap.keySet()) {
            if (unMatch.length() > 0) {
                unMatch.append(",");
            }
            unMatch.append(key);
        }
        MonitorManager.getCurrentAutoMatchBaseData().setErrorNumber(unMatch.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUnMatchValue(BaseDataTypeInfo typeInfo, BaseDataMapingInfo mappingInfo, Map<String, String> unMatchKeyMap, Map<String, String> unMatchValueMap) throws BOSException, EASBizException, SQLException {
        String ksql;
        String sql = ksql = this.getSrcSql(typeInfo, mappingInfo.getSrcWhere());
        Connection con = null;
        try {
            con = DBUtils.getConnection(this.ctx);
            int dbType = 0;
            if (DBUtil.isOracle((Connection)con)) {
                dbType = 2;
            } else if (DBUtil.isDB2((Connection)con)) {
                dbType = 1;
            } else if (DBUtil.isMSSQL((Connection)con)) {
                dbType = 3;
            }
            if (!(con instanceof KDConnection)) {
                try {
                    sql = TransUtil.Translate((String)ksql, (int)dbType);
                }
                catch (SqlTranslateException sqlTranslateException) {
                    // empty catch block
                }
            }
        }
        finally {
            SQLUtil.cleanup(con);
        }
        IConnection connection = ConnectionFactory.getLocalInstance(this.ctx);
        ConnectionInfo conn = this.baseDataTypeInfo.getConn();
        ObjectUuidPK pk = null;
        try {
            pk = new ObjectUuidPK(conn.getId().toString());
        }
        catch (NullPointerException ex) {
            MsgBox.showInfo((String)"\u6240\u9009\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e2d\u5f15\u7528\u7684\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728\u3002");
            return;
        }
        if (!connection.exists((IObjectPK)pk)) {
            MsgBox.showInfo((String)"\u6240\u9009\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e2d\u5f15\u7528\u7684\u8fde\u63a5\u5df2\u4e0d\u5b58\u5728\u3002");
            return;
        }
        BaseDataMapingEntryCollection entryColl = mappingInfo.getEntrys();
        Iterator it = entryColl.iterator();
        HashSet<String> existSet = new HashSet<String>();
        while (it.hasNext()) {
            BaseDataMapingEntryInfo entry = (BaseDataMapingEntryInfo)it.next();
            existSet.add(entry.getSrcID());
        }
        conn = connection.getConnectionInfo((IObjectPK)new ObjectUuidPK(conn.getId().toString()));
        IRowSet rs = SQLFacadeFactory.getLocalInstance(this.ctx).getTargetRowset(conn, sql.toString());
        if (null != rs) {
            while (rs.next()) {
                if (existSet.contains(rs.getString(1))) continue;
                unMatchKeyMap.put(rs.getString(1), rs.getString(2));
                unMatchValueMap.put(rs.getString(2), rs.getString(1));
            }
        }
    }

    private void getDescValues(DataMatchType matchType, Map<String, String> unMatchKeyMap, Map<String, String> unMatchValueMap, String specialType, Map<String, IObjectValue> resultMap) throws BOSException, EASBizException, ParserException, SQLException {
        String queryName = BaseDataInfoUtil.getQueryName(this.baseDataTypeInfo, this.ctx);
        MetaDataPK queryPK = MetaDataPK.create((String)queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo view = null;
        String where = this.baseDataMapingInfo.getDestWhere();
        view = StringUtils.isEmpty((String)where) ? new EntityViewInfo() : new EntityViewInfo(where);
        if (null == view.getFilter()) {
            view.setFilter(new FilterInfo());
        }
        this.filtWithOrgUnitInfo(this.ctx, filter.getFilterItems());
        this.filterWithMatchType(matchType, unMatchKeyMap, filter.getFilterItems(), specialType);
        if (filter.getFilterItems().size() > 0) {
            view.getFilter().mergeFilter(filter, "AND");
        }
        exec.setObjectView(view);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
            mainEntityInfo.getEntityRef();
        }
        BOSObjectType type = null;
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            type = mainEntityInfo.getEntityRef().getType();
        }
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)this.ctx).getCollection(type, view);
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            IObjectValue object = coll.getObject(i);
            String number = (String)object.get(this.baseDataTypeInfo.getDestID());
            String name = (String)object.get(this.baseDataTypeInfo.getDestDisplay());
            if (StringUtils.equals((String)specialType, (String)"number")) {
                if (!unMatchKeyMap.containsKey(number)) continue;
                unMatchKeyMap.remove(number);
                resultMap.put(number, object);
                continue;
            }
            if (StringUtils.equals((String)specialType, (String)"name")) {
                if (!unMatchValueMap.containsKey(name)) continue;
                unMatchValueMap.remove(name);
                resultMap.put(number, object);
                continue;
            }
            if (StringUtils.equals((String)specialType, (String)"both")) {
                String unMatchName = unMatchKeyMap.get(number);
                if (unMatchName == null || !StringUtils.equals((String)unMatchName, (String)name)) continue;
                resultMap.put(number, object);
                continue;
            }
            if (matchType.equals((Object)DataMatchType.OnlyNum)) {
                if (!unMatchKeyMap.containsKey(number)) continue;
                unMatchKeyMap.remove(number);
                resultMap.put(number, object);
                continue;
            }
            if (!matchType.equals((Object)DataMatchType.OnlyName) || !unMatchValueMap.containsKey(name)) continue;
            unMatchValueMap.remove(name);
            resultMap.put(number, object);
        }
    }

    private void filterWithMatchType(DataMatchType matchType, Map<String, String> unMatchValue, FilterItemCollection filterItemCollection, String type) {
        if (unMatchValue.size() == 0) {
            unMatchValue.put("", "");
        }
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.addAll(unMatchValue.values());
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(unMatchValue.keySet());
        if (StringUtils.equals((String)type, (String)"number")) {
            filterItemCollection.add(new FilterItemInfo(this.baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (StringUtils.equals((String)type, (String)"name")) {
            filterItemCollection.add(new FilterItemInfo(this.baseDataTypeInfo.getDestDisplay(), valueSet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.NumAndName)) {
            filterItemCollection.add(new FilterItemInfo(this.baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.OnlyNum)) {
            filterItemCollection.add(new FilterItemInfo(this.baseDataTypeInfo.getDestID(), keySet, CompareType.INCLUDE));
        } else if (matchType.equals((Object)DataMatchType.OnlyName)) {
            filterItemCollection.add(new FilterItemInfo(this.baseDataTypeInfo.getDestDisplay(), valueSet, CompareType.INCLUDE));
        }
    }

    private String getSrcSql(BaseDataTypeInfo typeInfo, String srcWhere) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ");
        sql.append(typeInfo.getSrcID());
        if (typeInfo.getSrcDisplay() != null) {
            sql.append(",");
            sql.append(typeInfo.getSrcDisplay());
        }
        sql.append(" from  ");
        sql.append(typeInfo.getSrcTable());
        if (!StringUtils.isEmpty((String)srcWhere)) {
            int beginIndex = 0;
            for (int i = 0; i < srcWhere.length(); ++i) {
                if (" ".equals(String.valueOf(srcWhere.charAt(i)))) {
                    ++beginIndex;
                    continue;
                }
                srcWhere = srcWhere.substring(beginIndex);
                break;
            }
            if (!StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                srcWhere = " where " + srcWhere;
            }
        }
        sql.append("  order by ");
        sql.append(typeInfo.getSrcID());
        return sql.toString();
    }

    public static String getQueryName(Context ctx, BaseDataTypeInfo baseData) {
        BaseDataInfo info = baseData.getDestBaseData();
        if (null == info) {
            throw new RuntimeException("\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6570\u636e\u9700\u8981\u5347\u7ea7.");
        }
        String query = info.getQueryName();
        if (StringUtils.isEmpty((String)query)) {
            String id = info.getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                info = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo((IObjectPK)pk);
                query = info.getQueryName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return query;
    }

    private void filtWithOrgUnitInfo(Context ctx, FilterItemCollection fic) throws BOSException, EASBizException {
        Object object;
        String orgId = this.baseDataMapingInfo.getOrgUnit();
        OrgType orgType = AutoMatchBaseData.getOrgType(ctx, this.baseDataTypeInfo);
        if (StringUtils.isEmpty((String)orgId)) {
            return;
        }
        OrgUnitInfo orgUnitInfo = NewOrgViewHelper.getOrgUnitInfo((Context)ctx, (String)orgId, (OrgType)orgType);
        if (null == orgUnitInfo) {
            return;
        }
        if (null == this.baseDataTypeInfo) {
            return;
        }
        String destOrgField = this.baseDataTypeInfo.getDestOrgField();
        if (StringUtils.isEmpty((String)destOrgField)) {
            return;
        }
        String orgUnitId = orgUnitInfo.getId().toString();
        fic.add(new FilterItemInfo(destOrgField, (Object)orgUnitId, CompareType.EQUALS));
        if (this.isAccountBaseType(ctx, this.baseDataTypeInfo) && OrgType.Company.equals((Object)orgType) && (object = orgUnitInfo.get("accounttable")) != null) {
            try {
                String accountTableIDValue = this.getAccountTableInfoId(object);
                fic.add(new FilterItemInfo("accountTableID.id", (Object)accountTableIDValue, CompareType.EQUALS));
                fic.add(new FilterItemInfo("isleaf", (Object)1, CompareType.EQUALS));
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
    }

    private String getAccountTableInfoId(Object object) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("com.kingdee.eas.basedata.master.account.AccountTableInfo");
            Method getId = clazz.getMethod("getId", new Class[0]);
            BOSUuid bosUuid = (BOSUuid)getId.invoke(object, new Object[0]);
            return bosUuid.toString();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
            return null;
        }
    }

    private static OrgType getOrgType(Context ctx, BaseDataTypeInfo baseDataType) {
        BaseDataInfo baseData = baseDataType.getDestBaseData();
        IObjectPK pk = CommonUtil.convert2PK(baseData.getId().toString());
        try {
            baseData = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo(pk);
        }
        catch (Exception e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        String queryName = baseData.getQueryName();
        OrgType orgType = CommonUtil.getOrgTypeByQueryName(queryName);
        return orgType;
    }

    private boolean isAccountBaseType(Context ctx, BaseDataTypeInfo baseDataType) {
        BaseDataInfo baseDataInfo = baseDataType.getDestBaseData();
        if (null != baseDataInfo) {
            try {
                String id = baseDataInfo.getId().toString();
                BaseDataInfo o = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo((IObjectPK)new ObjectUuidPK(id));
                if (null != o) {
                    return "com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery".equalsIgnoreCase(o.getQueryName());
                }
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return false;
    }

    public List getValueCollection(Context ctx, IMetaDataPK pk, List<String> queryValues) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo queryInfo = loader.getQuery(pk);
        SelectorItemCollection sic = new SelectorItemCollection();
        ArrayList resultArray = new ArrayList();
        try {
            IObjectCollection coll = null;
            SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
            SubEntityInfo mainEntityInfo = null;
            if (mainObjectInfo instanceof SubEntityInfo) {
                mainEntityInfo = (SubEntityInfo)mainObjectInfo;
                mainEntityInfo.getEntityRef();
            }
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            HashSet<String> queryValueSet = new HashSet<String>();
            queryValueSet.addAll(queryValues);
            fInfo.getFilterItems().add(new FilterItemInfo("id", queryValueSet, CompareType.INCLUDE));
            evInfo.setFilter(fInfo);
            evInfo.getSelector().addObjectCollection((IObjectCollection)sic);
            BOSObjectType type = null;
            if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
                type = mainEntityInfo.getEntityRef().getType();
            }
            coll = DynamicObjectFactory.getLocalInstance((Context)this.ctx).getCollection(type, evInfo);
            ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                IObjectValue ov = coll.getObject(i);
                result.add(ov);
            }
            resultArray.addAll(result);
            queryValues.clear();
            queryValues.addAll(result);
            return resultArray;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return new ArrayList();
        }
    }
}

