/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCheckDiffFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynCheckDiffInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynPublisherFacadeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynHead;
import com.kingdee.eas.csinterface.basedatasyn.ThreadBaseDataPlanSyn;
import com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice.BaseDataSynFacadeByWSService;
import com.kingdee.eas.csinterface.basedatasyn.app.basedataSynByWsservice.BaseDataSynTaskByWSService;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.factory.BaseDataMainTableFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.factory.BaseDataPlanFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataDownExecutor;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataPlan;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataSynParam;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.TranferType;
import com.kingdee.eas.csinterface.billmapping.app.util.BillFunMetuxUtil;
import com.kingdee.eas.csinterface.cache.util.CacheType;
import com.kingdee.eas.csinterface.data.DataExtractor;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.provider.db.MiddleBillDataProvider;
import com.kingdee.eas.csinterface.data.snapshot.Snapshot;
import com.kingdee.eas.csinterface.data.util.DataModelUtil;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.monitor.app.SnapshotDataChangeMonitorLogInfo;
import com.kingdee.eas.csinterface.schedule.ISchedule;
import com.kingdee.eas.csinterface.schedule.ScheduleActionEnum;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.schedule.app.service.AutoMatchBaseData;
import com.kingdee.eas.csinterface.schedule.app.service.CheckMidStatus;
import com.kingdee.eas.csinterface.schedule.app.service.DBFacade;
import com.kingdee.eas.csinterface.schedule.app.service.DesBIllCreator;
import com.kingdee.eas.csinterface.schedule.app.service.IScheduleTaskAction;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleFacade;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.AbstractDestBillTransferObject;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl.TransferMutiToMutiImpl;
import com.kingdee.eas.csinterface.schedule.app.service.destBillStrategy.impl.TransferOneTOneImpl;
import com.kingdee.eas.csinterface.syncdatabase.BDRMappingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceInfo;
import com.kingdee.eas.csinterface.webservice.EipWebServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeFactory;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceFactory;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSTransferLogInfo;
import com.kingdee.eas.csinterface.webservice.app.util.EipWebServiceTaskUtil;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ScheduleTaskAction
extends AbstractBOSObject
implements IScheduleTaskAction {
    private static Logger logger = Logger.getLogger(ScheduleTaskAction.class);
    public static Map<String, Integer> CURRENT_BASE_DATA_THREAD = new HashMap<String, Integer>();
    public static final Integer MAX_BASE_DATA_THREAD = 3;
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"BIDSFADE");
    private static IScheduleTaskAction scheduleTaskAction = new ScheduleTaskAction();
    public static Set<String> BASEDATAMAPPING_PROCESS = new HashSet<String>();
    public static long RETRY_DELAYTIMES = 180000L;
    public static Set<String> hasCheckReady = new HashSet<String>();

    public static IScheduleTaskAction getInstance() {
        return scheduleTaskAction;
    }

    public static Set<String> getHasCheckReady() {
        return hasCheckReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTask(Job job, String scheduledId, Map<String, Object> param) throws Exception {
        if (param == null) {
            param = new HashMap<String, Object>();
        }
        MutexParameter retParam = null;
        Context ctx = job.getContext();
        EIPLicenseCheckUtil.checkLicenseEnough(ctx);
        ISchedule scheduleInstacne = ScheduleFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(scheduledId);
        ScheduleInfo scheduleInfo = scheduleInstacne.getScheduleInfo((IObjectPK)pk);
        ScheduleActionEnum actionType = scheduleInfo.getActionType();
        DataSourceType dataSourceType = scheduleInfo.getDsType();
        String stragyId = "";
        boolean isBaseDataSyn = false;
        String baseDataKey = "";
        boolean isHttpService = false;
        if (scheduleInfo.getStrategy() != null) {
            stragyId = scheduleInfo.getStrategy().getId().toString();
        } else if (scheduleInfo.getBaseDataMap() != null) {
            stragyId = scheduleInfo.getBaseDataMap().getId().toString();
        } else if (scheduleInfo.getBaseDataSyn() != null) {
            BaseDataSynWebServiceInfo baseDataSynWebServiceInfo;
            WSServiceInfo wsserviceInfo;
            isBaseDataSyn = true;
            stragyId = scheduleInfo.getBaseDataSyn().getId().toString();
            ConnectionInfo conn = scheduleInfo.getConn();
            if (conn != null) {
                String connId = conn.getId().toString();
                baseDataKey = stragyId + connId;
            }
            if ((wsserviceInfo = scheduleInfo.getWsservice()) != null) {
                String wsserviceId = wsserviceInfo.getId().toString();
                baseDataKey = stragyId + wsserviceId;
                isHttpService = true;
            }
            if ((baseDataSynWebServiceInfo = scheduleInfo.getBasedataSynWebService()) != null) {
                String webserviceId = baseDataSynWebServiceInfo.getId().toString();
                baseDataKey = stragyId + webserviceId;
                isHttpService = true;
            }
        } else if (scheduleInfo.getBaseDataRule2BaseData() != null) {
            stragyId = scheduleInfo.getBaseDataRule2BaseData().getId().toString();
        } else if (scheduleInfo.getBaseDataGroupRule2BaseData() != null) {
            stragyId = scheduleInfo.getBaseDataGroupRule2BaseData().getId().toString();
        } else if (scheduleInfo.getWsinterface() != null) {
            stragyId = scheduleInfo.getWsinterface().getId().toString();
        }
        if (stragyId == "") {
            logger.error((Object)"\u5f53\u524d\u8c03\u5ea6\u6ca1\u6709\u53ef\u4ee5\u6267\u884c\u7684\u6709\u6548\u8c03\u5ea6\uff0c\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        ctx = this.createContext(job, scheduleInfo);
        BillMappingInfo billMappingInfo = null;
        BaseDataMapingInfo baseDataMapingInfo = null;
        BaseDataSynHeadInfo baseDataSyninfo = null;
        WSInterfaceInfo wsInterfaceInfo = null;
        WSIdentificationCodeInfo wsIdentificationCodeInfo = null;
        int type = actionType.getValue();
        if (type == 600) {
            baseDataMapingInfo = BaseDataMapingFactory.getLocalInstance(ctx).getBaseDataMapingInfo(CommonUtil.convert2PK(stragyId));
        } else if (type == 400 || type == 500 || type == 700) {
            baseDataSyninfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo(CommonUtil.convert2PK(stragyId));
            if (type == 800) {
                logger.error((Object)("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u6267\u884c\u4e86\u5220\u9664\u7684\u8c03\u5ea6" + new Date()));
            }
        } else if (type == 1024) {
            wsInterfaceInfo = WSInterfaceFactory.getLocalInstance(ctx).getWSInterfaceInfo(CommonUtil.convert2PK(scheduleInfo.getWsinterface().getId().toString()));
            wsIdentificationCodeInfo = WSIdentificationCodeFactory.getLocalInstance(ctx).getWSIdentificationCodeInfo(CommonUtil.convert2PK(scheduleInfo.getWsIdentificationCode().getId().toString()));
        } else if (type != 750) {
            billMappingInfo = DataModelUtil.readBillMappingInfo(ctx, stragyId);
        }
        Set<String> set = BASEDATAMAPPING_PROCESS;
        synchronized (set) {
            if (isBaseDataSyn) {
                if (BASEDATAMAPPING_PROCESS.contains(baseDataKey)) {
                    if (baseDataSyninfo != null) {
                        logger.info((Object)("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\uff08" + baseDataSyninfo.getNumber() + "\uff09\u6b63\u5728\u6267\u884c\uff0c\u6b64\u6b21\u6267\u884c\u88ab\u4f5c\u5e9f" + new Date()));
                    } else {
                        logger.info((Object)("\u57fa\u7840\u8d44\u6599\u540c\u6b65\u65b9\u6848\u6b63\u5728\u6267\u884c\uff0c\u6b64\u6b21\u6267\u884c\u88ab\u4f5c\u5e9f" + new Date()));
                    }
                    try {
                        String connId = null;
                        ConnectionInfo conn = scheduleInfo.getConn();
                        if (conn != null) {
                            connId = conn.getId().toString();
                        }
                        if (baseDataSyninfo != null) {
                            baseDataSyninfo.setExtendedProperty("extConnId", connId);
                        }
                        String processMethod = "";
                        if (type == 400) {
                            if (isHttpService) {
                                processMethod = "processBaseDataDownByRemoteService";
                                BaseDataSynFacadeByWSService.enableOnce4WS2WebService(ctx, job, scheduleInfo, baseDataSyninfo, null, null, processMethod, type, null, RETRY_DELAYTIMES);
                            } else {
                                processMethod = "processBaseDataDown";
                                ScheduleFacade.enableOnce4Interface(ctx, job, scheduleInfo, baseDataSyninfo, null, null, processMethod, type, null, RETRY_DELAYTIMES);
                            }
                        } else if (type == 500) {
                            if (isHttpService) {
                                processMethod = "processBaseDataChangeByRemoteService";
                                BaseDataSynFacadeByWSService.enableOnce4WS2WebService(ctx, job, scheduleInfo, baseDataSyninfo, null, null, processMethod, type, null, RETRY_DELAYTIMES);
                            } else {
                                processMethod = "processBaseDataChange";
                                ScheduleFacade.enableOnce4Interface(ctx, job, scheduleInfo, baseDataSyninfo, null, null, processMethod, type, null, RETRY_DELAYTIMES);
                            }
                        } else if (type == 700) {
                            if (isHttpService) {
                                processMethod = "processBaseDataDownAndChangeByRemoteService";
                                BaseDataSynFacadeByWSService.enableOnce4WS2WebService(ctx, job, scheduleInfo, baseDataSyninfo, null, null, processMethod, type, null, RETRY_DELAYTIMES);
                            } else {
                                processMethod = "processBaseDataDownAndChange";
                                ScheduleFacade.enableOnce4Interface(ctx, job, scheduleInfo, baseDataSyninfo, null, null, processMethod, type, null, RETRY_DELAYTIMES);
                            }
                        } else if (actionType.getValue() == 1100) {
                            String actionInfo = "schedule";
                            BaseDataSynCheckDiffInfo baseDataSynCheckDiffInfo = BaseDataSynCheckDiffFactory.getLocalInstance(ctx).getBaseDataSynCheckDiffInfo("where SynHeadID='" + stragyId + "'");
                            BaseDataSynCheckDiffFactory.getLocalInstance(ctx).doAction(actionInfo, baseDataSynCheckDiffInfo);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u57fa\u7840\u8d44\u6599\u540c\u6b65\u51b2\u7a81\u65f6\uff0c\u91cd\u65b0\u4e0b\u8f7d\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u51fa\u9519");
                    }
                    return;
                }
                BASEDATAMAPPING_PROCESS.add(baseDataKey);
            } else {
                if (BASEDATAMAPPING_PROCESS.contains(stragyId)) {
                    logger.info((Object)("\u8c03\u5ea6\u7b56\u7565(" + scheduleInfo.getName() + ")\u6b63\u5728\u6267\u884c\uff0c\u6b64\u6b21\u6267\u884c\u88ab\u4f5c\u5e9f" + new Date()));
                    return;
                }
                BASEDATAMAPPING_PROCESS.add(stragyId);
            }
        }
        try {
            if (type == 0 || type == 900 || type == 550) {
                if (null != billMappingInfo && billMappingInfo.isIsBillRequestMutex()) {
                    if (BillFunMetuxUtil.isRequstFunMutex(ctx, billMappingInfo, "\u751f\u6210\u4e2d\u95f4\u5355\u636e")) {
                        retParam = BillFunMetuxUtil.requestFunMutex(ctx, (CoreBaseInfo)billMappingInfo, "\u751f\u6210\u4e2d\u95f4\u5355\u636e");
                        this.processMidBill(ctx, job, billMappingInfo, null);
                    } else {
                        BillFunMetuxUtil.triggerBillDelayTask4Schedule(ctx, scheduledId, param, 10000L);
                    }
                } else {
                    this.processMidBill(ctx, job, billMappingInfo, null);
                }
            } else if (type == 1) {
                if (null != billMappingInfo && billMappingInfo.isIsBillRequestMutex()) {
                    if (BillFunMetuxUtil.isRequstFunMutex(ctx, billMappingInfo, "\u751f\u6210\u76ee\u6807\u5355\u636e")) {
                        retParam = BillFunMetuxUtil.requestFunMutex(ctx, (CoreBaseInfo)billMappingInfo, "\u751f\u6210\u76ee\u6807\u5355\u636e");
                        this.processBOTP(ctx, job, scheduledId, scheduleInfo.getBotMapping().getId().toString(), billMappingInfo, null);
                    } else {
                        BillFunMetuxUtil.triggerBillDelayTask4Schedule(ctx, scheduledId, param, 10000L);
                    }
                } else {
                    this.processBOTP(ctx, job, scheduledId, scheduleInfo.getBotMapping().getId().toString(), billMappingInfo, null);
                }
            } else if (type == 100) {
                String operatorSource = MonitorManager.getOperatorSource();
                this.processMidBill(ctx, job, billMappingInfo, null);
                MonitorManager.setOperatorSource(operatorSource);
                this.processBOTP(ctx, job, scheduledId, scheduleInfo.getBotMapping().getId().toString(), billMappingInfo, null);
            } else if (type == 200 || type == 1000) {
                if (null != billMappingInfo && billMappingInfo.isIsBillRequestMutex()) {
                    if (BillFunMetuxUtil.isRequstFunMutex(ctx, billMappingInfo, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316")) {
                        retParam = BillFunMetuxUtil.requestFunMutex(ctx, (CoreBaseInfo)billMappingInfo, "\u68c0\u6d4b\u6e90\u5355\u636e\u6570\u636e\u53d8\u5316");
                        this.processDataChangeBySnapshot(ctx, job, billMappingInfo, null);
                    } else {
                        BillFunMetuxUtil.triggerBillDelayTask4Schedule(ctx, scheduledId, param, 10000L);
                    }
                } else {
                    this.processDataChangeBySnapshot(ctx, job, billMappingInfo, null);
                }
            } else if (type == 300 || type == 850) {
                this.checkMidStatus(ctx, job, scheduleInfo, billMappingInfo, type);
            } else if (type == 600) {
                this.processMatchBaseData(ctx, job, scheduleInfo, baseDataMapingInfo, null);
            } else if (type == 400) {
                if (isHttpService) {
                    ScheduleTaskAction.processBaseDataDownByRemoteService(ctx, job, scheduleInfo, baseDataSyninfo, null, null, null);
                } else {
                    ScheduleTaskAction.processBaseDataDown(ctx, job, scheduleInfo, baseDataSyninfo, null, null, null);
                }
            } else if (type == 500) {
                if (isHttpService) {
                    ScheduleTaskAction.processBaseDataChangeByRemoteService(ctx, job, scheduleInfo, baseDataSyninfo, null, null, null);
                } else {
                    ScheduleTaskAction.processBaseDataChange(ctx, job, scheduleInfo, baseDataSyninfo, null, null, null);
                }
            } else if (type == 700) {
                if (isHttpService) {
                    ScheduleTaskAction.processBaseDataDownAndChangeByRemoteService(ctx, job, scheduleInfo, baseDataSyninfo, null, null, null);
                } else {
                    ScheduleTaskAction.processBaseDataDownAndChange(ctx, job, scheduleInfo, baseDataSyninfo, null, null, null);
                }
            } else if (type == 800) {
                ScheduleTaskAction.processBaseDataDelete(ctx, job, scheduleInfo, baseDataSyninfo, null, null, null);
            } else if (type == 650) {
                BDRMappingInfo bdrMappingInfo = scheduleInfo.getBaseDataRule2BaseData();
                ScheduleFacade.triggerProcessBaseData(ctx, null, billMappingInfo, bdrMappingInfo, scheduleInfo);
            } else if (type == 750) {
                String groupId = scheduleInfo.getBaseDataGroupRule2BaseData().getId().toString();
                ScheduleFacade.triggerProcessBaseDataGroup(ctx, groupId, scheduleInfo);
            } else if (type == 850) {
                MonitorManager.enterCheckMidStatusforBasedata(ctx, null, billMappingInfo.getNumber(), scheduleInfo.getId().toString());
                this.processCheckStatusForBasedata(ctx, billMappingInfo.getNumber(), scheduleInfo);
            } else if (type == 1024) {
                ScheduleTaskAction.processHttpSendData(ctx, job, scheduleInfo);
            } else if (type == 950) {
                this.processDataChangeBySnapshot(ctx, job, billMappingInfo, null);
            }
        }
        finally {
            if (isBaseDataSyn) {
                BASEDATAMAPPING_PROCESS.remove(baseDataKey);
            } else {
                BASEDATAMAPPING_PROCESS.remove(stragyId);
            }
            if (null != retParam) {
                BillFunMetuxUtil.releaseFunctionMutex(ctx, retParam.getRequestId());
            }
        }
    }

    private void checkMidStatus(Context ctx, Job job, ScheduleInfo scheduleInfo, BillMappingInfo billMappingInfo, int type) throws Exception {
        try {
            if (type == 300) {
                MonitorManager.enterCheckMidStatus(ctx, null, billMappingInfo.getNumber(), scheduleInfo.getId().toString());
            } else if (type == 850) {
                MonitorManager.enterCheckMidStatusforBasedata(ctx, null, billMappingInfo.getNumber(), scheduleInfo.getId().toString());
            }
            if (CheckMidStatus.checkByOldLogic) {
                if (type == 300) {
                    new CheckMidStatus(ctx, billMappingInfo, scheduleInfo).check();
                } else if (type == 850) {
                    ScheduleFacade.triggerProcessCheckStatus(ctx, billMappingInfo.getNumber(), null, scheduleInfo);
                }
            } else {
                new CheckMidStatus(ctx, billMappingInfo, scheduleInfo).check(type);
            }
        }
        catch (Exception e) {
            MonitorManager.error(e);
            throw e;
        }
        finally {
            MonitorManager.exit(ctx);
        }
    }

    public static void reOrderBillTask(Context ctx, ScheduleActionEnum actionType, Job job, String scheduledId, BillMappingInfo billMappingInfo, BaseDataSynHeadInfo baseDataSyninfo, Map<String, Object> param) throws Exception {
        if (actionType.getValue() == 0) {
            param.put("mappingStrategyId", billMappingInfo.getId().toString());
            ScheduleFacade.triggerProcessMidBill(ctx, param);
        } else if (actionType.getValue() != 1 && actionType.getValue() != 100 && actionType.getValue() != 200 && actionType.getValue() != 300 && actionType.getValue() != 600 && (actionType.getValue() == 400 || actionType.getValue() == 500 || actionType.getValue() == 700)) {
            param.put("baseDataSyn", String.valueOf(actionType.getValue()));
            param.put("headInfoId", baseDataSyninfo.getId().toString());
            ScheduleFacade.triggerProcessBaseDataTask(ctx, param);
        }
    }

    public static void processHttpSendData(Context ctx, Job job, ScheduleInfo scheduleInfo) throws Exception {
        JSONObject config = new JSONObject();
        JSONObject data = new JSONObject();
        IObjectPK obj = null;
        config.put("interfaceId", (Object)scheduleInfo.getWsinterface().getNumber());
        config.put("license", (Object)scheduleInfo.getWsIdentificationCode().getNumber());
        config.put("synchronized", (Object)"1");
        Timestamp lastSuccessDate = scheduleInfo.getLastSuccessTimerDate();
        Date newDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String endTime = dateFormat.format(newDate);
        data.put("starttime", (Object)dateFormat.format(lastSuccessDate));
        data.put("endtime", (Object)endTime);
        EipWebServiceFactory.getLocalInstance(ctx).httpSendService(config.toString(), data);
        scheduleInfo.setLastSuccessTimerDate(Timestamp.valueOf(endTime));
        obj = ScheduleFactory.getLocalInstance(ctx).save((CoreBaseInfo)scheduleInfo);
    }

    public static void processHttpSendDataBackGround(Context ctx, Job job, WSTransferLogInfo wstransferLogInfo) throws Exception {
        ctx.setCaller(CommonUtil.convert2PK(wstransferLogInfo.getCreator().getId().toString()));
        ctx.setUserName(wstransferLogInfo.getCreator().getNumber());
        EipWebServiceFactory.getLocalInstance(ctx).httpSendServiceBackground(wstransferLogInfo);
    }

    public static void processTaskHttpSendData(Context ctx, Job job, String config, Object data, String uniqueData, Integer retryCount) throws Exception {
        String sql = "select fid from T_EIP_UNIQUEVALUE where fid =  ('" + uniqueData + "')";
        Boolean flag = false;
        try {
            flag = EipWebServiceTaskUtil.isExistData(ctx, sql);
        }
        catch (Exception e) {
            String errmesage = "T_EIP_UNIQUEVALUE\u8868\u67e5\u627e\u6570\u636e\u5931\u8d25\uff01\u552f\u4e00\u503c\u4e3a[" + uniqueData + "]\u914d\u7f6e\u53c2\u6570\u4e3a:[" + config + "]";
            logger.error((Object)errmesage);
            throw new Exception(errmesage, e);
        }
        if (retryCount > 10) {
            flag = true;
            logger.error((Object)("\u5f02\u6b65\u4efb\u52a1\u91cd\u8bd5\u8d85\u8fc710\u6b21\uff1a\r\n" + config + "\r\n" + data.toString() + "\r\n" + uniqueData + "\r\n"));
            return;
        }
        if (flag.booleanValue()) {
            try {
                sql = "delete from T_EIP_UNIQUEVALUE where fid =  ('" + uniqueData + "')";
                ScheduleTaskAction.processTaskHttpSendData(ctx, job, config, data);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw e;
            }
            finally {
                try {
                    EipWebServiceTaskUtil.updateData(ctx, sql);
                }
                catch (Exception e1) {
                    String errmesage1 = "T_EIP_UNIQUEVALUE\u8868\u5220\u9664\u6570\u636e\u5931\u8d25\uff01\u552f\u4e00\u503c\u4e3a[" + uniqueData + "]\u914d\u7f6e\u53c2\u6570\u4e3a:[" + config + "]";
                    throw new Exception(errmesage1, e1);
                }
            }
        }
        Thread.sleep(3000L);
        EipWebServiceTaskUtil.doTaskHttpSendByInterface(ctx, config, data, uniqueData, retryCount + 1);
    }

    public static void processTaskHttpSendData(Context ctx, Job job, String config, Object data) throws Exception {
        EipWebServiceFactory.getLocalInstance(ctx).httpSendService(config, data);
    }

    public static String processBaseDataDownAndChange(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        ScheduleTaskAction.processBaseDataChange(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, userList);
        ScheduleTaskAction.processBaseDataDown(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, userList);
        return null;
    }

    public void processCheckStatusForBasedata(Context ctx, String billNumber, ScheduleInfo scheduleInfo) throws Exception {
        try {
            ScheduleFacade.triggerProcessCheckStatus(ctx, billNumber, null, scheduleInfo);
        }
        catch (Exception e) {
            MonitorManager.error(e);
            throw e;
        }
        finally {
            MonitorManager.exit(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processBaseDataDown(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        String headId = baseDataSynInfo.getId().toString();
        String connectionId = "";
        String baseDataKey = "";
        try {
            boolean isSync;
            String scheduleId;
            BaseDataResourceholder.put(ctx);
            boolean needInvalidLog = true;
            String number = baseDataSynInfo.getNumber();
            boolean isExecOne = scheduleInfo == null;
            String string = scheduleId = isExecOne ? "" : scheduleInfo.getId().toString();
            if (!StringUtils.isEmpty((String)mainSQL)) {
                baseDataSynInfo.setExtendedProperty("extMainSQL", mainSQL);
            }
            MonitorManager.enterBaseData(ctx, null, number, scheduleId, baseDataSynInfo, "\u57fa\u7840\u8d44\u6599\u540c\u6b65");
            MonitorManager.getCurrentBaseDataDown().setExtendedProperty("userList", userList);
            connectionId = isExecOne ? baseDataSynInfo.getExtendedProperty("extConnId") : scheduleInfo.getConn().getId().toString();
            Object sync = ctx.get((Object)"sync");
            boolean bl = isSync = sync != null && "true".equalsIgnoreCase(sync.toString());
            if (!isSync && isExecOne) {
                baseDataKey = headId + connectionId;
                Set<String> set = BASEDATAMAPPING_PROCESS;
                synchronized (set) {
                    block15: {
                        if (!BASEDATAMAPPING_PROCESS.contains(baseDataKey)) break block15;
                        try {
                            baseDataSynInfo.setExtendedProperty("extConnId", connectionId);
                            ScheduleFacade.enableOnce4Interface(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, "", 400, userList, 0L);
                        }
                        catch (Exception e) {
                            logger.error((Object)"\u57fa\u7840\u8d44\u6599\u540c\u6b65\u51b2\u7a81\u65f6\uff0c\u91cd\u65b0\u4e0b\u8f7d\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u51fa\u9519");
                        }
                        String string2 = "\u4efb\u52a1\u5df2\u7ecf\u4e0b\u8fbe\u7ed9\u670d\u52a1\u5668\u505a\u540e\u53f0\u6267\u884c";
                        return string2;
                    }
                    BASEDATAMAPPING_PROCESS.add(baseDataKey);
                }
            }
            ScheduleTaskAction.expandPlan(ctx, baseDataSynInfo, mainSQL, mainPKList, BaseDataSynUtil.actionTypes.get(0));
        }
        catch (Exception e) {
            MonitorManager.error(ctx, e);
            MonitorManager.setExit(true);
        }
        finally {
            BaseDataResourceholder.reset();
            if (MonitorManager.isExit()) {
                BASEDATAMAPPING_PROCESS.remove(baseDataKey);
                MonitorManager.exit(ctx);
            }
        }
        return null;
    }

    public static String processBaseDataDownByRemoteService(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        return BaseDataSynTaskByWSService.processBaseDataDownByRemoteService(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, userList);
    }

    public static String processBaseDataChangeByRemoteService(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        return BaseDataSynTaskByWSService.processBaseDataChangeByRemoteService(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, userList);
    }

    public static String processBaseDataDownAndChangeByRemoteService(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        return BaseDataSynTaskByWSService.processBaseDataDownAndChangeByRemoteService(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, userList);
    }

    public static String processBaseDataDeleteByRemoteService(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        return BaseDataSynTaskByWSService.processBaseDataDeleteByRemoteService(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, userList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processBaseDataChange(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        String headId = baseDataSynInfo.getId().toString();
        String connectionId = "";
        String baseDataKey = "";
        try {
            boolean isSync;
            String scheduleId;
            BaseDataResourceholder.put(ctx);
            String number = baseDataSynInfo.getNumber();
            boolean needInvalidLog = true;
            boolean isExecOne = scheduleInfo == null;
            String string = scheduleId = isExecOne ? "" : scheduleInfo.getId().toString();
            if (!StringUtils.isEmpty((String)mainSQL)) {
                baseDataSynInfo.setExtendedProperty("extMainSQL", mainSQL);
            }
            MonitorManager.enterBaseData(ctx, null, number, scheduleId, baseDataSynInfo, "\u57fa\u7840\u8d44\u6599\u540c\u6b65(\u68c0\u6d4b\u53d8\u5316)");
            MonitorManager.getCurrentBaseDataDown().setExtendedProperty("userList", userList);
            MonitorManager.getCurrentBaseDataDown().setExtendedProperty("interfaceResult", baseDataSynInfo.getExtendedProperty("interfaceResult"));
            connectionId = isExecOne ? baseDataSynInfo.getExtendedProperty("extConnId") : scheduleInfo.getConn().getId().toString();
            Object sync = ctx.get((Object)"sync");
            boolean bl = isSync = sync != null && "true".equalsIgnoreCase(sync.toString());
            if (!isSync && isExecOne) {
                baseDataKey = headId + connectionId;
                Set<String> set = BASEDATAMAPPING_PROCESS;
                synchronized (set) {
                    block15: {
                        if (!BASEDATAMAPPING_PROCESS.contains(baseDataKey)) break block15;
                        try {
                            baseDataSynInfo.setExtendedProperty("extConnId", connectionId);
                            ScheduleFacade.enableOnce4Interface(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, "", 500, userList, 0L);
                        }
                        catch (Exception e) {
                            logger.error((Object)"\u57fa\u7840\u8d44\u6599\u540c\u6b65\u51b2\u7a81\u65f6\uff0c\u91cd\u65b0\u4e0b\u8f7d\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u51fa\u9519");
                        }
                        String string2 = "\u4efb\u52a1\u5df2\u7ecf\u4e0b\u8fbe\u7ed9\u670d\u52a1\u5668\u505a\u540e\u53f0\u6267\u884c";
                        return string2;
                    }
                    BASEDATAMAPPING_PROCESS.add(baseDataKey);
                }
            }
            ScheduleTaskAction.expandPlan(ctx, baseDataSynInfo, mainSQL, mainPKList, BaseDataSynUtil.actionTypes.get(1));
        }
        catch (Exception e) {
            MonitorManager.error(ctx, e);
            MonitorManager.setExit(true);
        }
        finally {
            BaseDataResourceholder.reset();
            if (MonitorManager.isExit()) {
                BASEDATAMAPPING_PROCESS.remove(baseDataKey);
                MonitorManager.exit(ctx);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processBaseDataDelete(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String userList) throws Exception {
        String headId = baseDataSynInfo.getId().toString();
        String connectionId = "";
        String baseDataKey = "";
        try {
            boolean isSync;
            boolean needInvalidLog = true;
            String number = baseDataSynInfo.getNumber();
            boolean isExecOne = scheduleInfo == null;
            String scheduleId = isExecOne ? "" : scheduleInfo.getId().toString();
            MonitorManager.enterBaseData(ctx, null, number, scheduleId, baseDataSynInfo, "\u57fa\u7840\u8d44\u6599\u540c\u6b65(\u5220\u9664)");
            MonitorManager.getCurrentBaseDataDown().setExtendedProperty("userList", userList);
            connectionId = isExecOne ? baseDataSynInfo.getExtendedProperty("extConnId") : scheduleInfo.getConn().getId().toString();
            Object sync = ctx.get((Object)"sync");
            boolean bl = isSync = sync != null && "true".equalsIgnoreCase(sync.toString());
            if (!isSync && isExecOne) {
                baseDataKey = headId + connectionId;
                Set<String> set = BASEDATAMAPPING_PROCESS;
                synchronized (set) {
                    block13: {
                        if (!BASEDATAMAPPING_PROCESS.contains(baseDataKey)) break block13;
                        try {
                            baseDataSynInfo.setExtendedProperty("extConnId", connectionId);
                            ScheduleFacade.enableOnce4Interface(ctx, job, scheduleInfo, baseDataSynInfo, mainSQL, mainPKList, "", 800, userList, 0L);
                        }
                        catch (Exception e) {
                            logger.error((Object)"\u57fa\u7840\u8d44\u6599\u540c\u6b65\u51b2\u7a81\u65f6\uff0c\u91cd\u65b0\u4e0b\u8f7d\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u51fa\u9519");
                        }
                        String string = "\u4efb\u52a1\u5df2\u7ecf\u4e0b\u8fbe\u7ed9\u670d\u52a1\u5668\u505a\u540e\u53f0\u6267\u884c";
                        return string;
                    }
                    BASEDATAMAPPING_PROCESS.add(baseDataKey);
                }
            }
            ScheduleTaskAction.expandPlan(ctx, baseDataSynInfo, mainSQL, mainPKList, BaseDataSynUtil.actionTypes.get(2));
        }
        catch (Exception e) {
            MonitorManager.error(ctx, e);
            e.printStackTrace();
        }
        finally {
            BASEDATAMAPPING_PROCESS.remove(baseDataKey);
            MonitorManager.exit(ctx);
        }
        return null;
    }

    public static void expandPlan(Context ctx, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String execType) throws Exception {
        boolean isMultiPlan = baseDataSynInfo.isMultiPlan();
        ThreadBaseDataPlanSyn baseDataPlanSyn = new ThreadBaseDataPlanSyn();
        if (isMultiPlan) {
            BaseDataSynSubPlanCollection subPlans = baseDataSynInfo.getPlans();
            ArrayList<BaseDataSynSubPlanInfo> tmpList = new ArrayList<BaseDataSynSubPlanInfo>();
            for (int i = 0; i < subPlans.size(); ++i) {
                BaseDataSynSubPlanInfo tableInfo = subPlans.get(i);
                tmpList.add(tableInfo);
            }
            Collections.sort(tmpList, new Comparator<BaseDataSynSubPlanInfo>(){

                @Override
                public int compare(BaseDataSynSubPlanInfo o1, BaseDataSynSubPlanInfo o2) {
                    return o1.getSeq() - o2.getSeq();
                }
            });
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < subPlans.size(); ++i) {
                idSet.add(subPlans.get(i).getSubPlanId());
            }
            String[] idArray = idSet.toArray(new String[0]);
            IBaseDataSynHead instance = BaseDataSynHeadFactory.getLocalInstance(ctx);
            Map map = instance.convertId2CoreBaseInfo(idArray);
            for (BaseDataSynSubPlanInfo subPlanId : tmpList) {
                BaseDataSynHeadInfo subPlan = (BaseDataSynHeadInfo)map.get(subPlanId.getSubPlanId());
                subPlan.getExtendedProperties().putAll(baseDataSynInfo.getExtendedProperties());
                if (subPlan.isMultiPlan()) {
                    ScheduleTaskAction.expandPlan(ctx, subPlan, mainSQL, mainPKList, execType);
                    continue;
                }
                ScheduleTaskAction.runEachPlan(ctx, baseDataSynInfo, mainSQL, mainPKList, execType, baseDataPlanSyn, subPlan);
            }
        } else {
            ScheduleTaskAction.runEachPlan(ctx, baseDataSynInfo, mainSQL, mainPKList, execType, baseDataPlanSyn, baseDataSynInfo);
        }
    }

    private static void runEachPlan(Context ctx, BaseDataSynHeadInfo baseDataSynInfo, String mainSQL, String mainPKList, String execType, ThreadBaseDataPlanSyn baseDataPlanSyn, BaseDataSynHeadInfo subPlan) throws Exception {
        if (ThreadBaseDataSynParam.isOpenMultiThread(baseDataSynInfo.getDescription())) {
            BaseDataDownMonitorLogInfo logInfo = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
            logInfo.setExecMode(0);
            logInfo.setExtendedProperty("execMode", "\u591a\u7ebf\u7a0b");
            logInfo.setExecType(execType);
            baseDataPlanSyn.insetBaseDataPlan(baseDataSynInfo);
            subPlan.setBaseDataPlanSyn(baseDataPlanSyn);
            ThreadBaseDataPlan thradBaseDataPlan = new ThreadBaseDataPlan(ctx, subPlan, mainSQL, mainPKList, execType, baseDataPlanSyn, logInfo);
            ThreadBaseDataSynParam.planExec.submit(thradBaseDataPlan);
        } else {
            ScheduleTaskAction.execEachPlan(ctx, baseDataSynInfo, mainSQL, mainPKList, execType);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void execEachPlan(Context ctx, BaseDataSynHeadInfo baseDataSynInfo, String extendSQL, String mainPKList, String execType) throws Exception {
        BaseDataDownMonitorLogInfo baseDataDownLog;
        block21: {
            boolean isSuccess = true;
            baseDataDownLog = null;
            try {
                List<String> pkList;
                boolean isMultiThread;
                boolean isFirst;
                boolean hasNext;
                BaseDataDownExecutor executor;
                BaseDataSynTableInfo mainTableInfo;
                block24: {
                    List<String> pkList2;
                    block23: {
                        block22: {
                            boolean hasPublish = BaseDataSynUtil.checkPlanHasPublish(ctx, baseDataSynInfo);
                            if (!hasPublish) {
                                BaseDataSynPublisherFacadeFactory.getLocalInstance(ctx).publish(baseDataSynInfo.getId().toString());
                            }
                            String number = baseDataSynInfo.getNumber();
                            JSONObject obj = BaseDataResourceholder.getSpecialSQLForMultiPlan();
                            if (obj != null && obj.get((Object)baseDataSynInfo.getNumber()) != null && !StringUtils.isEmpty((String)obj.get((Object)baseDataSynInfo.getNumber()).toString())) {
                                extendSQL = obj.get((Object)baseDataSynInfo.getNumber()).toString();
                            }
                            BaseDataMainTableFactory tableFactory = new BaseDataMainTableFactory();
                            mainTableInfo = (BaseDataSynTableInfo)((BaseDataPlanFactory)tableFactory).create(ctx, BaseDataPlanFactory.Type.ID, baseDataSynInfo.getId().toString(), CacheType.SYNTABLE);
                            executor = new BaseDataDownExecutor(ctx);
                            baseDataDownLog = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
                            BaseDataResourceholder.put(ctx);
                            hasNext = true;
                            isFirst = true;
                            isMultiThread = false;
                            if (baseDataDownLog.getExecMode() == 0) {
                                isMultiThread = true;
                            }
                            if (!StringUtils.equals((String)BaseDataSynUtil.actionTypes.get(0), (String)execType)) break block22;
                            pkList2 = null;
                            break block23;
                        }
                        if (StringUtils.equals((String)BaseDataSynUtil.actionTypes.get(1), (String)execType)) {
                            pkList = null;
                            break block24;
                        } else {
                            if (!StringUtils.equals((String)BaseDataSynUtil.actionTypes.get(2), (String)execType)) break block21;
                            executor.execBaseDataDelete(baseDataSynInfo, extendSQL);
                            break block21;
                        }
                    }
                    while (hasNext) {
                        pkList2 = BaseDataSynUtil.getMainPKListForAdd(ctx, baseDataSynInfo, mainTableInfo, extendSQL, isFirst);
                        if (!pkList2.isEmpty()) {
                            baseDataDownLog.addChangeCount(pkList2.size());
                            if (isMultiThread) {
                                executor.execBaseDataByType(baseDataSynInfo, pkList2, mainTableInfo, extendSQL, baseDataDownLog, isFirst, null);
                                ScheduleTaskAction.removeMapByBaseDataSyn(baseDataDownLog);
                                return;
                            }
                            executor.execBaseDataDown(baseDataSynInfo, pkList2);
                        } else {
                            if (isMultiThread) {
                                baseDataDownLog.setExit(true);
                            }
                            hasNext = false;
                        }
                        isFirst = false;
                    }
                    break block21;
                }
                while (hasNext) {
                    pkList = BaseDataSynUtil.getMainPKListForUpdate(ctx, baseDataSynInfo, mainTableInfo, extendSQL, isFirst);
                    if (!pkList.isEmpty()) {
                        baseDataDownLog.addChangeCount(pkList.size());
                        if (isMultiThread) {
                            executor.execBaseDataByType(baseDataSynInfo, pkList, mainTableInfo, extendSQL, baseDataDownLog, isFirst, null);
                            ScheduleTaskAction.removeMapByBaseDataSyn(baseDataDownLog);
                            return;
                        }
                        executor.execBaseDataUpdate(baseDataSynInfo, pkList);
                    } else {
                        if (isMultiThread) {
                            baseDataDownLog.setExit(true);
                        }
                        hasNext = false;
                    }
                    isFirst = false;
                    if (BaseDataSynUtil.MAXCOUNT <= pkList.size()) continue;
                    hasNext = false;
                }
            }
            catch (Throwable e) {
                try {
                    isSuccess = false;
                    throw new Exception(e);
                }
                catch (Throwable throwable) {
                    ScheduleTaskAction.removeMapByBaseDataSyn(baseDataDownLog);
                    throw throwable;
                }
            }
        }
        ScheduleTaskAction.removeMapByBaseDataSyn(baseDataDownLog);
        return;
    }

    public static void removeMapByBaseDataSyn(BaseDataDownMonitorLogInfo baseDataDownLog) {
        Map<String, String> mainId_ChangeTime_map;
        if (null != baseDataDownLog && !(mainId_ChangeTime_map = baseDataDownLog.getMainId_ChangeTime_map()).isEmpty()) {
            mainId_ChangeTime_map.clear();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void processMatchBaseData(Context ctx, Job job, ScheduleInfo scheduleInfo, BaseDataMapingInfo baseDataMapingInfo, Map<String, Object> param) throws Exception {
        int currentThead;
        String connId;
        block7: {
            connId = null;
            currentThead = 0;
            BaseDataTypeInfo typeInfo = BaseDataTypeFactory.getLocalInstance(ctx).getBaseDataTypeInfo(CommonUtil.convert2PK(baseDataMapingInfo.getBaseDataType().getId().toString()));
            connId = typeInfo.getConn().getId().toString();
            if (!CURRENT_BASE_DATA_THREAD.containsKey(connId)) {
                CURRENT_BASE_DATA_THREAD.put(connId, currentThead);
            }
            if ((currentThead = CURRENT_BASE_DATA_THREAD.get(connId).intValue()) < MAX_BASE_DATA_THREAD) break block7;
            CURRENT_BASE_DATA_THREAD.put(connId, currentThead);
            MonitorManager.exit(ctx);
            return;
        }
        try {
            CURRENT_BASE_DATA_THREAD.put(connId, currentThead + 1);
            MonitorManager.enterAutoMatchBaseData(ctx, null, baseDataMapingInfo.getNumber(), scheduleInfo.getId().toString());
            new AutoMatchBaseData(ctx, baseDataMapingInfo, scheduleInfo).process();
            CURRENT_BASE_DATA_THREAD.put(connId, currentThead);
        }
        catch (ObjectNotFoundException ne) {
            try {
                ScheduleFacade.disable(ctx, scheduleInfo);
                MonitorManager.error(ne);
                throw ne;
                catch (Exception e) {
                    MonitorManager.error(e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                CURRENT_BASE_DATA_THREAD.put(connId, currentThead);
                MonitorManager.exit(ctx);
                throw throwable;
            }
        }
        MonitorManager.exit(ctx);
        return;
    }

    private void processCheckMidStatus(Context ctx, Job job, ScheduleInfo scheduleInfo, BillMappingInfo billMappingInfo, Map<String, Object> param) throws Exception {
        try {
            MonitorManager.enterCheckMidStatus(ctx, null, billMappingInfo.getNumber(), scheduleInfo.getId().toString());
            new CheckMidStatus(ctx, billMappingInfo, scheduleInfo).check();
        }
        catch (Exception e) {
            MonitorManager.error(e);
            throw e;
        }
        finally {
            MonitorManager.exit(ctx);
        }
    }

    @Override
    public void processMidBill(Context ctx, Job job, BillMappingInfo billMappingInfo, Map<String, Object> param) throws Exception {
        try {
            MonitorManager.enterSrcToMidBill(ctx, null, billMappingInfo.getNumber(), null);
            StructuredDataModel dataModel = DataModelUtil.convert(billMappingInfo);
            MiddleBillDataProvider dataProvider = new MiddleBillDataProvider(dataModel);
            DataExtractor dataExtractor = new DataExtractor(dataProvider, dataModel);
            dataExtractor.extract(ctx, param, true);
        }
        catch (Exception e) {
            MonitorManager.error(e);
            throw e;
        }
        finally {
            MonitorManager.exit(ctx);
        }
    }

    private static boolean threadLock(Context ctx, Job job, String threadName) {
        int theadUbound = 1;
        if (ctx == null || threadName == null || theadUbound <= 0) {
            return true;
        }
        int[] types = new int[]{12};
        Object[] objs = new Object[]{threadName};
        String sql = "select fname from t_job_thread where fname=?";
        try {
            if (SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])objs).size() == 0) {
                sql = "insert into t_job_thread(fname, fcount, ftime) values('" + threadName + "',0,getdate())";
                SQL.executeUpdate((Context)ctx, (String)sql);
            }
            sql = "update t_job_thread set fcount=fcount+1,ftime=getdate() where fname=? and fcount<?";
            types = new int[]{12, 4};
            objs = new Object[]{threadName, String.valueOf(theadUbound)};
            return SQL.executeUpdate((Context)ctx, (String)sql, (int[])types, (Object[])objs) >= 1;
        }
        catch (Throwable t) {
            logger.error((Object)("threadLock job " + job + " failed!"));
            return false;
        }
    }

    private static void threadUnlock(Context ctx, Job job, String threadName) {
        int theadUbound = 1;
        if (ctx == null || threadName == null || theadUbound <= 0) {
            return;
        }
        try {
            String sql = "update t_job_thread set fcount=fcount-1,ftime=getdate() where fname='" + threadName + "' and fcount>0";
            SQL.executeUpdate((Context)ctx, (String)sql);
        }
        catch (Throwable t) {
            logger.error((Object)("threadUnlock job " + job + " failed!"));
        }
    }

    @Override
    public void processBOTP(Context ctx, Job job, String scheduledId, String botpId, BillMappingInfo billMappingInfo, Map<String, Object> param) throws Exception {
        BOTMappingInfo botMapping = DBFacade.getBotMapping(ctx, botpId);
        DesBIllCreator desBIllCreator = new DesBIllCreator(ctx, scheduledId, billMappingInfo.getNumber(), botMapping, billMappingInfo.getCashFlowRelation(), billMappingInfo.isIntegrateCashFlow(), billMappingInfo.getEasCashFlowRelation(), billMappingInfo.isIntergrateEASCashFlow(), billMappingInfo.getAssistAccountRelation(), billMappingInfo.isIntegrateEasAssAcc());
        desBIllCreator.botp2DesBill();
    }

    private void processDataChangeBySnapshot(Context ctx, Job job, BillMappingInfo billMappingInfo, Map<String, Object> param) throws Exception {
        this.processDataChange(ctx, job, billMappingInfo, null);
    }

    public void processDataChange(Context ctx, Job job, BillMappingInfo billMappingInfo, String filter) throws Exception {
        boolean isSnapshot = billMappingInfo.isNeedResetSnapshot();
        this.innerProcessDataChange(ctx, job, billMappingInfo, filter, isSnapshot);
    }

    private boolean innerProcessDataChange(Context ctx, Job job, BillMappingInfo billMappingInfo, String filter, boolean isSnapshot) throws Exception {
        boolean isSuccess = false;
        try {
            SnapshotDataChangeMonitorLogInfo monitorLogInfo = MonitorManager.enterSnapshotDataChange(ctx, "\u8c03\u5ea6\u7b56\u7565", billMappingInfo.getNumber());
            monitorLogInfo.setSynchronizedUpdate(billMappingInfo.isSrcChangeReGenerate());
            monitorLogInfo.setAgent(DataSourceType.agent.equals((Object)billMappingInfo.getDsType()));
            new Snapshot(ctx, billMappingInfo, isSnapshot, filter).startSnapShot();
            isSuccess = true;
        }
        catch (Exception e) {
            MonitorManager.error(e);
            throw e;
        }
        finally {
            MonitorManager.exit(ctx);
        }
        return isSuccess;
    }

    public void updateBalance(Context ctx, String voucherId) throws BOSException, SecurityException, NoSuchMethodException {
        VoucherInfo voucher = null;
        try {
            voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getVoucherWithoutPermissionCheck(CommonUtil.convert2PK(voucherId));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (voucher == null) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        String companyId = voucher.getCompany().getId().toString();
        DataBaseInfo table = this.getAccountTableCollection(ctx, companyId).get(0);
        param.put("table", table.getId().toString());
        param.put("company", companyId);
        try {
            Class<?> c = Class.forName("com.kingdee.eas.fi.gl.BalanceFunEnum");
            Constructor<?> cons = c.getConstructor(String.class, Integer.TYPE);
            Object[] args = new Object[]{"CURAMOUNT", 1};
            param.put("function", cons.newInstance(args));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        param.put("post", true);
        param.put("periodfrom", (CoreBaseInfo)voucher.get("period"));
        param.put("periodto", (CoreBaseInfo)voucher.get("period"));
        param.put("selectedAV", new ArrayList());
        try {
            String userid = ctx.getCaller().toString();
            String clientIP = null;
            String datacenter = ctx.getAIS();
            String orgid = null;
            try {
                ctx = Ctx.getContext((String)datacenter, (String)userid, orgid, clientIP);
            }
            catch (BOSException e1) {
                logger.error((Object)e1);
            }
            Class<?> periodFactory = Class.forName("com.kingdee.eas.fi.gl.PeriodTransFacadeFactory");
            Method method = periodFactory.getMethod("getLocalInstance", Context.class);
            Object periodFacadeObj = method.invoke(periodFactory, ctx);
            Class<?> facade = periodFacadeObj.getClass();
            Method method2 = facade.getMethod("check", Map.class);
            method2.invoke(periodFacadeObj, param);
            Class<?> gLBalanceFacadeFactory = Class.forName("com.kingdee.eas.fi.gl.GLBalanceFacadeFactory");
            Method balanceMethod = gLBalanceFacadeFactory.getMethod("getLocalInstance", Context.class);
            Object balanceFacadeObj = balanceMethod.invoke(periodFactory, ctx);
            Class<?> balanceFacade = balanceFacadeObj.getClass();
            Method method3 = balanceFacade.getMethod("updateVoucherBalance", String[].class);
            method3.invoke(balanceFacadeObj, (Object[])new String[]{companyId});
            Method method4 = facade.getMethod("doOK", Map.class);
            method4.invoke(periodFacadeObj, param);
        }
        catch (Exception e2) {
            logger.error((Object)("\u91cd\u7b97\u79d1\u76ee\u4f59\u989d\u8868\u51fa\u9519" + e2.getMessage()));
            e2.printStackTrace();
        }
    }

    public DataBaseCollection getAccountTableCollection(Context ctx, String companyId) throws BOSException {
        DataBaseCollection tableInfosNew = new DataBaseCollection();
        ArrayList<String> tableIdList = new ArrayList<String>();
        EntityViewInfo eviForCtrl = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)companyId));
        eviForCtrl.setFilter(filter);
        eviForCtrl.getSelector().add("accountTableID.*");
        DataBaseCollection acctCtrlCols = (DataBaseCollection)DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(new BOSObjectType("DEBAF4DF"), eviForCtrl);
        if (acctCtrlCols != null) {
            int count = acctCtrlCols.size();
            for (int i = 0; i < count; ++i) {
                DataBaseInfo acctCtrlInfo = acctCtrlCols.get(i);
                tableIdList.add(((DataBaseInfo)acctCtrlInfo.get("accountTableID")).getId().toString());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        DataBaseCollection tableInfos = (DataBaseCollection)DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(new BOSObjectType("17698E6D"), evi);
        for (DataBaseInfo tableInfo : tableInfos) {
            if (!tableIdList.contains(tableInfo.getId().toString())) continue;
            tableInfosNew.add(tableInfo);
        }
        return tableInfosNew;
    }

    private Context createContext(Job job, ScheduleInfo scheduleInfo) {
        Context ctx = job.getContext();
        String userid = scheduleInfo.getCreator().getId().toString();
        System.out.println("\u542f\u7528\u7684 userid = " + userid + ",\u8c03\u5ea6\u7b56\u7565\u540d\u79f0\uff1a" + scheduleInfo.getSimpleName());
        String clientIP = null;
        String datacenter = ctx.getAIS();
        String orgid = null;
        try {
            ctx = Ctx.getContext((String)datacenter, (String)userid, orgid, clientIP);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        return ctx;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void desBill(Context context, Job job, String scheduId, BillMappingInfo billMapping, BOTMappingInfo botpInfo, Integer assignmentNumber) throws Exception {
        AbstractDestBillTransferObject tranferOject = null;
        if (TranferType.oneToOne.equals((Object)billMapping.getTransferType())) {
            tranferOject = new TransferOneTOneImpl(context, scheduId, null, botpInfo, billMapping, assignmentNumber);
        } else if (billMapping.getTransferType() == null || billMapping.getTransferType().equals((Object)TranferType.mutiToMuti) || billMapping.getTransferType().equals((Object)TranferType.multiToOne)) {
            tranferOject = new TransferMutiToMutiImpl(context, scheduId, null, botpInfo, billMapping, assignmentNumber);
        }
        try {
            if (tranferOject == null) {
                throw new NullPointerException("tranferOject\u4e3anull");
            }
            tranferOject.invokeTransfer();
        }
        catch (Exception e) {
            logger.error((Object)("\u3010\u8f6c\u6362\u5355\u636e\u51fa\u9519\u3011" + e.getMessage()));
        }
    }
}

