/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.app.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.DynamicBillTemplateCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.billmapping.MidBillDataProcessFacadeFactory;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BOTPUtil {
    public static void botp(Context ctx, String midTable, CoreBillBaseCollection bills, BOTMappingInfo botMapping) throws Exception {
        CoreBillBaseCollection src = BOTPUtil.getSrcBillsUnTransfered(ctx, bills, botMapping.getDestEntityName());
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = new BTPTransformResult();
        try {
            btpResult = iBTPManager.transformForBotp(src, botMapping.getDestEntityName(), CommonUtil.convert2PK(botMapping.getId().toString()));
        }
        catch (BTPException e) {
            if (e.getMessage().indexOf("\u96c6\u5408\u4e0d\u7b26\u5408\u8f6c\u6362\u89c4\u5219\u7684\u6570\u636e\u8fc7\u6ee4\u6761\u4ef6") > -1) {
                btpResult.setBills(null);
            }
            throw e;
        }
        MonitorManager.getCurrentMidBillToDest().setTransformResult(btpResult);
        BOTPUtil.saveBotpBill(ctx, btpResult, iBTPManager);
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < src.size(); ++i) {
            idList.add(src.get(i).getId().toString());
        }
        MidBillDataProcessFacadeFactory.getLocalInstance(ctx).setMidBillStatus(midTable, idList.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMidBillStatus(Context ctx, Map<String, Set<String>> cashflowIDMap, String midTableName) throws BOSException {
        HashSet<String> srcBillIdSet = new HashSet<String>();
        HashSet<String> srcIdSet = new HashSet<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        for (Map.Entry<String, Set<String>> item : cashflowIDMap.entrySet()) {
            srcBillIdSet.add(item.getKey());
            for (String str : item.getValue()) {
                srcIdSet.add(str);
            }
            sql.append("'").append(item.getKey()).append("'").append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        MidBillDataProcessFacadeFactory.getLocalInstance(ctx).setMidBillEntryStatus(midTableName + "Entry", srcIdSet.toArray(new String[0]));
        try {
            if (!srcBillIdSet.isEmpty()) {
                MidBillDataProcessFacadeFactory.getLocalInstance(ctx).setMidBillStatus(midTableName, srcBillIdSet.toArray(new String[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateMidBillStatus(Context ctx, DynamicBillTemplateCollection src, String midTableName) throws BOSException {
        HashSet<String> srcBillIdSet = new HashSet<String>();
        HashSet<String> srcIdSet = new HashSet<String>();
        Iterator its = src.iterator();
        while (its.hasNext()) {
            DynamicBillTemplateInfo bill = (DynamicBillTemplateInfo)its.next();
            srcBillIdSet.add(bill.getId().toString());
            DynamicBillTemplateEntryCollection entrys = bill.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicBillTemplateEntryInfo entry = entrys.get(i);
                if (StringUtils.isEmpty((String)entry.getId().toString())) continue;
                srcIdSet.add(entry.getId().toString());
            }
        }
        MidBillDataProcessFacadeFactory.getLocalInstance(ctx).setMidBillEntryStatus(midTableName + "Entry", srcIdSet.toArray(new String[0]));
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        for (String str : srcBillIdSet) {
            sql.append("'").append(str).append("'").append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        try {
            Connection connection = DBUtils.getConnection(ctx);
            PreparedStatement preparedStatement = connection.prepareStatement("select  distinct(bill.fid)\u3000from " + midTableName + " bill  left join " + midTableName + "Entry billEntry on billEntry.fparentid = bill.fid  where (billEntry.fentryStatus  = 0 or billEntry.fentryStatus  is null) and bill.fid in " + sql.toString());
            ResultSet rs = preparedStatement.executeQuery();
            HashSet<String> resultSet = new HashSet<String>();
            while (rs.next()) {
                String billId = rs.getString(1);
                resultSet.add(billId);
            }
            srcBillIdSet.removeAll(resultSet);
            if (!srcBillIdSet.isEmpty()) {
                MidBillDataProcessFacadeFactory.getLocalInstance(ctx).setMidBillStatus(midTableName, srcBillIdSet.toArray(new String[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void saveBotpBill(Context ctx, BTPTransformResult result, IBTPManager iBtpManager) throws BOSException, EASBizException {
        IObjectCollection destBillCols = result.getBills();
        if (destBillCols == null) {
            return;
        }
        BOTRelationCollection botRelationCols = result.getBOTRelationCollection();
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            iBtpManager.saveRelations(destBillInfo, botRelationCols);
        }
    }

    private static CoreBillBaseCollection getSrcBillsUnTransfered(Context ctx, CoreBillBaseCollection bills, String destBillTypeBOSType) throws BOSException {
        ArrayList<String> idlist = new ArrayList<String>();
        for (int i = 0; i < bills.size(); ++i) {
            idlist.add(bills.get(i).getId().toString());
        }
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        if (relations == null || relations.size() == 0) {
            return bills;
        }
        HashSet<String> srcIdSet = new HashSet<String>();
        for (BOTRelationInfo relation : relations) {
            srcIdSet.add(relation.getSrcObjectID());
        }
        CoreBillBaseCollection src = new CoreBillBaseCollection();
        for (CoreBillBaseInfo bill : bills) {
            String id = bill.getId().toString();
            if (!srcIdSet.contains(id)) {
                src.add(bill);
                continue;
            }
            System.out.println(id + "\u5df2\u7ecf\u751f\u6210\u76ee\u6807\u5355\u636e!");
        }
        return src;
    }

    public static void updateMidBillStatusEasCash(Context ctx, Map<String, Set<String>> cashflowIDMap, String midTableName) throws BOSException {
        HashSet<String> srcBillIdSet = new HashSet<String>();
        HashSet<String> srcIdSet = new HashSet<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        for (Map.Entry<String, Set<String>> item : cashflowIDMap.entrySet()) {
            srcBillIdSet.add(item.getKey());
            for (String str : item.getValue()) {
                srcIdSet.add(str);
            }
            sql.append("'").append(item.getKey()).append("'").append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        String billNumber = midTableName.substring("CT_EIP_".length());
        DIPMetadata dm = new DIPMetadata(billNumber);
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        String entryStatus = entrysEntityInfo.getPropertyByName("entryStatus").getMappingField().getName();
        String assignmentNumber = entrysEntityInfo.getPropertyByName("assignmentNumber").getMappingField().getName();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            connection = DBUtils.getConnection(ctx);
            String jobNumber = "";
            if (MonitorManager.getCurrentMidBillToDest() != null) {
                jobNumber = MonitorManager.getCurrentMidBillToDest().getAssignNumber();
            }
            StringBuilder queryString = new StringBuilder();
            queryString.append(" update ").append(midTableName + "Entry").append(" set ").append(" " + assignmentNumber + "= '").append(jobNumber).append("' ,").append(" " + entryStatus + "= ? ").append(" where fid = ?");
            preparedStatement = connection.prepareStatement(queryString.toString());
            for (String id : srcIdSet) {
                preparedStatement.setObject(1, 1);
                preparedStatement.setObject(2, id);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement = connection.prepareStatement("select  distinct(bill.fid)\u3000from " + midTableName + " bill  left join " + midTableName + "Entry billEntry on billEntry.fparentid = bill.fid  where (billEntry." + entryStatus + "  = 0 or billEntry." + entryStatus + "  is null) and bill.fid in " + sql.toString());
            rs = preparedStatement.executeQuery();
            HashSet<String> resultSet = new HashSet<String>();
            while (rs.next()) {
                String billId = rs.getString(1);
                resultSet.add(billId);
            }
            srcBillIdSet.removeAll(resultSet);
            if (!srcBillIdSet.isEmpty()) {
                preparedStatement = connection.prepareStatement("update " + midTableName + " set fmidbillstatus=?,ffivouchered=?  where fid=?");
                for (String id : srcBillIdSet) {
                    preparedStatement.setObject(1, 1);
                    preparedStatement.setObject(2, 1);
                    preparedStatement.setObject(3, id);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, preparedStatement, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)preparedStatement, (Connection)connection);
    }
}

