/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.schedule.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.runtime.BotEngineNew;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryCollection;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DestBillBatchUtil {
    private static final Logger logger = CoreUIObject.getLogger(DestBillBatchUtil.class);
    public static final String entryReation = "parent";
    public static final String botpSplitTag = "\\.";
    public static int maxGroupNumber = 50;
    public static final String bidBillAssigNumber_table = "T_EIP_MidBillAssignumber";
    public static final String assigBill_Table = "T_EIP_AssigNumberBills";
    public static int billGroupSize = 1;

    public static Map<String, String> findBotpGroupRule(Context ctx, BOTMappingInfo botMapping) throws BOSException {
        Map resultMap = null;
        try {
            BotEngineNew botEngineNew = new BotEngineNew(ctx);
            Method method = botEngineNew.getClass().getMethod("groupAttribute", Class.forName("java.lang.String"));
            resultMap = (Map)method.invoke((Object)botEngineNew, botMapping.getId().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    public static String findTableEntityMap(Map<String, String> map, BillMappingInfo billMappingInfo, Map<String, Boolean> typeMap, Map<String, String> tableEntryMap) throws BOSException {
        StringBuilder groupByBuilder = new StringBuilder();
        try {
            for (String entryValue : map.keySet()) {
                String tablevalue = map.get(entryValue);
                String[] entryAndField = entryValue.split(botpSplitTag);
                String[] tableAndField = tablevalue.split(botpSplitTag);
                if (tableAndField[0].equalsIgnoreCase(billMappingInfo.getMidBillEntryTable())) {
                    typeMap.put(tableAndField[1].toUpperCase(), false);
                } else if (tableAndField[0].equalsIgnoreCase(billMappingInfo.getMidBillTable())) {
                    typeMap.put(tableAndField[1].toUpperCase(), true);
                }
                tableEntryMap.put(tableAndField[1].toUpperCase(), entryAndField[1]);
                groupByBuilder.append(tablevalue).append(",");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return groupByBuilder.deleteCharAt(groupByBuilder.length() - 1).toString();
    }

    public static CoreBillBaseCollection convertBillEntryColl2BillColl(DynamicBillTemplateEntryCollection entrys) {
        CoreBillBaseCollection sourceBill = new CoreBillBaseCollection();
        HashMap<String, DynamicBillTemplateEntryCollection> headEntrMap = new HashMap<String, DynamicBillTemplateEntryCollection>();
        HashMap<String, DynamicBillTemplateInfo> headIdInfoMap = new HashMap<String, DynamicBillTemplateInfo>();
        for (int index = 0; index < entrys.size(); ++index) {
            DynamicBillTemplateEntryInfo entryInfo = entrys.get(index);
            DynamicBillTemplateInfo headInfo = (DynamicBillTemplateInfo)entryInfo.get(entryReation);
            String parentId = headInfo.getId().toString();
            if (!headIdInfoMap.containsKey(parentId)) {
                headIdInfoMap.put(parentId, headInfo);
            }
            if (headEntrMap.containsKey(parentId)) {
                ((DynamicBillTemplateEntryCollection)((Object)headEntrMap.get(parentId))).add(entryInfo);
                continue;
            }
            DynamicBillTemplateEntryCollection entryList = new DynamicBillTemplateEntryCollection();
            entryList.add(entryInfo);
            headEntrMap.put(parentId, entryList);
        }
        for (String billId : headIdInfoMap.keySet()) {
            DynamicBillTemplateInfo billInfo = (DynamicBillTemplateInfo)headIdInfoMap.get(billId);
            billInfo.getEntrys().addCollection((DynamicBillTemplateEntryCollection)((Object)headEntrMap.get(billId)));
            sourceBill.add((CoreBillBaseInfo)billInfo);
        }
        return sourceBill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getMaxAssNumberByBillMapiing(Context ctx, BillMappingInfo info) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Integer maxNumber = 1;
        try {
            connection = DBUtils.getConnection(ctx);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
            preparedStatement = connection.prepareStatement("update T_EIP_MidBillAssignumber set fassignmentNumber = fassignmentNumber  where fbillMappingId = ?");
            preparedStatement.setObject(1, info.getId().toString());
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("select fassignmentNumber  from  T_EIP_MidBillAssignumber where fbillMappingId ='" + info.getId().toString() + "'");
            ResultSet max = preparedStatement.executeQuery();
            if (max.next()) {
                maxNumber = Integer.valueOf(max.getString(1));
                preparedStatement = connection.prepareStatement("update T_EIP_MidBillAssignumber set fassignmentNumber = ?  where fbillMappingId = ?");
            } else {
                preparedStatement = connection.prepareStatement("insert into T_EIP_MidBillAssignumber(fassignmentNumber,fbillMappingId) values(?,?)");
            }
            preparedStatement.setObject(1, maxNumber + 1);
            preparedStatement.setObject(2, info.getId().toString());
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception e) {
            logger.error((Object)e);
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                logger.error((Object)e1);
            }
        }
        finally {
            SQLUtil.cleanup(connection);
        }
        return maxNumber;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insertAssignBills(Context ctx, Integer assignmentNumber, Set<String> billIds, String billMappingId) throws Exception {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            ArrayList<String> listIds = new ArrayList<String>(billIds);
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("insert into T_EIP_AssigNumberBills(fassignmentNumber ,fmidBillIds ,fbillMappingId)  values(?,?,?)");
            int pageCount = (listIds.size() - 1) / billGroupSize + 1;
            for (int i = 0; i < pageCount; ++i) {
                List subList = null;
                StringBuilder sb = new StringBuilder();
                subList = i < pageCount - 1 ? listIds.subList(i * billGroupSize, (i + 1) * billGroupSize) : listIds.subList(i * billGroupSize, listIds.size());
                for (int j = 0; j < subList.size(); ++j) {
                    sb.append((String)subList.get(j)).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                preparedStatement.setObject(1, assignmentNumber);
                preparedStatement.setObject(2, sb.toString());
                preparedStatement.setObject(3, billMappingId);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            try {
                connection.commit();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw e;
                catch (Exception e1) {
                    logger.error((Object)e1);
                    throw e1;
                }
            }
            catch (Throwable throwable) {
                SQLUtil.cleanup(connection);
                throw throwable;
            }
        }
        SQLUtil.cleanup(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getBillByAssignNumber(Context ctx, Integer assignmentNumber, String billMappingId) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        HashSet<String> result = new HashSet<String>();
        try {
            connection = DBUtils.getConnection(ctx);
            preparedStatement = connection.prepareStatement("select fmidBillIds  from  T_EIP_AssigNumberBills where fassignmentNumber = ? and fbillMappingId =?");
            preparedStatement.setObject(1, assignmentNumber);
            preparedStatement.setObject(2, billMappingId);
            ResultSet set = preparedStatement.executeQuery();
            while (set.next()) {
                String str = set.getString(1);
                String[] strSplit = str.split(",");
                for (int i = 0; i < strSplit.length; ++i) {
                    result.add(strSplit[i]);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtil.cleanup(connection);
        }
        return result;
    }
}

