/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.billmapping.SqlResult;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.app.AbstractSQLFacadeControllerBean;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class SQLFacadeControllerBean
extends AbstractSQLFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.syncdatabase.app.SQLFacadeControllerBean");
    private Context ctx;

    @Override
    protected IRowSet _getRowset(Context ctx, String StrSQL) throws BOSException {
        IRowSet rs = SQLFacadeControllerBean.executeQueryNoTx(ctx, StrSQL);
        return rs;
    }

    private static IRowSet executeQueryNoTx(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("555 is:" + sql), (Throwable)exc);
                throw new BOSException("Sql5 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    @Override
    protected boolean _exeSQL(Context ctx, String StrSQL) throws BOSException {
        SQLFacadeControllerBean.execute(ctx, StrSQL);
        return false;
    }

    private static void execute(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.error((Object)("sql 1 sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _DBConnection(Context ctx, String DBtype, String IP, String Port, String DBName, String UserName, String PasssWord) throws BOSException, EASBizException {
        ConnectionInfo ConnectionInfo2 = new ConnectionInfo();
        if (DBtype.equalsIgnoreCase("oracle")) {
            ConnectionInfo2.setDBType(DBType.Oracle);
        } else if (DBtype.equalsIgnoreCase("sqlserver")) {
            ConnectionInfo2.setDBType(DBType.SQLServer);
        } else if (DBtype.equalsIgnoreCase("db2")) {
            ConnectionInfo2.setDBType(DBType.DB2);
        } else if (DBtype.equalsIgnoreCase("mysql")) {
            ConnectionInfo2.setDBType(DBType.MySql);
        } else if (DBtype.equalsIgnoreCase("PostgreSQL")) {
            ConnectionInfo2.setDBType(DBType.PostgreSQL);
        } else {
            ConnectionInfo2.setDBType(DBType.Oracle);
        }
        ConnectionInfo2.setIP(IP);
        ConnectionInfo2.setPassword(PasssWord);
        ConnectionInfo2.setPort(Integer.parseInt(Port));
        ConnectionInfo2.setUsername(UserName);
        ConnectionInfo2.setInstance(DBName);
        Connection con = null;
        try {
            con = this.getConn(ConnectionInfo2);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private Connection getConn(ConnectionInfo connectionInfo) throws BOSException {
        String DBtype = connectionInfo.getDBType().getName().toString();
        DataBaseType dataBaseType = DataBaseType.getInstance(DBtype);
        String IP = connectionInfo.getIP();
        String DB = connectionInfo.getInstance();
        int port = connectionInfo.getPort();
        String username = connectionInfo.getUsername();
        String password = connectionInfo.getPassword();
        try {
            return KSQLUtil.getKSQLConnection(dataBaseType, IP, port, DB, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeFunction(Context ctx, ConnectionInfo conn, String function, List rptList) throws BOSException, EASBizException {
        Connection conn1 = this.getConn(conn);
        Object result = null;
        try {
            result = this.callFunction(conn1, function, rptList);
        }
        finally {
            SQLUtils.cleanup((Connection)conn1);
        }
        return result;
    }

    private Object callFunction(Connection conn, String function, List rpt) throws SQLDataException {
        CallableStatement cstmt = null;
        Object rs = null;
        String callSql = function;
        try {
            cstmt = conn.prepareCall(callSql);
            int n = rpt.size();
            for (int i = 0; i < n; ++i) {
                cstmt.setObject(i + 2, rpt.get(i));
            }
            cstmt.registerOutParameter(1, 12);
            cstmt.execute();
            rs = cstmt.getObject(1);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)cstmt);
        }
        return rs;
    }

    @Override
    public IRowSet getTargetRowset(Context ctx, ConnectionInfo connectionInfo, String StrSQL) throws BOSException, EASBizException {
        IRowSet iRowSet;
        ResultSet rs = null;
        Statement statement = null;
        Connection con = null;
        try {
            con = this.getConn(connectionInfo);
            statement = con.createStatement();
            rs = statement.executeQuery(StrSQL);
            iRowSet = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
        return iRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _executeBatch(Context ctx, IObjectValue connInfo, List sqls) throws BOSException, EASBizException {
        Connection conn = this.getConn((ConnectionInfo)connInfo);
        String[] arrSqlStr = new String[sqls.size()];
        int n = sqls.size();
        for (int i = 0; i < n; ++i) {
            arrSqlStr[i] = (String)sqls.get(i);
        }
        try {
            if (this.supportBatch(conn)) {
                this.goBatch(conn, arrSqlStr);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean supportBatch(Connection con) {
        try {
            DatabaseMetaData md = con.getMetaData();
            return md.supportsBatchUpdates();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] goBatch(Connection con, String[] sqls) throws SQLException {
        if (sqls == null) {
            return null;
        }
        Statement sm = null;
        try {
            sm = con.createStatement();
            for (int i = 0; i < sqls.length; ++i) {
                sm.addBatch(sqls[i]);
            }
            int[] i = sm.executeBatch();
            return i;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (null != sm) {
                sm.close();
            }
        }
        return null;
    }

    public boolean updateExecute(Context ctx, ConnectionInfo connectionInfo, String StrSQL) throws BOSException, EASBizException {
        boolean bl;
        Connection con = null;
        Statement statement = null;
        try {
            con = this.getConn(connectionInfo);
            statement = con.createStatement();
            bl = statement.execute(StrSQL);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)con);
        return bl;
    }

    @Override
    protected SqlResult _exeClientSql(Context ctx, ConnectionInfo connectionInfo, String ksql) throws BOSException, EASBizException {
        Connection con = null;
        ResultSet rs = null;
        Statement state = null;
        SqlResult sqlRst = new SqlResult();
        DataBaseType dbType = DataBaseType.getInstance(connectionInfo.getDBType().getName());
        try {
            try {
                con = KSQLUtil.getKSQLConnection(dbType, connectionInfo.getIP(), connectionInfo.getPort(), connectionInfo.getInstance(), connectionInfo.getUsername(), connectionInfo.getPassword());
            }
            catch (Exception e) {
                throw new Exception("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u3010\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u3011\u7684\u914d\u7f6e\u3002");
            }
            state = con.createStatement();
            System.out.println("executeQuery ksql :" + ksql);
            boolean s = state.execute(ksql);
            sqlRst.setUpdateCount(state.getUpdateCount());
            do {
                if ((rs = state.getResultSet()) == null) continue;
                JdbcRowSet jdbcRS = new JdbcRowSet();
                jdbcRS.populate(rs, 6500);
                sqlRst.getRowSets().add(jdbcRS);
                SQLUtils.cleanup((ResultSet)rs);
            } while (state.getMoreResults());
        }
        catch (Exception ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, state, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)state, (Connection)con);
        return sqlRst;
    }
}

