/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.eas.csinterface.basedatasyn.app.util.KeyTableUtil;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BaseDataFieldFixUtil {
    private static Logger logger = Logger.getLogger(BaseDataFieldFixUtil.class);
    private static final String CHECK_PK_FIELD_EXIST = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME=''FID'' AND KSQL_COL_TABNAME=''{0}'' ";
    private static final String ADD_PK_FIELD = "/*dialect*/ALTER TABLE {0} ADD FID VARCHAR(44) DEFAULT {1} NOT NULL";
    private static final String CREATE_UNIQUE_INDEX = "CREATE UNIQUE INDEX {0} ON {1}(FID)";
    private static final String CHECK_FLASTUPDATETIME_FIELD_EXIST = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME=''FLASTUPDATETIME'' AND KSQL_COL_TABNAME=''{0}'' ";
    private static final String ADD_FLASTUPDATETIME_FIELD = "ALTER TABLE {0} ADD FLASTUPDATETIME DATETIME DEFAULT {1} NOT NULL";
    private static final String CREATE_FLASTUPDATETIME_UNIQUE_INDEX = "/*dialect*/CREATE INDEX {0} ON {1}(FLASTUPDATETIME)";
    private static final String CREATE_FLASTUPDATETIME_TRIGGER = "/*dialect*/CREATE {0} TRIGGER {1} BEFORE INSERT OR Update ON {2}  FOR EACH ROW  DECLARE  BEGIN  {3}  END;";
    private static final String CREATE_FLASTUPDATETIME_TRIGGER_SQLSERVER = "/*dialect*/CREATE TRIGGER {0}  ON {1}  AFTER UPDATE AS  BEGIN     SET NOCOUNT ON;    {2}  END ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPkField(Context ctx, List<String> tables) {
        if (tables == null || tables.size() < 1) {
            return;
        }
        ArrayList arrayList = null;
        Connection cn = null;
        try {
            cn = DbConnector.getConnection((Context)ctx);
            String productName = cn.getMetaData().getDatabaseProductName().toLowerCase();
            for (String table : tables) {
                String sql = MessageFormat.format(CHECK_PK_FIELD_EXIST, table = table.toUpperCase());
                arrayList = SQL.executeQuery((Connection)cn, (String)sql, (int[])new int[0], (Object[])new Object[0]);
                if (arrayList != null && arrayList.size() == 0) {
                    if (productName.indexOf("oracle") > -1) {
                        sql = MessageFormat.format(ADD_PK_FIELD, table, "SYS_GUID()");
                    } else if (productName.indexOf("sql server") > -1) {
                        sql = MessageFormat.format(ADD_PK_FIELD, table, "NEWID()");
                    }
                    try {
                        SQL.executeUpdate((Connection)cn, (String)sql, (int[])new int[0], (Object[])new Object[0]);
                    }
                    catch (BOSException e) {
                        logger.error((Object)("\u6267\u884c\u521b\u5efafid\u51fa\u9519\uff0csql: " + sql), (Throwable)e);
                        throw e;
                    }
                    String indexName = KeyTableUtil.MD5(table + "mainPK");
                    sql = MessageFormat.format(CREATE_UNIQUE_INDEX, indexName, table);
                    try {
                        SQL.executeUpdate((Connection)cn, (String)sql, (int[])new int[0], (Object[])new Object[0]);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)("\u6267\u884c\u521b\u5efa\u7d22\u5f15\u51fa\u9519\uff0csql: " + sql), (Throwable)e);
                        throw e;
                    }
                }
                logger.info((Object)("table : " + table + " \u5df2\u7ecf\u5b58\u5728fid\u4e3b\u952e"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SQL.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFlastUpdateTimeField(Context ctx, List<String> tables) {
        if (tables == null || tables.size() < 1) {
            return;
        }
        ArrayList arrayList = null;
        ArrayList fidList = null;
        Connection cn = null;
        try {
            cn = DbConnector.getConnection((Context)ctx);
            String productName = cn.getMetaData().getDatabaseProductName().toLowerCase();
            for (String table : tables) {
                table = table.toUpperCase();
                String sql = MessageFormat.format(CHECK_FLASTUPDATETIME_FIELD_EXIST, table);
                String sql1 = "";
                arrayList = SQL.executeQuery((Connection)cn, (String)sql, (int[])new int[0], (Object[])new Object[0]);
                if (arrayList != null && arrayList.size() == 0) {
                    if (productName.indexOf("oracle") > -1) {
                        sql = MessageFormat.format(ADD_FLASTUPDATETIME_FIELD, table, "SYSDATE");
                        sql1 = MessageFormat.format(CREATE_FLASTUPDATETIME_TRIGGER, "OR REPLACE", "TRI_" + table, table, "SELECT SYSDATE INTO :NEW.FLASTUPDATETIME FROM DUAL;");
                    } else if (productName.indexOf("sql server") > -1) {
                        sql = "/*dialect*/" + MessageFormat.format(ADD_FLASTUPDATETIME_FIELD, table, "SYSDATETIME()");
                        fidList = SQL.executeQuery((Connection)cn, (String)MessageFormat.format(CHECK_PK_FIELD_EXIST, table), (int[])new int[0], (Object[])new Object[0]);
                        if (null != fidList && fidList.size() == 0) {
                            throw new RuntimeException("\u8868\uff1a" + table + "\u7684\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u521b\u5efa\u89e6\u53d1\u5668\u65f6\u7528\u5230\u4e86\u8868\u7684\u4e3b\u952eFID,FID\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u521b\u5efa\u4e3b\u952e\u3002");
                        }
                        String tempFidStr = fidList.get(0).toString().toString();
                        String tempFid = tempFidStr.substring(tempFidStr.indexOf("=") + 1, tempFidStr.lastIndexOf("}"));
                        String tempSql = "UPDATE " + table + " SET FLASTUPDATETIME=SYSDATETIME() WHERE " + tempFid + " IN (SELECT DISTINCT " + tempFid + " FROM inserted)";
                        sql1 = MessageFormat.format(CREATE_FLASTUPDATETIME_TRIGGER_SQLSERVER, "TRI_" + table, table, tempSql);
                    }
                    try {
                        SQL.executeUpdate((Connection)cn, (String)sql, (int[])new int[0], (Object[])new Object[0]);
                        if (productName.indexOf("oracle") > -1) {
                            FMIsqlFacadeFactory.getLocalInstance((Context)ctx).executeSql(sql1);
                        } else {
                            SQL.executeUpdate((Connection)cn, (String)sql1, (int[])new int[0], (Object[])new Object[0]);
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)("\u6267\u884c\u521b\u5efaFlastUpdatetime\u51fa\u9519\uff0csql: " + sql + " " + sql1), (Throwable)e);
                    }
                    String indexName = KeyTableUtil.MD5(table + "FlastUpdateTime");
                    sql = MessageFormat.format(CREATE_FLASTUPDATETIME_UNIQUE_INDEX, indexName, table);
                    try {
                        SQL.executeUpdate((Connection)cn, (String)sql, (int[])new int[0], (Object[])new Object[0]);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)("\u6267\u884c\u521b\u5efa\u7d22\u5f15\u51fa\u9519\uff0csql: " + sql), (Throwable)e);
                        throw e;
                    }
                }
                logger.info((Object)("table : " + table + " \u5df2\u7ecf\u5b58\u5728FlastUpdatetime\u4e3b\u952e"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SQL.close((Connection)cn);
        }
    }
}

