/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.data.process.impl.BaseDataMappingHelper;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BaseDataParseForCheck {
    private static Logger logger = Logger.getLogger((String)BaseDataParseForCheck.class.getName());

    public static Map<String, String> getParseData(IRowSet rs, BillMappingEntryCollection entryColl, Context ctx) throws SQLException, BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        int n = entryColl.size();
        for (int i = 0; i < n; ++i) {
            BaseDataTypeInfo feildType;
            BillMappingEntryInfo entryInfo = entryColl.get(i);
            String fieldName = entryInfo.getSrcFieldName();
            if (entryInfo.isDropped() || (feildType = entryInfo.getBaseDataType()) == null || entryInfo.getBaseDataType().getId() == null) continue;
            HashSet<String> colValueSet = new HashSet<String>();
            while (rs.next()) {
                String s = rs.getString(fieldName);
                colValueSet.add(s);
            }
            rs.beforeFirst();
            ICoreBase instance = BaseDataMappingHelper.getCoreBaseInstance(ctx, feildType);
            String typeID = entryInfo.getBaseDataType().getId().toString();
            String number = entryInfo.getBaseDataType().getNumber();
            String data = BaseDataParseForCheck.getData(colValueSet, ctx, typeID, number, instance);
            resultMap.put(fieldName, data);
        }
        return resultMap;
    }

    public static String getData(Set<String> set, Context ctx, String typeID, String number, ICoreBase instance) throws BOSException {
        StringBuffer strb = new StringBuffer();
        for (String key : set) {
            if (!StringUtils.isEmpty((String)strb.toString())) {
                strb.append(",");
            }
            strb.append(key);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseDataType.id", (Object)typeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("entrys.srcID", (Object)strb.toString(), CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        ev.setSelector(BaseDataParseForCheck.getSelectors());
        MetaDataPK mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.csinterface.syncdatabase.app", (String)"BaseDataMappingQuery4Server");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        queryExec.setObjectView(ev);
        IRowSet rowSet = queryExec.executeQuery();
        Set<String> resultSet = BaseDataParseForCheck.getResultSet(ctx, number, rowSet, instance);
        set.removeAll(resultSet);
        StringBuffer result = new StringBuffer();
        for (String str : set) {
            result.append(str + ",");
        }
        if (result.length() > 0) {
            result = result.deleteCharAt(result.lastIndexOf(","));
        }
        return result.toString();
    }

    private static Set<String> getResultSet(Context ctx, String number, IRowSet rowSet, ICoreBase instance) {
        HashSet<String> resultSet = new HashSet<String>();
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        try {
            StringBuffer strb = new StringBuffer();
            while (rowSet.next()) {
                String srcID = rowSet.getString("entrys.srcID");
                String destID = rowSet.getString("entrys.destID");
                try {
                    if (!StringUtils.isEmpty((String)strb.toString())) {
                        strb.append(",");
                    }
                    strb.append(destID);
                    resultSet.add(srcID);
                    tmpMap.put(destID, srcID);
                }
                catch (Throwable t) {
                    logger.warn((Object)("\u8b66\u544a\uff1a\u67e5\u8be2\u57fa\u7840\u8d44\u6599[" + destID + "]\u5f02\u5e38\uff1a" + t.getMessage()));
                    t.printStackTrace();
                }
            }
            Set<String> existIds = BaseDataParseForCheck.getExistCoreBase(ctx, number, strb.toString());
            Set keySet = tmpMap.keySet();
            keySet.removeAll(existIds);
            for (String str : keySet) {
                tmpMap.remove(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String str : tmpMap.keySet()) {
            resultSet.add((String)tmpMap.get(str));
        }
        return resultSet;
    }

    private static Set<String> getExistCoreBase(Context ctx, String number, String ids) throws BOSException {
        DIPMetadata dm = new DIPMetadata(number);
        MetaDataPK metaPK = MetaDataPK.create((String)dm.getQueryPK());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        ev.setSelector(sic);
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaPK);
        queryExec.setObjectView(ev);
        IRowSet rowSet = queryExec.executeQuery();
        HashSet<String> resultSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("id");
                resultSet.add(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultSet;
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseDataType.id"));
        sic.add(new SelectorItemInfo("entrys.srcID"));
        sic.add(new SelectorItemInfo("entrys.destID"));
        return sic;
    }
}

