/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.converter.core.Converter;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.util.CustColor;
import com.kingdee.eas.csinterface.utils.BaseDataMappingUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class BaseDataMappingExcelConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        return BaseDataMapingInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        try {
            BaseDataMapingInfo baseDataMapingInfo = (BaseDataMapingInfo)source;
            WritableWorkbook writableWorkbook = (WritableWorkbook)context.get("WritableWorkbook");
            WritableSheet writableSheet = writableWorkbook.getSheet(0);
            this.marshalEntry(context, baseDataMapingInfo, writableSheet);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void marshalHeader(MarshallingContext context, BaseDataMapingInfo baseDataMapingInfo, WritableSheet writableSheet) throws Exception {
        WritableCellFormat cellFormat = this.getCellFormat();
        String number = baseDataMapingInfo.getNumber();
        writableSheet.addCell((WritableCell)new Label(1, 0, number, (CellFormat)cellFormat));
        BaseDataTypeInfo baseDataTypeInfo = baseDataMapingInfo.getBaseDataType();
        String baseDataTypeInfoNo = "";
        if (null != baseDataTypeInfo) {
            baseDataTypeInfoNo = baseDataTypeInfo.getNumber();
        }
        writableSheet.addCell((WritableCell)new Label(1, 1, baseDataTypeInfoNo, (CellFormat)cellFormat));
        String orgUnit = baseDataMapingInfo.getOrgUnit();
        CoreBaseInfo info = BaseDataMappingUtil.convertFid2CoreBase(orgUnit);
        String orgUnitNumber = null;
        orgUnitNumber = null != info ? info.getString("number") : "";
        writableSheet.addCell((WritableCell)new Label(1, 2, orgUnitNumber, (CellFormat)cellFormat));
    }

    public static ICoreBase getCoreBaseInstance(Context ctx, String id) throws BOSException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        return coreBase;
    }

    private void marshalEntry(MarshallingContext context, BaseDataMapingInfo baseDataMapingInfo, WritableSheet writableSheet) throws Exception {
        KDTable kdtEntrys = (KDTable)context.get("kdtEntrys");
        ObjectValueRender destIDRender = (ObjectValueRender)kdtEntrys.getColumn("destID").getRenderer();
        int rowCount = kdtEntrys.getRowCount();
        int baseRowIndex = 1;
        WritableCellFormat cellFormat = this.getCellFormat();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = kdtEntrys.getRow(i);
            String srcID = this.getRowCellValue(row, "srcID");
            String srcDisplay = this.getRowCellValue(row, "srcDisplay");
            String destID = destIDRender.getText(row.getCell("destID").getValue());
            String destDisplay = (String)row.getCell("destDisplay").getValue();
            int lineIndex = baseRowIndex + i;
            writableSheet.addCell((WritableCell)new Label(0, lineIndex, srcID, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(1, lineIndex, srcDisplay, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(2, lineIndex, destID, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(3, lineIndex, destDisplay, (CellFormat)cellFormat));
        }
    }

    private WritableCellFormat getCellFormat() throws Exception {
        WritableCellFormat cellFormat = new WritableCellFormat(NumberFormats.TEXT);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
        cellFormat.setBackground((Colour)CustColor.CustColor_Yellow);
        return cellFormat;
    }

    private String getRowCellValue(IRow row, String key) {
        Object value = row.getCell(key).getValue();
        if (null == value) {
            return "";
        }
        if (value instanceof DataBaseInfo) {
            return ((DataBaseInfo)value).getNumber();
        }
        return value.toString();
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        return null;
    }
}

