/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import org.apache.log4j.Logger;

public class ImportUtil {
    private static Logger logger = Logger.getLogger(ImportUtil.class);
    private static int MAX_COUNT = 5000;

    public static String getTargetValue(ICoreBase instance, EntityViewInfo view, String baseValue) throws BOSException, EASBizException {
        return ImportUtil.getTargetValue(instance, view, baseValue, true);
    }

    public static String getTargetValue(ICoreBase instance, EntityViewInfo view, String baseValue, boolean withUnderLine) throws BOSException, EASBizException {
        String sepChar;
        boolean exist = instance.exists(view.getFilter());
        int currentCount = 0;
        String targetNumber = baseValue;
        String string = sepChar = withUnderLine ? "_" : "";
        while (exist && currentCount < MAX_COUNT) {
            targetNumber = baseValue + sepChar + ImportUtil.getSuffixNumber(++currentCount);
            view.getFilter().getFilterItems().get(0).setCompareValue((Object)targetNumber);
            exist = instance.exists(view.getFilter());
        }
        if (currentCount == MAX_COUNT) {
            logger.info((Object)("\u5df2\u7ecf\u5c1d\u8bd5" + MAX_COUNT + "\u6b21\uff0c\u503c\u3010" + baseValue + targetNumber + "\u3011\u4ecd\u7136\u91cd\u590d\u3002"));
            throw new BOSException("\u6570\u636e\u91cd\u590d\uff0c\u65e0\u6cd5\u5f15\u5165\u3002");
        }
        return targetNumber;
    }

    public static EntityViewInfo getEntityViewInfo4Equal(String propertyName, Object compareValue) {
        FilterItemInfo filterItem = new FilterItemInfo();
        filterItem.setPropertyName(propertyName);
        filterItem.setCompareValue(compareValue);
        filterItem.setCompareType(CompareType.EQUALS);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private static String getSuffixNumber(int number) {
        return number < 10 ? "0" + number : "" + number;
    }
}

