/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JDomB9Utils {
    public static String getAttributeValue(Element element, String attributeName) {
        Attribute attribute = element.getAttribute(attributeName);
        if (null == attribute) {
            return null;
        }
        return attribute.getValue();
    }

    public static String getAttributeValueUnNull(Element element, String attributeName) {
        Attribute attribute = element.getAttribute(attributeName);
        if (null == attribute) {
            throw new RuntimeException("\u8282\u70b9<" + element.getName() + ">\u4e0b\u672a\u5305\u542b\u5c5e\u6027<" + attributeName + ">");
        }
        return attribute.getValue();
    }

    public static Element getUnNullChildElement(Element parent, String childName) {
        Element child = parent.getChild(childName);
        if (null != child) {
            return child;
        }
        throw new RuntimeException("\u8282\u70b9<" + parent.getName() + ">\u4e0b\u672a\u5305\u542b\u8282\u70b9<" + childName + ">");
    }

    public static String getUnNullTextTrim(Element node) {
        String child = node.getTextTrim();
        if (null != child) {
            return child;
        }
        throw new RuntimeException("\u8282\u70b9<" + node.getName() + ">\u7684Text\u503c\u4e3aNULL");
    }

    public static String getUnNullChildText(Element parent, String childName) {
        String childText = parent.getChildText(childName);
        if (null != childText) {
            return childText;
        }
        throw new RuntimeException("\u8282\u70b9<" + parent.getName() + ">\u4e0b\u5b50\u8282\u70b9<" + childName + ">\u7684Text\u503c\u4e3aNULL.");
    }

    public static String getUnNullChildTextTrim(Element parent, String childName) {
        return JDomB9Utils.getUnNullChildText(parent, childName).trim();
    }

    public static Element createRoot(String rootName) {
        Element root = new Element(rootName);
        return root;
    }

    public static Element addChild(Element parent, String childName) {
        Element child = new Element(childName);
        parent.addContent((Content)child);
        return child;
    }

    public static void addChild(Element parent, Element child) {
        parent.addContent((Content)child);
    }

    public static Element addChild(Element parent, String childName, String childValue) {
        Element child = new Element(childName);
        child.setText(childValue == null ? "" : childValue);
        parent.addContent((Content)child);
        return child;
    }

    public static String e2Str(Element element, String indent, String encoding, boolean newlines) {
        Format format = Format.getRawFormat();
        format.setEncoding(encoding);
        format.setIndent(indent);
        XMLOutputter outputter = new XMLOutputter(format);
        String newLineString = "";
        if (newlines) {
            newLineString = "\n";
        }
        format.setLineSeparator(newLineString);
        return outputter.outputString(element);
    }

    public static String e2StrGBK(Element element) {
        return JDomB9Utils.e2Str(element, "    ", "GBK", true);
    }

    public static String e2StrUTF8(Element element) {
        return JDomB9Utils.e2Str(element, "    ", "UTF-8", true);
    }

    public static String doc2Str(Document document, String indent, String encoding, boolean newlines) {
        Format format = Format.getRawFormat();
        format.setEncoding(encoding);
        format.setIndent(indent);
        XMLOutputter outputter = new XMLOutputter(format);
        String newLineString = "";
        if (newlines) {
            newLineString = "\n";
        }
        format.setLineSeparator(newLineString);
        return outputter.outputString(document);
    }

    public static String doc2StrGBK(Document document) {
        return JDomB9Utils.doc2Str(document, "    ", "GBK", true);
    }

    public static String doc2StrUTF8(Document document) {
        return JDomB9Utils.doc2Str(document, "    ", "UTF-8", true);
    }

    public static Document str2Doc(String content, String encoding) {
        try {
            if (null == content) {
                return null;
            }
            if (-1 != content.indexOf("<?")) {
                content = content.substring(content.indexOf("<?"));
            }
            if (-1 == content.indexOf("<?")) {
                content = "<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>\n" + content;
            }
            SAXBuilder builder = new SAXBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes(encoding));
            Document document = builder.build((InputStream)bais);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5c06String\u8f6c\u5316\u4e3adocument\u5bf9\u8c61\u51fa\u73b0\u5f02\u5e38,\u539f\u56e0:" + e.getMessage(), e);
        }
    }

    public static Document str2DocGBK(String content) {
        return JDomB9Utils.str2Doc(content, "GBK");
    }

    public static Document str2DocUTF8(String content) {
        return JDomB9Utils.str2Doc(content, "UTF-8");
    }
}

